/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl;

import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.commonImpl.IWorldGetIdentifier;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.VoxyInstance;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldIdentifier {
    private static final class_5321<class_2874> NULL_DIM_KEY = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)class_2960.method_60654((String)"voxy:null_dimension_id"));
    public final class_5321<class_1937> key;
    public final long biomeSeed;
    public final class_5321<class_2874> dimension;
    private final transient long hashCode;
    @Nullable
    transient WeakReference<WorldEngine> cachedEngineObject;

    public WorldIdentifier(@NotNull class_5321<class_1937> key, long biomeSeed, @Nullable class_5321<class_2874> dimension) {
        if (key == null) {
            throw new IllegalStateException("Key cannot be null");
        }
        dimension = dimension == null ? NULL_DIM_KEY : dimension;
        this.key = key;
        this.biomeSeed = biomeSeed;
        this.dimension = dimension;
        this.hashCode = WorldIdentifier.mixStafford13(WorldIdentifier.registryKeyHashCode(key)) ^ WorldIdentifier.mixStafford13(WorldIdentifier.registryKeyHashCode(dimension)) ^ WorldIdentifier.mixStafford13(biomeSeed);
    }

    public int hashCode() {
        return (int)this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorldIdentifier) {
            WorldIdentifier other = (WorldIdentifier)obj;
            return other.hashCode == this.hashCode && other.biomeSeed == this.biomeSeed && WorldIdentifier.equal(other.key, this.key) && WorldIdentifier.equal(other.dimension, this.dimension);
        }
        return false;
    }

    private static <T> boolean equal(class_5321<T> a, class_5321<T> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.method_41185().equals((Object)b.method_41185()) && a.method_29177().equals((Object)b.method_29177());
    }

    public WorldEngine getOrCreateEngine() {
        VoxyInstance instance = VoxyCommon.getInstance();
        if (instance == null) {
            this.cachedEngineObject = null;
            return null;
        }
        WorldEngine engine = instance.getOrCreate(this);
        if (engine == null) {
            throw new IllegalStateException("Engine null on creation");
        }
        return engine;
    }

    public WorldEngine getNullable() {
        VoxyInstance instance = VoxyCommon.getInstance();
        if (instance == null) {
            this.cachedEngineObject = null;
            return null;
        }
        return instance.getNullable(this);
    }

    public static WorldIdentifier of(class_1937 level) {
        if (level == null) {
            return null;
        }
        return ((IWorldGetIdentifier)level).voxy$getIdentifier();
    }

    public static WorldEngine ofEngine(class_1937 level) {
        WorldIdentifier id = WorldIdentifier.of(level);
        if (id == null) {
            return null;
        }
        return id.getOrCreateEngine();
    }

    public static WorldEngine ofEngineNullable(class_1937 level) {
        WorldIdentifier id = WorldIdentifier.of(level);
        if (id == null) {
            return null;
        }
        return id.getNullable();
    }

    public static long mixStafford13(long seed) {
        seed += 918759875987111L;
        seed = (seed ^ seed >>> 30) * -4658895280553007687L;
        seed = (seed ^ seed >>> 27) * -7723592293110705685L;
        return seed ^ seed >>> 31;
    }

    public long getLongHash() {
        return this.hashCode;
    }

    private static long registryKeyHashCode(class_5321<?> key) {
        class_2960 A2 = key.method_41185();
        class_2960 B2 = key.method_29177();
        int a = A2 == null ? 0 : A2.hashCode();
        int b = B2 == null ? 0 : B2.hashCode();
        return Integer.toUnsignedLong(a) << 32 | Integer.toUnsignedLong(b);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public String getWorldId() {
        return WorldIdentifier.getWorldId(this);
    }

    public static String getWorldId(WorldIdentifier identifier) {
        String data = identifier.biomeSeed + identifier.key.toString();
        try {
            return WorldIdentifier.bytesToHex(MessageDigest.getInstance("SHA-256").digest(data.getBytes())).substring(0, 32);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

