/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.commonImpl.importers.IDataImporter;

public class ImportManager {
    private final Map<WorldEngine, ImportTask> activeImporters = new HashMap<WorldEngine, ImportTask>();

    protected synchronized ImportTask createImportTask(IDataImporter importer) {
        return new ImportTask(importer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryRunImport(IDataImporter importer) {
        ImportTask task;
        ImportManager importManager = this;
        synchronized (importManager) {
            ImportTask importerTask = this.activeImporters.get(importer.getEngine());
            if (importerTask != null) {
                if (!importerTask.isCompleted()) {
                    return false;
                }
                throw new IllegalStateException();
            }
            task = this.createImportTask(importer);
            this.activeImporters.put(importer.getEngine(), task);
        }
        task.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeAndRunIfNone(WorldEngine engine, Supplier<IDataImporter> factory) {
        try {
            engine.acquireRef();
            ImportManager importManager = this;
            synchronized (importManager) {
                if (this.activeImporters.containsKey(engine)) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = this.tryRunImport(factory.get());
            return bl;
        }
        finally {
            engine.releaseRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelImport(WorldEngine engine) {
        ImportTask task;
        ImportManager importManager = this;
        synchronized (importManager) {
            task = this.activeImporters.get(engine);
            if (task == null) {
                return false;
            }
        }
        task.shutdown();
        importManager = this;
        synchronized (importManager) {
            this.activeImporters.remove(engine);
        }
        return true;
    }

    private synchronized void jobFinished(ImportTask task) {
        ImportTask remTask = this.activeImporters.remove(task.importer.getEngine());
        if (remTask != null && remTask != task) {
            throw new IllegalStateException();
        }
    }

    protected class ImportTask {
        protected final IDataImporter importer;
        protected long startTime;
        protected long timer;
        protected long updateEvery = 50L;

        protected ImportTask(IDataImporter importer) {
            this.importer = importer;
            this.timer = System.currentTimeMillis();
        }

        private void start() {
            if (this.importer.isRunning()) {
                throw new IllegalStateException();
            }
            this.startTime = System.currentTimeMillis();
            this.importer.runImport(this::onUpdate, this::onCompleted);
        }

        protected boolean onUpdate(int completed, int outOf) {
            if (System.currentTimeMillis() - this.timer < this.updateEvery) {
                return false;
            }
            this.timer = System.currentTimeMillis();
            return true;
        }

        protected void onCompleted(int total) {
            ImportManager.this.jobFinished(this);
        }

        protected void shutdown() {
            this.importer.shutdown();
        }

        protected boolean isCompleted() {
            return !this.importer.isRunning();
        }
    }
}

