/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world.service;

import java.util.concurrent.ConcurrentLinkedDeque;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.voxelization.ILightingSupplier;
import me.cortex.voxy.common.voxelization.VoxelizedSection;
import me.cortex.voxy.common.voxelization.WorldConversionFactory;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldUpdater;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.VoxyInstance;
import me.cortex.voxy.commonImpl.WorldIdentifier;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3560;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.jetbrains.annotations.NotNull;

public class VoxelIngestService {
    private static final ThreadLocal<VoxelizedSection> SECTION_CACHE = ThreadLocal.withInitial(VoxelizedSection::createEmpty);
    private final Service service;
    private final ConcurrentLinkedDeque<IngestSection> ingestQueue = new ConcurrentLinkedDeque();

    public VoxelIngestService(ServiceManager pool) {
        this.service = pool.createServiceNoCleanup(() -> this::processJob, 5000L, "Ingest service");
    }

    private void processJob() {
        IngestSection task = this.ingestQueue.pop();
        task.world.markActive();
        class_2826 section = task.section;
        VoxelizedSection vs = SECTION_CACHE.get().setPosition(task.cx, task.cy, task.cz);
        if (section.method_38292() && task.blockLight == null && task.skyLight == null) {
            WorldUpdater.insertUpdate(task.world, vs.zero());
        } else {
            VoxelizedSection csec = WorldConversionFactory.convert(SECTION_CACHE.get(), task.world.getMapper(), (class_2841<class_2680>)section.method_12265(), (class_7522<class_6880<class_1959>>)section.method_38294(), VoxelIngestService.getLightingSupplier(task));
            WorldConversionFactory.mipSection(csec, task.world.getMapper());
            WorldUpdater.insertUpdate(task.world, csec);
        }
    }

    @NotNull
    private static ILightingSupplier getLightingSupplier(IngestSection task) {
        boolean bl;
        ILightingSupplier supplier = (x, y, z) -> 0;
        class_2804 sla = task.skyLight;
        class_2804 bla = task.blockLight;
        boolean sl = sla != null && !sla.method_12146();
        boolean bl2 = bl = bla != null && !bla.method_12146();
        if (sl || bl) {
            supplier = sl && bl ? (x, y, z) -> {
                int block = Math.min(15, bla.method_12139(x, y, z));
                int sky = Math.min(15, sla.method_12139(x, y, z));
                return (byte)(sky | block << 4);
            } : (bl ? (x, y, z) -> {
                int block = Math.min(15, bla.method_12139(x, y, z));
                int sky = 0;
                return (byte)(sky | block << 4);
            } : (x, y, z) -> {
                int block = 0;
                int sky = Math.min(15, sla.method_12139(x, y, z));
                return (byte)(sky | block << 4);
            });
        }
        return supplier;
    }

    private static boolean shouldIngestSection(class_2826 section, int cx, int cy, int cz) {
        return true;
    }

    public boolean enqueueIngest(WorldEngine engine, class_2818 chunk) {
        if (!this.service.isLive()) {
            return false;
        }
        if (!engine.isLive()) {
            throw new IllegalStateException("Tried inserting chunk into WorldEngine that was not alive");
        }
        engine.markActive();
        class_3568 lightingProvider = chunk.method_12200().method_22336();
        boolean gotLighting = false;
        int i = chunk.method_32891() - 1;
        boolean allEmpty = true;
        for (class_2826 section : chunk.method_12006()) {
            if (section == null || !VoxelIngestService.shouldIngestSection(section, chunk.method_12004().field_9181, ++i, chunk.method_12004().field_9180)) continue;
            allEmpty &= section.method_38292();
            class_4076 pos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)i);
            if (lightingProvider.method_51560(class_1944.field_9284, pos) != class_3560.class_8530.field_44726 && lightingProvider.method_51560(class_1944.field_9282, pos) != class_3560.class_8530.field_44726) continue;
            gotLighting = true;
        }
        if (allEmpty && !gotLighting) {
            i = chunk.method_32891() - 1;
            for (class_2826 section : chunk.method_12006()) {
                if (section == null || !VoxelIngestService.shouldIngestSection(section, chunk.method_12004().field_9181, ++i, chunk.method_12004().field_9180)) continue;
                this.ingestQueue.add(new IngestSection(chunk.method_12004().field_9181, i, chunk.method_12004().field_9180, engine, section, null, null));
                try {
                    this.service.execute();
                }
                catch (Exception e) {
                    Logger.error("Executing had an error: assume shutting down, aborting", e);
                    break;
                }
            }
        }
        if (!gotLighting) {
            return false;
        }
        class_3562 blp = lightingProvider.method_15562(class_1944.field_9282);
        class_3562 slp = lightingProvider.method_15562(class_1944.field_9284);
        i = chunk.method_32891() - 1;
        for (class_2826 section : chunk.method_12006()) {
            class_2804 sl;
            if (section == null || !VoxelIngestService.shouldIngestSection(section, chunk.method_12004().field_9181, ++i, chunk.method_12004().field_9180)) continue;
            class_4076 pos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)i);
            class_2804 bl = blp.method_15544(pos);
            if (bl != null) {
                bl = bl.method_12144();
            }
            if ((sl = slp.method_15544(pos)) != null) {
                sl = sl.method_12144();
            }
            this.ingestQueue.add(new IngestSection(chunk.method_12004().field_9181, i, chunk.method_12004().field_9180, engine, section, bl, sl));
            try {
                this.service.execute();
            }
            catch (Exception e) {
                Logger.error("Executing had an error: assume shutting down, aborting", e);
                break;
            }
        }
        return true;
    }

    public int getTaskCount() {
        return this.service.numJobs();
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public static boolean tryIngestChunk(WorldIdentifier worldId, class_2818 chunk) {
        if (worldId == null) {
            return false;
        }
        VoxyInstance instance = VoxyCommon.getInstance();
        if (instance == null) {
            return false;
        }
        if (!instance.isIngestEnabled(worldId)) {
            return false;
        }
        WorldEngine engine = instance.getOrCreate(worldId);
        if (engine == null) {
            return false;
        }
        return instance.getIngestService().enqueueIngest(engine, chunk);
    }

    public static boolean tryAutoIngestChunk(class_2818 chunk) {
        return VoxelIngestService.tryIngestChunk(WorldIdentifier.of(chunk.method_12200()), chunk);
    }

    private boolean rawIngest0(WorldEngine engine, class_2826 section, int x, int y, int z, class_2804 bl, class_2804 sl) {
        this.ingestQueue.add(new IngestSection(x, y, z, engine, section, bl, sl));
        try {
            this.service.execute();
            return true;
        }
        catch (Exception e) {
            Logger.error("Executing had an error: assume shutting down, aborting", e);
            return false;
        }
    }

    public static boolean rawIngest(WorldIdentifier id, class_2826 section, int x, int y, int z, class_2804 bl, class_2804 sl) {
        if (id == null) {
            return false;
        }
        WorldEngine engine = id.getOrCreateEngine();
        if (engine == null) {
            return false;
        }
        return VoxelIngestService.rawIngest(engine, section, x, y, z, bl, sl);
    }

    public static boolean rawIngest(WorldEngine engine, class_2826 section, int x, int y, int z, class_2804 bl, class_2804 sl) {
        if (!VoxelIngestService.shouldIngestSection(section, x, y, z)) {
            return false;
        }
        if (engine.instanceIn == null) {
            return false;
        }
        if (!engine.instanceIn.isIngestEnabled(null)) {
            return false;
        }
        return engine.instanceIn.getIngestService().rawIngest0(engine, section, x, y, z, bl, sl);
    }

    private record IngestSection(int cx, int cy, int cz, WorldEngine world, class_2826 section, class_2804 blockLight, class_2804 skyLight) {
    }
}

