/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world.service;

import java.util.concurrent.ConcurrentLinkedDeque;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldSection;

public class SectionSavingService {
    private final Service service;
    private final ConcurrentLinkedDeque<SaveEntry> saveQueue = new ConcurrentLinkedDeque();

    public SectionSavingService(ServiceManager sm) {
        this.service = sm.createServiceNoCleanup(() -> this::processJob, 100L, "Section saving service");
    }

    private void processJob() {
        SaveEntry task = this.saveQueue.pop();
        WorldSection section = task.section;
        section.assertNotFree();
        try {
            if (section.exchangeIsInSaveQueue(false)) {
                task.engine.storage.saveSection(section);
            }
        }
        catch (Exception e) {
            Logger.error("Voxy saver had an exception while executing please check logs and report error", e);
        }
        section.release();
    }

    public void enqueueSave(WorldEngine in, WorldSection section) {
        if (section.exchangeIsInSaveQueue(true)) {
            section.acquire();
            if (this.getTaskCount() > 5000) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                while (this.getTaskCount() > 5000 && this.service.isLive() && this.service.steal()) {
                    this.processJob();
                }
            }
            this.saveQueue.add(new SaveEntry(in, section));
            this.service.execute();
        }
    }

    public void shutdown() {
        if (this.service.numJobs() != 0) {
            Logger.error("Voxy section saving still in progress, estimated " + this.service.numJobs() + " sections remaining.");
            this.service.blockTillEmpty();
        }
        this.service.shutdown();
        while (!this.saveQueue.isEmpty()) {
            this.processJob();
        }
    }

    public int getTaskCount() {
        return this.service.numJobs();
    }

    private record SaveEntry(WorldEngine engine, WorldSection section) {
    }
}

