/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world.other;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.config.IMappingStorage;
import me.cortex.voxy.common.util.Pair;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3551;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.lwjgl.system.MemoryUtil;

public class Mapper {
    private static final int BLOCK_STATE_TYPE = 1;
    private static final int BIOME_TYPE = 2;
    private final IMappingStorage storage;
    public static final long UNKNOWN_MAPPING = -1L;
    public static final long AIR = 0L;
    private final ReentrantLock blockLock = new ReentrantLock();
    private final ConcurrentHashMap<class_2680, StateEntry> block2stateEntry = new ConcurrentHashMap(2000, 0.75f, 10);
    private final ObjectArrayList<StateEntry> blockId2stateEntry = new ObjectArrayList();
    private final ReentrantLock biomeLock = new ReentrantLock();
    private final ConcurrentHashMap<String, BiomeEntry> biome2biomeEntry = new ConcurrentHashMap(2000, 0.75f, 10);
    private final ObjectArrayList<BiomeEntry> biomeId2biomeEntry = new ObjectArrayList();
    private Consumer<StateEntry> newStateCallback;
    private Consumer<BiomeEntry> newBiomeCallback;

    public Mapper(IMappingStorage storage) {
        this.storage = storage;
        StateEntry airEntry = new StateEntry(0, class_2246.field_10124.method_9564());
        this.block2stateEntry.put(airEntry.state, airEntry);
        this.blockId2stateEntry.add((Object)airEntry);
        this.loadFromStorage();
    }

    public static boolean isAir(long id) {
        return (id & 0x7FFFF8000000L) == 0L;
    }

    public static int getBlockId(long id) {
        return (int)(id >> 27 & 0xFFFFFL);
    }

    public static int getBiomeId(long id) {
        return (int)(id >> 47 & 0x1FFL);
    }

    public static int getLightId(long id) {
        return (int)(id >> 56 & 0xFFL);
    }

    public static long withLight(long id, int light) {
        return id & 0xFFFFFFFFFFFFFFL | Integer.toUnsignedLong(light & 0xFF) << 56;
    }

    public static long airWithLight(int light) {
        return Integer.toUnsignedLong(light & 0xFF) << 56;
    }

    public void setStateCallback(Consumer<StateEntry> stateCallback) {
        this.newStateCallback = stateCallback;
    }

    public void setBiomeCallback(Consumer<BiomeEntry> biomeCallback) {
        this.newBiomeCallback = biomeCallback;
    }

    private void loadFromStorage() {
        Int2ObjectOpenHashMap<byte[]> mappings = this.storage.getIdMappingsData();
        ArrayList<StateEntry> sentries = new ArrayList<StateEntry>();
        ArrayList<BiomeEntry> bentries = new ArrayList<BiomeEntry>();
        ArrayList<Pair<byte[], Integer>> sentryErrors = new ArrayList<Pair<byte[], Integer>>();
        boolean[] forceResave = new boolean[1];
        for (Int2ObjectMap.Entry entry2 : mappings.int2ObjectEntrySet()) {
            int n = entry2.getIntKey() >>> 30;
            int id = entry2.getIntKey() & 0x3FFFFFFF;
            if (n == 1) {
                StateEntry sentry = StateEntry.deserialize(id, (byte[])entry2.getValue(), forceResave);
                if (sentry.state.method_26215()) {
                    Logger.error("Deserialization was air, removed block");
                    sentryErrors.add(new Pair<byte[], Integer>((byte[])entry2.getValue(), id));
                    continue;
                }
                sentries.add(sentry);
                StateEntry oldEntry = this.block2stateEntry.putIfAbsent(sentry.state, sentry);
                if (oldEntry == null) continue;
                Logger.warn("Multiple mappings for blockstate, using old state, expect things to possibly go really badly. " + oldEntry.id + ":" + sentry.id + ":" + String.valueOf(sentry.state));
                continue;
            }
            if (n == 2) {
                BiomeEntry bentry = BiomeEntry.deserialize(id, (byte[])entry2.getValue());
                bentries.add(bentry);
                if (this.biome2biomeEntry.put(bentry.biome, bentry) == null) continue;
                throw new IllegalStateException("Multiple mappings for biome entry");
            }
            throw new IllegalStateException("Unknown entryType");
        }
        if (!sentryErrors.isEmpty()) {
            forceResave[0] = forceResave[0] | true;
            Random rand = new Random();
            for (Pair pair : sentryErrors) {
                StateEntry state;
                while (this.block2stateEntry.put(state.state, state = new StateEntry((Integer)pair.right(), (class_2680)class_2248.field_10651.method_10200(rand.nextInt(class_2248.field_10651.method_10204() - 1)))) != null) {
                }
                sentries.add(state);
            }
        }
        sentries.stream().sorted(Comparator.comparing(a -> a.id)).forEach(entry -> {
            if (this.blockId2stateEntry.size() != entry.id) {
                throw new IllegalStateException("Block entry not ordered");
            }
            this.blockId2stateEntry.add(entry);
        });
        bentries.stream().sorted(Comparator.comparing(a -> a.id)).forEach(entry -> {
            if (this.biomeId2biomeEntry.size() != entry.id) {
                throw new IllegalStateException("Biome entry not ordered. got " + entry.biome + " with id " + entry.id + " expected id " + this.biomeId2biomeEntry.size());
            }
            this.biomeId2biomeEntry.add(entry);
        });
        if (forceResave[0]) {
            Logger.warn("Forced state resave triggered");
            this.forceResaveStates();
        }
    }

    public final int getBlockStateCount() {
        return this.blockId2stateEntry.size();
    }

    private StateEntry registerNewBlockState(class_2680 state) {
        this.blockLock.lock();
        StateEntry entry = this.block2stateEntry.get(state);
        if (entry != null) {
            this.blockLock.unlock();
            return entry;
        }
        entry = new StateEntry(this.blockId2stateEntry.size(), state);
        this.blockId2stateEntry.add((Object)entry);
        this.block2stateEntry.put(state, entry);
        this.blockLock.unlock();
        byte[] serialized = entry.serialize();
        ByteBuffer buffer = MemoryUtil.memAlloc((int)serialized.length);
        buffer.put(serialized);
        buffer.rewind();
        this.storage.putIdMapping(entry.id | 0x40000000, buffer);
        MemoryUtil.memFree((Buffer)buffer);
        if (this.newStateCallback != null) {
            this.newStateCallback.accept(entry);
        }
        return entry;
    }

    private BiomeEntry registerNewBiome(String biome) {
        this.biomeLock.lock();
        BiomeEntry entry = this.biome2biomeEntry.get(biome);
        if (entry != null) {
            this.biomeLock.unlock();
            return entry;
        }
        entry = new BiomeEntry(this.biomeId2biomeEntry.size(), biome);
        this.biomeId2biomeEntry.add((Object)entry);
        this.biome2biomeEntry.put(biome, entry);
        this.biomeLock.unlock();
        byte[] serialized = entry.serialize();
        ByteBuffer buffer = MemoryUtil.memAlloc((int)serialized.length);
        buffer.put(serialized);
        buffer.rewind();
        this.storage.putIdMapping(entry.id | Integer.MIN_VALUE, buffer);
        MemoryUtil.memFree((Buffer)buffer);
        if (this.newBiomeCallback != null) {
            this.newBiomeCallback.accept(entry);
        }
        return entry;
    }

    public long getBaseId(byte light, class_2680 state, class_6880<class_1959> biome) {
        if (state.method_26215()) {
            return Byte.toUnsignedLong(light) << 56;
        }
        return Mapper.composeMappingId(light, this.getIdForBlockState(state), this.getIdForBiome(biome));
    }

    public class_2680 getBlockStateFromBlockId(int blockId) {
        return ((StateEntry)this.blockId2stateEntry.get((int)blockId)).state;
    }

    public int getIdForBlockState(class_2680 state) {
        if (state.method_26215()) {
            return 0;
        }
        StateEntry mapping = this.block2stateEntry.get(state);
        if (mapping == null) {
            mapping = this.registerNewBlockState(state);
        }
        return mapping.id;
    }

    public int getBlockStateOpacity(long mappingId) {
        return this.getBlockStateOpacity(Mapper.getBlockId(mappingId));
    }

    public int getBlockStateOpacity(int blockId) {
        return ((StateEntry)this.blockId2stateEntry.get((int)blockId)).opacity;
    }

    public int getIdForBiome(class_6880<class_1959> biome) {
        String biomeId = ((class_5321)biome.method_40230().get()).method_29177().toString();
        BiomeEntry entry = this.biome2biomeEntry.get(biomeId);
        if (entry == null) {
            entry = this.registerNewBiome(biomeId);
        }
        return entry.id;
    }

    public static long composeMappingId(byte light, int blockId, int biomeId) {
        if ((long)blockId == 0L) {
            return Byte.toUnsignedLong(light) << 56;
        }
        return Byte.toUnsignedLong(light) << 56 | Integer.toUnsignedLong(biomeId) << 47 | Integer.toUnsignedLong(blockId) << 27;
    }

    public StateEntry[] getStateEntries() {
        this.blockLock.lock();
        ArrayList<StateEntry> set = new ArrayList<StateEntry>((Collection<StateEntry>)this.blockId2stateEntry);
        StateEntry[] out = new StateEntry[set.size()];
        int i = 0;
        for (StateEntry entry : set) {
            if (entry.id != i++) {
                throw new IllegalStateException();
            }
            out[i - 1] = entry;
        }
        this.blockLock.unlock();
        return out;
    }

    public BiomeEntry[] getBiomeEntries() {
        this.biomeLock.lock();
        ArrayList<BiomeEntry> set = new ArrayList<BiomeEntry>((Collection<BiomeEntry>)this.biomeId2biomeEntry);
        BiomeEntry[] out = new BiomeEntry[set.size()];
        int i = 0;
        for (BiomeEntry entry : set) {
            if (entry.id != i++) {
                throw new IllegalStateException();
            }
            out[i - 1] = entry;
        }
        this.biomeLock.unlock();
        return out;
    }

    public void forceResaveStates() {
        ByteBuffer buffer;
        byte[] serialized;
        ArrayList<StateEntry> blocks = new ArrayList<StateEntry>(this.block2stateEntry.values());
        ArrayList<BiomeEntry> biomes = new ArrayList<BiomeEntry>(this.biome2biomeEntry.values());
        for (StateEntry stateEntry : blocks) {
            if (stateEntry.state.method_26215() && stateEntry.id == 0) continue;
            if (this.blockId2stateEntry.indexOf((Object)stateEntry) != stateEntry.id) {
                throw new IllegalStateException("State Id NOT THE SAME, very critically bad. arr:" + this.blockId2stateEntry.indexOf((Object)stateEntry) + " entry: " + stateEntry.id);
            }
            serialized = stateEntry.serialize();
            buffer = MemoryUtil.memAlloc((int)serialized.length);
            buffer.put(serialized);
            buffer.rewind();
            this.storage.putIdMapping(stateEntry.id | 0x40000000, buffer);
            MemoryUtil.memFree((Buffer)buffer);
        }
        for (BiomeEntry biomeEntry : biomes) {
            if (this.biomeId2biomeEntry.indexOf((Object)biomeEntry) != biomeEntry.id) {
                throw new IllegalStateException("Biome Id NOT THE SAME, very critically bad");
            }
            serialized = biomeEntry.serialize();
            buffer = MemoryUtil.memAlloc((int)serialized.length);
            buffer.put(serialized);
            buffer.rewind();
            this.storage.putIdMapping(biomeEntry.id | Integer.MIN_VALUE, buffer);
            MemoryUtil.memFree((Buffer)buffer);
        }
        this.storage.flush();
    }

    public void close() {
    }

    public static final class StateEntry {
        public final int id;
        public final class_2680 state;
        public final int opacity;

        public StateEntry(int id, class_2680 state) {
            this.id = id;
            this.state = state;
            this.opacity = state.method_26204() instanceof class_2397 ? 15 : state.method_26193();
        }

        public byte[] serialize() {
            try {
                class_2487 serialized = new class_2487();
                serialized.method_10569("id", this.id);
                serialized.method_10566("block_state", (class_2520)class_2680.field_24734.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.state).result().get());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)serialized, (OutputStream)out);
                return out.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static StateEntry deserialize(int id, byte[] data, boolean[] forceResave) {
            try {
                class_2487 compound = class_2507.method_10629((InputStream)new ByteArrayInputStream(data), (class_2505)class_2505.method_53898());
                if (compound.method_68083("id", -1) != id) {
                    throw new IllegalStateException("Encoded id != expected id");
                }
                class_2487 bsc = (class_2487)compound.method_10562("block_state").orElseThrow();
                DataResult state = class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)bsc);
                if (state.isError()) {
                    Logger.info("Could not decode blockstate, attempting fixes, error: " + ((DataResult.Error)state.error().get()).message());
                    bsc = (class_2487)class_3551.method_15450().update(class_1208.field_5720, new Dynamic((DynamicOps)class_2509.field_11560, (Object)bsc), 0, class_155.method_16673().comp_4026().comp_4038()).getValue();
                    state = class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)bsc);
                    if (state.isError()) {
                        Logger.error("Could not decode blockstate setting to air. id:" + id + " error: " + ((DataResult.Error)state.error().get()).message());
                        return new StateEntry(id, class_2246.field_10124.method_9564());
                    }
                    Logger.info("Fixed blockstate to: " + String.valueOf(state.getOrThrow()));
                    forceResave[0] = forceResave[0] | true;
                    return new StateEntry(id, (class_2680)state.getOrThrow());
                }
                return new StateEntry(id, (class_2680)state.getOrThrow());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class BiomeEntry {
        public final int id;
        public final String biome;

        public BiomeEntry(int id, String biome) {
            this.id = id;
            this.biome = biome;
        }

        public byte[] serialize() {
            try {
                class_2487 serialized = new class_2487();
                serialized.method_10569("id", this.id);
                serialized.method_10582("biome_id", this.biome);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)serialized, (OutputStream)out);
                return out.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static BiomeEntry deserialize(int id, byte[] data) {
            try {
                class_2487 compound = class_2507.method_10629((InputStream)new ByteArrayInputStream(data), (class_2505)class_2505.method_53898());
                if (compound.method_68083("id", -1) != id) {
                    throw new IllegalStateException("Encoded id != expected id");
                }
                String biome = compound.method_68564("biome_id", null);
                return new BiomeEntry(id, biome);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

