/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import me.cortex.voxy.common.world.ActiveSectionTracker;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.commonImpl.VoxyCommon;

public final class WorldSection {
    public static final int SECTION_VOLUME = 32768;
    public static final boolean VERIFY_WORLD_SECTION_EXECUTION = VoxyCommon.isVerificationFlagOn("verifyWorldSectionExecution");
    static final VarHandle ATOMIC_STATE_HANDLE;
    private static final VarHandle NON_EMPTY_CHILD_HANDLE;
    private static final VarHandle NON_EMPTY_BLOCK_HANDLE;
    private static final VarHandle IN_SAVE_QUEUE_HANDLE;
    private static final VarHandle IS_DIRTY_HANDLE;
    private static final int ARRAY_REUSE_CACHE_SIZE = 400;
    private static final AtomicInteger ARRAY_REUSE_CACHE_COUNT;
    private static final ConcurrentLinkedDeque<long[]> ARRAY_REUSE_CACHE;
    public final int lvl;
    public final int x;
    public final int y;
    public final int z;
    public final long key;
    long metadata;
    long[] data = null;
    volatile int nonEmptyBlockCount = 0;
    volatile byte nonEmptyChildren;
    final ActiveSectionTracker tracker;
    volatile boolean inSaveQueue;
    volatile boolean isDirty;
    private volatile int atomicState = 1;

    WorldSection(int lvl, int x, int y, int z, ActiveSectionTracker tracker) {
        this.lvl = lvl;
        this.x = x;
        this.y = y;
        this.z = z;
        this.key = WorldEngine.getWorldSectionId(lvl, x, y, z);
        this.tracker = tracker;
        this.data = ARRAY_REUSE_CACHE.poll();
        if (this.data == null) {
            this.data = new long[32768];
        } else {
            ARRAY_REUSE_CACHE_COUNT.decrementAndGet();
        }
    }

    void primeForReuse() {
        ATOMIC_STATE_HANDLE.set(this, 1);
    }

    public long[] _unsafeGetRawDataArray() {
        return this.data;
    }

    public int hashCode() {
        return ((this.x * 1235641 + this.y) * 8127451 + this.z) * 918267913 + this.lvl;
    }

    public boolean tryAcquire() {
        int next;
        int prev;
        do {
            if (((prev = ATOMIC_STATE_HANDLE.get(this)) & 1) != 0) continue;
            return false;
        } while (!ATOMIC_STATE_HANDLE.compareAndSet(this, prev, next = prev + 2));
        return (next & 1) != 0;
    }

    public int acquire() {
        return this.acquire(1);
    }

    public int acquire(int count) {
        int state = ATOMIC_STATE_HANDLE.getAndAdd(this, count << 1) + (count << 1);
        if ((state & 1) == 0) {
            throw new IllegalStateException("Tried to acquire unloaded section: " + WorldEngine.pprintPos(this.key) + " obj: " + System.identityHashCode(this));
        }
        return state >> 1;
    }

    public int getRefCount() {
        return ATOMIC_STATE_HANDLE.get(this) >> 1;
    }

    public int release() {
        return this.release(true);
    }

    int release(boolean unload) {
        int state = ATOMIC_STATE_HANDLE.getAndAdd(this, -2) - 2;
        if (state < 1) {
            throw new IllegalStateException("Section got into an invalid state");
        }
        if ((state & 1) == 0) {
            throw new IllegalStateException("Tried releasing a freed section");
        }
        if (state >> 1 == 0 && unload) {
            if (this.tracker != null) {
                this.tracker.tryUnload(this);
            } else if (this.trySetFreed()) {
                this._releaseArray();
            }
        }
        return state >> 1;
    }

    boolean trySetFreed() {
        int witness = ATOMIC_STATE_HANDLE.compareAndExchange(this, 1, 0);
        if ((witness & 1) == 0 && witness != 0) {
            throw new IllegalStateException("Section marked as free but has refs");
        }
        return witness == 1;
    }

    void _releaseArray() {
        if (VERIFY_WORLD_SECTION_EXECUTION && this.data == null) {
            throw new IllegalStateException();
        }
        if (ARRAY_REUSE_CACHE_COUNT.get() < 400) {
            ARRAY_REUSE_CACHE.add(this.data);
            ARRAY_REUSE_CACHE_COUNT.incrementAndGet();
        }
        this.data = null;
    }

    public void assertNotFree() {
        if (VERIFY_WORLD_SECTION_EXECUTION && (ATOMIC_STATE_HANDLE.get(this) & 1) == 0) {
            throw new IllegalStateException();
        }
    }

    public static int getIndex(int x, int y, int z) {
        int M = 31;
        if (VERIFY_WORLD_SECTION_EXECUTION && (x < 0 || x > 31 || y < 0 || y > 31 || z < 0 || z > 31)) {
            throw new IllegalArgumentException("Out of bounds: " + x + ", " + y + ", " + z);
        }
        return (y & 0x1F) << 10 | (z & 0x1F) << 5 | x & 0x1F;
    }

    public long set(int x, int y, int z, long id) {
        int idx = WorldSection.getIndex(x, y, z);
        long old = this.data[idx];
        this.data[idx] = id;
        return old;
    }

    public long[] copyData() {
        this.assertNotFree();
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void copyDataTo(long[] cache) {
        this.copyDataTo(cache, 0);
    }

    public void copyDataTo(long[] cache, int dstOffset) {
        this.assertNotFree();
        if (cache.length - dstOffset < this.data.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.data, 0, cache, dstOffset, this.data.length);
    }

    public static int getChildIndex(int x, int y, int z) {
        return x & 1 | (y & 1) << 2 | (z & 1) << 1;
    }

    public byte getNonEmptyChildren() {
        return NON_EMPTY_CHILD_HANDLE.get(this);
    }

    public int updateEmptyChildState(WorldSection child) {
        byte next;
        byte prev;
        int childIdx = WorldSection.getChildIndex(child.x, child.y, child.z);
        byte msk = (byte)(1 << childIdx);
        while (!NON_EMPTY_CHILD_HANDLE.compareAndSet(this, prev = this.getNonEmptyChildren(), next = (byte)(prev & ~msk | (child.getNonEmptyChildren() != 0 ? msk : (byte)0)))) {
        }
        return prev != 0 ^ next != 0 ? 2 : (prev != next ? 1 : 0);
    }

    public int getNonEmptyBlockCount() {
        return NON_EMPTY_BLOCK_HANDLE.get(this);
    }

    public int addNonEmptyBlockCount(int delta) {
        int count = NON_EMPTY_BLOCK_HANDLE.getAndAdd(this, delta) + delta;
        if (VERIFY_WORLD_SECTION_EXECUTION && count < 0) {
            throw new IllegalStateException("Count is negative!");
        }
        return count;
    }

    public boolean updateLvl0State() {
        byte next;
        byte prev;
        if (VERIFY_WORLD_SECTION_EXECUTION && this.lvl != 0) {
            throw new IllegalStateException("Tried updating a level 0 lod when its not level 0: " + WorldEngine.pprintPos(this.key));
        }
        while (!NON_EMPTY_CHILD_HANDLE.compareAndSet(this, prev = this.getNonEmptyChildren(), next = (byte)(NON_EMPTY_BLOCK_HANDLE.get(this) == 0 ? 0 : 255))) {
        }
        return prev != next;
    }

    public void _unsafeSetNonEmptyChildren(byte nonEmptyChildren) {
        NON_EMPTY_CHILD_HANDLE.set(this, nonEmptyChildren);
    }

    public static WorldSection _createRawUntrackedUnsafeSection(int lvl, int x, int y, int z) {
        return new WorldSection(lvl, x, y, z, null);
    }

    public boolean exchangeIsInSaveQueue(boolean state) {
        return IN_SAVE_QUEUE_HANDLE.compareAndExchange(this, !state, state) == !state;
    }

    public void markDirty() {
        IS_DIRTY_HANDLE.getAndSet(this, true);
    }

    public boolean setNotDirty() {
        return IS_DIRTY_HANDLE.getAndSet(this, false);
    }

    public boolean isFreed() {
        return (ATOMIC_STATE_HANDLE.get(this) & 1) == 0;
    }

    static {
        try {
            ATOMIC_STATE_HANDLE = MethodHandles.lookup().findVarHandle(WorldSection.class, "atomicState", Integer.TYPE);
            NON_EMPTY_CHILD_HANDLE = MethodHandles.lookup().findVarHandle(WorldSection.class, "nonEmptyChildren", Byte.TYPE);
            NON_EMPTY_BLOCK_HANDLE = MethodHandles.lookup().findVarHandle(WorldSection.class, "nonEmptyBlockCount", Integer.TYPE);
            IN_SAVE_QUEUE_HANDLE = MethodHandles.lookup().findVarHandle(WorldSection.class, "inSaveQueue", Boolean.TYPE);
            IS_DIRTY_HANDLE = MethodHandles.lookup().findVarHandle(WorldSection.class, "isDirty", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        ARRAY_REUSE_CACHE_COUNT = new AtomicInteger(0);
        ARRAY_REUSE_CACHE = new ConcurrentLinkedDeque();
    }
}

