/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.common.world.WorldSection;
import me.cortex.voxy.common.world.other.Mapper;
import me.cortex.voxy.commonImpl.VoxyCommon;
import org.lwjgl.system.MemoryUtil;

public class SaveLoadSystem {
    public static final boolean VERIFY_HASH_ON_LOAD = VoxyCommon.isVerificationFlagOn("verifySectionHash");
    public static final boolean VERIFY_MEMORY_ACCESS = VoxyCommon.isVerificationFlagOn("verifyMemoryAccess");
    public static final int BIGGEST_SERIALIZED_SECTION_SIZE = 524296;
    private static final ThreadLocal<SerializationCache> CACHE = ThreadLocal.withInitial(SerializationCache::new);

    public static int lin2z(int i) {
        int x = i & 0x1F;
        int y = i >> 10 & 0x1F;
        int z = i >> 5 & 0x1F;
        return Integer.expand(x, 4681) | Integer.expand(y, 9362) | Integer.expand(z, 18724);
    }

    public static int z2lin(int i) {
        int x = Integer.compress(i, 4681);
        int y = Integer.compress(i, 9362);
        int z = Integer.compress(i, 18724);
        return x | y << 10 | z << 5;
    }

    public static MemoryBuffer serialize(WorldSection section) {
        SerializationCache cache = CACHE.get();
        long[] data = cache.blockStateCache;
        section.copyDataTo(data);
        short[] compressed = cache.compressedCache;
        Long2ShortOpenHashMap LUT = cache.lutMapCache;
        LUT.clear();
        long[] lutValues = cache.lutCache;
        int lutIndex = 0;
        long pHash = 99L;
        for (int i = 0; i < data.length; ++i) {
            long block = data[i];
            int mapping = LUT.putIfAbsent(block, (short)lutIndex);
            if (mapping == -1) {
                int n = lutIndex;
                lutIndex = (short)(lutIndex + 1);
                mapping = n;
                lutValues[mapping] = block;
            }
            compressed[SaveLoadSystem.lin2z((int)i)] = mapping;
            pHash *= 127817112311121L;
            pHash ^= pHash >> 31;
            pHash += 9918322711L;
            pHash ^= block;
        }
        MemoryBuffer raw = new MemoryBuffer((long)compressed.length * 2L + (long)lutIndex * 8L + 512L);
        long ptr = raw.address;
        long hash = section.key ^ (long)lutIndex * 1293481298141L;
        MemoryUtil.memPutLong((long)ptr, (long)section.key);
        long metadata = 0L;
        MemoryUtil.memPutLong((long)(ptr += 8L), (long)(metadata |= Byte.toUnsignedLong(section.nonEmptyChildren)));
        hash ^= metadata;
        hash *= 1242629872171L;
        MemoryUtil.memPutInt((long)(ptr += 8L), (int)lutIndex);
        ptr += 4L;
        for (int i = 0; i < lutIndex; ++i) {
            long id = lutValues[i];
            MemoryUtil.memPutLong((long)ptr, (long)id);
            ptr += 8L;
            hash *= 1230987149811L;
            hash += 12831L;
            hash ^= id;
        }
        UnsafeUtil.memcpy(compressed, ptr);
        MemoryUtil.memPutLong((long)(ptr += (long)compressed.length * 2L), (long)(hash ^= pHash));
        return raw.subSize((ptr += 8L) - raw.address);
    }

    public static boolean deserialize(WorldSection section, MemoryBuffer data) {
        long ptr = data.address;
        long key = MemoryUtil.memGetLong((long)ptr);
        if (VERIFY_MEMORY_ACCESS && data.size <= (ptr += 8L) - data.address) {
            throw new IllegalStateException("Memory access OOB");
        }
        long metadata = MemoryUtil.memGetLong((long)ptr);
        if (VERIFY_MEMORY_ACCESS && data.size <= (ptr += 8L) - data.address) {
            throw new IllegalStateException("Memory access OOB");
        }
        section.nonEmptyChildren = (byte)(metadata & 0xFFL);
        int lutLen = MemoryUtil.memGetInt((long)ptr);
        if (VERIFY_MEMORY_ACCESS && data.size <= (ptr += 4L) - data.address) {
            throw new IllegalStateException("Memory access OOB");
        }
        if (lutLen > 32768) {
            throw new IllegalStateException("lutLen impossibly large, max size should be 32768 but got size " + lutLen);
        }
        long[] lut = SaveLoadSystem.CACHE.get().lutCache;
        long hash = 0L;
        if (VERIFY_HASH_ON_LOAD) {
            hash = key ^ (long)lutLen * 1293481298141L;
            hash ^= metadata;
            hash *= 1242629872171L;
        }
        for (int i = 0; i < lutLen; ++i) {
            lut[i] = MemoryUtil.memGetLong((long)ptr);
            if (VERIFY_MEMORY_ACCESS && data.size <= (ptr += 8L) - data.address) {
                throw new IllegalStateException("Memory access OOB");
            }
            if (!VERIFY_HASH_ON_LOAD) continue;
            hash *= 1230987149811L;
            hash += 12831L;
            hash ^= lut[i];
        }
        if (section.key != key) {
            Logger.error("Decompressed section not the same as requested. got: " + key + " expected: " + section.key);
            return false;
        }
        int nonEmptyBlockCount = 0;
        for (int i = 0; i < 32768; ++i) {
            long state = lut[Short.toUnsignedInt(MemoryUtil.memGetShort((long)ptr))];
            if (VERIFY_MEMORY_ACCESS && data.size <= (ptr += 2L) - data.address) {
                throw new IllegalStateException("Memory access OOB");
            }
            nonEmptyBlockCount += Mapper.isAir(state) ? 0 : 1;
            section.data[SaveLoadSystem.z2lin((int)i)] = state;
        }
        section.nonEmptyBlockCount = nonEmptyBlockCount;
        if (VERIFY_HASH_ON_LOAD) {
            long pHash = 99L;
            for (long block : section.data) {
                pHash *= 127817112311121L;
                pHash ^= pHash >> 31;
                pHash += 9918322711L;
                pHash ^= block;
            }
            hash ^= pHash;
            long expectedHash = MemoryUtil.memGetLong((long)ptr);
            if (VERIFY_MEMORY_ACCESS && data.size < (ptr += 8L) - data.address) {
                throw new IllegalStateException("Memory access OOB");
            }
            if (expectedHash != hash) {
                Logger.error("Hash mismatch got: " + hash + " expected: " + expectedHash + " removing region");
                return false;
            }
        }
        return true;
    }

    private record SerializationCache(long[] blockStateCache, short[] compressedCache, long[] lutCache, Long2ShortOpenHashMap lutMapCache) {
        public SerializationCache() {
            this(new long[32768], new short[32768], new long[32768], new Long2ShortOpenHashMap(512));
            this.lutMapCache.defaultReturnValue((short)-1);
        }
    }
}

