/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class LoadedPositionTracker {
    private final Supplier<Object> factory;
    private static final Object SENTINEL_LOCK = new Object();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private transient long[] key;
    private transient Object[] value;
    private transient int mask;
    private transient Object zeroObj;
    private static final long LONG_PHI = -7046029254386353131L;
    private static final VarHandle LONG_ARR_HANDLE = MethodHandles.arrayElementVarHandle(long[].class);
    private static final VarHandle ZERO_OBJ_HANDLE;

    public LoadedPositionTracker(Supplier<Object> factory) {
        this.factory = factory;
        this.setSize(12);
    }

    private void setSize(int bits) {
        this.mask = (1 << bits) - 1;
        this.key = new long[1 << bits];
        this.value = new Object[1 << bits];
        this.zeroObj = null;
    }

    public Object getSecOrMakeLoader(long loc) {
        Object val;
        if ((loc = LoadedPositionTracker.mix(loc)) == 0L) {
            Object var = this.zeroObj;
            if (var == null) {
                Object replace = this.factory.get();
                while ((var = ZERO_OBJ_HANDLE.compareAndExchange(this, null, replace)) == SENTINEL_LOCK) {
                }
                if (var == null) {
                    var = replace;
                }
            }
            return var;
        }
        this.aReadLock();
        int pos = this.findAcquire(loc);
        if (pos < 0) {
            if (this.value[pos = -pos - 1] == null) {
                throw new IllegalStateException();
            }
            Object val2 = this.value[pos] = this.factory.get();
            VarHandle.releaseFence();
            this.rReadLock();
            return val2;
        }
        while ((val = this.value[pos]) == null || val == SENTINEL_LOCK) {
            Thread.onSpinWait();
            VarHandle.acquireFence();
        }
        this.rReadLock();
        return val;
    }

    public Object exchange(long loc, Object with) {
        if (with == null) {
            throw new IllegalArgumentException("with cannot be null");
        }
        if ((loc = LoadedPositionTracker.mix(loc)) == 0L) {
            Object val;
            while ((val = ZERO_OBJ_HANDLE.get(this)) == SENTINEL_LOCK || !ZERO_OBJ_HANDLE.compareAndSet(this, val, with)) {
            }
            if (val == null) {
                throw new IllegalStateException();
            }
            return val;
        }
        this.aReadLock();
        int pos = this.find(loc);
        this.rReadLock();
        if (pos < 0) {
            throw new IllegalStateException("Position not found");
        }
        Object val = this.value[pos];
        this.value[pos] = with;
        this.rReadLock();
        if (val == null) {
            throw new IllegalStateException("Value was null");
        }
        return val;
    }

    public Object removeIfCondition(long loc, Predicate<Object> test) {
        if ((loc = LoadedPositionTracker.mix(loc)) == 0L) {
            Object[] val = this.value;
            if (test.test(val)) {
                return ZERO_OBJ_HANDLE.compareAndExchange(this, val, null);
            }
            return null;
        }
        this.aReadLock();
        int pos = this.find(loc);
        this.rReadLock();
        if (pos < 0) {
            return null;
        }
        this.aWriteLock();
        Object val = this.value[pos];
        if (test.test(val)) {
            this.value[pos] = null;
            this.shiftKeys(pos);
            this.rWriteLock();
            return val;
        }
        this.rWriteLock();
        return null;
    }

    private void aReadLock() {
    }

    private void rReadLock() {
    }

    private void aWriteLock() {
    }

    private void rWriteLock() {
    }

    private int find(long k) {
        long[] key = this.key;
        int msk = this.mask;
        int pos = (int)k & msk;
        long curr = key[pos];
        if (curr == 0L) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & msk]) != 0L) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private int findAcquire(long k) {
        long[] key = this.key;
        int msk = this.mask;
        int pos = (int)k & msk;
        long curr = key[pos];
        if (curr == 0L && (curr = LONG_ARR_HANDLE.compareAndExchange(key, pos, 0, k)) == 0L) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & msk]) != 0L || (curr = LONG_ARR_HANDLE.compareAndExchange(key, pos, 0, k)) != 0L) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private void shiftKeys(int pos) {
        long[] key = this.key;
        Object[] value = this.value;
        int msk = this.mask;
        while (true) {
            long curr;
            int last = pos;
            pos = last + 1 & msk;
            while (true) {
                if ((curr = key[pos]) == 0L) {
                    key[last] = 0L;
                    value[last] = null;
                    return;
                }
                int slot = (int)curr & msk;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & msk;
            }
            key[last] = curr;
            value[last] = value[pos];
        }
    }

    public static long mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        LoadedPositionTracker map = new LoadedPositionTracker(AtomicInteger::new);
        ObjectIterator t = new Thread[20];
        Long2ObjectOpenHashMap a = new Long2ObjectOpenHashMap(3000);
        ReentrantLock l = new ReentrantLock();
        for (int j = 0; j < ((Thread[])t).length; ++j) {
            int finalJ = j;
            t[j] = new Thread(() -> {
                Random r = new Random((finalJ + 1) * 1482791);
                for (int i = 0; i < 20024000; ++i) {
                    long p = (long)r.nextInt(3000) * 5981754211L;
                    Object entry = map.getSecOrMakeLoader(p);
                    if (entry instanceof AtomicInteger) {
                        AtomicInteger ai = (AtomicInteger)entry;
                        if (ai.incrementAndGet() <= 2) continue;
                        map.exchange(p, new AtomicInteger[]{ai});
                        continue;
                    }
                    if (entry instanceof AtomicInteger[]) {
                        AtomicInteger[] aia = (AtomicInteger[])entry;
                        AtomicInteger ai = aia[0];
                        ai.incrementAndGet();
                        continue;
                    }
                    throw new IllegalStateException();
                }
            });
            t[j].start();
        }
        long start = System.currentTimeMillis();
        for (Thread tt : t) {
            tt.join();
        }
        System.err.println(System.currentTimeMillis() - start);
        for (Long2ObjectMap.Entry entries : a.long2ObjectEntrySet()) {
            Object val = map.getSecOrMakeLoader(entries.getLongKey());
            int iv = 0;
            if (val instanceof AtomicInteger) {
                AtomicInteger ai = (AtomicInteger)val;
                iv = ai.get();
            } else {
                iv = ((AtomicInteger[])val)[0].get();
            }
            val = entries.getValue();
            int iv2 = 0;
            if (val instanceof AtomicInteger) {
                AtomicInteger ai = (AtomicInteger)val;
                iv2 = ai.get();
            } else {
                iv2 = ((AtomicInteger[])val)[0].get();
            }
            if (iv == iv2) continue;
            throw new IllegalStateException();
        }
    }

    private static /* synthetic */ boolean lambda$main$1(Object obj) {
        if (obj instanceof AtomicInteger) {
            AtomicInteger ai = (AtomicInteger)obj;
            return ai.get() > 100;
        }
        if (obj instanceof AtomicInteger[]) {
            AtomicInteger[] aia = (AtomicInteger[])obj;
            AtomicInteger ai = aia[0];
            return ai.get() > 200;
        }
        throw new IllegalStateException();
    }

    private static /* synthetic */ Object lambda$main$0(long lll) {
        return new AtomicInteger();
    }

    static {
        try {
            ZERO_OBJ_HANDLE = MethodHandles.lookup().findVarHandle(LoadedPositionTracker.class, "zeroObj", Object.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

