/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.voxelization;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.WeakHashMap;
import me.cortex.voxy.common.voxelization.ILightingSupplier;
import me.cortex.voxy.common.voxelization.VoxelizedSection;
import me.cortex.voxy.common.world.other.Mapper;
import me.cortex.voxy.common.world.other.Mipper;
import net.caffeinemc.mods.lithium.common.world.chunk.LithiumHashPalette;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_2814;
import net.minecraft.class_2816;
import net.minecraft.class_2834;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3508;
import net.minecraft.class_6490;
import net.minecraft.class_6502;
import net.minecraft.class_6564;
import net.minecraft.class_6880;
import net.minecraft.class_7522;

public class WorldConversionFactory {
    private static final boolean LITHIUM_INSTALLED = FabricLoader.getInstance().isModLoaded("lithium");
    private static final ThreadLocal<Cache> THREAD_LOCAL = ThreadLocal.withInitial(Cache::new);

    private static boolean setupLithiumLocalPallet(class_2837<class_2680> vp, Reference2IntOpenHashMap<class_2680> blockCache, Mapper mapper, int[] pc) {
        if (vp instanceof LithiumHashPalette) {
            for (int i = 0; i < vp.method_12197(); ++i) {
                class_2680 state = null;
                int blockId = -1;
                try {
                    state = (class_2680)vp.method_12288(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (state != null && (blockId = blockCache.getOrDefault((Object)state, -1)) == -1) {
                    blockId = mapper.getIdForBlockState(state);
                    blockCache.put((Object)state, blockId);
                }
                pc[i] = blockId;
            }
            return true;
        }
        return false;
    }

    private static int setupLocalPalette(class_2837<class_2680> vp, Reference2IntOpenHashMap<class_2680> blockCache, Mapper mapper, int[] pc) {
        int c = vp.method_12197();
        if (vp instanceof class_2834) {
            for (int i = 0; i < vp.method_12197(); ++i) {
                class_2680 state = (class_2680)vp.method_12288(i);
                int blockId = -1;
                if (state != null && (blockId = blockCache.getOrDefault((Object)state, -1)) == -1) {
                    blockId = mapper.getIdForBlockState(state);
                    blockCache.put((Object)state, blockId);
                }
                pc[i] = blockId;
            }
        } else if (vp instanceof class_2814) {
            class_2814 pal = (class_2814)vp;
            for (int i = 0; i < vp.method_12197(); ++i) {
                class_2680 state = null;
                int blockId = -1;
                try {
                    state = (class_2680)vp.method_12288(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (state != null && (blockId = blockCache.getOrDefault((Object)state, -1)) == -1) {
                    blockId = mapper.getIdForBlockState(state);
                    blockCache.put((Object)state, blockId);
                }
                pc[i] = blockId;
            }
        } else if (vp instanceof class_6564) {
            int blockId = -1;
            class_2680 state = (class_2680)vp.method_12288(0);
            if (state != null && (blockId = blockCache.getOrDefault((Object)state, -1)) == -1) {
                blockId = mapper.getIdForBlockState(state);
                blockCache.put((Object)state, blockId);
            }
            pc[0] = blockId;
        } else if (!LITHIUM_INSTALLED || !WorldConversionFactory.setupLithiumLocalPallet(vp, blockCache, mapper, pc)) {
            throw new IllegalStateException("Unknown palette type: " + String.valueOf(vp));
        }
        return c;
    }

    public static VoxelizedSection convert(VoxelizedSection section, Mapper stateMapper, class_2841<class_2680> blockContainer, class_7522<class_6880<class_1959>> biomeContainer, ILightingSupplier lightSupplier) {
        Cache cache = THREAD_LOCAL.get();
        Reference2IntOpenHashMap<class_2680> blockCache = cache.getLocalMapping(stateMapper);
        int[] biomes = cache.biomeCache;
        long[] data = section.section;
        class_2837 vp = blockContainer.field_34560.comp_119;
        int[] pc = cache.getPaletteCache(vp.method_12197());
        class_2816 bps = null;
        int pcc = 0;
        class_2837 class_28372 = blockContainer.field_34560.comp_119;
        if (class_28372 instanceof class_2816) {
            class_2816 _bps;
            bps = _bps = (class_2816)class_28372;
            pcc = bps.method_12197();
        } else {
            pcc = WorldConversionFactory.setupLocalPalette((class_2837<class_2680>)vp, blockCache, stateMapper, pc);
            pcc = Math.max(0, pcc - 1);
        }
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                for (int x = 0; x < 4; ++x) {
                    biomes[i++] = stateMapper.getIdForBiome((class_6880<class_1959>)((class_6880)biomeContainer.method_12321(x, y, z)));
                }
            }
        }
        int nonZeroCnt = 0;
        class_6490 z = blockContainer.field_34560.comp_118;
        if (z instanceof class_3508) {
            class_3508 bStor = (class_3508)z;
            long[] bDat = bStor.method_15212();
            int iterPerLong = 64 / bStor.method_34896() - 1;
            int MSK = (1 << bStor.method_34896()) - 1;
            int eBits = bStor.method_34896();
            long sample = 0L;
            int c = 0;
            int dec = 0;
            for (int i2 = 0; i2 <= 4095; ++i2) {
                if (dec-- == 0) {
                    sample = bDat[c++];
                    dec = iterPerLong;
                }
                int bId = bps == null ? pc[Math.min((int)(sample & (long)MSK), pcc)] : stateMapper.getIdForBlockState((class_2680)bps.method_12288((int)(sample & (long)MSK)));
                sample >>>= eBits;
                byte light = lightSupplier.supply(i2 & 0xF, i2 >> 8 & 0xF, i2 >> 4 & 0xF);
                nonZeroCnt += bId != 0 ? 1 : 0;
                data[i2] = Mapper.composeMappingId(light, bId, biomes[Integer.compress(i2, 3276)]);
            }
        } else {
            if (!(blockContainer.field_34560.comp_118 instanceof class_6502)) {
                throw new IllegalStateException();
            }
            int bId = pc[0];
            if (bId == 0) {
                for (i = 0; i <= 4095; ++i) {
                    data[i] = Mapper.airWithLight(lightSupplier.supply(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF));
                }
            } else {
                nonZeroCnt = 4096;
                for (i = 0; i <= 4095; ++i) {
                    byte light = lightSupplier.supply(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF);
                    data[i] = Mapper.composeMappingId(light, bId, biomes[Integer.compress(i, 3276)]);
                }
            }
        }
        section.lvl0NonAirCount = nonZeroCnt;
        return section;
    }

    private static int G(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private static int H(int x, int y, int z) {
        return (y << 6 | z << 3 | x) + 4096;
    }

    private static int I(int x, int y, int z) {
        return (y << 4 | z << 2 | x) + 512 + 4096;
    }

    private static int J(int x, int y, int z) {
        return (y << 2 | z << 1 | x) + 64 + 512 + 4096;
    }

    public static void mipSection(VoxelizedSection section, Mapper mapper) {
        int x;
        int z;
        int y;
        long[] data = section.section;
        int i = 0;
        int MSK = 3822;
        int iMSK1 = ~MSK + 1;
        int q = 0;
        while (true) {
            data[4096 + i++] = Mipper.mip(data[q | WorldConversionFactory.G(0, 0, 0)], data[q | WorldConversionFactory.G(1, 0, 0)], data[q | WorldConversionFactory.G(0, 0, 1)], data[q | WorldConversionFactory.G(1, 0, 1)], data[q | WorldConversionFactory.G(0, 1, 0)], data[q | WorldConversionFactory.G(1, 1, 0)], data[q | WorldConversionFactory.G(0, 1, 1)], data[q | WorldConversionFactory.G(1, 1, 1)], mapper);
            if (q == MSK) break;
            q = q + iMSK1 & MSK;
        }
        i = 0;
        for (y = 0; y < 8; y += 2) {
            for (z = 0; z < 8; z += 2) {
                for (x = 0; x < 8; x += 2) {
                    data[4608 + i++] = Mipper.mip(data[WorldConversionFactory.H(x, y, z)], data[WorldConversionFactory.H(x + 1, y, z)], data[WorldConversionFactory.H(x, y, z + 1)], data[WorldConversionFactory.H(x + 1, y, z + 1)], data[WorldConversionFactory.H(x, y + 1, z)], data[WorldConversionFactory.H(x + 1, y + 1, z)], data[WorldConversionFactory.H(x, y + 1, z + 1)], data[WorldConversionFactory.H(x + 1, y + 1, z + 1)], mapper);
                }
            }
        }
        i = 0;
        for (y = 0; y < 4; y += 2) {
            for (z = 0; z < 4; z += 2) {
                for (x = 0; x < 4; x += 2) {
                    data[4672 + i++] = Mipper.mip(data[WorldConversionFactory.I(x, y, z)], data[WorldConversionFactory.I(x + 1, y, z)], data[WorldConversionFactory.I(x, y, z + 1)], data[WorldConversionFactory.I(x + 1, y, z + 1)], data[WorldConversionFactory.I(x, y + 1, z)], data[WorldConversionFactory.I(x + 1, y + 1, z)], data[WorldConversionFactory.I(x, y + 1, z + 1)], data[WorldConversionFactory.I(x + 1, y + 1, z + 1)], mapper);
                }
            }
        }
        data[4680] = Mipper.mip(data[WorldConversionFactory.J(0, 0, 0)], data[WorldConversionFactory.J(1, 0, 0)], data[WorldConversionFactory.J(0, 0, 1)], data[WorldConversionFactory.J(1, 0, 1)], data[WorldConversionFactory.J(0, 1, 0)], data[WorldConversionFactory.J(1, 1, 0)], data[WorldConversionFactory.J(0, 1, 1)], data[WorldConversionFactory.J(1, 1, 1)], mapper);
    }

    private static final class Cache {
        private final int[] biomeCache = new int[64];
        private final WeakHashMap<Mapper, Reference2IntOpenHashMap<class_2680>> localMapping = new WeakHashMap();
        private int[] paletteCache = new int[1024];

        private Cache() {
        }

        private Reference2IntOpenHashMap<class_2680> getLocalMapping(Mapper mapper) {
            return this.localMapping.computeIfAbsent(mapper, a_ -> new Reference2IntOpenHashMap());
        }

        private int[] getPaletteCache(int size) {
            if (this.paletteCache.length < size) {
                this.paletteCache = new int[size];
            }
            return this.paletteCache;
        }
    }
}

