/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util.cpu;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Random;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.ThreadUtils;
import org.lwjgl.system.Platform;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class CpuLayout {
    public static final Core[] CORES = Platform.get() == Platform.WINDOWS ? CpuLayout.generateCoreLayoutWindows() : (Platform.get() == Platform.LINUX ? CpuLayout.generateCoreLayoutLinux() : null);

    private CpuLayout() {
    }

    public static void setThreadAffinity(Core ... cores) {
        Affinity[] affinity = new Affinity[cores.length];
        for (int i = 0; i < cores.length; ++i) {
            affinity[i] = cores[i].affinity;
        }
        CpuLayout.setThreadAffinity(affinity);
    }

    public static void setThreadAffinity(Affinity ... affinities) {
        Platform platform = Platform.get();
        if (platform == Platform.WINDOWS) {
            long[] msks = new long[affinities.length];
            short[] groups = new short[affinities.length];
            Arrays.fill(groups, (short)-1);
            int i = 0;
            for (Affinity a2 : affinities) {
                int idx;
                for (idx = 0; idx < i && groups[idx] != a2.group; ++idx) {
                }
                if (idx == i) {
                    groups[idx] = a2.group;
                    ++i;
                }
                int n = idx;
                msks[n] = msks[n] | a2.msk;
            }
            ThreadUtils.SetThreadSelectedCpuSetMasksWin32(Arrays.copyOf(msks, i), Arrays.copyOf(groups, i));
        } else if (platform == Platform.LINUX) {
            Arrays.sort(affinities, (a, b) -> a.group - b.group);
            long[] msks = new long[affinities.length];
            for (int i = 0; i < affinities.length; ++i) {
                msks[i] = affinities[i].msk;
            }
            ThreadUtils.schedSetaffinityLinux(msks);
        } else {
            Logger.error("Don't know how to set thread affinity on this platform.");
        }
    }

    private static Core[] generateCoreLayoutWindows() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] cores = Kernel32Util.getLogicalProcessorInformationEx((int)0);
        boolean allSameClass = true;
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX coreO : cores) {
            WinNT.PROCESSOR_RELATIONSHIP core = (WinNT.PROCESSOR_RELATIONSHIP)coreO;
            allSameClass &= core.efficiencyClass == 0;
        }
        int i = 0;
        Core[] res = new Core[cores.length];
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX coreO : cores) {
            WinNT.PROCESSOR_RELATIONSHIP core = (WinNT.PROCESSOR_RELATIONSHIP)coreO;
            boolean smt = (core.flags & 1) == 1;
            byte eclz = core.efficiencyClass;
            if (core.groupMask.length != 1) {
                throw new IllegalStateException("Unsupported architecture");
            }
            long msk = core.groupMask[0].mask.longValue();
            if (Long.bitCount(msk) > 1 != smt) {
                throw new IllegalStateException("Logic issue");
            }
            res[i++] = new Core(!allSameClass && eclz == 0, new Affinity(msk, core.groupMask[0].group));
        }
        CpuLayout.sort(res);
        return res;
    }

    private static Core[] generateCoreLayoutLinux() {
        CentralProcessor processor = new SystemInfo().getHardware().getProcessor();
        Int2ObjectOpenHashMap affinityMsk = new Int2ObjectOpenHashMap();
        for (CentralProcessor.LogicalProcessor thread : processor.getLogicalProcessors()) {
            Affinity aff = (Affinity)affinityMsk.getOrDefault(thread.getPhysicalProcessorNumber(), (Object)new Affinity(0L, (short)thread.getProcessorGroup()));
            if (thread.getProcessorGroup() != aff.group) {
                throw new IllegalStateException();
            }
            affinityMsk.put(thread.getPhysicalProcessorNumber(), (Object)new Affinity(aff.msk | 1L << thread.getProcessorNumber(), (short)thread.getProcessorGroup()));
        }
        Core[] cores = new Core[processor.getPhysicalProcessors().size()];
        int i = 0;
        boolean allSameEfficiency = true;
        for (CentralProcessor.PhysicalProcessor core : processor.getPhysicalProcessors()) {
            if (core.getEfficiency() == 0) continue;
            allSameEfficiency = false;
            break;
        }
        for (CentralProcessor.PhysicalProcessor core : processor.getPhysicalProcessors()) {
            Affinity aff = (Affinity)affinityMsk.remove(core.getPhysicalProcessorNumber());
            if (aff == null) {
                throw new IllegalStateException();
            }
            cores[i++] = new Core(core.getEfficiency() == 0 && !allSameEfficiency, aff);
        }
        CpuLayout.sort(cores);
        return cores;
    }

    private static void sort(Core[] cores) {
        Arrays.sort(cores, (a, b) -> {
            if (a.isEfficiency == b.isEfficiency) {
                int c = Short.compareUnsigned(a.affinity.group, b.affinity.group);
                if (c == 0) {
                    return Long.compareUnsigned(a.affinity.msk, b.affinity.msk);
                }
                return c;
            }
            return a.isEfficiency ? 1 : -1;
        });
    }

    public static void main(String[] args) throws InterruptedException {
        System.err.println(Arrays.toString(CORES));
        CpuLayout.setThreadAffinity(CORES[0], CORES[1]);
        int i = 0;
        while (i < 20) {
            int finalI = i++;
            new Thread(() -> {
                CpuLayout.setThreadAffinity(CORES[finalI & 3]);
                Random r = new Random();
                int j = 0;
                while (r.nextLong() != 0L) {
                    ++j;
                }
                System.out.println(j);
            }).start();
        }
        while (true) {
            Thread.sleep(100L);
        }
    }

    public static int getCoreCount() {
        if (CORES == null) {
            return Runtime.getRuntime().availableProcessors();
        }
        return CORES.length;
    }

    public record Affinity(long msk, short group) {
    }

    public record Core(boolean isEfficiency, Affinity affinity) {
    }
}

