/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.Kernel32;

public class ThreadUtils {
    public static final int WIN32_THREAD_PRIORITY_TIME_CRITICAL = 15;
    public static final int WIN32_THREAD_PRIORITY_LOWEST = -2;
    public static final int WIN32_THREAD_MODE_BACKGROUND_BEGIN = 65536;
    public static final int WIN32_THREAD_MODE_BACKGROUND_END = 131072;
    public static final boolean isWindows;
    private static final long SetThreadPriority;
    private static final long SetThreadSelectedCpuSetMasks;
    private static final long schedSetaffinity;

    public static boolean SetThreadSelectedCpuSetMasksWin32(long mask) {
        return ThreadUtils.SetThreadSelectedCpuSetMasksWin32(new long[]{mask}, new short[]{0});
    }

    public static boolean SetThreadSelectedCpuSetMasksWin32(long[] masks, short[] groups) {
        if (SetThreadSelectedCpuSetMasks == 0L || !isWindows) {
            return false;
        }
        if (masks == null) {
            int retVal = JNI.invokePPCI((long)Kernel32.GetCurrentThread(), (long)0L, (short)0, (long)SetThreadSelectedCpuSetMasks);
            if (retVal == 0) {
                throw new IllegalStateException();
            }
            return true;
        }
        if (masks.length != groups.length) {
            throw new IllegalArgumentException();
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            long ptr = stack.ncalloc(16, masks.length, 16);
            MemoryUtil.memSet((long)ptr, (int)0, (long)((long)masks.length * 16L));
            for (int i = 0; i < masks.length; ++i) {
                MemoryUtil.memPutLong((long)(ptr + (long)i * 16L), (long)masks[i]);
                MemoryUtil.memPutShort((long)(ptr + (long)i * 16L + 8L), (short)groups[i]);
            }
            int retVal = JNI.invokePPCI((long)Kernel32.GetCurrentThread(), (long)ptr, (short)((short)masks.length), (long)SetThreadSelectedCpuSetMasks);
            if (retVal == 0) {
                throw new IllegalStateException();
            }
            boolean bl = true;
            return bl;
        }
    }

    public static boolean SetSelfThreadPriorityWin32(int priority) {
        if (SetThreadPriority == 0L || !isWindows) {
            return false;
        }
        if (JNI.callPI((long)Kernel32.GetCurrentThread(), (int)priority, (long)SetThreadPriority) == 0) {
            throw new IllegalStateException("Operation failed");
        }
        return true;
    }

    public static boolean schedSetaffinityLinux(long[] masks) {
        if (schedSetaffinity == 0L || isWindows) {
            return false;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            long ptr = stack.ncalloc(8, masks.length, 8);
            for (int i = 0; i < masks.length; ++i) {
                MemoryUtil.memPutLong((long)(ptr + (long)i * 8L), (long)masks[i]);
            }
            int retVal = JNI.invokePPI((int)0, (long)((long)masks.length * 8L), (long)ptr, (long)schedSetaffinity);
            if (retVal != 0) {
                throw new IllegalStateException();
            }
            boolean bl = true;
            return bl;
        }
    }

    static {
        boolean bl = isWindows = Platform.get() == Platform.WINDOWS;
        if (isWindows) {
            SetThreadPriority = Kernel32.getLibrary().getFunctionAddress((CharSequence)"SetThreadPriority");
            SetThreadSelectedCpuSetMasks = Kernel32.getLibrary().getFunctionAddress((CharSequence)"SetThreadSelectedCpuSetMasks");
        } else {
            SetThreadPriority = 0L;
            SetThreadSelectedCpuSetMasks = 0L;
        }
        if (Platform.get() == Platform.LINUX) {
            SharedLibrary libc = APIUtil.apiCreateLibrary((String)"libc.so.6");
            schedSetaffinity = APIUtil.apiGetFunctionAddress((FunctionProvider)libc, (String)"sched_setaffinity");
        } else {
            schedSetaffinity = 0L;
        }
    }
}

