/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util;

import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;

public class AllocationArena {
    public static final long SIZE_LIMIT = -1L;
    private static final int ADDR_BITS = 34;
    private static final int SIZE_BITS = 30;
    private static final long SIZE_MSK = 0x3FFFFFFFL;
    private static final long ADDR_MSK = 0x3FFFFFFFFL;
    private final LongRBTreeSet FREE = new LongRBTreeSet(Long::compareUnsigned);
    private final LongRBTreeSet TAKEN = new LongRBTreeSet(Long::compareUnsigned);
    private long sizeLimit = Long.MAX_VALUE;
    private long totalSize;
    private boolean resized;

    public void reset() {
        this.FREE.clear();
        this.TAKEN.clear();
        this.sizeLimit = Long.MAX_VALUE;
        this.totalSize = 0L;
        this.resized = false;
    }

    public boolean getResetResized() {
        boolean ret = this.resized;
        this.resized = false;
        return ret;
    }

    public long getSize() {
        return this.totalSize;
    }

    public int numFreeBlocks() {
        return this.FREE.size();
    }

    public int getLargestFreeBlockSize(int index) {
        LongBidirectionalIterator iter = this.FREE.tailSet(-1L).iterator();
        while (index > 0 && iter.hasPrevious()) {
            iter.previousLong();
            --index;
        }
        long slot = iter.previousLong();
        return (int)(slot >> 34);
    }

    public long alloc(int size) {
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        LongBidirectionalIterator iter = this.FREE.iterator(((long)size << 34) - 1L);
        if (!iter.hasNext()) {
            this.resized = true;
            long addr = this.totalSize;
            if (this.totalSize + (long)size > this.sizeLimit) {
                return -1L;
            }
            this.totalSize += (long)size;
            this.TAKEN.add(addr << 30 | (long)size);
            return addr;
        }
        long slot = iter.nextLong();
        iter.remove();
        if (slot >>> 34 == (long)size) {
            this.TAKEN.add(slot << 30 | slot >>> 34);
        } else {
            this.TAKEN.add((slot & 0x3FFFFFFFFL) << 30 | (long)size);
            this.FREE.add((slot >>> 34) - (long)size << 34 | (slot & 0x3FFFFFFFFL) + (long)size);
        }
        return slot & 0x3FFFFFFFFL;
    }

    public int free(long addr) {
        long delta;
        long endAddr;
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        long size = slot & 0x3FFFFFFFL;
        iter.remove();
        if (iter.hasPrevious()) {
            long prevSlot = iter.previousLong();
            endAddr = (prevSlot >>> 30) + (prevSlot & 0x3FFFFFFFL);
            if (endAddr != addr) {
                delta = addr - endAddr;
                this.FREE.remove(delta << 34 | endAddr);
                slot = endAddr << 30 | (slot & 0x3FFFFFFFL) + delta;
            }
            iter.nextLong();
        } else if (!this.FREE.isEmpty() && this.FREE.remove(addr << 34)) {
            slot = addr + size;
        }
        if (iter.hasNext()) {
            endAddr = (slot >>> 30) + (slot & 0x3FFFFFFFL);
            long nextSlot = iter.nextLong();
            if (endAddr != nextSlot >>> 30) {
                delta = (nextSlot >>> 30) - endAddr;
                this.FREE.remove(delta << 34 | endAddr);
                slot = slot & 0xFFFFFFFFC0000000L | (slot & 0x3FFFFFFFL) + delta;
            }
        } else {
            this.resized = true;
            this.totalSize -= slot & 0x3FFFFFFFL;
            return (int)size;
        }
        slot = slot >>> 30 | slot << 34;
        this.FREE.add(slot);
        return (int)size;
    }

    public boolean expand(long addr, int extra) {
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        if (!iter.hasNext()) {
            return false;
        }
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        long updatedSlot = slot & 0xFFFFFFFFC0000000L | (slot & 0x3FFFFFFFL) + (long)extra;
        if (iter.hasNext()) {
            long endAddr;
            long next = iter.nextLong();
            long delta = (next >>> 30) - (endAddr = (slot >>> 30) + (slot & 0x3FFFFFFFL));
            if ((long)extra <= delta) {
                this.FREE.remove(delta << 34 | endAddr);
                iter.previousLong();
                iter.previousLong();
                iter.remove();
                this.TAKEN.add(updatedSlot);
                if ((long)extra != delta) {
                    this.FREE.add(delta - (long)extra << 34 | endAddr + (long)extra);
                }
                return true;
            }
            return false;
        }
        if (this.totalSize + (long)extra > this.sizeLimit) {
            return false;
        }
        iter.remove();
        this.TAKEN.add(updatedSlot);
        this.totalSize += (long)extra;
        return true;
    }

    public long getSize(long addr) {
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        if (!iter.hasNext()) {
            throw new IllegalArgumentException();
        }
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        return slot & 0x3FFFFFFFL;
    }

    public void setLimit(long size) {
        this.sizeLimit = size;
        if (this.sizeLimit < this.totalSize) {
            throw new IllegalStateException("Size set smaller than current size");
        }
    }

    public long getLimit() {
        return this.sizeLimit;
    }
}

