/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.cortex.voxy.common.thread.MultiThreadPrioritySemaphore;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.util.Pair;

public class UnifiedServiceThreadPool {
    public final ServiceManager serviceManager;
    public final MultiThreadPrioritySemaphore groupSemaphore;
    private final MultiThreadPrioritySemaphore.Block selfBlock;
    private final ThreadGroup dedicatedPool;
    private final List<Thread> threads = new ArrayList<Thread>();
    private int threadId = 0;

    public UnifiedServiceThreadPool() {
        this.dedicatedPool = new ThreadGroup("Voxy Dedicated Service");
        this.serviceManager = new ServiceManager(this::release);
        this.groupSemaphore = new MultiThreadPrioritySemaphore(this.serviceManager::tryRunAJob);
        this.selfBlock = this.groupSemaphore.createBlock();
    }

    private final void release(int i) {
        this.groupSemaphore.pooledRelease(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNumThreads(int threads) {
        List<Thread> list = this.threads;
        synchronized (list) {
            int diff = threads - this.threads.size();
            if (diff == 0) {
                return false;
            }
            if (diff < 0) {
                this.selfBlock.release(-diff);
            } else {
                for (int i = 0; i < diff; ++i) {
                    Thread t = new Thread(this.dedicatedPool, this::workerThread, "Dedicated Voxy Worker #" + this.threadId++);
                    t.setPriority(3);
                    t.setDaemon(true);
                    this.threads.add(t);
                    t.start();
                }
            }
        }
        while (true) {
            list = this.threads;
            synchronized (list) {
                if (this.threads.size() == threads) {
                    return true;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerThread() {
        this.selfBlock.acquire();
        List<Thread> list = this.threads;
        synchronized (list) {
            this.threads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.serviceManager.shutdown();
        this.selfBlock.release(10000);
        while (true) {
            List<Thread> list = this.threads;
            synchronized (list) {
                if (this.threads.isEmpty()) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.selfBlock.free();
    }

    public static void main(String[] args) {
        UnifiedServiceThreadPool ustp = new UnifiedServiceThreadPool();
        AtomicInteger cc = new AtomicInteger();
        AtomicInteger cnt = new AtomicInteger();
        Service s1 = ustp.serviceManager.createService(() -> {
            AtomicBoolean cleaned = new AtomicBoolean();
            AtomicInteger a = new AtomicInteger();
            return new Pair<Runnable, Runnable>(() -> {
                if (cleaned.get()) {
                    System.err.println("TRIED EXECUTING CLEANED CTX");
                } else {
                    a.incrementAndGet();
                    cnt.incrementAndGet();
                }
            }, () -> {
                if (cleaned.getAndSet(true)) {
                    System.err.println("TRIED DOUBLE CLEANING A VALUE");
                } else {
                    System.out.println("Cleaned ref, exec: " + a.get());
                    cc.incrementAndGet();
                }
            });
        }, 1L);
        for (int i = 0; i < 1000; ++i) {
            s1.execute();
        }
        ustp.setNumThreads(1);
        ustp.setNumThreads(10);
        ustp.setNumThreads(0);
        ustp.setNumThreads(1);
        s1.blockTillEmpty();
        s1.shutdown();
        ustp.shutdown();
        System.out.println(cnt);
    }
}

