/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.rocksdb;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.LongConsumer;
import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.storage.StorageBackend;
import me.cortex.voxy.common.config.storage.StorageConfig;
import me.cortex.voxy.common.util.MemoryBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Filter;
import org.rocksdb.HyperClockCache;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;

public class RocksDBStorageBackend
extends StorageBackend {
    private final RocksDB db;
    private final ColumnFamilyHandle worldSections;
    private final ColumnFamilyHandle idMappings;
    private final ReadOptions sectionReadOps;
    private final WriteOptions sectionWriteOps;
    private final List<AbstractImmutableNativeReference> closeList = new ArrayList<AbstractImmutableNativeReference>();

    public RocksDBStorageBackend(String path) {
        RocksDB.loadLibrary();
        ColumnFamilyOptions cfOpts = new ColumnFamilyOptions().setCompressionType(CompressionType.ZSTD_COMPRESSION).optimizeForSmallDb();
        ColumnFamilyOptions cfWorldSecOpts = new ColumnFamilyOptions().setCompressionType(CompressionType.NO_COMPRESSION).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setLevelCompactionDynamicLevelBytes(true).optimizeForPointLookup(128L);
        HyperClockCache bCache = new HyperClockCache(0x8000000L, 0L, 4, false);
        BloomFilter filter = new BloomFilter(10.0);
        cfWorldSecOpts.setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setCacheIndexAndFilterBlocksWithHighPriority(true).setBlockCache((Cache)bCache).setDataBlockHashTableUtilRatio(0.75).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinaryAndHash).setFilterPolicy((Filter)filter));
        List<ColumnFamilyDescriptor> cfDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOpts), new ColumnFamilyDescriptor("world_sections".getBytes(), cfWorldSecOpts), new ColumnFamilyDescriptor("id_mappings".getBytes(), cfOpts));
        DBOptions options = new DBOptions().setAvoidUnnecessaryBlockingIO(true).setIncreaseParallelism(2).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setMaxTotalWalSize(0x8000000L);
        ArrayList handles = new ArrayList();
        try {
            this.db = RocksDB.open((DBOptions)options, (String)path, cfDescriptors, handles);
            this.sectionReadOps = new ReadOptions();
            this.sectionWriteOps = new WriteOptions();
            this.closeList.addAll(handles);
            this.closeList.add((AbstractImmutableNativeReference)this.db);
            this.closeList.add((AbstractImmutableNativeReference)options);
            this.closeList.add((AbstractImmutableNativeReference)cfOpts);
            this.closeList.add((AbstractImmutableNativeReference)cfWorldSecOpts);
            this.closeList.add((AbstractImmutableNativeReference)this.sectionReadOps);
            this.closeList.add((AbstractImmutableNativeReference)this.sectionWriteOps);
            this.closeList.add((AbstractImmutableNativeReference)filter);
            this.closeList.add((AbstractImmutableNativeReference)bCache);
            this.worldSections = (ColumnFamilyHandle)handles.get(1);
            this.idMappings = (ColumnFamilyHandle)handles.get(2);
            this.db.flushWal(true);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void iterateStoredSectionPositions(LongConsumer consumer) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer keyBuff = stack.calloc(8);
            long keyBuffPtr = MemoryUtil.memAddress((ByteBuffer)keyBuff);
            RocksIterator iter = this.db.newIterator(this.worldSections, this.sectionReadOps);
            iter.seekToFirst();
            while (iter.isValid()) {
                iter.key(keyBuff);
                long key = Long.reverseBytes(MemoryUtil.memGetLong((long)keyBuffPtr));
                consumer.accept(key);
                iter.next();
            }
            iter.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MemoryBuffer getSectionData(long key, MemoryBuffer scratch) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buffer = stack.malloc(8);
            MemoryUtil.memPutLong((long)MemoryUtil.memAddress((ByteBuffer)buffer), (long)Long.reverseBytes(RocksDBStorageBackend.swizzlePos(key)));
            int result = this.db.get(this.worldSections, this.sectionReadOps, buffer, MemoryUtil.memByteBuffer((long)scratch.address, (int)((int)scratch.size)));
            if (result == -1) {
                MemoryBuffer memoryBuffer2 = null;
                return memoryBuffer2;
            }
            MemoryBuffer memoryBuffer = scratch.subSize(result);
            return memoryBuffer;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSectionData(long key, MemoryBuffer data) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer keyBuff = stack.calloc(8);
            MemoryUtil.memPutLong((long)MemoryUtil.memAddress((ByteBuffer)keyBuff), (long)Long.reverseBytes(RocksDBStorageBackend.swizzlePos(key)));
            this.db.put(this.worldSections, this.sectionWriteOps, keyBuff, data.asByteBuffer());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteSectionData(long key) {
        try {
            this.db.delete(this.worldSections, RocksDBStorageBackend.longToBytes(RocksDBStorageBackend.swizzlePos(key)));
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putIdMapping(int id, ByteBuffer data) {
        try {
            byte[] buffer = new byte[data.remaining()];
            data.get(buffer);
            data.rewind();
            this.db.put(this.idMappings, RocksDBStorageBackend.intToBytes(id), buffer);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Int2ObjectOpenHashMap<byte[]> getIdMappingsData() {
        RocksIterator iterator = this.db.newIterator(this.idMappings);
        Int2ObjectOpenHashMap out = new Int2ObjectOpenHashMap();
        iterator.seekToFirst();
        while (iterator.isValid()) {
            out.put(RocksDBStorageBackend.bytesToInt(iterator.key()), (Object)iterator.value());
            iterator.next();
        }
        return out;
    }

    @Override
    public void flush() {
        try {
            this.db.flushWal(true);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.flush();
        this.closeList.forEach(AbstractImmutableNativeReference::close);
    }

    private static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    private static int bytesToInt(byte[] i) {
        return Byte.toUnsignedInt(i[0]) << 24 | Byte.toUnsignedInt(i[1]) << 16 | Byte.toUnsignedInt(i[2]) << 8 | Byte.toUnsignedInt(i[3]);
    }

    private static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    private static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    private static long swizzlePos(long key) {
        return key;
    }

    public static class Config
    extends StorageConfig {
        @Override
        public StorageBackend build(ConfigBuildCtx ctx) {
            return new RocksDBStorageBackend(ctx.ensurePathExists(ctx.substituteString(ctx.resolvePath())));
        }

        public static String getConfigTypeName() {
            return "RocksDB";
        }
    }
}

