/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.inmemory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.function.LongConsumer;
import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.storage.StorageBackend;
import me.cortex.voxy.common.config.storage.StorageConfig;
import me.cortex.voxy.common.util.MemoryBuffer;
import net.minecraft.class_6673;
import org.apache.commons.lang3.stream.Streams;
import org.lwjgl.system.MemoryUtil;

public class MemoryStorageBackend
extends StorageBackend {
    private final Long2ObjectMap<MemoryBuffer>[] maps;
    private final Int2ObjectMap<ByteBuffer> idMappings = new Int2ObjectOpenHashMap();

    public MemoryStorageBackend() {
        this(4);
    }

    private Long2ObjectMap<MemoryBuffer> getMap(long key) {
        return this.maps[(int)(class_6673.method_39002((long)(class_6673.method_39002((long)key) ^ key)) & (long)(this.maps.length - 1))];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateStoredSectionPositions(LongConsumer consumer) {
        Long2ObjectMap<MemoryBuffer>[] long2ObjectMapArray = this.maps;
        int n = long2ObjectMapArray.length;
        for (int i = 0; i < n; ++i) {
            Long2ObjectMap<MemoryBuffer> map;
            Long2ObjectMap<MemoryBuffer> long2ObjectMap = map = long2ObjectMapArray[i];
            synchronized (long2ObjectMap) {
                map.keySet().forEach(consumer);
                continue;
            }
        }
    }

    public MemoryStorageBackend(int slicesBitCount) {
        this.maps = new Long2ObjectMap[1 << slicesBitCount];
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new Long2ObjectOpenHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBuffer getSectionData(long key, MemoryBuffer scratch) {
        Long2ObjectMap<MemoryBuffer> map;
        Long2ObjectMap<MemoryBuffer> long2ObjectMap = map = this.getMap(key);
        synchronized (long2ObjectMap) {
            MemoryBuffer data = (MemoryBuffer)map.get(key);
            if (data != null) {
                data.cpyTo(scratch.address);
                return scratch.subSize(data.size);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSectionData(long key, MemoryBuffer data) {
        Long2ObjectMap<MemoryBuffer> map;
        Long2ObjectMap<MemoryBuffer> long2ObjectMap = map = this.getMap(key);
        synchronized (long2ObjectMap) {
            MemoryBuffer cpy = data.copy();
            MemoryBuffer old = (MemoryBuffer)map.put(key, (Object)cpy);
            if (old != null) {
                old.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSectionData(long key) {
        Long2ObjectMap<MemoryBuffer> map;
        Long2ObjectMap<MemoryBuffer> long2ObjectMap = map = this.getMap(key);
        synchronized (long2ObjectMap) {
            MemoryBuffer data = (MemoryBuffer)map.remove(key);
            if (data != null) {
                data.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIdMapping(int id, ByteBuffer data) {
        Int2ObjectMap<ByteBuffer> int2ObjectMap = this.idMappings;
        synchronized (int2ObjectMap) {
            ByteBuffer cpy = MemoryUtil.memAlloc((int)data.remaining());
            MemoryUtil.memCopy((ByteBuffer)data, (ByteBuffer)cpy);
            ByteBuffer prev = (ByteBuffer)this.idMappings.put(id, (Object)cpy);
            if (prev != null) {
                MemoryUtil.memFree((Buffer)prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Int2ObjectOpenHashMap<byte[]> getIdMappingsData() {
        Int2ObjectOpenHashMap out = new Int2ObjectOpenHashMap();
        Int2ObjectMap<ByteBuffer> int2ObjectMap = this.idMappings;
        synchronized (int2ObjectMap) {
            for (Int2ObjectMap.Entry entry : this.idMappings.int2ObjectEntrySet()) {
                byte[] buf = new byte[((ByteBuffer)entry.getValue()).remaining()];
                ((ByteBuffer)entry.getValue()).get(buf);
                ((ByteBuffer)entry.getValue()).rewind();
                out.put(entry.getIntKey(), (Object)buf);
            }
            return out;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        Streams.of((Object[])this.maps).map(Long2ObjectMap::values).flatMap(Collection::stream).forEach(MemoryBuffer::free);
        this.idMappings.values().forEach(MemoryUtil::memFree);
    }

    public static class Config
    extends StorageConfig {
        @Override
        public StorageBackend build(ConfigBuildCtx ctx) {
            return new MemoryStorageBackend();
        }

        public static String getConfigTypeName() {
            return "Memory";
        }
    }
}

