/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.compressors;

import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.compressors.CompressorConfig;
import me.cortex.voxy.common.config.compressors.StorageCompressor;
import me.cortex.voxy.common.util.GlobalCleaner;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.ThreadLocalMemoryBuffer;
import org.lwjgl.util.zstd.Zstd;

public class ZSTDCompressor
implements StorageCompressor {
    private static final ThreadLocal<Ref> COMPRESSION_CTX = ThreadLocal.withInitial(ZSTDCompressor::createCleanableCompressionContext);
    private static final ThreadLocal<Ref> DECOMPRESSION_CTX = ThreadLocal.withInitial(ZSTDCompressor::createCleanableDecompressionContext);
    private static final ThreadLocalMemoryBuffer SCRATCH = new ThreadLocalMemoryBuffer(525320L);
    private final int level;

    private static Ref createCleanableCompressionContext() {
        long ctx = Zstd.ZSTD_createCCtx();
        Ref ref = new Ref(ctx);
        GlobalCleaner.CLEANER.register(ref, () -> Zstd.ZSTD_freeCCtx((long)ctx));
        return ref;
    }

    private static Ref createCleanableDecompressionContext() {
        long ctx = Zstd.ZSTD_createDCtx();
        Zstd.nZSTD_DCtx_setParameter((long)ctx, (int)1002, (int)1);
        Ref ref = new Ref(ctx);
        GlobalCleaner.CLEANER.register(ref, () -> Zstd.ZSTD_freeDCtx((long)ctx));
        return ref;
    }

    public ZSTDCompressor(int level) {
        this.level = level;
    }

    @Override
    public MemoryBuffer compress(MemoryBuffer saveData) {
        MemoryBuffer compressedData = new MemoryBuffer((int)Zstd.ZSTD_COMPRESSBOUND((long)saveData.size));
        long compressedSize = Zstd.nZSTD_compressCCtx((long)ZSTDCompressor.COMPRESSION_CTX.get().ptr, (long)compressedData.address, (long)compressedData.size, (long)saveData.address, (long)saveData.size, (int)this.level);
        return compressedData.subSize(compressedSize);
    }

    @Override
    public MemoryBuffer decompress(MemoryBuffer saveData) {
        MemoryBuffer decompressed = SCRATCH.get().createUntrackedUnfreeableReference();
        long size = Zstd.nZSTD_decompressDCtx((long)ZSTDCompressor.DECOMPRESSION_CTX.get().ptr, (long)decompressed.address, (long)decompressed.size, (long)saveData.address, (long)saveData.size);
        return decompressed.subSize(size);
    }

    @Override
    public void close() {
    }

    private record Ref(long ptr) {
    }

    public static class Config
    extends CompressorConfig {
        public int compressionLevel;

        @Override
        public StorageCompressor build(ConfigBuildCtx ctx) {
            return new ZSTDCompressor(this.compressionLevel);
        }

        public static String getConfigTypeName() {
            return "ZSTD";
        }
    }
}

