/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.cortex.voxy.common.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class Serialization {
    public static final Set<Class<?>> CONFIG_TYPES = new HashSet();
    public static Gson GSON;

    public static void init() {
        String BASE_SEARCH_PACKAGE = "me.cortex.voxy";
        HashMap<Class, GsonConfigSerialization> serializers = new HashMap<Class, GsonConfigSerialization>();
        LinkedHashSet<String> clazzs = new LinkedHashSet<String>();
        Path path = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("voxy").get()).getRootPaths().get(0);
        clazzs.addAll(Serialization.collectAllClasses(path, BASE_SEARCH_PACKAGE));
        clazzs.addAll(Serialization.collectAllClasses(BASE_SEARCH_PACKAGE));
        int count = 0;
        block4: for (String clzName : clazzs) {
            if (!clzName.toLowerCase(Locale.ROOT).contains("config") || clzName.contains("mixin") || clzName.contains("ModMenuIntegration") || clzName.contains("VoxyConfigScreenPages") || clzName.endsWith("VoxyConfig") || clzName.equals(Serialization.class.getName())) continue;
            try {
                Class<?> clz = Class.forName(clzName);
                if (Modifier.isAbstract(clz.getModifiers())) continue;
                Class<?> original = clz;
                while ((clz = clz.getSuperclass()) != null) {
                    if (!CONFIG_TYPES.contains(clz)) continue;
                    Method nameMethod = null;
                    try {
                        nameMethod = original.getMethod("getConfigTypeName", new Class[0]);
                        nameMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (nameMethod == null) {
                        Logger.error("WARNING: Config class " + clzName + " doesnt contain a getConfigTypeName and thus wont be serializable");
                        continue block4;
                    }
                    ++count;
                    String name = (String)nameMethod.invoke(null, new Object[0]);
                    serializers.computeIfAbsent(clz, GsonConfigSerialization::new).register(name, original);
                    Logger.info("Registered " + original.getSimpleName() + " as " + name + " for config type " + clz.getSimpleName());
                }
            }
            catch (Exception e) {
                Logger.error("Error while setting up config serialization", e);
            }
        }
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        for (Map.Entry entry : serializers.entrySet()) {
            builder.registerTypeAdapterFactory((TypeAdapterFactory)entry.getValue());
        }
        GSON = builder.create();
        Logger.info("Registered " + count + " config types");
    }

    private static List<String> collectAllClasses(String pack) {
        try {
            InputStream stream = Serialization.class.getClassLoader().getResourceAsStream(pack.replaceAll("[.]", "/"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            return reader.lines().flatMap(inner -> {
                if (inner.endsWith(".class")) {
                    return Stream.of(pack + "." + inner.replace(".class", ""));
                }
                if (!inner.contains(".")) {
                    return Serialization.collectAllClasses(pack + "." + inner).stream();
                }
                return Stream.of(new String[0]);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            Logger.error("Failed to collect classes in package: " + pack, e);
            return List.of();
        }
    }

    private static List<String> collectAllClasses(Path base, String pack) {
        if (!Files.exists(base.resolve(pack.replaceAll("[.]", "/")), new LinkOption[0])) {
            return List.of();
        }
        try {
            return Files.list(base.resolve(pack.replaceAll("[.]", "/"))).flatMap(inner -> {
                if (inner.getFileName().toString().endsWith(".class")) {
                    return Stream.of(pack + "." + inner.getFileName().toString().replace(".class", ""));
                }
                if (Files.isDirectory(inner, new LinkOption[0])) {
                    return Serialization.collectAllClasses(base, pack + "." + String.valueOf(inner.getFileName())).stream();
                }
                return Stream.of(new String[0]);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class GsonConfigSerialization<T>
    implements TypeAdapterFactory {
        private final String typeField = "TYPE";
        private final Class<T> clz;
        private final Map<String, Class<? extends T>> name2type = new HashMap<String, Class<? extends T>>();
        private final Map<Class<? extends T>, String> type2name = new HashMap<Class<? extends T>, String>();

        private GsonConfigSerialization(Class<T> clz) {
            this.clz = clz;
        }

        public GsonConfigSerialization<T> register(String typeName, Class<? extends T> cls) {
            if (this.name2type.put(typeName, cls) != null) {
                throw new IllegalStateException("Type name already registered: " + typeName);
            }
            if (this.type2name.put(cls, typeName) != null) {
                throw new IllegalStateException("Class already registered with type name: " + typeName + ", " + String.valueOf(cls));
            }
            return this;
        }

        private T deserialize(Gson gson, JsonElement json) {
            Class<? extends T> retype = this.name2type.get(json.getAsJsonObject().remove(this.typeField).getAsString());
            return (T)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(retype)).fromJsonTree(json);
        }

        private JsonElement serialize(Gson gson, T value) {
            Object name = this.type2name.get(value.getClass());
            if (name == null) {
                name = "UNKNOWN_TYPE_{" + value.getClass().getName() + "}";
            }
            JsonElement vjson = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(value.getClass())).toJsonTree(value);
            JsonObject json = new JsonObject();
            json.addProperty(this.typeField, (String)name);
            vjson.getAsJsonObject().asMap().forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1));
            return json;
        }

        public <X> TypeAdapter<X> create(final Gson gson, TypeToken<X> type) {
            if (this.clz.isAssignableFrom(type.getRawType())) {
                final TypeAdapter jsonObjectAdapter = gson.getAdapter(JsonElement.class);
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        jsonObjectAdapter.write(out, (Object)this.serialize(gson, value));
                    }

                    public T read(JsonReader in) throws IOException {
                        JsonElement obj = (JsonElement)jsonObjectAdapter.read(in);
                        return this.deserialize(gson, obj);
                    }
                };
            }
            return null;
        }
    }
}

