/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.mixin.minecraft;

import me.cortex.voxy.client.VoxyClientInstance;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.client.core.util.IrisUtil;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.WorldIdentifier;
import net.minecraft.class_1937;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class MixinLevelRenderer
implements IGetVoxyRenderSystem {
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Unique
    private VoxyRenderSystem renderer;

    @Override
    public VoxyRenderSystem getVoxyRenderSystem() {
        return this.renderer;
    }

    @Inject(method={"method_3279()V"}, at={@At(value="RETURN")}, order=900)
    private void reloadVoxyRenderer(CallbackInfo ci) {
        this.shutdownRenderer();
        if (this.field_4085 != null) {
            this.createRenderer();
        }
    }

    @Inject(method={"method_3244"}, at={@At(value="HEAD")})
    private void voxy$captureSetWorld(class_638 world, CallbackInfo ci) {
        if (this.field_4085 != world) {
            this.shutdownRenderer();
        }
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    private void injectClose(CallbackInfo ci) {
        this.shutdownRenderer();
    }

    @Override
    public void shutdownRenderer() {
        if (this.renderer != null) {
            this.renderer.shutdown();
            this.renderer = null;
        }
    }

    @Override
    public void createRenderer() {
        if (this.renderer != null) {
            throw new IllegalStateException("Cannot have multiple renderers");
        }
        if (!VoxyConfig.CONFIG.isRenderingEnabled()) {
            Logger.info("Not creating renderer due to disabled");
            return;
        }
        if (this.field_4085 == null) {
            Logger.error("Not creating renderer due to null world");
            return;
        }
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            Logger.error("Not creating renderer due to null instance");
            return;
        }
        WorldEngine world = WorldIdentifier.ofEngine((class_1937)this.field_4085);
        if (world == null) {
            Logger.error("Null world selected");
            return;
        }
        try {
            this.renderer = new VoxyRenderSystem(world, instance.getServiceManager());
        }
        catch (RuntimeException e) {
            if (IrisUtil.irisShaderPackEnabled()) {
                IrisUtil.disableIrisShaders();
            }
            throw e;
        }
        instance.updateDedicatedThreads();
    }
}

