/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.iris;

import java.util.function.Supplier;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.client.iris.IrisShaderPatch;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class VoxyUniforms {
    public static Matrix4f getViewProjection() {
        IGetVoxyRenderSystem getVrs = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
        if (getVrs == null || getVrs.getVoxyRenderSystem() == null) {
            return new Matrix4f();
        }
        VoxyRenderSystem vrs = getVrs.getVoxyRenderSystem();
        return new Matrix4f((Matrix4fc)vrs.getViewport().MVP);
    }

    public static Matrix4f getModelView() {
        IGetVoxyRenderSystem getVrs = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
        if (getVrs == null || getVrs.getVoxyRenderSystem() == null) {
            return new Matrix4f();
        }
        VoxyRenderSystem vrs = getVrs.getVoxyRenderSystem();
        return new Matrix4f((Matrix4fc)vrs.getViewport().modelView);
    }

    public static Matrix4f getProjection() {
        IGetVoxyRenderSystem getVrs = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
        if (getVrs == null || getVrs.getVoxyRenderSystem() == null) {
            return new Matrix4f();
        }
        VoxyRenderSystem vrs = getVrs.getVoxyRenderSystem();
        Matrix4f mat = vrs.getViewport().projection;
        if (mat == null) {
            return new Matrix4f();
        }
        return new Matrix4f((Matrix4fc)mat);
    }

    public static void addUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "vxRenderDistance", () -> VoxyConfig.CONFIG.sectionRenderDistance * 32).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxViewProj", VoxyUniforms::getViewProjection).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxViewProjInv", (Supplier)new Inverted(VoxyUniforms::getViewProjection)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxViewProjPrev", (Supplier)new PreviousMat(VoxyUniforms::getViewProjection)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxModelView", VoxyUniforms::getModelView).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxModelViewInv", (Supplier)new Inverted(VoxyUniforms::getModelView)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxModelViewPrev", (Supplier)new PreviousMat(VoxyUniforms::getModelView)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxProj", VoxyUniforms::getProjection).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxProjInv", (Supplier)new Inverted(VoxyUniforms::getProjection)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "vxProjPrev", (Supplier)new PreviousMat(VoxyUniforms::getProjection));
        if (IrisShaderPatch.IMPERSONATE_DISTANT_HORIZONS) {
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "dhNearPlane", () -> 16).uniform1f(UniformUpdateFrequency.PER_FRAME, "dhFarPlane", () -> 48000).uniform1i(UniformUpdateFrequency.PER_FRAME, "dhRenderDistance", () -> VoxyConfig.CONFIG.sectionRenderDistance * 32 * 16).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "dhProjection", VoxyUniforms::getProjection).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "dhProjectionInverse", (Supplier)new Inverted(VoxyUniforms::getProjection)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "dhPreviousProjection", (Supplier)new PreviousMat(VoxyUniforms::getProjection));
        }
    }

    private record Inverted(Supplier<Matrix4fc> parent) implements Supplier<Matrix4fc>
    {
        @Override
        public Matrix4fc get() {
            Matrix4f copy = new Matrix4f(this.parent.get());
            copy.invert();
            return copy;
        }
    }

    private static class PreviousMat
    implements Supplier<Matrix4fc> {
        private final Supplier<Matrix4fc> parent;
        private Matrix4f previous;

        PreviousMat(Supplier<Matrix4fc> parent) {
            this.parent = parent;
            this.previous = new Matrix4f();
        }

        @Override
        public Matrix4fc get() {
            Matrix4f previous = this.previous;
            this.previous = new Matrix4f(this.parent.get());
            return previous;
        }
    }
}

