/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.iris;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import me.cortex.voxy.client.core.IrisVoxyRenderPipeline;
import me.cortex.voxy.client.iris.IrisShaderPatch;
import me.cortex.voxy.client.mixin.iris.CustomUniformsAccessor;
import me.cortex.voxy.client.mixin.iris.IrisRenderingPipelineAccessor;
import me.cortex.voxy.common.Logger;
import net.irisshaders.iris.gl.buffer.ShaderStorageBufferHolder;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.sampler.GlSampler;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.gl.state.ValueUpdateNotifier;
import net.irisshaders.iris.gl.texture.InternalTextureFormat;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.gl.uniform.DynamicUniformHolder;
import net.irisshaders.iris.gl.uniform.FloatSupplier;
import net.irisshaders.iris.gl.uniform.LocationalUniformHolder;
import net.irisshaders.iris.gl.uniform.Uniform;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformType;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.targets.RenderTarget;
import net.irisshaders.iris.targets.RenderTargets;
import net.irisshaders.iris.uniforms.CommonUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.uniforms.custom.cached.BooleanCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.CachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Float2VectorCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Float3VectorCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Float4MatrixCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Float4VectorCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.FloatCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Int2VectorCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.Int3VectorCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.IntCachedUniform;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryUtil;

public class IrisVoxyRenderPipelineData {
    public IrisVoxyRenderPipeline thePipeline;
    public final int[] opaqueDrawTargets;
    public final int[] translucentDrawTargets;
    private final String opaquePatch;
    private final String translucentPatch;
    private final StructLayout uniforms;
    private final Runnable blendingSetup;
    private final ImageSet imageSet;
    private final SSBOSet ssboSet;
    public final boolean renderToVanillaDepth;
    public final float[] resolutionScale;
    public final String TAA;
    public final boolean useViewportDims;
    public final boolean deferTranslucency;

    private IrisVoxyRenderPipelineData(IrisShaderPatch patch, int[] opaqueDrawTargets, int[] translucentDrawTargets, StructLayout uniformSet, Runnable blendingSetup, ImageSet imageSet, SSBOSet ssboSet) {
        this.opaqueDrawTargets = opaqueDrawTargets;
        this.translucentDrawTargets = translucentDrawTargets;
        this.opaquePatch = patch.getPatchOpaqueSource();
        this.translucentPatch = patch.getPatchTranslucentSource();
        this.uniforms = uniformSet;
        this.blendingSetup = blendingSetup;
        this.imageSet = imageSet;
        this.ssboSet = ssboSet;
        this.renderToVanillaDepth = patch.emitToVanillaDepth();
        this.TAA = patch.getTAAShift();
        this.resolutionScale = patch.getRenderScale();
        this.useViewportDims = patch.useViewportDims();
        this.deferTranslucency = patch.deferedTranslucentRendering();
    }

    public SSBOSet getSsboSet() {
        return this.ssboSet;
    }

    public ImageSet getImageSet() {
        return this.imageSet;
    }

    public StructLayout getUniforms() {
        return this.uniforms;
    }

    public Runnable getBlender() {
        return this.blendingSetup;
    }

    public String opaqueFragPatch() {
        return this.opaquePatch;
    }

    public String translucentFragPatch() {
        return this.translucentPatch;
    }

    public static IrisVoxyRenderPipelineData buildPipeline(IrisRenderingPipeline ipipe, IrisShaderPatch patch, CustomUniforms cu, ShaderStorageBufferHolder ssboHolder) {
        StructLayout uniforms = IrisVoxyRenderPipelineData.createUniformLayoutStructAndUpdater(IrisVoxyRenderPipelineData.createUniformSet(cu, patch));
        ImageSet imageSet = IrisVoxyRenderPipelineData.createImageSet(ipipe, patch);
        SSBOSet ssboSet = IrisVoxyRenderPipelineData.createSSBOLayouts(patch.getSSBOs(), ssboHolder);
        int[] opaqueDrawTargets = IrisVoxyRenderPipelineData.getDrawBuffers(patch.getOpqaueTargets(), (ImmutableSet<Integer>)ipipe.getFlippedAfterPrepare(), ((IrisRenderingPipelineAccessor)ipipe).getRenderTargets());
        int[] translucentDrawTargets = IrisVoxyRenderPipelineData.getDrawBuffers(patch.getTranslucentTargets(), (ImmutableSet<Integer>)ipipe.getFlippedAfterPrepare(), ((IrisRenderingPipelineAccessor)ipipe).getRenderTargets());
        return new IrisVoxyRenderPipelineData(patch, opaqueDrawTargets, translucentDrawTargets, uniforms, patch.createBlendSetup(), imageSet, ssboSet);
    }

    private static int[] getDrawBuffers(int[] targets, ImmutableSet<Integer> stageWritesToAlt, RenderTargets rt) {
        int[] targetTextures = new int[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            int textureId;
            RenderTarget target = rt.getOrCreate(targets[i]);
            targetTextures[i] = textureId = stageWritesToAlt.contains((Object)targets[i]) ? target.getAltTexture() : target.getMainTexture();
        }
        return targetTextures;
    }

    private static String convertToGlslType(UniformType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case UniformType.INT -> "int";
            case UniformType.FLOAT -> "float";
            case UniformType.MAT3 -> "mat3";
            case UniformType.MAT4 -> "mat4";
            case UniformType.VEC2 -> "vec2";
            case UniformType.VEC2I -> "ivec2";
            case UniformType.VEC3 -> "vec3";
            case UniformType.VEC3I -> "ivec3";
            case UniformType.VEC4 -> "vec4";
            case UniformType.VEC4I -> "ivec4";
        };
    }

    public boolean shouldDeferTranslucency() {
        return false;
    }

    private static StructLayout createUniformLayoutStructAndUpdater(List<UniformWritingHolder> uniforms) {
        if (uniforms.size() == 0) {
            return null;
        }
        List[] ordering = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        for (UniformWritingHolder uniform : uniforms) {
            int order = IrisVoxyRenderPipelineData.getUniformOrdering(uniform.type);
            ordering[order].add(uniform);
        }
        int pos = 0;
        Int2ObjectLinkedOpenHashMap layout = new Int2ObjectLinkedOpenHashMap();
        for (UniformWritingHolder uniform : ordering[0]) {
            layout.put(pos, (Object)uniform);
            pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
        }
        if (!ordering[1].isEmpty() && (ordering[1].size() & 1) == 0) {
            for (UniformWritingHolder uniform : ordering[1]) {
                layout.put(pos, (Object)uniform);
                pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
            }
            ordering[1].clear();
        }
        for (UniformWritingHolder uniform : ordering[2]) {
            layout.put(pos, (Object)uniform);
            pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
            if (!ordering[3].isEmpty()) {
                uniform = (UniformWritingHolder)ordering[3].removeFirst();
                layout.put(pos, (Object)uniform);
                pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
                continue;
            }
            ++pos;
        }
        for (UniformWritingHolder uniform : ordering[1]) {
            layout.put(pos, (Object)uniform);
            pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
        }
        for (UniformWritingHolder uniform : ordering[3]) {
            layout.put(pos, (Object)uniform);
            pos += IrisVoxyRenderPipelineData.getSizeAndAlignment(uniform.type) >> 5;
        }
        if (layout.size() != uniforms.size()) {
            throw new IllegalStateException();
        }
        StringBuilder struct = new StringBuilder("{\n");
        for (Int2ObjectMap.Entry pair : layout.int2ObjectEntrySet()) {
            struct.append("\t").append(IrisVoxyRenderPipelineData.convertToGlslType(((UniformWritingHolder)pair.getValue()).type)).append(" ").append(((UniformWritingHolder)pair.getValue()).name).append(";\n");
        }
        struct.append("}");
        String structLayout = struct.toString();
        LongConsumer[] updaters = new LongConsumer[uniforms.size()];
        int i = 0;
        for (Int2ObjectMap.Entry pair : layout.int2ObjectEntrySet()) {
            updaters[i++] = (LongConsumer)((UniformWritingHolder)pair.getValue()).writingFactory.get((long)pair.getIntKey() * 4L);
        }
        LongConsumer updater = ptr -> {
            for (LongConsumer u : updaters) {
                u.accept(ptr);
            }
        };
        return new StructLayout(pos * 4, structLayout, updater);
    }

    private static LongConsumer createWriter(long offset, FunctionReturn ret, CachedUniform uniform) {
        if (uniform instanceof BooleanCachedUniform) {
            BooleanCachedUniform bcu = (BooleanCachedUniform)uniform;
            return ptr -> {
                bcu.writeTo(ret);
                MemoryUtil.memPutInt((long)(ptr += offset), (int)(ret.booleanReturn ? 1 : 0));
            };
        }
        if (uniform instanceof FloatCachedUniform) {
            FloatCachedUniform fcu = (FloatCachedUniform)uniform;
            return ptr -> {
                fcu.writeTo(ret);
                MemoryUtil.memPutFloat((long)(ptr += offset), (float)ret.floatReturn);
            };
        }
        if (uniform instanceof IntCachedUniform) {
            IntCachedUniform icu = (IntCachedUniform)uniform;
            return ptr -> {
                icu.writeTo(ret);
                MemoryUtil.memPutInt((long)(ptr += offset), (int)ret.intReturn);
            };
        }
        if (uniform instanceof Float2VectorCachedUniform) {
            Float2VectorCachedUniform v2fcu = (Float2VectorCachedUniform)uniform;
            return ptr -> {
                v2fcu.writeTo(ret);
                ((Vector2f)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        if (uniform instanceof Float3VectorCachedUniform) {
            Float3VectorCachedUniform v3fcu = (Float3VectorCachedUniform)uniform;
            return ptr -> {
                v3fcu.writeTo(ret);
                ((Vector3f)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        if (uniform instanceof Float4VectorCachedUniform) {
            Float4VectorCachedUniform v4fcu = (Float4VectorCachedUniform)uniform;
            return ptr -> {
                v4fcu.writeTo(ret);
                ((Vector4f)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        if (uniform instanceof Int2VectorCachedUniform) {
            Int2VectorCachedUniform v2icu = (Int2VectorCachedUniform)uniform;
            return ptr -> {
                v2icu.writeTo(ret);
                ((Vector2i)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        if (uniform instanceof Int3VectorCachedUniform) {
            Int3VectorCachedUniform v3icu = (Int3VectorCachedUniform)uniform;
            return ptr -> {
                v3icu.writeTo(ret);
                ((Vector3i)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        if (uniform instanceof Float4MatrixCachedUniform) {
            Float4MatrixCachedUniform f4mcu = (Float4MatrixCachedUniform)uniform;
            return ptr -> {
                f4mcu.writeTo(ret);
                ((Matrix4f)ret.objectReturn).getToAddress(ptr += offset);
            };
        }
        throw new IllegalStateException("Unknown uniform type " + uniform.getClass().getName());
    }

    private static int P(int size, int align) {
        return size << 5 | align;
    }

    private static int getSizeAndAlignment(UniformType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case UniformType.INT, UniformType.FLOAT -> IrisVoxyRenderPipelineData.P(1, 1);
            case UniformType.MAT3 -> IrisVoxyRenderPipelineData.P(11, 4);
            case UniformType.MAT4 -> IrisVoxyRenderPipelineData.P(16, 4);
            case UniformType.VEC2, UniformType.VEC2I -> IrisVoxyRenderPipelineData.P(2, 2);
            case UniformType.VEC3, UniformType.VEC3I -> IrisVoxyRenderPipelineData.P(3, 4);
            case UniformType.VEC4, UniformType.VEC4I -> IrisVoxyRenderPipelineData.P(4, 4);
        };
    }

    private static int getUniformOrdering(UniformType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case UniformType.MAT4, UniformType.VEC4, UniformType.VEC4I -> 0;
            case UniformType.VEC2, UniformType.VEC2I -> 1;
            case UniformType.MAT3, UniformType.VEC3, UniformType.VEC3I -> 2;
            case UniformType.INT, UniformType.FLOAT -> 3;
        };
    }

    private static List<UniformWritingHolder> createUniformSet(CustomUniforms cu, final IrisShaderPatch patch) {
        final ArrayList<UniformWritingHolder> uniforms = new ArrayList<UniformWritingHolder>();
        final HashSet seenUniforms = new HashSet();
        DynamicLocationalUniformHolder uniformBuilder = new DynamicLocationalUniformHolder(){

            public DynamicLocationalUniformHolder uniform1i(UniformUpdateFrequency updateFrequency, String name, IntSupplier value) {
                return this.uniform1i(name, value, null);
            }

            public DynamicLocationalUniformHolder uniform1i(String name, IntSupplier value, ValueUpdateNotifier notifier) {
                this.injectDynamicUniformType(name, UniformType.INT, (Long2ObjectFunction<LongConsumer>)((Long2ObjectFunction)offset -> ptr -> MemoryUtil.memPutInt((long)(ptr + offset), (int)value.getAsInt())));
                return this;
            }

            public DynamicLocationalUniformHolder uniform1f(UniformUpdateFrequency updateFrequency, String name, FloatSupplier value) {
                return this.uniform1f(name, value, null);
            }

            public DynamicLocationalUniformHolder uniform1f(String name, FloatSupplier value, ValueUpdateNotifier notifier) {
                this.injectDynamicUniformType(name, UniformType.FLOAT, (Long2ObjectFunction<LongConsumer>)((Long2ObjectFunction)offset -> ptr -> MemoryUtil.memPutFloat((long)(ptr + offset), (float)value.getAsFloat())));
                return this;
            }

            public DynamicLocationalUniformHolder uniform3f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector3f> value) {
                return this.uniform3f(name, value, null);
            }

            public DynamicLocationalUniformHolder uniform3f(String name, Supplier<Vector3f> value, ValueUpdateNotifier notifier) {
                this.injectDynamicUniformType(name, UniformType.VEC3, (Long2ObjectFunction<LongConsumer>)((Long2ObjectFunction)offset -> arg_0 -> 1.lambda$uniform3f$4((Supplier)value, offset, arg_0)));
                return this;
            }

            private void injectDynamicUniformType(String name, UniformType type, Long2ObjectFunction<LongConsumer> supplier) {
                String[] names = patch.getUniformList();
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equals(name)) continue;
                    if (!seenUniforms.add(name)) {
                        throw new IllegalArgumentException("Already added uniform: " + name);
                    }
                    uniforms.add(new UniformWritingHolder(name, type, supplier));
                    break;
                }
            }

            public DynamicLocationalUniformHolder addDynamicUniform(Uniform uniform, ValueUpdateNotifier valueUpdateNotifier) {
                throw new IllegalStateException("Type not implemented for uniform: " + String.valueOf(uniform));
            }

            public LocationalUniformHolder addUniform(UniformUpdateFrequency uniformUpdateFrequency, Uniform uniform) {
                return this;
            }

            public OptionalInt location(String uniformName, UniformType uniformType) {
                String[] names = patch.getUniformList();
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equals(uniformName)) continue;
                    return OptionalInt.of(i);
                }
                return OptionalInt.empty();
            }

            public UniformHolder externallyManagedUniform(String s, UniformType uniformType) {
                return null;
            }

            private static /* synthetic */ void lambda$uniform3f$4(Supplier value, long offset, long ptr) {
                ((Vector3f)value.get()).getToAddress(ptr + offset);
            }
        };
        CommonUniforms.addDynamicUniforms((DynamicUniformHolder)uniformBuilder, (FogMode)FogMode.PER_FRAGMENT);
        cu.assignTo((LocationalUniformHolder)uniformBuilder);
        cu.mapholderToPass((LocationalUniformHolder)uniformBuilder, (Object)patch);
        FunctionReturn cachedReturn = new FunctionReturn();
        ((CustomUniformsAccessor)cu).getLocationMap().get(patch).object2IntEntrySet().forEach(entry -> {
            if (!seenUniforms.add(((CachedUniform)entry.getKey()).getName())) {
                throw new IllegalArgumentException("Already added uniform: " + ((CachedUniform)entry.getKey()).getName());
            }
            uniforms.add(new UniformWritingHolder(((CachedUniform)entry.getKey()).getName(), Type.convert((Type)((CachedUniform)entry.getKey()).getType()), (Long2ObjectFunction<LongConsumer>)((Long2ObjectFunction)offset -> IrisVoxyRenderPipelineData.createWriter(offset, cachedReturn, (CachedUniform)entry.getKey()))));
        });
        if (uniforms.size() != patch.getUniformList().length) {
            HashSet<String> uniformsUnseen = new HashSet<String>(List.of(patch.getUniformList()));
            for (UniformWritingHolder uniform : uniforms) {
                uniformsUnseen.remove(uniform.name);
            }
            Logger.error("The following uniforms could not be found: [" + uniformsUnseen.stream().sorted(String::compareToIgnoreCase).collect(Collectors.joining(",")) + "]");
        }
        return uniforms;
    }

    private static ImageSet createImageSet(IrisRenderingPipeline ipipe, IrisShaderPatch patch) {
        Object2ObjectLinkedOpenHashMap<String, String> samplerDataSet = patch.getSamplerSet();
        if (samplerDataSet == null) {
            return null;
        }
        final LinkedHashSet samplerNameSet = new LinkedHashSet(samplerDataSet.keySet());
        if (samplerNameSet.isEmpty()) {
            return null;
        }
        final LinkedHashSet samplerSet = new LinkedHashSet();
        SamplerHolder samplerBuilder = new SamplerHolder(){

            public boolean hasSampler(String s) {
                return samplerNameSet.contains(s);
            }

            public boolean hasSampler(String ... names) {
                for (String name : names) {
                    if (!samplerNameSet.contains(name)) continue;
                    return true;
                }
                return false;
            }

            private String name(String ... names) {
                for (String name : names) {
                    if (!samplerNameSet.contains(name)) continue;
                    return name;
                }
                return null;
            }

            public boolean addDefaultSampler(TextureType type, IntSupplier texture, ValueUpdateNotifier notifier, Supplier<GlSampler> sampler, String ... names) {
                Logger.error("Unsupported default sampler");
                return false;
            }

            public boolean addDynamicSampler(TextureType type, IntSupplier texture, Supplier<GlSampler> sampler, String ... names) {
                return this.addDynamicSampler(type, texture, null, sampler, names);
            }

            public boolean addDynamicSampler(TextureType type, IntSupplier texture, ValueUpdateNotifier notifier, Supplier<GlSampler> sampler, String ... names) {
                if (!this.hasSampler(names)) {
                    return false;
                }
                samplerSet.add(new TextureWSampler(this.name(names), texture, sampler != null ? () -> {
                    GlSampler s = (GlSampler)sampler.get();
                    return s != null ? s.getId() : -1;
                } : () -> -1));
                return true;
            }

            public void addExternalSampler(int texture, String ... names) {
                if (!this.hasSampler(names)) {
                    return;
                }
                samplerSet.add(new TextureWSampler(this.name(names), () -> texture, () -> -1));
            }
        };
        ImageHolder imageBuilder = new ImageHolder(){

            public boolean hasImage(String s) {
                return false;
            }

            public void addTextureImage(IntSupplier intSupplier, InternalTextureFormat internalTextureFormat, String s) {
            }
        };
        ipipe.addGbufferOrShadowSamplers(samplerBuilder, imageBuilder, () -> ((IrisRenderingPipeline)ipipe).getFlippedAfterPrepare(), false, true, true, false);
        if (samplerSet.size() != samplerNameSet.size()) {
            Logger.error("Did not find all requested samplers. Found [" + samplerSet.stream().map(a -> a.name).collect(Collectors.joining()) + "] expected " + String.valueOf(samplerNameSet));
        }
        StringBuilder builder = new StringBuilder();
        TextureWSampler[] samplers = new TextureWSampler[samplerSet.size()];
        int i = 0;
        Iterator iterator = samplerSet.iterator();
        while (iterator.hasNext()) {
            TextureWSampler entry;
            samplers[i] = entry = (TextureWSampler)iterator.next();
            String samplerType = (String)samplerDataSet.get((Object)entry.name);
            builder.append("layout(binding=(BASE_SAMPLER_BINDING_INDEX+").append(i).append(")) uniform ").append(samplerType).append(" ").append(entry.name).append(";\n");
            ++i;
        }
        IntConsumer bindingFunction = base -> {
            for (int j = 0; j < samplers.length; ++j) {
                int unit = j + base;
                TextureWSampler ts = samplers[j];
                ARBDirectStateAccess.glBindTextureUnit((int)unit, (int)ts.texture.getAsInt());
                int sampler = ts.sampler.getAsInt();
                if (sampler == -1) continue;
                GL33C.glBindSampler((int)unit, (int)sampler);
            }
        };
        return new ImageSet(builder.toString(), bindingFunction);
    }

    private static SSBOSet createSSBOLayouts(Int2ObjectMap<String> ssbos, ShaderStorageBufferHolder ssboStore) {
        if (ssboStore == null) {
            return null;
        }
        if (ssbos.isEmpty()) {
            return null;
        }
        String header = "";
        if (ssbos.containsKey(-1)) {
            header = (String)ssbos.remove(-1);
        }
        StringBuilder builder = new StringBuilder(header);
        builder.append("\n");
        SSBOBinding[] bindings = new SSBOBinding[ssbos.size()];
        int i = 0;
        for (Int2ObjectMap.Entry entry : ssbos.int2ObjectEntrySet()) {
            String val = (String)entry.getValue();
            bindings[i] = new SSBOBinding(entry.getIntKey(), i);
            builder.append("layout(binding = (BUFFER_BINDING_INDEX_BASE+").append(i).append(")) restrict buffer IrisBufferBinding").append(i);
            builder.append(" ").append(val).append(";\n");
            ++i;
        }
        IntConsumer bindingFunction = base -> {
            for (SSBOBinding binding : bindings) {
                ARBUniformBufferObject.glBindBufferBase((int)37074, (int)(base + binding.bindingOffset), (int)ssboStore.getBufferIndex(binding.irisIndex));
            }
        };
        return new SSBOSet(builder.toString(), bindingFunction);
    }

    public record StructLayout(int size, String layout, LongConsumer updater) {
    }

    public record ImageSet(String layout, IntConsumer bindingFunction) {
    }

    public record SSBOSet(String layout, IntConsumer bindingFunction) {
    }

    private record UniformWritingHolder(String name, UniformType type, Long2ObjectFunction<LongConsumer> writingFactory) {
    }

    private record TextureWSampler(String name, IntSupplier texture, IntSupplier sampler) {
    }

    private record SSBOBinding(int irisIndex, int bindingOffset) {
    }
}

