/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.iris;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.Strictness;
import com.google.gson.annotations.JsonAdapter;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntSupplier;
import me.cortex.voxy.client.iris.ShaderLoadError;
import me.cortex.voxy.common.Logger;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.include.AbsolutePackPath;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.GL33;

public class IrisShaderPatch {
    public static final int VERSION = ((IntSupplier)() -> 1).getAsInt();
    public static final boolean IMPERSONATE_DISTANT_HORIZONS = System.getProperty("voxy.impersonateDHShader", "false").equalsIgnoreCase("true");
    private final PatchGson patchData;
    private final ShaderPack pack;
    private final Int2ObjectMap<String> ssbos;
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{2}).setStrictness(Strictness.LENIENT).create();

    private IrisShaderPatch(PatchGson patchData, ShaderPack pack) {
        this.patchData = patchData;
        this.pack = pack;
        this.ssbos = patchData.ssbos == null ? new Int2ObjectOpenHashMap() : patchData.ssbos;
    }

    public boolean useViewportDims() {
        return this.patchData.useViewportDims;
    }

    public Int2ObjectMap<String> getSSBOs() {
        return new Int2ObjectLinkedOpenHashMap(this.ssbos);
    }

    public String getPatchOpaqueSource() {
        return this.patchData.opaquePatchData;
    }

    public String getPatchTranslucentSource() {
        return this.patchData.translucentPatchData;
    }

    public String getTAAShift() {
        return this.patchData.taaOffset == null ? "{return vec2(0.0);}" : this.patchData.taaOffset;
    }

    public String[] getUniformList() {
        return this.patchData.uniforms;
    }

    public Object2ObjectLinkedOpenHashMap<String, String> getSamplerSet() {
        return this.patchData.samplers;
    }

    public int[] getOpqaueTargets() {
        return this.patchData.opaqueDrawBuffers;
    }

    public int[] getTranslucentTargets() {
        return this.patchData.translucentDrawBuffers;
    }

    public boolean emitToVanillaDepth() {
        return !this.patchData.excludeLodsFromVanillaDepth;
    }

    public float[] getRenderScale() {
        if (this.patchData.renderScale == null || this.patchData.renderScale.length == 0) {
            return new float[]{1.0f, 1.0f};
        }
        if (this.patchData.renderScale.length == 1) {
            return new float[]{this.patchData.renderScale[0], this.patchData.renderScale[0]};
        }
        return new float[]{Math.max(0.01f, this.patchData.renderScale[0]), Math.max(0.01f, this.patchData.renderScale[1])};
    }

    public boolean deferedTranslucentRendering() {
        return false;
    }

    public Runnable createBlendSetup() {
        if (this.patchData.blending == null || this.patchData.blending.isEmpty()) {
            return () -> {};
        }
        return () -> {
            Int2ObjectOpenHashMap<BlendState> BS = this.patchData.blending;
            BlendState init = (BlendState)BS.getOrDefault(-1, null);
            if (init != null) {
                if (init.off) {
                    GL33.glDisable((int)3042);
                } else {
                    GL33.glEnable((int)3042);
                    GL33.glBlendFuncSeparate((int)init.sRGB, (int)init.dRGB, (int)init.sA, (int)init.dA);
                }
            }
            for (Int2ObjectMap.Entry entry : BS.int2ObjectEntrySet()) {
                if (entry.getIntKey() == -1) continue;
                BlendState s = (BlendState)entry.getValue();
                if (s.off) {
                    GL33.glDisablei((int)3042, (int)s.buffer);
                    continue;
                }
                GL33.glEnablei((int)3042, (int)s.buffer);
                ARBDrawBuffersBlend.glBlendFuncSeparateiARB((int)s.buffer, (int)s.sRGB, (int)s.dRGB, (int)s.sA, (int)s.dA);
            }
        };
    }

    public static IrisShaderPatch makePatch(ShaderPack ipack, AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider) {
        String voxyPatchData = sourceProvider.apply(directory.resolve("voxy.json"));
        if (voxyPatchData == null) {
            return null;
        }
        if (voxyPatchData.isBlank()) {
            return null;
        }
        voxyPatchData = voxyPatchData.replace("\\", "\\\\");
        PatchGson patchData = null;
        try {
            String invalidPatchDataReason;
            String taa;
            String translucent;
            StringBuilder builder = new StringBuilder(voxyPatchData.length());
            for (String line : voxyPatchData.split("\n")) {
                int idx = line.indexOf("//");
                if (idx != -1) {
                    builder.append(line, 0, idx);
                    builder.append(line.substring(idx).replace("\"", "\\\""));
                } else {
                    builder.append(line);
                }
                builder.append("\n");
            }
            voxyPatchData = builder.toString();
            patchData = (PatchGson)GSON.fromJson(voxyPatchData, PatchGson.class);
            if (patchData == null) {
                throw new IllegalStateException("Voxy patch json returned null, this is most likely due to malformed json file");
            }
            String opaque = sourceProvider.apply(directory.resolve("voxy_opaque.glsl"));
            if (opaque != null) {
                Logger.info("External opaque shader patch applied");
                patchData.opaquePatchData = opaque;
            }
            if ((translucent = sourceProvider.apply(directory.resolve("voxy_translucent.glsl"))) != null) {
                Logger.info("External translucent shader patch applied");
                patchData.translucentPatchData = translucent;
            }
            if ((taa = sourceProvider.apply(directory.resolve("voxy_taa.glsl"))) != null) {
                Logger.info("External taa shader patch applied");
                patchData.taaOffset = taa;
            }
            if ((invalidPatchDataReason = patchData.checkValid()) != null) {
                throw new IllegalStateException("voxy json patch not valid: " + invalidPatchDataReason);
            }
        }
        catch (Exception e) {
            patchData = null;
            Logger.error("Failed to parse patch data gson", e);
            throw new ShaderLoadError("Failed to parse patch data gson", e);
        }
        if (patchData == null) {
            return null;
        }
        if (patchData.version != VERSION) {
            Logger.error("Shader has voxy patch data, but patch version is incorrect. expected " + VERSION + " got " + patchData.version);
            throw new IllegalStateException("Shader version mismatch expected " + VERSION + " got " + patchData.version);
        }
        return new IrisShaderPatch(patchData, ipack);
    }

    private static class PatchGson {
        public int version;
        public int[] opaqueDrawBuffers;
        public int[] translucentDrawBuffers;
        public String[] uniforms;
        @JsonAdapter(value=SamplerDeserializer.class)
        public Object2ObjectLinkedOpenHashMap<String, String> samplers;
        public String opaquePatchData;
        public String translucentPatchData;
        @JsonAdapter(value=SSBODeserializer.class)
        public Int2ObjectOpenHashMap<String> ssbos;
        @JsonAdapter(value=BlendStateDeserializer.class)
        public Int2ObjectOpenHashMap<BlendState> blending;
        public String taaOffset;
        public boolean excludeLodsFromVanillaDepth;
        public float[] renderScale;
        public boolean useViewportDims;

        private PatchGson() {
        }

        public String checkValid() {
            if (this.blending != null) {
                int i = 0;
                for (BlendState state : this.blending.values()) {
                    if (state.buffer != -1 && (state.buffer < 0 || this.translucentDrawBuffers.length <= state.buffer)) {
                        if (state.buffer < 0) {
                            return "Blending buffer is <0 at index: " + i;
                        }
                        return "Blending buffer index out of bounds at " + i + " was " + state.buffer + " maximum is " + (this.translucentDrawBuffers.length - 1);
                    }
                    ++i;
                }
            }
            if (this.opaquePatchData == null) {
                return "Opaque patch data is null";
            }
            if (this.uniforms == null) {
                return "Uniforms are null";
            }
            if (this.opaqueDrawBuffers == null) {
                return "Opaque draw buffers are null";
            }
            if (this.translucentDrawBuffers == null) {
                return "Translucent draw buffers are null";
            }
            return null;
        }
    }

    public record BlendState(int buffer, boolean off, int sRGB, int dRGB, int sA, int dA) {
        public static BlendState ALL_OFF = new BlendState(-1, true, 0, 0, 0, 0);
    }

    private static final class BlendStateDeserializer
    implements JsonDeserializer<Int2ObjectMap<BlendState>> {
        private BlendStateDeserializer() {
        }

        private static int parseType(String type) {
            if (!((String)(type = ((String)type).toUpperCase())).startsWith("GL_")) {
                type = "GL_" + (String)type;
            }
            return switch (type) {
                case "GL_ZERO" -> 0;
                case "GL_ONE" -> 1;
                case "GL_SRC_COLOR" -> 768;
                case "GL_ONE_MINUS_SRC_COLOR" -> 769;
                case "GL_SRC_ALPHA" -> 770;
                case "GL_ONE_MINUS_SRC_ALPHA" -> 771;
                case "GL_DST_ALPHA" -> 772;
                case "GL_ONE_MINUS_DST_ALPHA" -> 773;
                case "GL_DST_COLOR" -> 774;
                case "GL_ONE_MINUS_DST_COLOR" -> 775;
                case "GL_SRC_ALPHA_SATURATE" -> 776;
                case "GL_SRC1_COLOR" -> 35065;
                case "GL_ONE_MINUS_SRC1_COLOR" -> 35066;
                case "GL_ONE_MINUS_SRC1_ALPHA" -> 35067;
                default -> {
                    Logger.error("Unknown blend option " + (String)type);
                    yield -1;
                }
            };
        }

        public Int2ObjectMap<BlendState> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json == null) {
                return null;
            }
            Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap();
            try {
                if (json.isJsonPrimitive()) {
                    if (json.getAsString().equalsIgnoreCase("off")) {
                        ret.put(-1, (Object)BlendState.ALL_OFF);
                        return ret;
                    }
                } else if (json.isJsonObject()) {
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        int buffer = Integer.parseInt((String)entry.getKey());
                        BlendState state = null;
                        JsonElement val = (JsonElement)entry.getValue();
                        List<String> bs = null;
                        if (val.isJsonArray()) {
                            bs = val.getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
                        } else if (val.isJsonPrimitive()) {
                            String str = val.getAsString();
                            if (str.equalsIgnoreCase("off")) {
                                state = new BlendState(buffer, true, 0, 0, 0, 0);
                            } else {
                                String[] parts = str.split(" ");
                                if (parts.length < 4) {
                                    state = new BlendState(buffer, true, -1, -1, -1, -1);
                                } else {
                                    bs = List.of(parts);
                                }
                            }
                        } else {
                            Logger.error("Unknown blend state " + String.valueOf(val));
                            state = null;
                        }
                        if (bs != null) {
                            int[] v = bs.stream().mapToInt(BlendStateDeserializer::parseType).toArray();
                            state = new BlendState(buffer, false, v[0], v[1], v[2], v[3]);
                        }
                        ret.put(buffer, state);
                    }
                    return ret;
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
            Logger.error("Failed to parse blend state: " + String.valueOf(json));
            return ret;
        }
    }

    private static final class SamplerDeserializer
    implements JsonDeserializer<Object2ObjectLinkedOpenHashMap<String, String>> {
        private SamplerDeserializer() {
        }

        public Object2ObjectLinkedOpenHashMap<String, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Object2ObjectLinkedOpenHashMap ret = new Object2ObjectLinkedOpenHashMap();
            if (json == null) {
                return null;
            }
            try {
                if (json.isJsonArray()) {
                    for (JsonElement entry : json.getAsJsonArray()) {
                        String name = entry.getAsString();
                        String type = "sampler2D";
                        if (name.matches("shadowtex")) {
                            type = "sampler2DShadow";
                        }
                        ret.put((Object)name, (Object)type);
                    }
                } else {
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        String type = "sampler2D";
                        if (((JsonElement)entry.getValue()).isJsonNull()) {
                            if (((String)entry.getKey()).matches("shadowtex")) {
                                type = "sampler2DShadow";
                            }
                        } else {
                            type = ((JsonElement)entry.getValue()).getAsString();
                        }
                        ret.put((Object)((String)entry.getKey()), (Object)type);
                    }
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
            return ret;
        }
    }

    private static final class SSBODeserializer
    implements JsonDeserializer<Int2ObjectOpenHashMap<String>> {
        private SSBODeserializer() {
        }

        public Int2ObjectOpenHashMap<String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap();
            if (json == null) {
                return null;
            }
            try {
                for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                    ret.put(Integer.parseInt((String)entry.getKey()), (Object)((JsonElement)entry.getValue()).getAsString());
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
            return ret;
        }
    }
}

