/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;

public class RingUtil {
    private static int computeR(int rd2, int a, int b) {
        return rd2 - a * a - b * b;
    }

    private static int computeR(int rd2, int a) {
        return rd2 - a * a;
    }

    private static int pack(int a, int b, int d) {
        int m = 1023;
        return a & m | (b & m) << 10 | d << 20;
    }

    private static int pack(int a, int b) {
        int m = 65535;
        return a & m | (b & m) << 16;
    }

    public static int[] generateBoundingHalfSphere(int radius) {
        IntArrayList points = new IntArrayList();
        int rd2 = radius * radius;
        for (int a = -radius; a <= radius; ++a) {
            for (int b = -radius; b <= radius; ++b) {
                int pd = RingUtil.computeR(rd2, a, b);
                if (pd < 0) continue;
                pd = (int)Math.sqrt(pd);
                points.add(RingUtil.pack(a, b, pd));
            }
        }
        return points.toIntArray();
    }

    public static int[] generateBoundingHalfCircle(int radius) {
        IntArrayList points = new IntArrayList();
        int rd2 = radius * radius;
        for (int a = -radius; a <= radius; ++a) {
            int pd = RingUtil.computeR(rd2, a);
            if (pd < 0) continue;
            pd = (int)Math.sqrt(pd);
            points.add(RingUtil.pack(a, pd));
        }
        return points.toIntArray();
    }

    public static int[] generatingBoundingCorner2D(int radius) {
        IntOpenHashSet points = new IntOpenHashSet();
        for (int i = 1; i <= radius; ++i) {
            int other = (int)Math.floor(Math.sqrt(radius * radius - i * i));
            points.add(i << 16 | other);
        }
        return points.toIntArray();
    }
}

