/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayDeque;
import java.util.Deque;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlFence;
import me.cortex.voxy.client.core.gl.GlPersistentMappedBuffer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.AllocationArena;
import me.cortex.voxy.common.util.MemoryBuffer;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL45C;

public class UploadStream {
    private final AllocationArena allocationArena = new AllocationArena();
    private final GlPersistentMappedBuffer uploadBuffer;
    private final Deque<UploadFrame> frames = new ArrayDeque<UploadFrame>();
    private final LongArrayList thisFrameAllocations = new LongArrayList();
    private final Deque<UploadData> uploadList = new ArrayDeque<UploadData>();
    private static final boolean USE_COHERENT = false;
    private long caddr = -1L;
    private long offset = 0L;
    public static final UploadStream INSTANCE = new UploadStream(0x4000000L);

    public UploadStream(long size) {
        this.uploadBuffer = new GlPersistentMappedBuffer(size, 562).name("UploadStream");
        this.allocationArena.setLimit(size);
    }

    public void upload(GlBuffer buffer, long destOffset, MemoryBuffer data) {
        data.cpyTo(this.upload(buffer, destOffset, data.size));
    }

    public long uploadTo(GlBuffer buffer) {
        return this.upload(buffer, 0L, buffer.size());
    }

    public long upload(GlBuffer buffer, long destOffset, long size) {
        long addr = this.rawUploadAddress((int)size);
        this.uploadList.add(new UploadData(buffer, addr, destOffset, size));
        return this.uploadBuffer.addr() + addr;
    }

    public long rawUpload(int size) {
        return this.uploadBuffer.addr() + this.rawUploadAddress(size);
    }

    public long rawUploadAddress(int size) {
        long addr;
        if (size < 0) {
            throw new IllegalStateException("Negative size");
        }
        if ((long)size > this.uploadBuffer.size()) {
            throw new IllegalArgumentException();
        }
        size = size + 15 & 0xFFFFFFF0;
        if (this.caddr == -1L || !this.allocationArena.expand(this.caddr, size)) {
            if (this.caddr != -1L) {
                GL45C.glFlushMappedNamedBufferRange((int)this.uploadBuffer.id, (long)this.caddr, (long)this.offset);
            }
            this.caddr = this.allocationArena.alloc(size);
            if (this.caddr == -1L) {
                Logger.error("Upload stream full, preemptively committing, this could cause bad things to happen");
                int attempts = 10;
                while (--attempts != 0 && this.caddr == -1L) {
                    GL11.glFinish();
                    this.tick(false);
                    this.caddr = this.allocationArena.alloc(size);
                }
                if (this.caddr == -1L) {
                    throw new IllegalStateException("Could not allocate memory segment big enough for upload even after force flush");
                }
            }
            this.thisFrameAllocations.add(this.caddr);
            this.offset = size;
            addr = this.caddr;
        } else {
            addr = this.caddr + this.offset;
            this.offset += (long)size;
        }
        if (this.caddr + (long)size > this.uploadBuffer.size()) {
            throw new IllegalStateException();
        }
        return addr;
    }

    public void commit() {
        if (this.caddr != -1L) {
            GL45C.glFlushMappedNamedBufferRange((int)this.uploadBuffer.id, (long)this.caddr, (long)this.offset);
        }
        if (this.uploadList.isEmpty()) {
            return;
        }
        GL42.glMemoryBarrier((int)512);
        for (UploadData entry : this.uploadList) {
            ARBDirectStateAccess.glCopyNamedBufferSubData((int)this.uploadBuffer.id, (int)entry.target.id, (long)entry.uploadOffset, (long)entry.targetOffset, (long)entry.size);
        }
        this.uploadList.clear();
        GL42.glMemoryBarrier((int)512);
        this.caddr = -1L;
        this.offset = 0L;
    }

    public void tick() {
        this.tick(true);
    }

    private void tick(boolean commit) {
        if (commit) {
            this.commit();
        }
        if (!this.thisFrameAllocations.isEmpty()) {
            this.frames.add(new UploadFrame(new GlFence(), new LongArrayList((LongList)this.thisFrameAllocations)));
            this.thisFrameAllocations.clear();
        }
        while (!this.frames.isEmpty() && this.frames.peek().fence.signaled()) {
            UploadFrame frame = this.frames.pop();
            frame.allocations.forEach(this.allocationArena::free);
            frame.fence.free();
        }
    }

    public long getBaseAddress() {
        return this.uploadBuffer.addr();
    }

    public int getRawBufferId() {
        return this.uploadBuffer.id;
    }

    private record UploadData(GlBuffer target, long uploadOffset, long targetOffset, long size) {
    }

    private record UploadFrame(GlFence fence, LongArrayList allocations) {
    }
}

