/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import me.cortex.voxy.client.core.gl.GlFence;
import me.cortex.voxy.client.core.gl.GlPersistentMappedBuffer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.AllocationArena;
import org.lwjgl.opengl.GL11;

public class RawDownloadStream {
    private final GlPersistentMappedBuffer downloadBuffer;
    private final AllocationArena allocationArena = new AllocationArena();
    private final ArrayList<DownloadFragment> frameFragments = new ArrayList();
    private final Deque<DownloadFrame> frames = new ArrayDeque<DownloadFrame>();

    public RawDownloadStream(int size) {
        this.downloadBuffer = new GlPersistentMappedBuffer(size, 129).name("RawDownloadStream");
        this.allocationArena.setLimit(size);
    }

    public int download(int size, IDownloadCompletedCallback callback) {
        int allocation = (int)this.allocationArena.alloc(size);
        if ((long)allocation == -1L) {
            Logger.warn("Raw download stream full, preemptively committing, this could cause bad things to happen");
            GL11.glFinish();
            this.tick();
            allocation = (int)this.allocationArena.alloc(size);
            if ((long)allocation == -1L) {
                throw new IllegalStateException("Unable free enough memory for raw download stream");
            }
        }
        this.frameFragments.add(new DownloadFragment(allocation, callback));
        return allocation;
    }

    public void submit() {
        if (!this.frameFragments.isEmpty()) {
            DownloadFragment[] fragments = this.frameFragments.toArray(new DownloadFragment[0]);
            this.frameFragments.clear();
            this.frames.add(new DownloadFrame(new GlFence(), fragments));
        }
    }

    public void tick() {
        this.submit();
        while (!this.frames.isEmpty() && this.frames.peek().fence.signaled()) {
            DownloadFrame frame = this.frames.poll();
            for (DownloadFragment fragment : frame.fragments) {
                long addr = this.downloadBuffer.addr() + (long)fragment.allocation;
                fragment.callback.accept(addr);
                this.allocationArena.free(fragment.allocation);
            }
            frame.fence.free();
        }
    }

    public int getBufferId() {
        return this.downloadBuffer.id;
    }

    public void free() {
        GL11.glFinish();
        this.tick();
        GlFence fence = new GlFence();
        while (!fence.signaled()) {
            GL11.glFinish();
        }
        fence.free();
        this.tick();
        if (this.frames.size() != 0) {
            throw new IllegalStateException();
        }
        this.frames.forEach(a -> a.fence.free());
        this.downloadBuffer.free();
    }

    private record DownloadFragment(int allocation, IDownloadCompletedCallback callback) {
    }

    public static interface IDownloadCompletedCallback {
        public void accept(long var1);
    }

    private record DownloadFrame(GlFence fence, DownloadFragment[] fragments) {
    }
}

