/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import me.cortex.voxy.client.core.gl.GlFramebuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.gl.GlVertexArray;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL45C;

public class HiZBuffer {
    private final Shader hiz = Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, "voxy:hiz/blit.vsh").add(ShaderType.FRAGMENT, "voxy:hiz/blit.fsh").compile().name("HiZ Builder");
    private final GlFramebuffer fb = new GlFramebuffer().name("HiZ");
    private final int sampler = GL33.glGenSamplers();
    private final int type;
    private GlTexture texture;
    private int levels;
    private int width;
    private int height;

    public HiZBuffer() {
        this(35056);
    }

    public HiZBuffer(int type) {
        ARBDirectStateAccess.glNamedFramebufferDrawBuffer((int)this.fb.id, (int)0);
        this.type = type;
    }

    private void alloc(int width, int height) {
        this.levels = (int)Math.ceil(Math.log(Math.max(width, height)) / Math.log(2.0));
        this.texture = new GlTexture().store(this.type, this.levels, width, height).name("HiZ");
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10241, (int)9984);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10240, (int)9728);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)34892, (int)0);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10242, (int)33071);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10243, (int)33071);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10241, (int)9984);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10240, (int)9728);
        GL33C.glSamplerParameteri((int)this.sampler, (int)34892, (int)0);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10242, (int)33071);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10243, (int)33071);
        this.width = width;
        this.height = height;
        this.fb.bind(36096, this.texture, 0).verify();
    }

    public void buildMipChain(int srcDepthTex, int width, int height) {
        if (this.width != Integer.highestOneBit(width) || this.height != Integer.highestOneBit(height)) {
            if (this.texture != null) {
                this.texture.free();
                this.texture = null;
            }
            this.alloc(Integer.highestOneBit(width), Integer.highestOneBit(height));
        }
        GL30C.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        int boundFB = GL11.glGetInteger((int)36006);
        this.hiz.bind();
        GL30C.glBindFramebuffer((int)36160, (int)this.fb.id);
        GL30C.glDepthFunc((int)519);
        GL30C.glDepthMask((boolean)true);
        GL30C.glEnable((int)2929);
        ARBDirectStateAccess.glBindTextureUnit((int)0, (int)srcDepthTex);
        GL33.glBindSampler((int)0, (int)this.sampler);
        GL30C.glUniform1i((int)0, (int)0);
        int cw = this.width;
        int ch = this.height;
        for (int i = 0; i < this.levels; ++i) {
            this.fb.bind(36096, this.texture, i);
            GL30C.glViewport((int)0, (int)0, (int)cw, (int)ch);
            cw = Math.max(cw / 2, 1);
            ch = Math.max(ch / 2, 1);
            GL30C.glDrawArrays((int)6, (int)0, (int)4);
            GL45C.glTextureBarrier();
            GL42C.glMemoryBarrier((int)1032);
            ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)33084, (int)i);
            ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)33085, (int)i);
            if (i != 0) continue;
            ARBDirectStateAccess.glBindTextureUnit((int)0, (int)this.texture.id);
        }
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)33084, (int)0);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)33085, (int)1000);
        GL30C.glDepthFunc((int)515);
        GL30C.glDisable((int)2929);
        GL30C.glBindFramebuffer((int)36160, (int)boundFB);
        GL30C.glViewport((int)0, (int)0, (int)width, (int)height);
        GL30C.glBindVertexArray((int)0);
    }

    public void free() {
        this.fb.free();
        if (this.texture != null) {
            this.texture.free();
            this.texture = null;
        }
        GL33C.glDeleteSamplers((int)this.sampler);
        this.hiz.free();
    }

    public int getHizTextureId() {
        return this.texture.id;
    }

    public int getPackedLevels() {
        return this.width << 16 | this.height;
    }
}

