/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import java.util.function.Consumer;
import me.cortex.voxy.client.core.gl.Capabilities;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.rendering.util.DownloadStream;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.util.AllocationArena;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.commonImpl.VoxyCommon;

public class BufferArena {
    private static final boolean CHECK_SSBO_MAX_SIZE_CHECK = VoxyCommon.isVerificationFlagOn("checkSSBOMaxSize");
    private final long size;
    private final int elementSize;
    private final GlBuffer buffer;
    private final AllocationArena allocationMap = new AllocationArena();
    private long used;

    public BufferArena(long capacity, int elementSize) {
        if (capacity % (long)elementSize != 0L) {
            throw new IllegalArgumentException("Capacity not a multiple of element size");
        }
        if (CHECK_SSBO_MAX_SIZE_CHECK && capacity > Capabilities.INSTANCE.ssboMaxSize) {
            throw new IllegalArgumentException("Buffer is bigger than max ssbo size (requested " + capacity + " but has max of " + Capabilities.INSTANCE.ssboMaxSize + ")");
        }
        this.size = capacity;
        this.elementSize = elementSize;
        this.buffer = new GlBuffer(capacity);
        this.allocationMap.setLimit(capacity / (long)elementSize);
    }

    public long upload(MemoryBuffer buffer) {
        if (buffer.size % (long)this.elementSize != 0L) {
            throw new IllegalArgumentException("Buffer size not multiple of elementSize");
        }
        int size = (int)(buffer.size / (long)this.elementSize);
        long addr = this.allocationMap.alloc(size);
        if (addr == -1L) {
            return -1L;
        }
        long uploadPtr = UploadStream.INSTANCE.upload(this.buffer, addr * (long)this.elementSize, buffer.size);
        UnsafeUtil.memcpy(buffer.address, uploadPtr, buffer.size);
        this.used += (long)size;
        return addr;
    }

    public void free(long allocation) {
        this.used -= (long)this.allocationMap.free(allocation);
    }

    public void free() {
        this.buffer.free();
    }

    public int id() {
        this.buffer.assertNotFreed();
        return this.buffer.id;
    }

    public float usage() {
        return (float)((double)this.used / (double)(this.buffer.size() / (long)this.elementSize));
    }

    public long getUsedBytes() {
        return this.used * (long)this.elementSize;
    }

    public void downloadRemove(long allocation, Consumer<MemoryBuffer> consumer) {
        int size = this.allocationMap.free(allocation);
        this.used -= (long)size;
        DownloadStream.INSTANCE.download(this.buffer, allocation * (long)this.elementSize, (long)size * (long)this.elementSize, consumer);
    }
}

