/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.post;

import java.util.function.Function;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.util.SharedIndexBuffer;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL45C;

public class FullscreenBlit {
    private static final int EMPTY_VAO = GL45C.glCreateVertexArrays();
    private final Shader shader;

    public FullscreenBlit(String fragId) {
        this(fragId, (Shader.Builder<T> a) -> a);
    }

    public FullscreenBlit(String vertId, String fragId) {
        this(vertId, fragId, a -> a);
    }

    public <T extends Shader> FullscreenBlit(String fragId, Function<Shader.Builder<T>, Shader.Builder<T>> builder) {
        this("voxy:post/fullscreen.vert", fragId, builder);
    }

    public <T extends Shader> FullscreenBlit(String vertId, String fragId, Function<Shader.Builder<T>, Shader.Builder<T>> builder) {
        this.shader = builder.apply(Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, vertId).add(ShaderType.FRAGMENT, fragId)).compile();
    }

    public void bind() {
        this.shader.bind();
    }

    public void blit() {
        GL30C.glBindVertexArray((int)EMPTY_VAO);
        this.shader.bind();
        GL15C.glBindBuffer((int)34963, (int)SharedIndexBuffer.INSTANCE_BYTE.id());
        GL11C.glDrawElements((int)4, (int)6, (int)5121, (long)0L);
        GL30C.glBindVertexArray((int)0);
    }

    public void delete() {
        this.shader.free();
    }
}

