/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.hierachical;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.rendering.ISectionWatcher;
import me.cortex.voxy.client.core.rendering.building.BuiltSection;
import me.cortex.voxy.client.core.rendering.hierachical.NodeChildRequest;
import me.cortex.voxy.client.core.rendering.hierachical.NodeStore;
import me.cortex.voxy.client.core.rendering.hierachical.SingleNodeRequest;
import me.cortex.voxy.client.core.rendering.section.geometry.IGeometryManager;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.client.core.util.ExpandingObjectAllocationList;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.world.WorldEngine;
import org.lwjgl.system.MemoryUtil;

public class NodeManager {
    private static final boolean VERIFY_NODE_MANAGER_OPERATIONS = true;
    public static final int NULL_GEOMETRY_ID = -1;
    public static final int EMPTY_GEOMETRY_ID = -2;
    public static final int NULL_REQUEST_ID = 65535;
    public static final int SENTINEL_EMPTY_CHILD_PTR = 0xFFFFFE;
    public static final int NODE_ID_MSK = 0xFFFFFF;
    private static final int NODE_TYPE_MSK = -1073741824;
    private static final int NODE_TYPE_LEAF = 0;
    private static final int NODE_TYPE_INNER = 0x40000000;
    private static final int NODE_TYPE_REQUEST = Integer.MIN_VALUE;
    private static final int REQUEST_TYPE_SINGLE = 0;
    private static final int REQUEST_TYPE_CHILD = 0x20000000;
    private static final int REQUEST_TYPE_MSK = 0x20000000;
    private final ExpandingObjectAllocationList<SingleNodeRequest> singleRequests = new ExpandingObjectAllocationList((Int2ObjectFunction<T[]>)((Int2ObjectFunction)(SingleNodeRequest[]::new)));
    private final ExpandingObjectAllocationList<NodeChildRequest> childRequests = new ExpandingObjectAllocationList((Int2ObjectFunction<T[]>)((Int2ObjectFunction)(NodeChildRequest[]::new)));
    private final IntOpenHashSet nodeUpdates = new IntOpenHashSet();
    private final IGeometryManager geometryManager;
    private final ISectionWatcher watcher;
    private final Long2IntOpenHashMap activeSectionMap = new Long2IntOpenHashMap();
    private final NodeStore nodeData;
    public final int maxNodeCount;
    private final IntOpenHashSet topLevelNodeIds = new IntOpenHashSet();
    private final LongOpenHashSet topLevelNodes = new LongOpenHashSet();
    private int activeNodeRequestCount;
    private IntConsumer topLevelNodeIdAddedCallback;
    private IntConsumer topLevelNodeIdRemovedCallback;
    private ICleaner cleanerInterface;

    public void setClear(ICleaner callback) {
        this.cleanerInterface = callback;
    }

    private void clearAllocId(int id) {
        if (this.cleanerInterface != null) {
            this.cleanerInterface.alloc(id);
        }
    }

    private void clearMoveId(int from, int to) {
        if (this.cleanerInterface != null) {
            this.cleanerInterface.move(from, to);
        }
    }

    private void clearFreeId(int id) {
        if (this.cleanerInterface != null) {
            this.cleanerInterface.free(id);
        }
    }

    public void setTLNCallbacks(IntConsumer onAdd, IntConsumer onRemove) {
        this.topLevelNodeIdAddedCallback = onAdd;
        this.topLevelNodeIdRemovedCallback = onRemove;
    }

    public NodeManager(int maxNodeCount, IGeometryManager geometryManager, ISectionWatcher watcher) {
        if ((maxNodeCount & maxNodeCount - 1) != 0) {
            throw new IllegalArgumentException("Max node count must be a power of 2");
        }
        if (maxNodeCount > 0x1000000) {
            throw new IllegalArgumentException("Max node count cannot exceed 2^24");
        }
        this.activeSectionMap.defaultReturnValue(-1);
        this.watcher = watcher;
        this.maxNodeCount = maxNodeCount;
        this.nodeData = new NodeStore(maxNodeCount);
        this.geometryManager = geometryManager;
    }

    private static void assertPosValid(long pos) {
        int z;
        int y;
        int x;
        int lvl = WorldEngine.getLevel(pos);
        if (WorldEngine.getWorldSectionId(lvl, x = WorldEngine.getX(pos), y = WorldEngine.getY(pos), z = WorldEngine.getZ(pos)) != pos) {
            throw new IllegalStateException("Reconstructed pos not same as original");
        }
        long p2 = WorldEngine.getWorldSectionId(0, x <<= lvl, y <<= lvl, z <<= lvl);
        if (WorldEngine.getLevel(p2) != 0 || WorldEngine.getX(p2) != x || WorldEngine.getY(p2) != y || WorldEngine.getZ(p2) != z) {
            throw new IllegalStateException("Position not valid at all levels: " + pos + "-" + WorldEngine.pprintPos(pos) + ":" + WorldEngine.pprintPos(p2));
        }
    }

    public void insertTopLevelNode(long pos) {
        NodeManager.assertPosValid(pos);
        if ((pos & 0xFL) != 0L) {
            throw new IllegalStateException("BAD POS !! YOU DID SOMETHING VERY BAD");
        }
        if (this.activeSectionMap.containsKey(pos)) {
            Logger.error("Tried inserting top level pos " + WorldEngine.pprintPos(pos) + " but it was in active map, discarding!");
            return;
        }
        SingleNodeRequest request = new SingleNodeRequest(pos);
        int id = this.singleRequests.put(request);
        this.watcher.watch(pos, 3);
        this.activeSectionMap.put(pos, id | Integer.MIN_VALUE | 0);
        this.topLevelNodes.add(pos);
    }

    public void removeTopLevelNode(long pos) {
        if (!this.topLevelNodes.remove(pos)) {
            throw new IllegalStateException("Position not in top level map: " + WorldEngine.pprintPos(pos));
        }
        int nodeId = this.activeSectionMap.get(pos);
        if (nodeId == -1) {
            throw new IllegalStateException("Tried removing top level pos " + WorldEngine.pprintPos(pos) + " but it was not in active map, discarding!");
        }
        if ((nodeId & 0xC0000000) != Integer.MIN_VALUE) {
            int id = nodeId & 0xFFFFFF;
            if (!this.topLevelNodeIds.remove(id)) {
                throw new IllegalStateException("Node id was not in top level node ids: " + nodeId + " pos: " + WorldEngine.pprintPos(pos));
            }
            if (this.topLevelNodeIdRemovedCallback != null) {
                this.topLevelNodeIdRemovedCallback.accept(id);
            }
        }
        this.recurseRemoveNode(pos);
    }

    IntOpenHashSet getTopLevelNodeIds() {
        return this.topLevelNodeIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processGeometryResult(BuiltSection sectionResult) {
        long pos = sectionResult.position;
        int nodeId = this.activeSectionMap.get(pos);
        if (nodeId == -1) {
            sectionResult.free();
            return;
        }
        if ((nodeId & 0xC0000000) == Integer.MIN_VALUE) {
            if ((nodeId & 0x20000000) == 0) {
                SingleNodeRequest request = this.singleRequests.get(nodeId & 0xFFFFFF);
                request.setMesh(this.uploadReplaceSection(request.getMesh(), sectionResult));
                if (!request.hasChildExistenceSet()) {
                    request.setChildExistence(sectionResult.childExistence);
                }
                if (!request.isSatisfied()) return;
                this.singleRequests.release(nodeId & 0xFFFFFF);
                this.finishRequest(request);
                return;
            } else {
                if ((nodeId & 0x20000000) != 0x20000000) throw new IllegalStateException();
                NodeChildRequest request = this.childRequests.get(nodeId & 0xFFFFFF);
                int childId = NodeManager.getChildIdx(pos);
                request.setChildMesh(childId, this.uploadReplaceSection(request.getChildMesh(childId), sectionResult));
                if (!request.hasChildChildExistence(childId)) {
                    request.setChildChildExistence(childId, sectionResult.childExistence);
                }
                if (!request.isSatisfied()) return;
                this.finishRequest(nodeId & 0xFFFFFF, request);
            }
            return;
        } else {
            if ((nodeId & 0xC0000000) != 0x40000000 && (nodeId & 0xC0000000) != 0) throw new IllegalStateException();
            nodeId &= 0xFFFFFF;
            if ((this.watcher.get(pos) & 1) == 0) {
                if (this.nodeData.isNodeGeometryInFlight(nodeId)) {
                    throw new IllegalStateException();
                }
                Logger.warn("Recieved geometry update but not watching it, discarding");
                sectionResult.free();
                return;
            }
            this.nodeData.unmarkNodeGeometryInFlight(nodeId);
            if (this.updateNodeGeometry(nodeId, sectionResult) == 0) return;
            this.invalidateNode(nodeId);
        }
    }

    private void removeGeometryCached(long pos, int id) {
        this.geometryManager.removeSection(id);
    }

    private int uploadReplaceSection(int meshId, BuiltSection section) {
        if (section.isEmpty()) {
            if (meshId != -1 && meshId != -2) {
                this.geometryManager.removeSection(meshId);
            }
            section.free();
            return -2;
        }
        if (meshId != -1 && meshId != -2) {
            return this.geometryManager.uploadReplaceSection(meshId, section);
        }
        return this.geometryManager.uploadSection(section);
    }

    private int updateNodeGeometry(int node, BuiltSection geometry) {
        int previousGeometry = this.nodeData.getNodeGeometry(node);
        int newGeometry = -2;
        if (previousGeometry != -2 && previousGeometry != -1) {
            if (!geometry.isEmpty()) {
                newGeometry = this.geometryManager.uploadReplaceSection(previousGeometry, geometry);
            } else {
                this.geometryManager.removeSection(previousGeometry);
            }
        } else if (!geometry.isEmpty()) {
            newGeometry = this.geometryManager.uploadSection(geometry);
        }
        if (previousGeometry != newGeometry) {
            this.nodeData.setNodeGeometry(node, newGeometry);
        }
        if (previousGeometry == newGeometry) {
            return 0;
        }
        if (previousGeometry == -2 || previousGeometry == -1) {
            return 1;
        }
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processChildChange(long pos, byte childExistence) {
        int nodeId = this.activeSectionMap.get(pos);
        if (nodeId == -1) {
            Logger.warn("Got child change for pos " + WorldEngine.pprintPos(pos) + " but it was not in active map, ignoring!");
            return;
        }
        if ((nodeId & 0xC0000000) == Integer.MIN_VALUE) {
            if ((nodeId & 0x20000000) == 0) {
                SingleNodeRequest request = this.singleRequests.get(nodeId & 0xFFFFFF);
                request.setChildExistence(childExistence);
                if (!request.isSatisfied()) return;
                this.singleRequests.release(nodeId & 0xFFFFFF);
                this.finishRequest(request);
                return;
            } else {
                if ((nodeId & 0x20000000) != 0x20000000) throw new IllegalStateException();
                NodeChildRequest request = this.childRequests.get(nodeId & 0xFFFFFF);
                request.setChildChildExistence(NodeManager.getChildIdx(pos), childExistence);
                if (!request.isSatisfied()) return;
                this.finishRequest(nodeId & 0xFFFFFF, request);
            }
            return;
        } else if ((nodeId & 0xC0000000) == 0x40000000) {
            this.updateChildSectionsInner(pos, nodeId & 0xFFFFFF, childExistence);
            return;
        } else {
            if ((nodeId & 0xC0000000) != 0) return;
            if (this.nodeData.isNodeRequestInFlight(nodeId & 0xFFFFFF)) {
                long cPos;
                int i;
                int requestId = this.nodeData.getNodeRequest(nodeId);
                NodeChildRequest request = this.childRequests.get(requestId);
                if (request.getPosition() != pos) {
                    throw new IllegalStateException("Request is not at pos, got " + WorldEngine.pprintPos(request.getPosition()) + " expected " + WorldEngine.pprintPos(pos));
                }
                byte oldMsk = request.getMsk();
                byte change = (byte)(oldMsk ^ childExistence);
                byte rem = (byte)(change & oldMsk);
                for (i = 0; i < 8; ++i) {
                    if ((rem & 1 << i) == 0) continue;
                    cPos = NodeManager.makeChildPos(pos, i);
                    int meshId = request.removeAndUnRequire(i);
                    if (meshId != -1 && meshId != -2) {
                        this.removeGeometryCached(cPos, meshId);
                    }
                    if (this.activeSectionMap.remove(cPos) == -1) {
                        throw new IllegalStateException("Child pos was in a request but not in active section map");
                    }
                    if (this.watcher.unwatch(cPos, 3)) continue;
                    throw new IllegalStateException("Child pos was not being watched");
                }
                rem = (byte)(change & childExistence);
                for (i = 0; i < 8; ++i) {
                    if ((rem & 1 << i) == 0) continue;
                    request.addChildRequirement(i);
                    cPos = NodeManager.makeChildPos(pos, i);
                    if (this.activeSectionMap.put(cPos, requestId | Integer.MIN_VALUE | 0x20000000) != -1) {
                        throw new IllegalStateException("Child pos was already in active section tracker but was part of a request");
                    }
                    if (this.watcher.watch(cPos, 3)) continue;
                    throw new IllegalStateException("Child pos update router issue");
                }
                if (request.isSatisfied()) {
                    this.finishRequest(requestId, request);
                }
            }
            this.nodeData.setNodeChildExistence(nodeId & 0xFFFFFF, childExistence);
            this.invalidateNode(nodeId & 0xFFFFFF);
        }
    }

    private void updateChildSectionsInner(long pos, int nodeId, byte childExistence) {
        byte existence;
        byte add;
        if (childExistence == 0) {
            Logger.warn("Inner node child existence is changing to 0, this is mild bad");
        }
        if ((add = (byte)(((existence = this.nodeData.getNodeChildExistence(nodeId)) ^ childExistence) & childExistence)) != 0) {
            int requestId;
            NodeChildRequest request;
            if (!this.nodeData.isNodeRequestInFlight(nodeId)) {
                NodeChildRequest request2 = new NodeChildRequest(pos);
                int requestId2 = this.childRequests.put(request2);
                this.nodeData.markRequestInFlight(nodeId);
                this.nodeData.setNodeRequest(nodeId, requestId2);
                ++this.activeNodeRequestCount;
            }
            if ((request = this.childRequests.get(requestId = this.nodeData.getNodeRequest(nodeId))).getPosition() != pos) {
                throw new IllegalStateException("Request is not at pos: got " + WorldEngine.pprintPos(pos) + " expected: " + WorldEngine.pprintPos(request.getPosition()));
            }
            for (int i = 0; i < 8; ++i) {
                if ((add & 1 << i) == 0) continue;
                request.addChildRequirement(i);
                long cPos = NodeManager.makeChildPos(pos, i);
                if (this.activeSectionMap.put(cPos, requestId | Integer.MIN_VALUE | 0x20000000) != -1) {
                    throw new IllegalStateException("Child pos was already in active section tracker but was part of a request");
                }
                if (this.watcher.watch(cPos, 3)) continue;
                throw new IllegalStateException("Child pos update router issue");
            }
        }
        this.nodeData.setNodeChildExistence(nodeId, childExistence);
        int rem = (existence ^ childExistence) & existence & 0xFF;
        if (rem != 0) {
            int i;
            if (this.nodeData.isNodeRequestInFlight(nodeId)) {
                int requestId = this.nodeData.getNodeRequest(nodeId);
                NodeChildRequest request = this.childRequests.get(requestId);
                if (request.getPosition() != pos) {
                    throw new IllegalStateException("Request is not at pos");
                }
                int reqRem = Byte.toUnsignedInt(request.getMsk()) & rem;
                if (reqRem != 0) {
                    for (i = 0; i < 8; ++i) {
                        int cnid;
                        if ((reqRem & 1 << i) == 0) continue;
                        long cPos = NodeManager.makeChildPos(pos, i);
                        int meshId = request.removeAndUnRequire(i);
                        if (meshId != -1 && meshId != -2) {
                            this.removeGeometryCached(cPos, meshId);
                        }
                        if ((cnid = this.activeSectionMap.remove(cPos)) == -1 || (cnid & 0xC0000000) != Integer.MIN_VALUE) {
                            throw new IllegalStateException("Child pos was in a request but not in active section map");
                        }
                        if (this.watcher.unwatch(cPos, 3)) continue;
                        throw new IllegalStateException("Child pos was not being watched");
                    }
                }
                rem ^= reqRem;
            }
            if (rem != 0) {
                int oldPtr = this.nodeData.getChildPtr(nodeId);
                int oldCount = this.nodeData.getChildPtrCount(nodeId);
                if (oldPtr == -1) {
                    throw new IllegalStateException();
                }
                int oldExistence = 0;
                for (i = 0; i < oldCount; ++i) {
                    if (!this.nodeData.nodeExists(i + oldPtr)) {
                        throw new IllegalStateException();
                    }
                    oldExistence |= 1 << NodeManager.getChildIdx(this.nodeData.nodePosition(i + oldPtr));
                }
                if ((rem & oldExistence) != rem) {
                    throw new IllegalStateException();
                }
                int remaining = rem ^ oldExistence;
                if (remaining == 0) {
                    if (childExistence != 0 && !this.nodeData.isNodeRequestInFlight(nodeId)) {
                        throw new IllegalStateException();
                    }
                    this.nodeData.setAllChildrenAreLeaf(nodeId, false);
                    this.nodeData.setChildPtr(nodeId, 0xFFFFFE);
                    this.nodeData.setChildPtrCount(nodeId, 8);
                    for (int i2 = 0; i2 < 8; ++i2) {
                        if ((rem & 1 << i2) == 0) continue;
                        long cPos = NodeManager.makeChildPos(pos, i2);
                        this.recurseRemoveNode(cPos);
                    }
                } else {
                    int i3;
                    int newCnt = Integer.bitCount(remaining);
                    int newPtr = this.nodeData.allocate(newCnt);
                    int prevChildId = oldPtr - 1;
                    int newChildId = newPtr - 1;
                    boolean allChildNodesLeaf = true;
                    for (i3 = 0; i3 < 8; ++i3) {
                        long cPos;
                        if ((oldExistence & 1 << i3) == 0) continue;
                        ++prevChildId;
                        if ((rem & 1 << i3) != 0) {
                            cPos = NodeManager.makeChildPos(pos, i3);
                            this.recurseRemoveNode(cPos);
                            continue;
                        }
                        ++newChildId;
                        cPos = this.nodeData.nodePosition(prevChildId);
                        if (cPos != NodeManager.makeChildPos(pos, i3)) {
                            throw new IllegalStateException();
                        }
                        this.nodeData.copyNode(prevChildId, newChildId);
                        this.clearAllocId(newChildId);
                        this.clearMoveId(prevChildId, newChildId);
                        this.clearFreeId(prevChildId);
                        int prevNodeId = this.activeSectionMap.get(cPos);
                        if ((prevNodeId & 0xC0000000) == Integer.MIN_VALUE) {
                            throw new IllegalStateException();
                        }
                        if ((prevNodeId & 0xFFFFFF) != prevChildId) {
                            throw new IllegalStateException("State inconsistency");
                        }
                        allChildNodesLeaf &= (prevNodeId & 0xC0000000) == 0;
                        this.activeSectionMap.put(cPos, prevNodeId & 0xC0000000 | newChildId);
                        this.nodeData.free(prevChildId);
                        this.invalidateNode(prevChildId);
                        this.invalidateNode(newChildId);
                    }
                    this.nodeData.setAllChildrenAreLeaf(nodeId, allChildNodesLeaf);
                    this.nodeData.setChildPtr(nodeId, newPtr);
                    this.nodeData.setChildPtrCount(nodeId, newCnt);
                    for (i3 = 0; i3 < oldCount; ++i3) {
                        if (!this.nodeData.nodeExists(i3 + oldPtr)) continue;
                        throw new IllegalStateException();
                    }
                }
                this.invalidateNode(nodeId);
            }
            if (this.nodeData.isNodeRequestInFlight(nodeId)) {
                int requestId = this.nodeData.getNodeRequest(nodeId);
                NodeChildRequest request = this.childRequests.get(requestId);
                if (request.getPosition() != pos) {
                    throw new IllegalStateException("Request is not at pos");
                }
                if (request.isSatisfied()) {
                    this.finishRequest(requestId, request);
                }
            }
        }
        if (childExistence == 0) {
            if (this.nodeData.isNodeRequestInFlight(nodeId)) {
                throw new IllegalStateException();
            }
            if (this.nodeData.getNodeGeometry(nodeId) == -1) {
                Logger.error("Transforming inner node to leaf node while it has null geometry");
                if (!this.nodeData.isNodeGeometryInFlight(nodeId)) {
                    if ((this.watcher.get(pos) & 1) != 0) {
                        throw new IllegalStateException("Watcher was already watching for geometry update, but geometry was null");
                    }
                    this.processRequest(pos);
                    if ((this.watcher.get(pos) & 1) == 0 || !this.nodeData.isNodeGeometryInFlight(nodeId)) {
                        throw new IllegalStateException("Watcher must be watching for geometry update");
                    }
                }
                Logger.error("Setting geometry to EMPTY while request is inflight");
                this.nodeData.setNodeGeometry(nodeId, -2);
            }
            if (this.nodeData.getChildPtr(nodeId) != 0xFFFFFE) {
                throw new IllegalStateException();
            }
            this.nodeData.setChildPtr(nodeId, -1);
            int old = this.activeSectionMap.put(pos, 0 | nodeId);
            this.nodeData.setAllChildrenAreLeaf(nodeId, false);
            this.invalidateNode(nodeId);
        }
    }

    private void recurseRemoveChildNodes(long pos) {
        this._recurseRemoveNode(pos, true);
    }

    private void recurseRemoveNode(long pos) {
        this._recurseRemoveNode(pos, false);
    }

    private void _removeRequest(int reqId, NodeChildRequest req, long pos) {
        for (int i = 0; i < 8; ++i) {
            int cId;
            if ((req.getMsk() & 1 << i) == 0) continue;
            long childPos = NodeManager.makeChildPos(pos, i);
            int meshId = req.getChildMesh(i);
            if (meshId != -2 && meshId != -1) {
                this.removeGeometryCached(childPos, meshId);
            }
            if ((cId = this.activeSectionMap.remove(childPos)) == -1) {
                throw new IllegalStateException("Child not in activeMap");
            }
            if ((cId & 0xC0000000) != Integer.MIN_VALUE || (cId & 0x20000000) != 0x20000000 || (cId & 0xFFFFFF) != reqId) {
                throw new IllegalStateException("Invalid child active state map: " + cId);
            }
            if (this.watcher.unwatch(childPos, 3)) continue;
            throw new IllegalStateException("Pos was not being watched");
        }
        this.childRequests.release(reqId);
        --this.activeNodeRequestCount;
    }

    private void _recurseRemoveNode(long pos, boolean onlyRemoveChildren) {
        int nodeId = onlyRemoveChildren ? this.activeSectionMap.get(pos) : this.activeSectionMap.remove(pos);
        if (nodeId == -1) {
            throw new IllegalStateException("Cannot remove pos that doesnt exist");
        }
        int type = nodeId & 0xC0000000;
        if (type == 0x40000000 || type == 0) {
            if (!this.nodeData.nodeExists(nodeId &= 0xFFFFFF)) {
                throw new IllegalStateException("Node exists in section map but not in nodeData");
            }
            byte childExistence = this.nodeData.getNodeChildExistence(nodeId);
            if (this.nodeData.isNodeRequestInFlight(nodeId)) {
                int reqId = this.nodeData.getNodeRequest(nodeId);
                NodeChildRequest req = this.childRequests.get(reqId);
                childExistence = (byte)(childExistence ^ req.getMsk());
                this._removeRequest(reqId, req, pos);
                if (onlyRemoveChildren) {
                    this.nodeData.unmarkRequestInFlight(nodeId);
                    this.nodeData.setNodeRequest(nodeId, 65535);
                }
            }
            if (type == 0x40000000) {
                byte msk = 0;
                int childPtr = this.nodeData.getChildPtr(nodeId);
                if (childPtr == -1) {
                    throw new IllegalStateException();
                }
                if (childPtr != 0xFFFFFE) {
                    int childCnt = this.nodeData.getChildPtrCount(nodeId);
                    if (Integer.bitCount(Byte.toUnsignedInt(childExistence)) != childCnt) {
                        throw new IllegalStateException();
                    }
                    for (int i = 0; i < childCnt; ++i) {
                        if (!this.nodeData.nodeExists(i + childPtr)) {
                            throw new IllegalStateException();
                        }
                        long cp = this.nodeData.nodePosition(i + childPtr);
                        if (this.makeParentPos(cp) != pos) {
                            throw new IllegalStateException();
                        }
                        msk = (byte)(msk | (byte)(1 << NodeManager.getChildIdx(cp)));
                    }
                }
                if (msk != childExistence) {
                    throw new IllegalStateException();
                }
                for (int i = 0; i < 8; ++i) {
                    if ((childExistence & 1 << i) == 0) continue;
                    long childPos = NodeManager.makeChildPos(pos, i);
                    this.recurseRemoveNode(childPos);
                }
                int childPtr2 = this.nodeData.getChildPtr(nodeId);
                if (childPtr2 == -1) {
                    throw new IllegalStateException();
                }
                if (childPtr2 != 0xFFFFFE) {
                    int childCnt = this.nodeData.getChildPtrCount(nodeId);
                    if (Integer.bitCount(Byte.toUnsignedInt(childExistence)) != childCnt) {
                        throw new IllegalStateException();
                    }
                    for (int i = 0; i < childCnt; ++i) {
                        if (!this.nodeData.nodeExists(i + childPtr2)) continue;
                        throw new IllegalStateException();
                    }
                }
                if (onlyRemoveChildren) {
                    this.nodeData.setChildPtr(nodeId, -1);
                }
            }
            if (!onlyRemoveChildren) {
                int meshId = this.nodeData.getNodeGeometry(nodeId);
                if (meshId != -2 && meshId != -1) {
                    this.removeGeometryCached(pos, meshId);
                }
                this.nodeData.free(nodeId);
                this.clearFreeId(nodeId);
                this.invalidateNode(nodeId);
                if (!this.watcher.unwatch(pos, 3)) {
                    throw new IllegalStateException("Pos was not being watched");
                }
            } else {
                this.nodeData.setAllChildrenAreLeaf(nodeId, false);
                this.invalidateNode(nodeId);
            }
        } else if (type == Integer.MIN_VALUE) {
            if (!this.watcher.unwatch(pos, 3)) {
                throw new IllegalStateException("Pos was not being watched");
            }
            if ((nodeId & 0x20000000) == 0) {
                int meshId;
                SingleNodeRequest req = this.singleRequests.get(nodeId &= 0xFFFFFF);
                if (req.getPosition() != pos) {
                    throw new IllegalStateException();
                }
                this.singleRequests.release(nodeId);
                if (req.hasMeshSet() && (meshId = req.getMesh()) != -2 && meshId != -1) {
                    this.removeGeometryCached(pos, meshId);
                }
            } else {
                NodeChildRequest req = this.childRequests.get(nodeId &= 0xFFFFFF);
                if (req.getPosition() != pos) {
                    throw new IllegalStateException();
                }
                this._removeRequest(nodeId, req, pos);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void finishRequest(SingleNodeRequest request) {
        int id = this.nodeData.allocate();
        this.nodeData.setNodePosition(id, request.getPosition());
        this.nodeData.setNodeGeometry(id, request.getMesh());
        this.nodeData.setNodeChildExistence(id, request.getChildExistence());
        this.activeSectionMap.put(request.getPosition(), id | 0);
        this.invalidateNode(id);
        if (!this.topLevelNodeIds.add(id)) {
            throw new IllegalStateException();
        }
        this.clearAllocId(id);
        if (this.topLevelNodeIdAddedCallback != null) {
            this.topLevelNodeIdAddedCallback.accept(id);
        }
    }

    private void finishRequest(int requestId, NodeChildRequest request) {
        int parentNodeId = this.activeSectionMap.get(request.getPosition());
        if (parentNodeId == -1 || (parentNodeId & 0xC0000000) == Integer.MIN_VALUE) {
            throw new IllegalStateException("CRITICAL BAD STATE!!! finishRequest tried to finish for a node that no longer exists in the map or has become a request type somehow?!!?!!" + WorldEngine.pprintPos(request.getPosition()) + " " + parentNodeId);
        }
        int parentNodeType = parentNodeId & 0xC0000000;
        parentNodeId &= 0xFFFFFF;
        if (request.getMsk() == 0) {
            this.childRequests.release(requestId);
            this.nodeData.setNodeRequest(parentNodeId, 65535);
            this.nodeData.unmarkRequestInFlight(parentNodeId);
            --this.activeNodeRequestCount;
            this.invalidateNode(parentNodeId);
            return;
        }
        if (parentNodeType == 0) {
            int msk = Byte.toUnsignedInt(request.getMsk());
            if (msk == 0) {
                throw new IllegalStateException();
            }
            int base = this.nodeData.allocate(Integer.bitCount(msk));
            int offset = -1;
            for (int childIdx = 0; childIdx < 8; ++childIdx) {
                if ((msk & 1 << childIdx) == 0) continue;
                long childPos = NodeManager.makeChildPos(request.getPosition(), childIdx);
                int childNodeId = base + ++offset;
                this.nodeData.setNodePosition(childNodeId, childPos);
                byte childExistence = request.getChildChildExistence(childIdx);
                if (childExistence == 0) {
                    // empty if block
                }
                this.nodeData.setNodeChildExistence(childNodeId, childExistence);
                this.nodeData.setNodeGeometry(childNodeId, request.getChildMesh(childIdx));
                this.invalidateNode(childNodeId);
                int pid = this.activeSectionMap.put(childPos, childNodeId | 0);
                if ((pid & 0xC0000000) != Integer.MIN_VALUE) {
                    throw new IllegalStateException("Put node in map from request but type was not request: " + pid + " " + WorldEngine.pprintPos(childPos));
                }
                this.clearAllocId(childNodeId);
            }
            this.childRequests.release(requestId);
            this.nodeData.setChildPtr(parentNodeId, base);
            this.nodeData.setChildPtrCount(parentNodeId, Integer.bitCount(msk));
            this.nodeData.setNodeRequest(parentNodeId, 65535);
            --this.activeNodeRequestCount;
            this.nodeData.unmarkRequestInFlight(parentNodeId);
            if ((this.activeSectionMap.put(request.getPosition(), 0x40000000 | parentNodeId) & 0xC0000000) != 0) {
                throw new IllegalStateException();
            }
            this.invalidateNode(parentNodeId);
            this.nodeData.setAllChildrenAreLeaf(parentNodeId, true);
            if (!this.topLevelNodes.contains(request.getPosition())) {
                int ppnId = this.activeSectionMap.get(this.makeParentPos(request.getPosition()));
                if ((ppnId & 0xC0000000) != 0x40000000) {
                    throw new IllegalStateException();
                }
                this.nodeData.setAllChildrenAreLeaf(ppnId & 0xFFFFFF, false);
            }
        } else if (parentNodeType == 0x40000000) {
            int reqMsk;
            int oldChildPtr = this.nodeData.getChildPtr(parentNodeId);
            int oldChildCnt = this.nodeData.getChildPtrCount(parentNodeId);
            if (oldChildPtr == -1) {
                throw new IllegalStateException();
            }
            int existingChildMsk = 0;
            if (oldChildPtr != 0xFFFFFE) {
                for (int i = 0; i < oldChildCnt; ++i) {
                    if (!this.nodeData.nodeExists(i + oldChildPtr)) {
                        throw new IllegalStateException();
                    }
                    existingChildMsk |= 1 << NodeManager.getChildIdx(this.nodeData.nodePosition(i + oldChildPtr));
                }
            }
            if ((byte)(existingChildMsk | (reqMsk = Byte.toUnsignedInt(request.getMsk()))) != this.nodeData.getNodeChildExistence(parentNodeId)) {
                throw new IllegalStateException("node data existence state does not match pointer mask");
            }
            if ((reqMsk & existingChildMsk) != 0) {
                throw new IllegalStateException("Overlapping child data!!! BAD");
            }
            int newMsk = reqMsk | existingChildMsk;
            int newChildPtr = this.nodeData.allocate(Integer.bitCount(newMsk));
            int childId = newChildPtr - 1;
            int prevChildId = oldChildPtr - 1;
            for (int i = 0; i < 8; ++i) {
                if ((newMsk & 1 << i) == 0) continue;
                ++childId;
                if ((reqMsk & 1 << i) != 0) {
                    long childPos = NodeManager.makeChildPos(request.getPosition(), i);
                    this.nodeData.setNodePosition(childId, childPos);
                    byte childExistence = request.getChildChildExistence(i);
                    if (childExistence == 0) {
                        // empty if block
                    }
                    this.nodeData.setNodeChildExistence(childId, childExistence);
                    this.nodeData.setNodeGeometry(childId, request.getChildMesh(i));
                    this.invalidateNode(childId);
                    int pid = this.activeSectionMap.put(childPos, childId | 0);
                    if ((pid & 0xC0000000) != Integer.MIN_VALUE) {
                        throw new IllegalStateException("Put node in map from request but type was not request: " + pid + " " + WorldEngine.pprintPos(childPos));
                    }
                    this.clearAllocId(childId);
                    continue;
                }
                long pos = this.nodeData.nodePosition(++prevChildId);
                this.nodeData.copyNode(prevChildId, childId);
                this.clearAllocId(childId);
                this.clearMoveId(prevChildId, childId);
                this.clearFreeId(prevChildId);
                int prevNodeId = this.activeSectionMap.get(pos);
                if ((prevNodeId & 0xC0000000) == Integer.MIN_VALUE) {
                    throw new IllegalStateException();
                }
                if ((prevNodeId & 0xFFFFFF) != prevChildId) {
                    throw new IllegalStateException("State inconsistency");
                }
                this.activeSectionMap.put(pos, prevNodeId & 0xC0000000 | childId);
                this.invalidateNode(prevChildId);
                this.invalidateNode(childId);
            }
            if (oldChildPtr != 0xFFFFFE) {
                this.nodeData.free(oldChildPtr, oldChildCnt);
            }
            if (oldChildPtr == 0xFFFFFE) {
                this.nodeData.setAllChildrenAreLeaf(parentNodeId, true);
            }
            this.childRequests.release(requestId);
            this.nodeData.setChildPtr(parentNodeId, newChildPtr);
            this.nodeData.setChildPtrCount(parentNodeId, Integer.bitCount(newMsk));
            this.nodeData.setNodeRequest(parentNodeId, 65535);
            --this.activeNodeRequestCount;
            this.nodeData.unmarkRequestInFlight(parentNodeId);
            this.invalidateNode(parentNodeId);
        } else {
            throw new IllegalStateException();
        }
    }

    public void processRequest(long pos) {
        int nodeId = this.activeSectionMap.get(pos);
        if (nodeId == -1) {
            return;
        }
        int nodeType = nodeId & 0xC0000000;
        nodeId &= 0xFFFFFF;
        if (nodeType == Integer.MIN_VALUE) {
            Logger.error("Tried processing request for pos: " + WorldEngine.pprintPos(pos) + " but its type was a request, ignoring!");
            return;
        }
        if (nodeType != 0 && nodeType != 0x40000000) {
            throw new IllegalStateException("Unknown node type: " + nodeType);
        }
        if (WorldEngine.getLevel(pos) == 0) {
            Logger.error("Requests cannot exist for bottom level nodes. at: " + WorldEngine.pprintPos(pos) + ". Ignoring request");
            return;
        }
        if (nodeType == 0) {
            if (this.nodeData.getNodeGeometry(nodeId) == -1) {
                Logger.warn("Got request for leaf that doesnt have geometry, this should not be possible at pos " + WorldEngine.pprintPos(pos));
                if (!this.watcher.watch(pos, 1)) {
                    Logger.warn("Node: " + nodeId + " at pos: " + WorldEngine.pprintPos(pos) + " got update request, but geometry was already being watched");
                }
                return;
            }
            if (this.nodeData.isNodeRequestInFlight(nodeId)) {
                Logger.warn("Tried processing a node that already has a request in flight: " + nodeId + " pos: " + WorldEngine.pprintPos(pos) + " ignoring");
                return;
            }
            this.nodeData.markRequestInFlight(nodeId);
            this.makeLeafChildRequest(nodeId);
        } else {
            this.processInnerRequest(pos, nodeId);
        }
    }

    private void makeLeafChildRequest(int nodeId) {
        long pos = this.nodeData.nodePosition(nodeId);
        byte childExistence = this.nodeData.getNodeChildExistence(nodeId);
        if (childExistence == 0 && !this.topLevelNodes.contains(pos)) {
            Logger.warn("Not creating a leaf request with existence mask of 0 at pos", WorldEngine.pprintPos(pos));
            this.nodeData.unmarkRequestInFlight(nodeId);
            this.invalidateNode(nodeId);
            return;
        }
        NodeChildRequest request = new NodeChildRequest(pos);
        int requestId = this.childRequests.put(request);
        for (int i = 0; i < 8; ++i) {
            if ((childExistence & 1 << i) == 0) continue;
            long childPos = NodeManager.makeChildPos(pos, i);
            request.addChildRequirement(i);
            int pid = this.activeSectionMap.put(childPos, requestId | Integer.MIN_VALUE | 0x20000000);
            if (pid != -1) {
                Object extra = "";
                if ((pid & 0xC0000000) == 0) {
                    extra = " type leaf: pos " + WorldEngine.pprintPos(this.nodeData.nodePosition(pid)) + " hasRequest: " + this.nodeData.isNodeRequestInFlight(pid);
                }
                throw new IllegalStateException("Leaf request creation failed to insert child into map as a mapping already existed for the node! pos: " + WorldEngine.pprintPos(childPos) + " id: " + pid + " for parent " + WorldEngine.pprintPos(pos) + " extra " + (String)extra);
            }
            if (this.watcher.watch(childPos, 3)) continue;
            throw new IllegalStateException("Failed to watch childPos");
        }
        this.nodeData.setNodeRequest(nodeId, requestId);
        ++this.activeNodeRequestCount;
    }

    private void processInnerRequest(long pos, int nodeId) {
        int geo = this.nodeData.getNodeGeometry(nodeId);
        boolean isWatchingUpdate = (this.watcher.get(pos) & 1) != 0;
        boolean inflight = this.nodeData.isNodeGeometryInFlight(nodeId);
        if (inflight && !isWatchingUpdate) {
            throw new IllegalStateException();
        }
        if (geo != -1 && inflight && geo != -2) {
            throw new IllegalStateException();
        }
        if (!this.nodeData.isNodeGeometryInFlight(nodeId)) {
            if (!this.watcher.watch(pos, 1)) {
                this.invalidateNode(nodeId);
            } else {
                this.nodeData.markNodeGeometryInFlight(nodeId);
            }
        }
    }

    public void removeNodeGeometry(long pos) {
        int nodeId = this.activeSectionMap.get(pos);
        if (nodeId == -1) {
            return;
        }
        int nodeType = nodeId & 0xC0000000;
        nodeId &= 0xFFFFFF;
        if (nodeType == Integer.MIN_VALUE) {
            return;
        }
        if (nodeType == 0x40000000) {
            this.clearGeometryInternal(pos, nodeId);
        } else if (this.topLevelNodes.contains(pos)) {
            int geo = this.nodeData.getNodeGeometry(nodeId);
            if (geo != -1 && geo != -2) {
                Logger.warn("Tried removing geometry from top level node which is not allowed, disregarding request");
                return;
            }
        } else {
            this.processLeafGeometryRemoval(pos);
        }
    }

    private void processLeafGeometryRemoval(long cPos) {
        long pPos = this.makeParentPos(cPos);
        int pId = this.activeSectionMap.get(pPos);
        if (pId == -1) {
            throw new IllegalStateException("Parent node must exist");
        }
        if ((pId & 0xC0000000) != 0x40000000) {
            throw new IllegalStateException("Parent node must be an inner node");
        }
        int pGeo = this.nodeData.getNodeGeometry(pId &= 0xFFFFFF);
        if (pGeo == -1) {
            this.processRequest(pPos);
        } else {
            this.recurseRemoveChildNodes(pPos);
            int old = this.activeSectionMap.put(pPos, 0 | pId);
            if (old == -1) {
                throw new IllegalStateException();
            }
            if ((old & 0xC0000000) != 0x40000000 || (old & 0xFFFFFF) != pId) {
                throw new IllegalStateException();
            }
            this.nodeData.setAllChildrenAreLeaf(pId, false);
        }
    }

    private void clearGeometryInternal(long pos, int nodeId) {
        int meshId = this.nodeData.getNodeGeometry(nodeId);
        if (meshId != -1 && meshId != -2) {
            if (this.watcher.unwatch(pos, 1)) {
                throw new IllegalStateException("Unwatching position for geometry removal at: " + WorldEngine.pprintPos(pos) + " resulted in full removal");
            }
            this.removeGeometryCached(pos, meshId);
            this.nodeData.setNodeGeometry(nodeId, -1);
            this.invalidateNode(nodeId);
            this.nodeData.unmarkNodeGeometryInFlight(nodeId);
        } else if (meshId == -1) {
            // empty if block
        }
    }

    public boolean writeChanges(GlBuffer nodeBuffer) {
        if (this.nodeUpdates.isEmpty()) {
            return false;
        }
        this.nodeUpdates.forEach(i -> this.nodeData.writeNode(UploadStream.INSTANCE.upload(nodeBuffer, (long)i * 16L, 16L), i));
        this.nodeUpdates.clear();
        return true;
    }

    IntOpenHashSet getNodeUpdates() {
        return this.nodeUpdates;
    }

    void writeNode(int node, long address) {
        this.nodeData.writeNode(address, node);
    }

    public MemoryBuffer _generateChangeList() {
        if (this.nodeUpdates.isEmpty()) {
            return null;
        }
        MemoryBuffer buff = new MemoryBuffer((long)this.nodeUpdates.size() * 20L);
        int c = 0;
        IntIterator intIterator = this.nodeUpdates.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            long addr = buff.address + 20L * (long)c++;
            MemoryUtil.memPutInt((long)addr, (int)i);
            this.nodeData.writeNode(addr + 4L, i);
        }
        this.nodeUpdates.clear();
        return buff;
    }

    private void invalidateNode(int nodeId) {
        this.nodeUpdates.add(nodeId);
    }

    private static int getChildIdx(long pos) {
        int x = WorldEngine.getX(pos);
        int y = WorldEngine.getY(pos);
        int z = WorldEngine.getZ(pos);
        return x & 1 | (y & 1) << 2 | (z & 1) << 1;
    }

    private static long makeChildPos(long basePos, int addin) {
        int lvl = WorldEngine.getLevel(basePos);
        if (lvl == 0) {
            throw new IllegalArgumentException("Cannot create a child lower than lod level 0");
        }
        return WorldEngine.getWorldSectionId(lvl - 1, WorldEngine.getX(basePos) << 1 | addin & 1, WorldEngine.getY(basePos) << 1 | addin >> 2 & 1, WorldEngine.getZ(basePos) << 1 | addin >> 1 & 1);
    }

    private long makeParentPos(long pos) {
        int lvl = WorldEngine.getLevel(pos);
        if (lvl == 4) {
            throw new IllegalArgumentException("Cannot create a parent higher than LoD 4");
        }
        return WorldEngine.getWorldSectionId(lvl + 1, WorldEngine.getX(pos) >> 1, WorldEngine.getY(pos) >> 1, WorldEngine.getZ(pos) >> 1);
    }

    public void addDebug(List<String> debug) {
        debug.add("NC/IF: " + this.activeSectionMap.size() + "/" + (this.singleRequests.count() + this.childRequests.count()));
    }

    public int getCurrentMaxNodeId() {
        return this.nodeData.getEndNodeId();
    }

    private int verifyRequest(long pos, int node, int cActiveExistence, LongOpenHashSet seenPositions, IntOpenHashSet seenNodes) {
        if (this.nodeData.isNodeRequestInFlight(node)) {
            int requestId = this.nodeData.getNodeRequest(node);
            NodeChildRequest request = this.childRequests.get(requestId);
            if (request.getPosition() != pos) {
                throw new IllegalStateException();
            }
            int reqMsk = Byte.toUnsignedInt(request.getMsk());
            if ((cActiveExistence & reqMsk) != 0) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < 8; ++i) {
                if ((reqMsk & 1 << i) == 0) continue;
                long cPos = NodeManager.makeChildPos(pos, i);
                int cNode = this.activeSectionMap.get(cPos);
                if (cNode == -1) {
                    throw new IllegalStateException();
                }
                if ((cNode & 0xC0000000) != Integer.MIN_VALUE) {
                    throw new IllegalStateException();
                }
                if ((cNode & 0x20000000) != 0x20000000) {
                    throw new IllegalStateException();
                }
                if ((cNode & 0xFFFFFF) != requestId) {
                    throw new IllegalStateException();
                }
                this.verifyNode(cPos, seenPositions, seenNodes);
            }
            return reqMsk;
        }
        return 0;
    }

    private void verifyNode(long pos, LongOpenHashSet seenPositions, IntOpenHashSet seenNodes) {
        int node = this.activeSectionMap.get(pos);
        if (node == -1) {
            throw new IllegalStateException();
        }
        if (this.watcher.get(pos) == 0) {
            throw new IllegalStateException();
        }
        if (!seenPositions.add(pos)) {
            throw new IllegalStateException();
        }
        int type = node & 0xC0000000;
        if (type == Integer.MIN_VALUE) {
            if ((node & 0x20000000) == 0) {
                if (!this.topLevelNodes.contains(pos)) {
                    throw new IllegalStateException();
                }
                int id = node & 0xFFFFFF;
                SingleNodeRequest req = this.singleRequests.get(id);
                if (req.getPosition() != pos) {
                    throw new IllegalStateException();
                }
            } else {
                int id = node & 0xFFFFFF;
                NodeChildRequest req = this.childRequests.get(id);
                if (req.getPosition() != this.makeParentPos(pos)) {
                    throw new IllegalStateException();
                }
            }
        } else {
            if (!this.nodeData.nodeExists(node &= 0xFFFFFF)) {
                throw new IllegalStateException();
            }
            if (this.nodeData.nodePosition(node) != pos) {
                throw new IllegalStateException();
            }
            if (this.nodeData.getNodeRequest(node) != 65535 != this.nodeData.isNodeRequestInFlight(node)) {
                throw new IllegalStateException();
            }
            if (this.nodeData.isNodeRequestInFlight(node)) {
                NodeChildRequest req = this.childRequests.get(this.nodeData.getNodeRequest(node));
                if (req == null) {
                    throw new IllegalStateException();
                }
                if (req.getPosition() != pos) {
                    throw new IllegalStateException();
                }
                if (req.isSatisfied() && (type != 0 || !this.topLevelNodes.contains(pos))) {
                    throw new IllegalStateException();
                }
            }
            boolean hasGeometry = this.nodeData.getNodeGeometry(node) != -1;
            boolean watchingGeo = (this.watcher.get(pos) & 1) != 0;
            boolean awaitingGeo = this.nodeData.isNodeGeometryInFlight(node);
            if ((hasGeometry || awaitingGeo) != watchingGeo) {
                throw new IllegalStateException();
            }
            if (hasGeometry && awaitingGeo && this.nodeData.getNodeGeometry(node) != -2) {
                throw new IllegalStateException();
            }
            if (!seenNodes.add(node)) {
                throw new IllegalStateException();
            }
            if (type == 0x40000000) {
                int childPtr = this.nodeData.getChildPtr(node);
                int childCount = this.nodeData.getChildPtrCount(node);
                int cActiveExistence = 0;
                if (childPtr == -1) {
                    throw new IllegalStateException();
                }
                if (childPtr != 0xFFFFFE) {
                    boolean allChildrenLeaf = true;
                    for (int i = 0; i < childCount; ++i) {
                        if (!this.nodeData.nodeExists(i + childPtr)) {
                            throw new IllegalStateException();
                        }
                        long cPos = this.nodeData.nodePosition(i + childPtr);
                        if (this.makeParentPos(cPos) != pos) {
                            throw new IllegalStateException();
                        }
                        cActiveExistence |= 1 << NodeManager.getChildIdx(cPos);
                        int cNode = this.activeSectionMap.get(cPos);
                        if (cNode == -1) {
                            throw new IllegalStateException();
                        }
                        if ((cNode & 0xC0000000) != 0) {
                            allChildrenLeaf = false;
                        }
                        this.verifyNode(cPos, seenPositions, seenNodes);
                    }
                    if (this.nodeData.getAllChildrenAreLeaf(node) != allChildrenLeaf) {
                        throw new IllegalStateException();
                    }
                } else {
                    if (this.nodeData.getAllChildrenAreLeaf(node)) {
                        throw new IllegalStateException();
                    }
                    childCount = 0;
                }
                int childExistence = cActiveExistence;
                if ((childExistence |= this.verifyRequest(pos, node, cActiveExistence, seenPositions, seenNodes)) != Byte.toUnsignedInt(this.nodeData.getNodeChildExistence(node))) {
                    throw new IllegalStateException();
                }
                if (childExistence == 0) {
                    throw new IllegalStateException();
                }
            } else if (type == 0) {
                int childExistence;
                if (this.nodeData.getAllChildrenAreLeaf(node)) {
                    throw new IllegalStateException();
                }
                if (this.nodeData.getChildPtr(node) != -1) {
                    throw new IllegalStateException();
                }
                if (this.nodeData.getNodeGeometry(node) == -1) {
                    throw new IllegalStateException();
                }
                if (WorldEngine.getLevel(pos) == 0 ? this.nodeData.isNodeRequestInFlight(node) : this.nodeData.isNodeRequestInFlight(node) && (childExistence = this.verifyRequest(pos, node, 0, seenPositions, seenNodes)) != Byte.toUnsignedInt(this.nodeData.getNodeChildExistence(node))) {
                    throw new IllegalStateException();
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public void verifyIntegrity() {
        this.verifyIntegrity(null, null);
    }

    public void verifyIntegrity(LongSet watchingPosSet, IntSet nodes) {
        LongOpenHashSet seenPositions = new LongOpenHashSet();
        IntOpenHashSet seenNodes = new IntOpenHashSet();
        LongIterator longIterator = this.topLevelNodes.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            this.verifyNode(pos, seenPositions, seenNodes);
        }
        LongSet thisMap = this.activeSectionMap.keySet();
        if (!seenPositions.containsAll((LongCollection)thisMap) || !thisMap.containsAll((LongCollection)seenPositions)) {
            throw new IllegalStateException();
        }
        if (seenNodes.size() != this.nodeData.getNodeCount()) {
            throw new IllegalStateException();
        }
        IntIterator pos = seenNodes.iterator();
        while (pos.hasNext()) {
            int i = (Integer)pos.next();
            if (this.nodeData.nodeExists(i)) continue;
            throw new IllegalStateException();
        }
        if (this.activeNodeRequestCount != this.childRequests.count()) {
            throw new IllegalStateException();
        }
        if (watchingPosSet != null) {
            if (!watchingPosSet.containsAll((LongCollection)thisMap)) {
                throw new IllegalStateException();
            }
            if (!thisMap.containsAll((LongCollection)watchingPosSet)) {
                throw new IllegalStateException();
            }
        }
        if (nodes != null) {
            if (!nodes.containsAll((IntCollection)seenNodes)) {
                throw new IllegalStateException();
            }
            if (!seenNodes.containsAll((IntCollection)nodes)) {
                throw new IllegalStateException();
            }
        }
        IntOpenHashSet tln = new IntOpenHashSet(this.topLevelNodeIds.size());
        LongIterator longIterator2 = this.topLevelNodes.iterator();
        while (longIterator2.hasNext()) {
            long p = (Long)longIterator2.next();
            int n = this.activeSectionMap.get(p);
            if (n == -1) {
                throw new IllegalStateException();
            }
            if ((n & 0xC0000000) == Integer.MIN_VALUE || tln.add(n & 0xFFFFFF)) continue;
            throw new IllegalStateException();
        }
        if (!this.topLevelNodeIds.containsAll((IntCollection)tln)) {
            throw new IllegalStateException();
        }
        if (!tln.containsAll((IntCollection)this.topLevelNodeIds)) {
            throw new IllegalStateException();
        }
    }

    public static interface ICleaner {
        public void alloc(int var1);

        public void move(int var1, int var2);

        public void free(int var1);
    }
}

