/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.hierachical;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.StampedLock;
import me.cortex.voxy.client.TimingStatistics;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.GeometryCache;
import me.cortex.voxy.client.core.rendering.SectionUpdateRouter;
import me.cortex.voxy.client.core.rendering.building.BuiltSection;
import me.cortex.voxy.client.core.rendering.building.RenderGenerationService;
import me.cortex.voxy.client.core.rendering.hierachical.NodeCleaner;
import me.cortex.voxy.client.core.rendering.hierachical.NodeManager;
import me.cortex.voxy.client.core.rendering.section.geometry.BasicAsyncGeometryManager;
import me.cortex.voxy.client.core.rendering.section.geometry.BasicSectionGeometryData;
import me.cortex.voxy.client.core.rendering.section.geometry.IGeometryData;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.AllocationArena;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldSection;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.system.MemoryUtil;

public class AsyncNodeManager {
    private static final VarHandle RESULT_HANDLE;
    private static final VarHandle RESULT_CACHE_1_HANDLE;
    private static final VarHandle RESULT_CACHE_2_HANDLE;
    private final Thread thread;
    public final int maxNodeCount;
    private final long geometryCapacity;
    private volatile boolean running = true;
    private final NodeManager manager;
    private final BasicAsyncGeometryManager geometryManager;
    private final IGeometryData geometryData;
    private final SectionUpdateRouter router;
    private final GeometryCache geometryCache = new GeometryCache(0x100000000L);
    private final AtomicInteger workCounter = new AtomicInteger();
    private volatile SyncResults results = null;
    private volatile SyncResults resultCache1 = new SyncResults();
    private volatile SyncResults resultCache2 = new SyncResults();
    private final IntOpenHashSet tlnIdChange = new IntOpenHashSet();
    private final IntOpenHashSet cleanerIdResetClear = new IntOpenHashSet();
    private boolean needsWaitForSync = false;
    private final Shader scatterWrite = Shader.make(new IShaderProcessor[0]).define("INPUT_BUFFER_BINDING", 0).define("OUTPUT_BUFFER1_BINDING", 1).define("OUTPUT_BUFFER2_BINDING", 2).add(ShaderType.COMPUTE, "voxy:util/scatter.comp").compile();
    private final Shader multiMemcpy = Shader.make(new IShaderProcessor[0]).define("INPUT_HEADER_BUFFER_BINDING", 0).define("INPUT_DATA_BUFFER_BINDING", 1).define("OUTPUT_BUFFER_BINDING", 2).add(ShaderType.COMPUTE, "voxy:util/memcpy.comp").compile();
    private IntConsumer tlnAddCallback;
    private IntConsumer tlnRemoveCallback;
    private int currentMaxNodeId = 0;
    private long usedGeometryAmount = 0L;
    private final ConcurrentLinkedDeque<MemoryBuffer> requestBatchQueue = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<WorldSection> childUpdateQueue = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<BuiltSection> geometryUpdateQueue = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<MemoryBuffer> removeBatchQueue = new ConcurrentLinkedDeque();
    private final StampedLock tlnLock = new StampedLock();
    private final LongOpenHashSet tlnAdd = new LongOpenHashSet();
    private final LongOpenHashSet tlnRem = new LongOpenHashSet();

    public AsyncNodeManager(int maxNodeCount, IGeometryData geometryData, RenderGenerationService renderService) {
        this.geometryData = geometryData;
        this.geometryCapacity = ((BasicSectionGeometryData)geometryData).getGeometryCapacityBytes();
        this.maxNodeCount = maxNodeCount;
        this.thread = new Thread(() -> {
            try {
                while (this.running) {
                    this.run();
                }
            }
            catch (Exception e) {
                Logger.error("Critical error occurred in async processor, things will be broken", e);
            }
        });
        this.thread.setName("Async Node Manager");
        this.geometryManager = new BasicAsyncGeometryManager(((BasicSectionGeometryData)geometryData).getMaxSectionCount(), this.geometryCapacity);
        this.router = new SectionUpdateRouter();
        this.router.setCallbacks(pos -> {
            BuiltSection cachedGeometry = this.geometryCache.remove(pos);
            if (cachedGeometry != null) {
                this.submitGeometryResult(cachedGeometry);
            } else {
                renderService.enqueueTask(pos);
            }
        }, renderService::enqueueTask, this::submitChildChange);
        renderService.setResultConsumer(this::submitGeometryResult);
        this.manager = new NodeManager(maxNodeCount, this.geometryManager, this.router);
        this.manager.setClear(new NodeManager.ICleaner(){

            @Override
            public void alloc(int id) {
                AsyncNodeManager.this.cleanerIdResetClear.remove(id);
                AsyncNodeManager.this.cleanerIdResetClear.add(id | Integer.MIN_VALUE);
            }

            @Override
            public void move(int from, int to) {
            }

            @Override
            public void free(int id) {
                AsyncNodeManager.this.cleanerIdResetClear.remove(id | Integer.MIN_VALUE);
                AsyncNodeManager.this.cleanerIdResetClear.add(id);
            }
        });
        this.manager.setTLNCallbacks(id -> {
            if (!this.tlnIdChange.remove(id) && !this.tlnIdChange.add(id | Integer.MIN_VALUE)) {
                throw new IllegalStateException();
            }
        }, id -> {
            if (!this.tlnIdChange.remove(id | Integer.MIN_VALUE) && !this.tlnIdChange.add(id)) {
                throw new IllegalStateException();
            }
        });
    }

    private SyncResults getMakeResultObject() {
        SyncResults resultSet = RESULT_CACHE_1_HANDLE.getAndSet(this, null);
        if (resultSet == null) {
            resultSet = RESULT_CACHE_2_HANDLE.getAndSet(this, null);
        }
        if (resultSet == null) {
            throw new IllegalStateException("There should always be an object in the result set cache pair");
        }
        resultSet.reset();
        return resultSet;
    }

    private void run() {
        int val;
        int i;
        BuiltSection job;
        WorldSection job2;
        LongIterator iter;
        if (this.workCounter.get() <= 0) {
            LockSupport.park();
            if (this.workCounter.get() <= 0 || !this.running) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.running) {
            return;
        }
        int workDone = 0;
        LongOpenHashSet add = null;
        LongOpenHashSet rem = null;
        long stamp = this.tlnLock.writeLock();
        if (!this.tlnAdd.isEmpty()) {
            add = new LongOpenHashSet((LongCollection)this.tlnAdd);
            this.tlnAdd.clear();
        }
        if (!this.tlnRem.isEmpty()) {
            rem = new LongOpenHashSet((LongCollection)this.tlnRem);
            this.tlnRem.clear();
        }
        this.tlnLock.unlockWrite(stamp);
        int work = 0;
        if (rem != null) {
            iter = rem.longIterator();
            while (iter.hasNext()) {
                this.manager.removeTopLevelNode(iter.nextLong());
                ++work;
            }
        }
        if (add != null) {
            iter = add.longIterator();
            while (iter.hasNext()) {
                this.manager.insertTopLevelNode(iter.nextLong());
                ++work;
            }
        }
        workDone += work;
        while ((job2 = this.childUpdateQueue.poll()) != null) {
            ++workDone;
            this.manager.processChildChange(job2.key, job2.getNonEmptyChildren());
            job2.release();
        }
        for (int limit = 0; limit < 300 && this.geometryCapacity - this.geometryManager.getGeometryUsedBytes() > 50000000L && (job = this.geometryUpdateQueue.poll()) != null; ++limit) {
            ++workDone;
            this.manager.processGeometryResult(job);
        }
        while ((job = this.requestBatchQueue.poll()) != null) {
            ++workDone;
            long ptr = job.address;
            int count = MemoryUtil.memGetInt((long)ptr);
            ptr += 8L;
            if (job.size < (long)count * 8L + 8L) {
                throw new IllegalStateException();
            }
            for (i = 0; i < count; ++i) {
                long pos = (long)MemoryUtil.memGetInt((long)ptr) << 32;
                ptr += 4L;
                this.manager.processRequest(pos |= Integer.toUnsignedLong(MemoryUtil.memGetInt((long)(ptr += 4L))));
            }
            job.free();
        }
        while ((job = this.removeBatchQueue.poll()) != null) {
            ++workDone;
            long ptr = job.address;
            int zeroCount = 0;
            for (i = 0; i < 256; ++i) {
                long pos = (long)MemoryUtil.memGetInt((long)ptr) << 32;
                ptr += 4L;
                if ((pos |= Integer.toUnsignedLong(MemoryUtil.memGetInt((long)(ptr += 4L)))) == -1L) continue;
                if (pos == 0L && zeroCount++ > 0) {
                    Logger.error("Remove node pos is 0 " + zeroCount + " times, this is really bad, please report");
                    continue;
                }
                this.manager.removeNodeGeometry(pos);
            }
            job.free();
        }
        if (this.workCounter.addAndGet(-workDone) < 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.workCounter.get() < 0) {
                Logger.error("Work counter less than zero, hope it fixes itself...");
            }
        }
        if (workDone == 0) {
            return;
        }
        if (this.needsWaitForSync) {
            while (RESULT_HANDLE.get(this) != null && this.running) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        SyncResults prev = RESULT_HANDLE.getAndSet(this, null);
        SyncResults results = null;
        if (prev == null) {
            this.needsWaitForSync = false;
            results = this.getMakeResultObject();
            results.tlnDelta.addAll((IntCollection)this.tlnIdChange);
            this.tlnIdChange.clear();
            if (!this.geometryManager.getUploads().isEmpty()) {
                ObjectIterator iter2 = this.geometryManager.getUploads().int2ObjectEntrySet().fastIterator();
                while (iter2.hasNext()) {
                    Int2ObjectMap.Entry val2 = (Int2ObjectMap.Entry)iter2.next();
                    results.geometryUpload.upload(val2.getIntKey(), (MemoryBuffer)val2.getValue());
                    ((MemoryBuffer)val2.getValue()).free();
                }
                this.geometryManager.getUploads().clear();
            }
            this.geometryManager.getHeapRemovals().clear();
            results.cleanerOperations.addAll((IntCollection)this.cleanerIdResetClear);
            this.cleanerIdResetClear.clear();
        } else {
            int val3;
            results = prev;
            if (!this.tlnIdChange.isEmpty()) {
                IntIterator iter3 = this.tlnIdChange.intIterator();
                while (iter3.hasNext()) {
                    val3 = iter3.nextInt();
                    if (results.tlnDelta.remove(val3 ^ Integer.MIN_VALUE)) continue;
                    results.tlnDelta.add(val3);
                }
                this.tlnIdChange.clear();
            }
            if (!this.cleanerIdResetClear.isEmpty()) {
                IntIterator iter4 = this.cleanerIdResetClear.intIterator();
                while (iter4.hasNext()) {
                    val3 = iter4.nextInt();
                    results.cleanerOperations.remove(val3 ^ Integer.MIN_VALUE);
                    results.cleanerOperations.add(val3);
                }
                this.cleanerIdResetClear.clear();
            }
            if (!this.geometryManager.getHeapRemovals().isEmpty()) {
                IntOpenHashSet rem2 = this.geometryManager.getHeapRemovals();
                IntIterator iter5 = rem2.intIterator();
                while (iter5.hasNext()) {
                    results.geometryUpload.remove(iter5.nextInt());
                }
                rem2.clear();
            }
            if (!this.geometryManager.getUploads().isEmpty()) {
                Int2ObjectOpenHashMap<MemoryBuffer> add2 = this.geometryManager.getUploads();
                ObjectIterator iter6 = add2.int2ObjectEntrySet().fastIterator();
                while (iter6.hasNext()) {
                    Int2ObjectMap.Entry val4 = (Int2ObjectMap.Entry)iter6.next();
                    results.geometryUpload.upload(val4.getIntKey(), (MemoryBuffer)val4.getValue());
                    ((MemoryBuffer)val4.getValue()).free();
                }
                add2.clear();
            }
        }
        if (!this.geometryManager.getUpdateIds().isEmpty()) {
            IntOpenHashSet ids = this.geometryManager.getUpdateIds();
            IntIterator iter7 = ids.intIterator();
            while (iter7.hasNext()) {
                val = iter7.nextInt();
                int scatterAddr = val << 1 | Integer.MIN_VALUE;
                long ptrA = results.getScatterWritePtr(scatterAddr + 0, 1);
                long ptrB = results.getScatterWritePtr(scatterAddr + 1, 0);
                this.geometryManager.writeMetadataSplit(val, ptrA, ptrB);
            }
            ids.clear();
        }
        if (!this.manager.getNodeUpdates().isEmpty()) {
            IntOpenHashSet ids = this.manager.getNodeUpdates();
            IntIterator iter8 = ids.intIterator();
            while (iter8.hasNext()) {
                val = iter8.nextInt();
                long ptr = results.getScatterWritePtr(val);
                this.manager.writeNode(val, ptr);
            }
            ids.clear();
        }
        results.geometrySectionCount = this.geometryManager.getSectionCount();
        results.usedGeometry = this.geometryManager.getGeometryUsedBytes();
        results.currentMaxNodeId = this.manager.getCurrentMaxNodeId();
        this.needsWaitForSync |= (long)results.geometryUpload.currentElemCopyAmount * 8L > 0x200000L;
        this.needsWaitForSync |= results.cleanerOperations.size() > 1024;
        this.needsWaitForSync |= results.scatterWriteLocationMap.size() > 4096;
        this.needsWaitForSync |= results.tlnDelta.size() > 10;
        if (!RESULT_HANDLE.compareAndSet(this, null, results)) {
            throw new IllegalArgumentException("Should always have null");
        }
    }

    public void tick(GlBuffer nodeBuffer, NodeCleaner cleaner) {
        SyncResults results = RESULT_HANDLE.getAndSet(this, null);
        if (results == null) {
            return;
        }
        if (!results.tlnDelta.isEmpty()) {
            IntIterator iter = results.tlnDelta.intIterator();
            while (iter.hasNext()) {
                int val = iter.nextInt();
                if ((val & Integer.MIN_VALUE) != 0) {
                    this.tlnAddCallback.accept(val & Integer.MAX_VALUE);
                    continue;
                }
                this.tlnRemoveCallback.accept(val);
            }
        }
        BasicSectionGeometryData store = (BasicSectionGeometryData)this.geometryData;
        store.setSectionCount(results.geometrySectionCount);
        ComputeMemoryCopy upload = results.geometryUpload;
        if (!upload.dataUploadPoints.isEmpty()) {
            ((BasicSectionGeometryData)this.geometryData).ensureAccessable(upload.maxElementAccess);
            TimingStatistics.A.start();
            int copies = upload.dataUploadPoints.size();
            int scratchSize = (int)upload.arena.getSize() * 8;
            long ptr = UploadStream.INSTANCE.rawUploadAddress(scratchSize + copies * 16);
            UnsafeUtil.memcpy(upload.scratchHeaderBuffer.address, UploadStream.INSTANCE.getBaseAddress() + ptr, (long)copies * 16L);
            UnsafeUtil.memcpy(upload.scratchDataBuffer.address, UploadStream.INSTANCE.getBaseAddress() + ptr + (long)copies * 16L, (long)scratchSize);
            UploadStream.INSTANCE.commit();
            this.multiMemcpy.bind();
            GL43C.glBindBufferRange((int)37074, (int)0, (int)UploadStream.INSTANCE.getRawBufferId(), (long)ptr, (long)((long)copies * 16L));
            GL43C.glBindBufferRange((int)37074, (int)1, (int)UploadStream.INSTANCE.getRawBufferId(), (long)(ptr + (long)copies * 16L), (long)scratchSize);
            ARBUniformBufferObject.glBindBufferBase((int)37074, (int)2, (int)((BasicSectionGeometryData)this.geometryData).getGeometryBuffer().id);
            if (copies > 500) {
                Logger.warn("Large amount of copies, lag will probably happen: " + copies);
            }
            GL42C.glMemoryBarrier((int)8192);
            GL43C.glDispatchCompute((int)copies, (int)1, (int)1);
            GL42C.glMemoryBarrier((int)8192);
            TimingStatistics.A.stop();
        }
        TimingStatistics.B.start();
        if (!results.scatterWriteLocationMap.isEmpty()) {
            int count = results.scatterWriteLocationMap.size();
            int chunks = (count + 3) / 4;
            int streamSize = chunks * 80;
            long ptr = UploadStream.INSTANCE.rawUploadAddress(streamSize + 16);
            ptr = ptr + 15L & 0xFFFFFFFFFFFFFFF0L;
            MemoryUtil.memCopy((long)results.scatterWriteBuffer.address, (long)(UploadStream.INSTANCE.getBaseAddress() + ptr), (long)streamSize);
            UploadStream.INSTANCE.commit();
            this.scatterWrite.bind();
            GL43C.glBindBufferRange((int)37074, (int)0, (int)UploadStream.INSTANCE.getRawBufferId(), (long)ptr, (long)streamSize);
            ARBUniformBufferObject.glBindBufferBase((int)37074, (int)1, (int)nodeBuffer.id);
            ARBUniformBufferObject.glBindBufferBase((int)37074, (int)2, (int)((BasicSectionGeometryData)this.geometryData).getMetadataBuffer().id);
            GL30C.glUniform1ui((int)0, (int)count);
            GL42C.glMemoryBarrier((int)8196);
            GL43C.glDispatchCompute((int)((count + 127) / 128), (int)1, (int)1);
            GL42C.glMemoryBarrier((int)8196);
        }
        TimingStatistics.B.stop();
        TimingStatistics.C.start();
        if (!results.cleanerOperations.isEmpty()) {
            cleaner.updateIds(results.cleanerOperations);
        }
        TimingStatistics.C.stop();
        this.currentMaxNodeId = results.currentMaxNodeId;
        this.usedGeometryAmount = results.usedGeometry;
        if (!RESULT_CACHE_1_HANDLE.compareAndSet(this, null, results) && !RESULT_CACHE_2_HANDLE.compareAndSet(this, null, results)) {
            throw new IllegalStateException("Could not insert result into cache");
        }
    }

    public void setTLNAddRemoveCallbacks(IntConsumer add, IntConsumer remove) {
        this.tlnAddCallback = add;
        this.tlnRemoveCallback = remove;
    }

    public int getCurrentMaxNodeId() {
        return this.currentMaxNodeId;
    }

    public long getUsedGeometryCapacity() {
        return this.usedGeometryAmount;
    }

    public long getGeometryCapacity() {
        return this.geometryCapacity;
    }

    private void addWork() {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        if (this.workCounter.getAndIncrement() == 0) {
            LockSupport.unpark(this.thread);
        }
    }

    public void submitRequestBatch(MemoryBuffer batch) {
        this.requestBatchQueue.add(batch);
        this.addWork();
    }

    private void submitChildChange(WorldSection section) {
        if (!this.running) {
            return;
        }
        section.acquire();
        this.childUpdateQueue.add(section);
        this.addWork();
    }

    private void submitGeometryResult(BuiltSection geometry) {
        if (!this.running) {
            geometry.free();
            return;
        }
        this.geometryUpdateQueue.add(geometry);
        this.addWork();
    }

    public void submitRemoveBatch(MemoryBuffer batch) {
        this.removeBatchQueue.add(batch);
        this.addWork();
    }

    public void addTopLevel(long section) {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        long stamp = this.tlnLock.writeLock();
        int state = 0;
        state = !this.tlnRem.remove(section) ? (state += this.tlnAdd.add(section) ? 1 : 0) : --state;
        if (state != 0 && this.workCounter.getAndAdd(state) == 0) {
            LockSupport.unpark(this.thread);
        }
        this.tlnLock.unlockWrite(stamp);
    }

    public void removeTopLevel(long section) {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        long stamp = this.tlnLock.writeLock();
        int state = 0;
        state = !this.tlnAdd.remove(section) ? (state += this.tlnRem.add(section) ? 1 : 0) : --state;
        if (state != 0 && this.workCounter.getAndAdd(state) == 0) {
            LockSupport.unpark(this.thread);
        }
        this.tlnLock.unlockWrite(stamp);
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        SyncResults result;
        WorldSection section;
        Object buffer;
        if (!this.running) {
            throw new IllegalStateException();
        }
        this.running = false;
        LockSupport.unpark(this.thread);
        try {
            while (this.thread.isAlive()) {
                LockSupport.unpark(this.thread);
                this.thread.join(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        while ((buffer = this.requestBatchQueue.poll()) != null) {
            ((MemoryBuffer)buffer).free();
        }
        while ((buffer = this.removeBatchQueue.poll()) != null) {
            ((MemoryBuffer)buffer).free();
        }
        while ((buffer = this.geometryUpdateQueue.poll()) != null) {
            ((BuiltSection)buffer).free();
        }
        while ((section = this.childUpdateQueue.poll()) != null) {
            section.release();
        }
        if (RESULT_HANDLE.get(this) != null) {
            result = RESULT_HANDLE.getAndSet(this, null);
            result.geometryUpload.free();
            result.scatterWriteBuffer.free();
        }
        if (RESULT_CACHE_1_HANDLE.get(this) != null) {
            result = RESULT_CACHE_1_HANDLE.getAndSet(this, null);
            result.geometryUpload.free();
            result.scatterWriteBuffer.free();
        }
        if (RESULT_CACHE_2_HANDLE.get(this) != null) {
            result = RESULT_CACHE_2_HANDLE.getAndSet(this, null);
            result.geometryUpload.free();
            result.scatterWriteBuffer.free();
        }
        this.scatterWrite.free();
        this.multiMemcpy.free();
        this.geometryCache.free();
    }

    public void addDebug(List<String> debug) {
        debug.add("UC/GC: " + this.getUsedGeometryCapacity() / 0x100000L + "/" + this.getGeometryCapacity() / 0x100000L);
    }

    public boolean hasWork() {
        return this.workCounter.get() != 0 || RESULT_HANDLE.get(this) != null;
    }

    public void worldEvent(WorldSection section, int flags, int neighborMask) {
        this.geometryCache.clear(section.key);
        this.router.forwardEvent(section, flags);
        if (neighborMask != 0) {
            if ((neighborMask & 1) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x, section.y - 1, section.z));
            }
            if ((neighborMask & 2) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x, section.y + 1, section.z));
            }
            if ((neighborMask & 4) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x - 1, section.y, section.z));
            }
            if ((neighborMask & 8) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x + 1, section.y, section.z));
            }
            if ((neighborMask & 0x10) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x, section.y, section.z - 1));
            }
            if ((neighborMask & 0x20) != 0) {
                this.router.triggerRemesh(WorldEngine.getWorldSectionId(section.lvl, section.x, section.y, section.z + 1));
            }
        }
    }

    static {
        try {
            RESULT_HANDLE = MethodHandles.lookup().findVarHandle(AsyncNodeManager.class, "results", SyncResults.class);
            RESULT_CACHE_1_HANDLE = MethodHandles.lookup().findVarHandle(AsyncNodeManager.class, "resultCache1", SyncResults.class);
            RESULT_CACHE_2_HANDLE = MethodHandles.lookup().findVarHandle(AsyncNodeManager.class, "resultCache2", SyncResults.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class SyncResults {
        private int currentMaxNodeId;
        private final IntOpenHashSet tlnDelta = new IntOpenHashSet();
        private int geometrySectionCount;
        private long usedGeometry;
        private final ComputeMemoryCopy geometryUpload = new ComputeMemoryCopy();
        private MemoryBuffer scatterWriteBuffer = new MemoryBuffer(16384L);
        private final Int2IntOpenHashMap scatterWriteLocationMap = new Int2IntOpenHashMap(1024);
        private final IntOpenHashSet cleanerOperations;

        private SyncResults() {
            this.scatterWriteLocationMap.defaultReturnValue(-1);
            this.cleanerOperations = new IntOpenHashSet();
        }

        public void reset() {
            this.cleanerOperations.clear();
            this.scatterWriteLocationMap.clear();
            this.currentMaxNodeId = 0;
            this.tlnDelta.clear();
            this.geometrySectionCount = 0;
            this.usedGeometry = 0L;
            this.geometryUpload.reset();
        }

        public long getScatterWritePtr(int location) {
            return this.getScatterWritePtr(location, 0);
        }

        public long getScatterWritePtr(int location, int ensureExtra) {
            int loc = this.scatterWriteLocationMap.get(location);
            if (loc == -1) {
                this.ensureScatterBufferCapacity(1 + ensureExtra);
                int baseId = this.scatterWriteLocationMap.size();
                int chunkBase = baseId / 4 * 5;
                int innerId = baseId & 3;
                MemoryUtil.memPutInt((long)(this.scatterWriteBuffer.address + (long)chunkBase * 16L + (long)innerId * 4L), (int)location);
                int writeLocation = chunkBase + 1 + innerId;
                this.scatterWriteLocationMap.put(location, writeLocation);
                return this.scatterWriteBuffer.address + (long)writeLocation * 16L;
            }
            return this.scatterWriteBuffer.address + 16L * (long)loc;
        }

        private void ensureScatterBufferCapacity(int extra) {
            int requiredChunks = (this.scatterWriteLocationMap.size() + extra + 3) / 4;
            long requiredSize = (long)requiredChunks * 5L * 16L;
            if (this.scatterWriteBuffer.size <= requiredSize) {
                long newSize = (long)((double)this.scatterWriteBuffer.size * 1.5 + (double)((long)extra * 80L));
                newSize = (newSize + 79L) / 80L * 80L;
                Logger.info("Expanding scatter update buffer to " + newSize);
                MemoryBuffer newBuffer = new MemoryBuffer(newSize);
                this.scatterWriteBuffer.cpyTo(newBuffer.address);
                this.scatterWriteBuffer.free();
                this.scatterWriteBuffer = newBuffer;
            }
        }
    }

    private static class ComputeMemoryCopy {
        public int currentElemCopyAmount;
        public int maxElementAccess;
        private MemoryBuffer scratchHeaderBuffer = new MemoryBuffer(65536L);
        private MemoryBuffer scratchDataBuffer = new MemoryBuffer(0x100000L);
        private final AllocationArena arena = new AllocationArena();
        private final Int2IntOpenHashMap dataUploadPoints = new Int2IntOpenHashMap();

        private ComputeMemoryCopy() {
            this.dataUploadPoints.defaultReturnValue(-1);
        }

        public void remove(int point) {
            int header = this.dataUploadPoints.remove(point);
            if (header == -1) {
                return;
            }
            int size = MemoryUtil.memGetInt((long)(this.scratchHeaderBuffer.address + (long)header * 16L + 8L));
            this.currentElemCopyAmount -= size;
            if (this.arena.free(MemoryUtil.memGetInt((long)(this.scratchHeaderBuffer.address + (long)header * 16L))) != size) {
                throw new IllegalStateException("Freed memory not same size as expected");
            }
            if (MemoryUtil.memGetInt((long)(this.scratchHeaderBuffer.address + (long)header * 16L + 4L)) != point) {
                throw new IllegalStateException("Destination not the same as point");
            }
            if (header == this.dataUploadPoints.size()) {
                long A2 = this.scratchHeaderBuffer.address + (long)header * 16L;
                MemoryUtil.memPutLong((long)A2, (long)0L);
                MemoryUtil.memPutLong((long)(A2 + 8L), (long)0L);
                return;
            }
            int endingPoint = MemoryUtil.memGetInt((long)(this.scratchHeaderBuffer.address + (long)this.dataUploadPoints.size() * 16L + 4L));
            if (this.dataUploadPoints.get(endingPoint) != this.dataUploadPoints.size()) {
                throw new IllegalStateException("ending header not pointing at end point");
            }
            long A3 = this.scratchHeaderBuffer.address + (long)this.dataUploadPoints.size() * 16L;
            long B2 = this.scratchHeaderBuffer.address + (long)header * 16L;
            MemoryUtil.memPutLong((long)B2, (long)MemoryUtil.memGetLong((long)A3));
            MemoryUtil.memPutLong((long)A3, (long)0L);
            MemoryUtil.memPutLong((long)(B2 + 8L), (long)MemoryUtil.memGetLong((long)(A3 + 8L)));
            MemoryUtil.memPutLong((long)(A3 + 8L), (long)0L);
            this.dataUploadPoints.put(endingPoint, header);
        }

        public void upload(int point, MemoryBuffer data) {
            if (data.size % 8L != 0L) {
                throw new IllegalStateException("Data must be of size multiple 8");
            }
            int elemSize = (int)(data.size / 8L);
            this.maxElementAccess = Math.max(this.maxElementAccess, point + elemSize);
            int header = this.dataUploadPoints.get(point);
            if (header != -1) {
                long headerPtr = this.scratchHeaderBuffer.address + (long)header * 16L;
                if (MemoryUtil.memGetInt((long)(headerPtr + 4L)) != point) {
                    throw new IllegalStateException("Existing destination not the point");
                }
                int pSize = MemoryUtil.memGetInt((long)(headerPtr + 8L));
                if (pSize == elemSize) {
                    data.cpyTo(this.scratchDataBuffer.address + (long)MemoryUtil.memGetInt((long)headerPtr) * 8L);
                } else {
                    if (this.arena.free(MemoryUtil.memGetInt((long)headerPtr)) != pSize) {
                        throw new IllegalStateException("Freed allocation not size as expected");
                    }
                    this.currentElemCopyAmount -= pSize;
                    this.currentElemCopyAmount += elemSize;
                    int alloc = this.allocScratchDataPos(elemSize);
                    data.cpyTo(this.scratchDataBuffer.address + (long)alloc * 8L);
                    MemoryUtil.memPutInt((long)headerPtr, (int)alloc);
                    MemoryUtil.memPutInt((long)(headerPtr + 8L), (int)elemSize);
                }
            } else {
                header = this.dataUploadPoints.size();
                this.dataUploadPoints.put(point, header);
                if (this.scratchHeaderBuffer.size <= (long)header * 16L) {
                    long newSize = Math.max(this.scratchHeaderBuffer.size * 2L, (long)header * 16L);
                    Logger.info("Resizing scratch header buffer to: " + newSize);
                    MemoryBuffer newScratch = new MemoryBuffer(newSize);
                    this.scratchHeaderBuffer.cpyTo(newScratch.address);
                    this.scratchHeaderBuffer.free();
                    this.scratchHeaderBuffer = newScratch;
                }
                long headerPtr = this.scratchHeaderBuffer.address + (long)header * 16L;
                this.currentElemCopyAmount += elemSize;
                int alloc = this.allocScratchDataPos(elemSize);
                data.cpyTo(this.scratchDataBuffer.address + (long)alloc * 8L);
                MemoryUtil.memPutInt((long)headerPtr, (int)alloc);
                MemoryUtil.memPutInt((long)(headerPtr + 4L), (int)point);
                MemoryUtil.memPutInt((long)(headerPtr + 8L), (int)elemSize);
            }
        }

        private int allocScratchDataPos(int size) {
            int pos = (int)this.arena.alloc(size);
            if (this.scratchDataBuffer.size <= (long)(pos + size) * 8L) {
                long newSize = Math.max(this.scratchDataBuffer.size * 2L, (long)(pos + size) * 8L);
                Logger.info("Resizing scratch data buffer to: " + newSize);
                MemoryBuffer newScratch = new MemoryBuffer(newSize);
                this.scratchDataBuffer.cpyTo(newScratch.address);
                this.scratchDataBuffer.free();
                this.scratchDataBuffer = newScratch;
            }
            return pos;
        }

        public void reset() {
            this.maxElementAccess = 0;
            this.currentElemCopyAmount = 0;
            this.dataUploadPoints.clear();
            this.arena.reset();
        }

        public void free() {
            this.scratchHeaderBuffer.free();
            this.scratchHeaderBuffer = null;
            this.scratchDataBuffer.free();
            this.scratchDataBuffer = null;
        }
    }
}

