/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.building;

import java.util.Arrays;
import me.cortex.voxy.client.core.model.IdNotYetComputedException;
import me.cortex.voxy.client.core.model.ModelFactory;
import me.cortex.voxy.client.core.model.ModelQueries;
import me.cortex.voxy.client.core.rendering.building.BuiltSection;
import me.cortex.voxy.client.core.rendering.building.OccupancySet;
import me.cortex.voxy.client.core.util.ScanMesher2D;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldSection;
import me.cortex.voxy.common.world.other.Mapper;
import me.cortex.voxy.commonImpl.VoxyCommon;
import org.lwjgl.system.MemoryUtil;

public class RenderDataFactory {
    private static final boolean BUILD_OCCUPANCY_SET = false;
    private static final boolean CHECK_NEIGHBOR_FACE_OCCLUSION = true;
    private static final boolean DISABLE_CULL_SAME_OCCLUDES = false;
    private static final boolean VERIFY_MESHING = VoxyCommon.isVerificationFlagOn("verifyMeshing");
    private final WorldEngine world;
    private final ModelFactory modelMan;
    private final long[] sectionData = new long[65536];
    private final long[] neighboringFaces = new long[6144];
    private final int[] opaqueMasks = new int[1024];
    private final int[] nonOpaqueMasks = new int[1024];
    private final int[] fluidMasks = new int[1024];
    private final MemoryBuffer quadBuffer = new MemoryBuffer(0x400000L);
    private final long quadBufferPtr;
    private final int[] quadCounters;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int quadCount;
    private final OccupancySet occupancy;
    private final Mesher blockMesher;
    private final Mesher seondaryblockMesher;
    private static final long LM = 9187343239835811840L;
    private final Mesher[] xAxisMeshers;
    private final Mesher[] secondaryXAxisMeshers;
    private static final long X_I_MSK = 1162219258676257L;

    public RenderDataFactory(WorldEngine world, ModelFactory modelManager, boolean emitMeshlets) {
        Mesher mesher;
        int i;
        this.quadBufferPtr = this.quadBuffer.address;
        this.quadCounters = new int[8];
        this.quadCount = 0;
        this.occupancy = new OccupancySet();
        this.blockMesher = new Mesher();
        this.seondaryblockMesher = new Mesher();
        this.xAxisMeshers = new Mesher[32];
        this.secondaryXAxisMeshers = new Mesher[32];
        for (i = 0; i < 32; ++i) {
            mesher = new Mesher();
            mesher.auxiliaryPosition = i;
            mesher.axis = 2;
            this.xAxisMeshers[i] = mesher;
        }
        for (i = 0; i < 32; ++i) {
            mesher = new Mesher();
            mesher.auxiliaryPosition = i;
            mesher.axis = 2;
            mesher.doAuxiliaryFaceOffset = false;
            this.secondaryXAxisMeshers[i] = mesher;
        }
        this.world = world;
        this.modelMan = modelManager;
    }

    private static long getQuadTyping(long metadata) {
        int type = 0;
        boolean a = ModelQueries.isTranslucent(metadata);
        boolean b = ModelQueries.isDoubleSided(metadata);
        type = a ? 0 : (b ? 2 : 4);
        return type;
    }

    private static long packPartialQuadData(int modelId, long state, long metadata) {
        long lightAndBiome = (state & 0xFFFF800000000000L) >>> 1;
        lightAndBiome &= ModelQueries.isBiomeColoured(metadata) ? -1L : -35958428274786305L;
        long quadData = lightAndBiome &= ModelQueries.isFullyOpaque(metadata) ? -9187343239835811841L : -1L;
        quadData |= Integer.toUnsignedLong(modelId) << 26;
        return quadData |= RenderDataFactory.getQuadTyping(metadata);
    }

    private int prepareSectionData(long[] rawSectionData) {
        long[] sectionData = this.sectionData;
        int[] rawModelIds = this.modelMan._unsafeRawAccess();
        long opaque = 0L;
        long notEmpty = 0L;
        long pureFluid = 0L;
        long partialFluid = 0L;
        int neighborAcquireMskAndFlags = 0;
        int i = 0;
        while (i < 32768) {
            long block = rawSectionData[i];
            if (Mapper.isAir(block)) {
                sectionData[i * 2] = (block & 0xFF00000000000000L) >>> 1;
                sectionData[i * 2 + 1] = 0L;
            } else {
                int modelId = rawModelIds[Mapper.getBlockId(block)];
                if (modelId == -1) {
                    return Mapper.getBlockId(block) | Integer.MIN_VALUE;
                }
                long modelMetadata = this.modelMan.getModelMetadataFromClientId(modelId);
                sectionData[i * 2] = RenderDataFactory.packPartialQuadData(modelId, block, modelMetadata);
                sectionData[i * 2 + 1] = modelMetadata;
                long msk = 1L << (i & 0x3F);
                opaque |= ModelQueries.isFullyOpaque(modelMetadata) ? msk : 0L;
                notEmpty |= modelId != 0 ? msk : 0L;
                pureFluid |= ModelQueries.isFluid(modelMetadata) ? msk : 0L;
                partialFluid |= ModelQueries.containsFluid(modelMetadata) ? msk : 0L;
            }
            if ((++i & 0x3F) != 0 || notEmpty == 0L) continue;
            long nonOpaque = (notEmpty ^ opaque) & (pureFluid ^ 0xFFFFFFFFFFFFFFFFL);
            long fluid = pureFluid | partialFluid;
            this.opaqueMasks[(i >> 5) - 2] = (int)opaque;
            this.opaqueMasks[(i >> 5) - 1] = (int)(opaque >>> 32);
            this.nonOpaqueMasks[(i >> 5) - 2] = (int)nonOpaque;
            this.nonOpaqueMasks[(i >> 5) - 1] = (int)(nonOpaque >>> 32);
            this.fluidMasks[(i >> 5) - 2] = (int)fluid;
            this.fluidMasks[(i >> 5) - 1] = (int)(fluid >>> 32);
            int packedEmpty = (int)(notEmpty >>> 32 | notEmpty);
            int neighborMsk = 0;
            neighborMsk += packedEmpty & 1;
            neighborMsk += packedEmpty >>> 30 & 2;
            neighborMsk += (i - 1 >> 10 == 0 ? 4 : 0) * (packedEmpty != 0 ? 1 : 0);
            neighborMsk += (i - 1 >> 10 == 31 ? 8 : 0) * (packedEmpty != 0 ? 1 : 0);
            neighborMsk += ((i - 33 >> 5 & 0x1F) == 0 ? 16 : 0) * ((int)notEmpty != 0 ? 1 : 0);
            neighborAcquireMskAndFlags |= (neighborMsk += ((i - 1 >> 5 & 0x1F) == 31 ? 32 : 0) * (notEmpty >>> 32 != 0L ? 1 : 0));
            neighborAcquireMskAndFlags |= opaque != 0L ? 64 : 0;
            opaque = 0L;
            notEmpty = 0L;
            pureFluid = 0L;
            partialFluid = 0L;
        }
        return neighborAcquireMskAndFlags;
    }

    private void acquireNeighborData(WorldSection section, int msk) {
        int i;
        long[] raw;
        WorldSection sec;
        if ((msk & 1) != 0) {
            sec = this.world.acquire(section.lvl, section.x - 1, section.y, section.z);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i] = raw[(i << 5) + 31];
            }
            sec.release();
        }
        if ((msk & 2) != 0) {
            sec = this.world.acquire(section.lvl, section.x + 1, section.y, section.z);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i + 1024] = raw[i << 5];
            }
            sec.release();
        }
        if ((msk & 4) != 0) {
            sec = this.world.acquire(section.lvl, section.x, section.y - 1, section.z);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i + 2048] = raw[i | 0x7C00];
            }
            sec.release();
        }
        if ((msk & 8) != 0) {
            sec = this.world.acquire(section.lvl, section.x, section.y + 1, section.z);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i + 3072] = raw[i];
            }
            sec.release();
        }
        if ((msk & 0x10) != 0) {
            sec = this.world.acquire(section.lvl, section.x, section.y, section.z - 1);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i + 4096] = raw[Integer.expand(i, 31775) | 0x3E0];
            }
            sec.release();
        }
        if ((msk & 0x20) != 0) {
            sec = this.world.acquire(section.lvl, section.x, section.y, section.z + 1);
            raw = sec._unsafeGetRawDataArray();
            for (i = 0; i < 1024; ++i) {
                this.neighboringFaces[i + 5120] = raw[Integer.expand(i, 31775)];
            }
            sec.release();
        }
    }

    private static boolean shouldMeshNonOpaqueBlockFace(int face, long quad, long meta, long neighborQuad, long neighborMeta) {
        if (((quad ^ neighborQuad) & 0x3FFFC000000L) == 0L && (ModelQueries.cullsSame(meta) || ModelQueries.faceOccludes(meta, face))) {
            return false;
        }
        if (!ModelQueries.faceExists(meta, face)) {
            return false;
        }
        return !ModelQueries.faceCanBeOccluded(meta, face) || !ModelQueries.faceOccludes(neighborMeta, face ^ 1);
    }

    private static void meshNonOpaqueFace(int face, long quad, long meta, long neighborQuad, long neighborMeta, Mesher mesher) {
        if (RenderDataFactory.shouldMeshNonOpaqueBlockFace(face, quad, meta, neighborQuad, neighborMeta)) {
            mesher.putNext((long)(face & 1) | quad & 0x807FFFFFFFFFFFFFL | (ModelQueries.faceUsesSelfLighting(meta, face) ? quad : neighborQuad) & 0x7F80000000000000L);
        } else {
            mesher.skip(1);
        }
    }

    private void generateYZOpaqueInnerGeometry(int axis) {
        for (int layer = 0; layer < 31; ++layer) {
            this.blockMesher.auxiliaryPosition = layer;
            int cSkip = 0;
            for (int other = 0; other < 32; ++other) {
                int skipAmount;
                int next;
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int current = this.opaqueMasks[pidx];
                int msk = current ^ (next = this.opaqueMasks[pidx + (skipAmount = axis == 0 ? 32 : 1)]);
                if (msk == 0) {
                    cSkip += 32;
                    continue;
                }
                this.blockMesher.skip(cSkip);
                cSkip = 0;
                int faceForwardMsk = msk & current;
                int cIdx = -1;
                while (msk != 0) {
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int facingForward = faceForwardMsk >> index & 1;
                    int idx = index + pidx * 32;
                    int shift = skipAmount * 32 * 2;
                    int iA = idx * 2 + (facingForward == 1 ? 0 : shift);
                    int iB = idx * 2 + (facingForward == 1 ? shift : 0);
                    long selfModel = this.sectionData[iA];
                    long nextModel = this.sectionData[iB];
                    long neighbor = this.sectionData[iB + 1];
                    boolean culls = false;
                    culls |= ((selfModel ^ nextModel) & 0x3FFFC000000L) == 0L && ModelQueries.cullsSame(neighbor);
                    if (culls |= ModelQueries.faceOccludes(neighbor, axis << 1 | 1 - facingForward)) {
                        this.blockMesher.skip(1);
                        continue;
                    }
                    this.blockMesher.putNext((long)facingForward | selfModel & 0x807FFFFFFFFFFFFFL | nextModel & 0x7F80000000000000L);
                }
                this.blockMesher.endRow();
            }
            this.blockMesher.finish();
        }
    }

    private void generateYZOpaqueOuterGeometry(int axis) {
        this.blockMesher.doAuxiliaryFaceOffset = false;
        for (int side = 0; side < 2; ++side) {
            int layer;
            this.blockMesher.auxiliaryPosition = layer = side == 0 ? 0 : 31;
            int cSkips = 0;
            for (int other = 0; other < 32; ++other) {
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int msk = this.opaqueMasks[pidx];
                if (msk == 0) {
                    cSkips += 32;
                    continue;
                }
                this.blockMesher.skip(cSkips);
                cSkips = 0;
                int cIdx = -1;
                while (msk != 0) {
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int idx = index + pidx * 32;
                    int neighborIdx = (axis + 1) * 32 * 32 * 2 + side * 32 * 32;
                    long neighborId = this.neighboringFaces[neighborIdx + other * 32 + index];
                    long A2 = this.sectionData[idx * 2];
                    int nib = Mapper.getBlockId(neighborId);
                    if (nib != 0) {
                        int cid = this.modelMan.getModelId(nib);
                        long meta = this.modelMan.getModelMetadataFromClientId(cid);
                        if (ModelQueries.isFullyOpaque(meta)) {
                            this.blockMesher.skip(1);
                            continue;
                        }
                        boolean culls = false;
                        culls |= (long)cid == (A2 >> 26 & 0xFFFFL) && ModelQueries.cullsSame(meta);
                        if (culls |= ModelQueries.faceOccludes(meta, axis << 1 | 1 - side)) {
                            this.blockMesher.skip(1);
                            continue;
                        }
                    }
                    this.blockMesher.putNext((side == 0 ? 0L : 1L) | A2 & 0x807FFFFFFFFFFFFFL | (neighborId & 0xFF00000000000000L) >>> 1);
                }
                this.blockMesher.endRow();
            }
            this.blockMesher.finish();
        }
        this.blockMesher.doAuxiliaryFaceOffset = true;
    }

    private void generateYZFluidInnerGeometry(int axis) {
        for (int layer = 0; layer < 31; ++layer) {
            this.blockMesher.auxiliaryPosition = layer;
            int cSkip = 0;
            for (int other = 0; other < 32; ++other) {
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int skipAmount = axis == 0 ? 32 : 1;
                int current = this.fluidMasks[pidx];
                int next = this.fluidMasks[pidx + skipAmount];
                int msk = (current | this.opaqueMasks[pidx]) ^ (next | this.opaqueMasks[pidx + skipAmount]);
                if ((msk &= current | next) == 0) {
                    cSkip += 32;
                    continue;
                }
                this.blockMesher.skip(cSkip);
                cSkip = 0;
                int faceForwardMsk = msk & current;
                int cIdx = -1;
                while (msk != 0) {
                    int bi;
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int facingForward = faceForwardMsk >> index & 1;
                    int idx = index + pidx * 32;
                    int a = idx * 2;
                    int b = (idx + skipAmount * 32) * 2;
                    int ai = facingForward == 1 ? a : b;
                    int n = bi = facingForward == 1 ? b : a;
                    if (ModelQueries.faceOccludes(this.sectionData[bi + 1], axis << 1 | 1 - facingForward)) {
                        this.blockMesher.skip(1);
                        continue;
                    }
                    long A2 = this.sectionData[ai];
                    long Am = this.sectionData[ai + 1];
                    if (ModelQueries.containsFluid(Am)) {
                        int modelId = (int)(A2 >> 26 & 0xFFFFL);
                        A2 &= 0xFFFFFC0003FFFFFFL;
                        int fluidId = this.modelMan.getFluidClientStateId(modelId);
                        A2 |= Integer.toUnsignedLong(fluidId) << 26;
                        Am = this.modelMan.getModelMetadataFromClientId(fluidId);
                        A2 &= 0xFFFFFFFFFFFFFFF9L;
                        A2 |= RenderDataFactory.getQuadTyping(Am);
                    }
                    long lighter = this.sectionData[bi];
                    this.blockMesher.putNext((long)facingForward | A2 & 0x807FFFFFFFFFFFFFL | lighter & 0x7F80000000000000L);
                }
                this.blockMesher.endRow();
            }
            this.blockMesher.finish();
        }
    }

    private void generateYZFluidOuterGeometry(int axis) {
        this.blockMesher.doAuxiliaryFaceOffset = false;
        for (int side = 0; side < 2; ++side) {
            int layer;
            this.blockMesher.auxiliaryPosition = layer = side == 0 ? 0 : 31;
            int cSkips = 0;
            for (int other = 0; other < 32; ++other) {
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int msk = this.fluidMasks[pidx];
                if (msk == 0) {
                    cSkips += 32;
                    continue;
                }
                this.blockMesher.skip(cSkips);
                cSkips = 0;
                int cIdx = -1;
                while (msk != 0) {
                    int modelId;
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int idx = index + pidx * 32;
                    int neighborIdx = (axis + 1) * 32 * 32 * 2 + side * 32 * 32;
                    long neighborId = this.neighboringFaces[neighborIdx + other * 32 + index];
                    long A2 = this.sectionData[idx * 2];
                    long B2 = this.sectionData[idx * 2 + 1];
                    if (ModelQueries.containsFluid(B2)) {
                        modelId = (int)(A2 >> 26 & 0xFFFFL);
                        A2 &= 0xFFFFFC0003FFFFFFL;
                        int fluidId = this.modelMan.getFluidClientStateId(modelId);
                        A2 |= Integer.toUnsignedLong(fluidId) << 26;
                        B2 = this.modelMan.getModelMetadataFromClientId(fluidId);
                        A2 &= 0xFFFFFFFFFFFFFFF9L;
                        A2 |= RenderDataFactory.getQuadTyping(B2);
                    }
                    if (Mapper.getBlockId(neighborId) != 0) {
                        modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        long meta = this.modelMan.getModelMetadataFromClientId(modelId);
                        if (ModelQueries.containsFluid(meta)) {
                            modelId = this.modelMan.getFluidClientStateId(modelId);
                        }
                        if (ModelQueries.cullsSame(B2) && (long)modelId == (A2 >> 26 & 0xFFFFL)) {
                            this.blockMesher.skip(1);
                            continue;
                        }
                        if (ModelQueries.faceOccludes(meta, axis << 1 | 1 - side)) {
                            this.blockMesher.skip(1);
                            continue;
                        }
                    }
                    this.blockMesher.putNext((side == 0 ? 0L : 1L) | A2 & 0x807FFFFFFFFFFFFFL | (neighborId & 0xFF00000000000000L) >>> 1);
                }
                this.blockMesher.endRow();
            }
            this.blockMesher.finish();
        }
        this.blockMesher.doAuxiliaryFaceOffset = true;
    }

    private void generateYZNonOpaqueInnerGeometry(int axis) {
        this.seondaryblockMesher.doAuxiliaryFaceOffset = false;
        this.blockMesher.axis = axis;
        this.seondaryblockMesher.axis = axis;
        for (int layer = 1; layer < 31; ++layer) {
            this.blockMesher.auxiliaryPosition = layer;
            this.seondaryblockMesher.auxiliaryPosition = layer;
            int cSkip = 0;
            for (int other = 0; other < 32; ++other) {
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int skipAmount = axis == 0 ? 1024 : 32;
                int msk = this.nonOpaqueMasks[pidx];
                if (msk == 0) {
                    cSkip += 32;
                    continue;
                }
                this.blockMesher.skip(cSkip);
                this.seondaryblockMesher.skip(cSkip);
                cSkip = 0;
                int cIdx = -1;
                while (msk != 0) {
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                        this.seondaryblockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int idx = index + pidx * 32;
                    long A2 = this.sectionData[idx * 2];
                    long B2 = this.sectionData[idx * 2 + 1];
                    RenderDataFactory.meshNonOpaqueFace(axis << 1 | 0, A2, B2, this.sectionData[(idx - skipAmount) * 2], this.sectionData[(idx - skipAmount) * 2 + 1], this.seondaryblockMesher);
                    RenderDataFactory.meshNonOpaqueFace(axis << 1 | 1, A2, B2, this.sectionData[(idx + skipAmount) * 2], this.sectionData[(idx + skipAmount) * 2 + 1], this.blockMesher);
                }
                this.blockMesher.endRow();
                this.seondaryblockMesher.endRow();
            }
            this.blockMesher.finish();
            this.seondaryblockMesher.finish();
        }
    }

    private void generateYZNonOpaqueOuterGeometry(int axis) {
        this.seondaryblockMesher.doAuxiliaryFaceOffset = false;
        this.blockMesher.axis = axis;
        this.seondaryblockMesher.axis = axis;
        for (int side = 0; side < 2; ++side) {
            int layer = side == 0 ? 0 : 31;
            int skipAmount = (axis == 0 ? 1024 : 32) * (1 - side * 2);
            this.blockMesher.auxiliaryPosition = layer;
            this.seondaryblockMesher.auxiliaryPosition = layer;
            int cSkips = 0;
            for (int other = 0; other < 32; ++other) {
                int pidx = axis == 0 ? layer * 32 + other : other * 32 + layer;
                int msk = this.nonOpaqueMasks[pidx];
                if (msk == 0) {
                    cSkips += 32;
                    continue;
                }
                this.blockMesher.skip(cSkips);
                this.seondaryblockMesher.skip(cSkips);
                cSkips = 0;
                int cIdx = -1;
                while (msk != 0) {
                    int index = Integer.numberOfTrailingZeros(msk);
                    int delta = index - cIdx - 1;
                    cIdx = index;
                    if (delta != 0) {
                        this.blockMesher.skip(delta);
                        this.seondaryblockMesher.skip(delta);
                    }
                    msk &= ~Integer.lowestOneBit(msk);
                    int idx = index + pidx * 32;
                    int neighborIdx = (axis + 1) * 32 * 32 * 2 + side * 32 * 32;
                    long neighborId = this.neighboringFaces[neighborIdx + other * 32 + index];
                    long A2 = this.sectionData[idx * 2];
                    long B2 = this.sectionData[idx * 2 + 1];
                    boolean fail = false;
                    if (Mapper.getBlockId(neighborId) != 0) {
                        int modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        if (ModelQueries.cullsSame(B2) && (long)modelId == (A2 >> 26 & 0xFFFFL)) {
                            fail = true;
                        } else {
                            long meta = this.modelMan.getModelMetadataFromClientId(modelId);
                            if (ModelQueries.faceOccludes(meta, axis << 1 | 1 - side)) {
                                fail = true;
                            }
                        }
                    }
                    long nA = this.sectionData[(idx + skipAmount) * 2];
                    long nB = this.sectionData[(idx + skipAmount) * 2 + 1];
                    boolean failB = false;
                    if (ModelQueries.cullsSame(nB) && (nA & 0x3FFFC000000L) == (A2 & 0x3FFFC000000L)) {
                        failB = true;
                    } else if (ModelQueries.faceOccludes(nB, axis << 1 | side)) {
                        failB = true;
                    }
                    if (ModelQueries.faceExists(B2, axis << 1 | 1) && (side == 1 && !fail || side == 0 && !failB)) {
                        this.blockMesher.putNext(1L | A2 | 0L);
                    } else {
                        this.blockMesher.skip(1);
                    }
                    if (ModelQueries.faceExists(B2, axis << 1 | 0) && (side == 0 && !fail || side == 1 && !failB)) {
                        this.seondaryblockMesher.putNext(0L | A2 | 0L);
                        continue;
                    }
                    this.seondaryblockMesher.skip(1);
                }
                this.blockMesher.endRow();
                this.seondaryblockMesher.endRow();
            }
            this.blockMesher.finish();
            this.seondaryblockMesher.finish();
        }
    }

    private void generateYZFaces() {
        for (int axis = 0; axis < 2; ++axis) {
            this.blockMesher.axis = axis;
            this.generateYZOpaqueInnerGeometry(axis);
            this.generateYZOpaqueOuterGeometry(axis);
            this.generateYZFluidInnerGeometry(axis);
            this.generateYZFluidOuterGeometry(axis);
            this.generateYZNonOpaqueInnerGeometry(axis);
            this.generateYZNonOpaqueOuterGeometry(axis);
        }
    }

    private void generateXOpaqueInnerGeometry() {
        for (int y = 0; y < 32; ++y) {
            long sumA = 0L;
            long sumB = 0L;
            long sumC = 0L;
            int partialHasCount = -1;
            int msk = 0;
            for (int z = 0; z < 32; ++z) {
                int lMsk = this.opaqueMasks[y * 32 + z];
                msk = lMsk ^ lMsk >>> 1;
                sumA += 1162219258676257L;
                sumB += 1162219258676257L;
                sumC += 1162219258676257L;
                if (z == 30 && (partialHasCount &= ~(msk &= Integer.MAX_VALUE)) != 0) {
                    for (int cmsk = partialHasCount; cmsk != 0; cmsk &= ~Integer.lowestOneBit(cmsk)) {
                        int index = Integer.numberOfTrailingZeros(cmsk);
                        this.xAxisMeshers[index].skip(31);
                    }
                    sumA &= Long.expand(Integer.toUnsignedLong(partialHasCount), 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumB &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 11, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumC &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 22, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (msk == 0) continue;
                int faceForwardMsk = msk & lMsk;
                int iter = msk;
                while (iter != 0) {
                    int skipCount;
                    int index = Integer.numberOfTrailingZeros(iter);
                    iter &= ~Integer.lowestOneBit(iter);
                    Mesher mesher = this.xAxisMeshers[index];
                    if (index < 11) {
                        skipCount = (int)(sumA >> index * 5);
                        sumA &= 31L << index * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else if (index < 22) {
                        skipCount = (int)(sumB >> (index - 11) * 5);
                        sumB &= 31L << (index - 11) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else {
                        skipCount = (int)(sumC >> (index - 22) * 5);
                        sumC &= 31L << (index - 22) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    skipCount &= 0x1F;
                    if (--skipCount != 0) {
                        mesher.skip(skipCount);
                    }
                    int facingForward = faceForwardMsk >> index & 1;
                    int idx = index + z * 32 + y * 32 * 32;
                    int iA = idx * 2 + (facingForward == 1 ? 0 : 2);
                    int iB = idx * 2 + (facingForward == 1 ? 2 : 0);
                    if (ModelQueries.faceOccludes(this.sectionData[iB + 1], 4 | 1 - facingForward)) {
                        mesher.skip(1);
                        continue;
                    }
                    long selfModel = this.sectionData[iA];
                    long nextModel = this.sectionData[iB];
                    mesher.putNext((long)facingForward | selfModel & 0x807FFFFFFFFFFFFFL | nextModel & 0x7F80000000000000L);
                }
            }
            msk ^= 0xFFFFFFFF;
            while (msk != 0) {
                int index = Integer.numberOfTrailingZeros(msk);
                msk &= ~Integer.lowestOneBit(msk);
                int skipCount = index < 11 ? (int)(sumA >> index * 5) : (index < 22 ? (int)(sumB >> (index - 11) * 5) : (int)(sumC >> (index - 22) * 5));
                if ((skipCount &= 0x1F) == 0) continue;
                this.xAxisMeshers[index].skip(skipCount);
            }
        }
    }

    private void generateXOuterOpaqueGeometry() {
        Mesher ma = this.xAxisMeshers[0];
        Mesher mb = this.xAxisMeshers[31];
        ma.finish();
        mb.finish();
        ma.doAuxiliaryFaceOffset = false;
        mb.doAuxiliaryFaceOffset = false;
        for (int y = 0; y < 32; ++y) {
            int skipA = 0;
            int skipB = 0;
            for (int z = 0; z < 32; ++z) {
                long A2;
                long meta;
                boolean oki;
                long neighborId;
                int i = y * 32 + z;
                int msk = this.opaqueMasks[i];
                if ((msk & 1) != 0) {
                    neighborId = this.neighboringFaces[i];
                    oki = true;
                    if (Mapper.getBlockId(neighborId) != 0) {
                        meta = this.modelMan.getModelMetadataFromClientId(this.modelMan.getModelId(Mapper.getBlockId(neighborId)));
                        if (ModelQueries.isFullyOpaque(meta)) {
                            oki = false;
                        } else if (ModelQueries.faceOccludes(meta, 4)) {
                            oki = false;
                        }
                    }
                    if (oki) {
                        ma.skip(skipA);
                        skipA = 0;
                        A2 = this.sectionData[(i << 5) * 2];
                        ma.putNext(0L | A2 & 0x807FFFFFFFFFFFFFL | (neighborId & 0xFF00000000000000L) >>> 1);
                    } else {
                        ++skipA;
                    }
                } else {
                    ++skipA;
                }
                if ((msk & Integer.MIN_VALUE) != 0) {
                    neighborId = this.neighboringFaces[i + 1024];
                    oki = true;
                    if (Mapper.getBlockId(neighborId) != 0) {
                        meta = this.modelMan.getModelMetadataFromClientId(this.modelMan.getModelId(Mapper.getBlockId(neighborId)));
                        if (ModelQueries.isFullyOpaque(meta)) {
                            oki = false;
                        } else if (ModelQueries.faceOccludes(meta, 5)) {
                            oki = false;
                        }
                    }
                    if (oki) {
                        mb.skip(skipB);
                        skipB = 0;
                        A2 = this.sectionData[(i * 32 + 31) * 2];
                        mb.putNext(1L | A2 & 0x807FFFFFFFFFFFFFL | (neighborId & 0xFF00000000000000L) >>> 1);
                        continue;
                    }
                    ++skipB;
                    continue;
                }
                ++skipB;
            }
            ma.skip(skipA);
            mb.skip(skipB);
        }
        ma.finish();
        mb.finish();
        ma.doAuxiliaryFaceOffset = true;
        mb.doAuxiliaryFaceOffset = true;
    }

    private void generateXInnerFluidGeometry() {
        for (int y = 0; y < 32; ++y) {
            long sumA = 0L;
            long sumB = 0L;
            long sumC = 0L;
            int partialHasCount = -1;
            int msk = 0;
            for (int z = 0; z < 32; ++z) {
                int oMsk = this.opaqueMasks[y * 32 + z];
                int fMsk = this.fluidMasks[y * 32 + z];
                int lMsk = oMsk | fMsk;
                msk = lMsk ^ lMsk >>> 1;
                msk &= Integer.MAX_VALUE;
                sumA += 1162219258676257L;
                sumB += 1162219258676257L;
                sumC += 1162219258676257L;
                if (z == 30 && (partialHasCount &= ~(msk &= fMsk | fMsk >> 1)) != 0) {
                    for (int cmsk = partialHasCount; cmsk != 0; cmsk &= ~Integer.lowestOneBit(cmsk)) {
                        int index = Integer.numberOfTrailingZeros(cmsk);
                        this.xAxisMeshers[index].skip(31);
                    }
                    sumA &= Long.expand(Integer.toUnsignedLong(partialHasCount), 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumB &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 11, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumC &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 22, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (msk == 0) continue;
                int faceForwardMsk = msk & lMsk;
                int iter = msk;
                while (iter != 0) {
                    int skipCount;
                    int index = Integer.numberOfTrailingZeros(iter);
                    iter &= ~Integer.lowestOneBit(iter);
                    Mesher mesher = this.xAxisMeshers[index];
                    if (index < 11) {
                        skipCount = (int)(sumA >> index * 5);
                        sumA &= 31L << index * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else if (index < 22) {
                        skipCount = (int)(sumB >> (index - 11) * 5);
                        sumB &= 31L << (index - 11) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else {
                        skipCount = (int)(sumC >> (index - 22) * 5);
                        sumC &= 31L << (index - 22) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    skipCount &= 0x1F;
                    if (--skipCount != 0) {
                        mesher.skip(skipCount);
                    }
                    int facingForward = faceForwardMsk >> index & 1;
                    int idx = index + z * 32 + y * 32 * 32;
                    int ai = (idx + (1 - facingForward)) * 2;
                    int bi = (idx + facingForward) * 2;
                    if (ModelQueries.faceOccludes(this.sectionData[bi + 1], 4 | 1 - facingForward)) {
                        mesher.skip(1);
                        continue;
                    }
                    long A2 = this.sectionData[ai];
                    long Am = this.sectionData[ai + 1];
                    if (ModelQueries.containsFluid(Am)) {
                        int modelId = (int)(A2 >> 26 & 0xFFFFL);
                        A2 &= 0xFFFFFC0003FFFFFFL;
                        int fluidId = this.modelMan.getFluidClientStateId(modelId);
                        A2 |= Integer.toUnsignedLong(fluidId) << 26;
                        Am = this.modelMan.getModelMetadataFromClientId(fluidId);
                        A2 &= 0xFFFFFFFFFFFFFFF9L;
                        A2 |= RenderDataFactory.getQuadTyping(Am);
                    }
                    long lighter = this.sectionData[bi];
                    mesher.putNext((long)facingForward | A2 & 0x807FFFFFFFFFFFFFL | lighter & 0x7F80000000000000L);
                }
            }
            msk ^= 0xFFFFFFFF;
            while (msk != 0) {
                int index = Integer.numberOfTrailingZeros(msk);
                msk &= ~Integer.lowestOneBit(msk);
                int skipCount = index < 11 ? (int)(sumA >> index * 5) : (index < 22 ? (int)(sumB >> (index - 11) * 5) : (int)(sumC >> (index - 22) * 5));
                if ((skipCount &= 0x1F) == 0) continue;
                this.xAxisMeshers[index].skip(skipCount);
            }
        }
    }

    private void generateXOuterFluidGeometry() {
        Mesher ma = this.xAxisMeshers[0];
        Mesher mb = this.xAxisMeshers[31];
        ma.finish();
        mb.finish();
        ma.doAuxiliaryFaceOffset = false;
        mb.doAuxiliaryFaceOffset = false;
        for (int y = 0; y < 32; ++y) {
            int skipA = 0;
            int skipB = 0;
            for (int z = 0; z < 32; ++z) {
                int fluidId;
                long Am;
                long A2;
                int sidx;
                boolean oki;
                long neighborId;
                int i = y * 32 + z;
                int msk = this.fluidMasks[i];
                if ((msk & 1) != 0) {
                    int modelId;
                    neighborId = this.neighboringFaces[i];
                    oki = true;
                    sidx = (i << 5) * 2;
                    A2 = this.sectionData[sidx];
                    Am = this.sectionData[sidx + 1];
                    if (ModelQueries.containsFluid(Am)) {
                        modelId = (int)(A2 >> 26 & 0xFFFFL);
                        A2 &= 0xFFFFFC0003FFFFFFL;
                        fluidId = this.modelMan.getFluidClientStateId(modelId);
                        A2 |= Integer.toUnsignedLong(fluidId) << 26;
                        Am = this.modelMan.getModelMetadataFromClientId(fluidId);
                        A2 &= 0xFFFFFFFFFFFFFFF9L;
                        A2 |= RenderDataFactory.getQuadTyping(Am);
                    }
                    if (Mapper.getBlockId(neighborId) != 0) {
                        modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        long meta = this.modelMan.getModelMetadataFromClientId(modelId);
                        if (ModelQueries.isFullyOpaque(meta)) {
                            oki = false;
                        }
                        if (ModelQueries.faceOccludes(meta, 5)) {
                            oki = false;
                        }
                        if (ModelQueries.containsFluid(meta)) {
                            modelId = this.modelMan.getFluidClientStateId(modelId);
                        }
                        if (ModelQueries.cullsSame(Am) && (long)modelId == (A2 >> 26 & 0xFFFFL)) {
                            oki = false;
                        }
                    }
                    if (oki) {
                        ma.skip(skipA);
                        skipA = 0;
                        long lightData = (neighborId & 0xFF00000000000000L) >>> 1;
                        ma.putNext(0L | A2 & 0x807FFFFFFFFFFFFFL | lightData);
                    } else {
                        ++skipA;
                    }
                } else {
                    ++skipA;
                }
                if ((msk & Integer.MIN_VALUE) != 0) {
                    neighborId = this.neighboringFaces[i + 1024];
                    oki = true;
                    sidx = (i * 32 + 31) * 2;
                    A2 = this.sectionData[sidx];
                    Am = this.sectionData[sidx + 1];
                    if (ModelQueries.containsFluid(Am)) {
                        int modelId = (int)(A2 >> 26 & 0xFFFFL);
                        A2 &= 0xFFFFFC0003FFFFFFL;
                        fluidId = this.modelMan.getFluidClientStateId(modelId);
                        A2 |= Integer.toUnsignedLong(fluidId) << 26;
                        Am = this.modelMan.getModelMetadataFromClientId(fluidId);
                    }
                    if (Mapper.getBlockId(neighborId) != 0) {
                        int modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        long meta = this.modelMan.getModelMetadataFromClientId(modelId);
                        if (ModelQueries.isFullyOpaque(meta)) {
                            oki = false;
                        }
                        if (ModelQueries.faceOccludes(meta, 4)) {
                            oki = false;
                        }
                        if (ModelQueries.containsFluid(meta)) {
                            modelId = this.modelMan.getFluidClientStateId(modelId);
                        }
                        if (ModelQueries.cullsSame(Am) && (long)modelId == (A2 >> 26 & 0xFFFFL)) {
                            oki = false;
                        }
                    }
                    if (oki) {
                        mb.skip(skipB);
                        skipB = 0;
                        long lightData = (neighborId & 0xFF00000000000000L) >>> 1;
                        mb.putNext(1L | A2 & 0x807FFFFFFFFFFFFFL | lightData);
                        continue;
                    }
                    ++skipB;
                    continue;
                }
                ++skipB;
            }
            ma.skip(skipA);
            mb.skip(skipB);
        }
        ma.finish();
        mb.finish();
        ma.doAuxiliaryFaceOffset = true;
        mb.doAuxiliaryFaceOffset = true;
    }

    private void generateXNonOpaqueInnerGeometry() {
        for (int y = 0; y < 32; ++y) {
            long sumA = 0L;
            long sumB = 0L;
            long sumC = 0L;
            int partialHasCount = -1;
            int msk = 0;
            for (int z = 0; z < 32; ++z) {
                int index;
                msk = this.nonOpaqueMasks[y * 32 + z] & 0x7FFFFFFE;
                sumA += 1162219258676257L;
                sumB += 1162219258676257L;
                sumC += 1162219258676257L;
                if (z == 30 && (partialHasCount &= ~msk) != 0) {
                    for (int cmsk = partialHasCount; cmsk != 0; cmsk &= ~Integer.lowestOneBit(cmsk)) {
                        index = Integer.numberOfTrailingZeros(cmsk);
                        this.xAxisMeshers[index].skip(31);
                        this.secondaryXAxisMeshers[index].skip(31);
                    }
                    sumA &= Long.expand(Integer.toUnsignedLong(partialHasCount), 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumB &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 11, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                    sumC &= Long.expand(Integer.toUnsignedLong(partialHasCount) >> 22, 1162219258676257L) * 31L ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (msk == 0) continue;
                int iter = msk;
                while (iter != 0) {
                    int skipCount;
                    index = Integer.numberOfTrailingZeros(iter);
                    iter &= ~Integer.lowestOneBit(iter);
                    if (index < 11) {
                        skipCount = (int)(sumA >> index * 5);
                        sumA &= 31L << index * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else if (index < 22) {
                        skipCount = (int)(sumB >> (index - 11) * 5);
                        sumB &= 31L << (index - 11) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    } else {
                        skipCount = (int)(sumC >> (index - 22) * 5);
                        sumC &= 31L << (index - 22) * 5 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    skipCount &= 0x1F;
                    Mesher mesherA = this.xAxisMeshers[index];
                    Mesher mesherB = this.secondaryXAxisMeshers[index];
                    if (--skipCount != 0) {
                        mesherA.skip(skipCount);
                        mesherB.skip(skipCount);
                    }
                    int idx = index + z * 32 + y * 32 * 32;
                    long A2 = this.sectionData[idx * 2];
                    long Am = this.sectionData[idx * 2 + 1];
                    RenderDataFactory.meshNonOpaqueFace(4, A2, Am, this.sectionData[(idx - 1) * 2], this.sectionData[(idx - 1) * 2 + 1], mesherB);
                    RenderDataFactory.meshNonOpaqueFace(5, A2, Am, this.sectionData[(idx + 1) * 2], this.sectionData[(idx + 1) * 2 + 1], mesherA);
                }
            }
            msk ^= 0xFFFFFFFF;
            while (msk != 0) {
                int index = Integer.numberOfTrailingZeros(msk);
                msk &= ~Integer.lowestOneBit(msk);
                int skipCount = index < 11 ? (int)(sumA >> index * 5) : (index < 22 ? (int)(sumB >> (index - 11) * 5) : (int)(sumC >> (index - 22) * 5));
                if ((skipCount &= 0x1F) == 0) continue;
                this.xAxisMeshers[index].skip(skipCount);
                this.secondaryXAxisMeshers[index].skip(skipCount);
            }
        }
    }

    private static void dualMeshNonOpaqueOuterX(int side, long quad, long meta, int neighborAId, int neighborLight, long neighborAMeta, long neighborBQuad, long neighborBMeta, Mesher ma, Mesher mb) {
        if (neighborAId == 0 && ModelQueries.faceExists(meta, 4 ^ side) || neighborAId != 0 && RenderDataFactory.shouldMeshNonOpaqueBlockFace(4 ^ side, quad, meta, (long)neighborAId << 26, neighborAMeta)) {
            ma.putNext((long)side | quad & 0x807FFFFFFFFFFFFFL | (ModelQueries.faceUsesSelfLighting(meta, 4 ^ side) ? quad : (long)neighborLight << 55));
        } else {
            ma.skip(1);
        }
        if (RenderDataFactory.shouldMeshNonOpaqueBlockFace(5 ^ side, quad, meta, neighborBQuad, neighborBMeta)) {
            mb.putNext((long)(side ^ 1) | quad & 0x807FFFFFFFFFFFFFL | (ModelQueries.faceUsesSelfLighting(meta, 5 ^ side) ? quad : neighborBQuad) & 0x7F80000000000000L);
        } else {
            mb.skip(1);
        }
    }

    private void generateXNonOpaqueOuterGeometry() {
        Mesher npx = this.xAxisMeshers[0];
        npx.finish();
        Mesher nnx = this.secondaryXAxisMeshers[0];
        nnx.finish();
        Mesher ppx = this.xAxisMeshers[31];
        ppx.finish();
        Mesher pnx = this.secondaryXAxisMeshers[31];
        pnx.finish();
        for (int y = 0; y < 32; ++y) {
            int skipA = 0;
            int skipB = 0;
            for (int z = 0; z < 32; ++z) {
                long nM;
                int modelId;
                long Am;
                long A2;
                int sidx;
                long neighborId;
                int i = y * 32 + z;
                int msk = this.nonOpaqueMasks[i];
                if ((msk & 1) != 0) {
                    neighborId = this.neighboringFaces[i];
                    sidx = (i << 5) * 2;
                    A2 = this.sectionData[sidx];
                    Am = this.sectionData[sidx + 1];
                    modelId = 0;
                    nM = 0L;
                    if (Mapper.getBlockId(neighborId) != 0) {
                        modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        nM = this.modelMan.getModelMetadataFromClientId(modelId);
                    }
                    nnx.skip(skipA);
                    npx.skip(skipA);
                    skipA = 0;
                    RenderDataFactory.dualMeshNonOpaqueOuterX(0, A2, Am, modelId, Mapper.getLightId(neighborId), nM, this.sectionData[sidx + 2], this.sectionData[sidx + 3], nnx, npx);
                } else {
                    ++skipA;
                }
                if ((msk & Integer.MIN_VALUE) != 0) {
                    neighborId = this.neighboringFaces[i + 1024];
                    sidx = (i * 32 + 31) * 2;
                    A2 = this.sectionData[sidx];
                    Am = this.sectionData[sidx + 1];
                    modelId = 0;
                    nM = 0L;
                    if (Mapper.getBlockId(neighborId) != 0) {
                        modelId = this.modelMan.getModelId(Mapper.getBlockId(neighborId));
                        nM = this.modelMan.getModelMetadataFromClientId(modelId);
                    }
                    pnx.skip(skipB);
                    ppx.skip(skipB);
                    skipB = 0;
                    RenderDataFactory.dualMeshNonOpaqueOuterX(1, A2, Am, modelId, Mapper.getLightId(neighborId), nM, this.sectionData[sidx - 2], this.sectionData[sidx - 1], ppx, pnx);
                    continue;
                }
                ++skipB;
            }
            nnx.skip(skipA);
            npx.skip(skipA);
            pnx.skip(skipB);
            ppx.skip(skipB);
        }
    }

    private void generateXFaces() {
        this.generateXOpaqueInnerGeometry();
        this.generateXOuterOpaqueGeometry();
        for (Mesher mesher : this.xAxisMeshers) {
            mesher.finish();
        }
        this.generateXInnerFluidGeometry();
        this.generateXOuterFluidGeometry();
        for (Mesher mesher : this.xAxisMeshers) {
            mesher.finish();
        }
        this.generateXNonOpaqueInnerGeometry();
        this.generateXNonOpaqueOuterGeometry();
        for (Mesher mesher : this.xAxisMeshers) {
            mesher.finish();
        }
        for (Mesher mesher : this.secondaryXAxisMeshers) {
            mesher.finish();
        }
    }

    private final void buildOccupancy() {
        for (int i = 0; i < 1024; ++i) {
            int occ = 0;
            int msk = this.opaqueMasks[i];
            occ |= msk ^ msk >> 1;
            occ |= msk ^ msk << 1;
            occ |= i < 992 ? msk ^ this.opaqueMasks[i + 32] : 0;
            occ |= 31 < i ? msk ^ this.opaqueMasks[i - 32] : 0;
            occ |= (i & 0x1F) < 31 ? msk ^ this.opaqueMasks[i + 1] : 0;
            occ |= 0 < (i & 0x1F) ? msk ^ this.opaqueMasks[i - 1] : 0;
            while (occ != 0) {
                this.occupancy.set(i * 32 + Integer.numberOfTrailingZeros(occ));
                occ &= ~Integer.lowestOneBit(occ);
            }
        }
    }

    public BuiltSection generateMesh(WorldSection section) {
        this.quadCount = 0;
        this.blockMesher.reset();
        this.blockMesher.doAuxiliaryFaceOffset = true;
        this.seondaryblockMesher.reset();
        this.seondaryblockMesher.doAuxiliaryFaceOffset = true;
        for (Mesher mesher : this.xAxisMeshers) {
            mesher.reset();
            mesher.doAuxiliaryFaceOffset = true;
        }
        for (Mesher mesher : this.secondaryXAxisMeshers) {
            mesher.reset();
            mesher.doAuxiliaryFaceOffset = false;
        }
        this.occupancy.reset();
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        Arrays.fill(this.quadCounters, 0);
        Arrays.fill(this.opaqueMasks, 0);
        Arrays.fill(this.nonOpaqueMasks, 0);
        Arrays.fill(this.fluidMasks, 0);
        int neighborMskAndFlags = this.prepareSectionData(section._unsafeGetRawDataArray());
        if ((neighborMskAndFlags & Integer.MIN_VALUE) != 0) {
            throw new IdNotYetComputedException(neighborMskAndFlags & 0xFFFFF, true);
        }
        int neighborMsk = neighborMskAndFlags & 0x3F;
        int flags = neighborMskAndFlags >>> 6;
        this.acquireNeighborData(section, neighborMsk);
        try {
            this.generateYZFaces();
            this.generateXFaces();
        }
        catch (IdNotYetComputedException e) {
            e.auxBitMsk = neighborMsk;
            e.auxData = this.neighboringFaces;
            throw e;
        }
        if (this.quadCount == 0) {
            return BuiltSection.emptyWithChildren(section.key, section.getNonEmptyChildren());
        }
        if (this.quadCount >= 65536) {
            Logger.warn("Large quad count for section " + WorldEngine.pprintPos(section.key) + " is " + this.quadCount);
        }
        if (this.minX < 0 || this.minY < 0 || this.minZ < 0 || 32 < this.maxX || 32 < this.maxY || 32 < this.maxZ) {
            throw new IllegalStateException();
        }
        int[] offsets = new int[8];
        MemoryBuffer buff = new MemoryBuffer((long)this.quadCount * 8L);
        long ptr = buff.address;
        int coff = 0;
        for (int buffer = 0; buffer < 8; ++buffer) {
            offsets[buffer] = coff;
            int size = this.quadCounters[buffer];
            UnsafeUtil.memcpy(this.quadBufferPtr + (long)(buffer * 524288), ptr + (long)coff * 8L, (long)size * 8L);
            coff += size;
        }
        int aabb = 0;
        aabb |= this.minX;
        aabb |= this.minY << 5;
        aabb |= this.minZ << 10;
        aabb |= this.maxX - this.minX - 1 << 15;
        aabb |= this.maxY - this.minY - 1 << 20;
        MemoryBuffer occupancy = null;
        return new BuiltSection(section.key, section.getNonEmptyChildren(), aabb |= this.maxZ - this.minZ - 1 << 25, buff, offsets, occupancy);
    }

    public void free() {
        this.quadBuffer.free();
    }

    private final class Mesher
    extends ScanMesher2D {
        public int auxiliaryPosition = 0;
        public boolean doAuxiliaryFaceOffset = true;
        public int axis = 0;

        private Mesher() {
        }

        @Override
        protected void emitQuad(int x, int z, int length, int width, long data) {
            int bufferIdx;
            int face;
            if (VERIFY_MESHING) {
                if (length < 1 || length > 16) {
                    throw new IllegalStateException("length out of bounds: " + length);
                }
                if (width < 1 || width > 16) {
                    throw new IllegalStateException("width out of bounds: " + width);
                }
                if (x < 0 || x > 31) {
                    throw new IllegalStateException("x out of bounds: " + x);
                }
                if (z < 0 || z > 31) {
                    throw new IllegalStateException("z out of bounds: " + z);
                }
                if (x - (length - 1) < 0 || z - (width - 1) < 0) {
                    throw new IllegalStateException("dim out of bounds: " + (x - (length - 1)) + ", " + (z - (width - 1)));
                }
            }
            ++RenderDataFactory.this.quadCount;
            x -= length - 1;
            z -= width - 1;
            if (this.axis == 2) {
                int tmp = x;
                x = z;
                z = tmp;
                tmp = length;
                length = width;
                width = tmp;
            }
            int auxData = (int)(data & 0x3FFFFFFL);
            data &= 0xFFFFFFFFFC000000L;
            int axisSide = auxData & 1;
            int type = auxData >> 1 & 3;
            if (VERIFY_MESHING && type == 3) {
                throw new IllegalStateException();
            }
            int auxPos = this.auxiliaryPosition;
            if (VERIFY_MESHING && (auxPos += 1 - (this.doAuxiliaryFaceOffset ? axisSide : 1)) > 31) {
                throw new IllegalStateException("OOB face: " + auxPos + ", " + axisSide);
            }
            int axis = this.axis;
            int encodedPosition = face = axis << 1 | axisSide;
            encodedPosition |= width - 1 << 7 | length - 1 << 3;
            encodedPosition |= x << (axis == 2 ? 16 : 21);
            encodedPosition |= z << (axis == 1 ? 16 : 11);
            int shiftAmount = axis == 0 ? 16 : (axis == 1 ? 11 : 21);
            long quad = data | Integer.toUnsignedLong(encodedPosition |= auxPos << shiftAmount);
            int n = bufferIdx = type + (type == 2 ? face : 0);
            int n2 = RenderDataFactory.this.quadCounters[n];
            RenderDataFactory.this.quadCounters[n] = n2 + 1;
            long bufferOffset = (long)n2 * 8L + (long)bufferIdx * 8L * 65536L;
            MemoryUtil.memPutLong((long)(RenderDataFactory.this.quadBufferPtr + bufferOffset), (long)quad);
            if (axis == 0) {
                RenderDataFactory.this.minY = Math.min(RenderDataFactory.this.minY, auxPos);
                RenderDataFactory.this.maxY = Math.max(RenderDataFactory.this.maxY, auxPos);
                RenderDataFactory.this.minX = Math.min(RenderDataFactory.this.minX, x);
                RenderDataFactory.this.maxX = Math.max(RenderDataFactory.this.maxX, x + length);
                RenderDataFactory.this.minZ = Math.min(RenderDataFactory.this.minZ, z);
                RenderDataFactory.this.maxZ = Math.max(RenderDataFactory.this.maxZ, z + width);
            } else if (axis == 1) {
                RenderDataFactory.this.minZ = Math.min(RenderDataFactory.this.minZ, auxPos);
                RenderDataFactory.this.maxZ = Math.max(RenderDataFactory.this.maxZ, auxPos);
                RenderDataFactory.this.minX = Math.min(RenderDataFactory.this.minX, x);
                RenderDataFactory.this.maxX = Math.max(RenderDataFactory.this.maxX, x + length);
                RenderDataFactory.this.minY = Math.min(RenderDataFactory.this.minY, z);
                RenderDataFactory.this.maxY = Math.max(RenderDataFactory.this.maxY, z + width);
            } else {
                RenderDataFactory.this.minX = Math.min(RenderDataFactory.this.minX, auxPos);
                RenderDataFactory.this.maxX = Math.max(RenderDataFactory.this.maxX, auxPos);
                RenderDataFactory.this.minY = Math.min(RenderDataFactory.this.minY, x);
                RenderDataFactory.this.maxY = Math.max(RenderDataFactory.this.maxY, x + length);
                RenderDataFactory.this.minZ = Math.min(RenderDataFactory.this.minZ, z);
                RenderDataFactory.this.maxZ = Math.max(RenderDataFactory.this.maxZ, z + width);
            }
        }
    }
}

