/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.building;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import org.lwjgl.system.MemoryUtil;

public class OccupancySet {
    private long topLvl;
    private final long[] bottomLvl = new long[512];

    public void set(int pos) {
        long topBit = 1L << Integer.compress(pos, 25368);
        int botIdx = Integer.compress(pos, 7399);
        int baseBotIdx = Long.bitCount(this.topLvl & topBit - 1L) * 8;
        if ((this.topLvl & topBit) == 0L) {
            long toMove = this.topLvl & ((topBit << 1) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
            if (toMove != 0L) {
                int i;
                int base = baseBotIdx + 8;
                int count = Long.bitCount(toMove);
                for (i = base + count * 8 - 1; base <= i; --i) {
                    this.bottomLvl[i] = this.bottomLvl[i - 8];
                }
                for (i = baseBotIdx; i < baseBotIdx + 8; ++i) {
                    this.bottomLvl[i] = 0L;
                }
            }
            this.topLvl |= topBit;
        }
        int n = baseBotIdx + (botIdx >> 6);
        this.bottomLvl[n] = this.bottomLvl[n] | 1L << (botIdx & 0x3F);
    }

    private boolean get(int pos) {
        long topBit = 1L << Integer.compress(pos, 25368);
        int botIdx = Integer.compress(pos, 7399);
        if ((this.topLvl & topBit) == 0L) {
            return false;
        }
        int baseBotIdx = Long.bitCount(this.topLvl & topBit - 1L) * 8;
        return (this.bottomLvl[baseBotIdx + (botIdx >> 6)] & 1L << (botIdx & 0x3F)) != 0L;
    }

    public void reset() {
        if (this.topLvl != 0L) {
            Arrays.fill(this.bottomLvl, 0L);
        }
        this.topLvl = 0L;
    }

    public int writeSize() {
        return 8 + Long.bitCount(this.topLvl) * 8 * 8;
    }

    public boolean isEmpty() {
        return this.topLvl == 0L;
    }

    public void write(long ptr, boolean asLongs) {
        if (asLongs) {
            MemoryUtil.memPutLong((long)ptr, (long)this.topLvl);
            ptr += 8L;
            int cnt = Long.bitCount(this.topLvl);
            for (int i = 0; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MemoryUtil.memPutLong((long)ptr, (long)this.bottomLvl[i * 8 + j]);
                    ptr += 8L;
                }
            }
        } else {
            MemoryUtil.memPutInt((long)ptr, (int)((int)(this.topLvl >>> 32)));
            MemoryUtil.memPutInt((long)(ptr += 4L), (int)((int)this.topLvl));
            ptr += 4L;
            int cnt = Long.bitCount(this.topLvl);
            for (int i = 0; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    long v = this.bottomLvl[i * 8 + j];
                    MemoryUtil.memPutInt((long)ptr, (int)((int)(v >>> 32)));
                    MemoryUtil.memPutInt((long)(ptr += 4L), (int)((int)v));
                    ptr += 4L;
                }
            }
        }
    }

    public static void main(String[] args) {
        for (int q = 0; q < 1000; ++q) {
            OccupancySet o = new OccupancySet();
            Random r = new Random(12523532643L * (long)q);
            BitSet bs = new BitSet(32768);
            for (int i = 0; i < 5000; ++i) {
                int p = r.nextInt(32768);
                o.set(p);
                bs.set(p);
                for (int j = 0; j < 32768; ++j) {
                    if (o.get(j) == bs.get(j)) continue;
                    throw new IllegalStateException();
                }
            }
        }
    }
}

