/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model.bakery;

import com.mojang.blaze3d.textures.GpuTexture;
import java.util.Iterator;
import java.util.List;
import me.cortex.voxy.client.core.model.bakery.BudgetBufferRenderer;
import me.cortex.voxy.client.core.model.bakery.GlViewCapture;
import me.cortex.voxy.client.core.model.bakery.ReuseVertexConsumer;
import net.minecraft.class_10868;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6539;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL14C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45;

public class ModelTextureBakery {
    private static final Matrix4f[] VIEWS = new Matrix4f[6];
    private final GlViewCapture capture;
    private final ReuseVertexConsumer vc = new ReuseVertexConsumer();
    private final int width;
    private final int height;

    public ModelTextureBakery(int width, int height) {
        this.capture = new GlViewCapture(width, height);
        this.width = width;
        this.height = height;
    }

    public static int getMetaFromLayer(class_11515 layer) {
        boolean hasDiscard = layer == class_11515.field_60925 || layer == class_11515.field_60926 || layer == class_11515.field_60927;
        boolean isMipped = layer == class_11515.field_60923 || layer == class_11515.field_60926 || layer == class_11515.field_60927;
        int meta = hasDiscard ? 1 : 0;
        return meta |= 2;
    }

    private void bakeBlockModel(class_2680 state, class_11515 layer) {
        if (state.method_26217() == class_2464.field_11455) {
            return;
        }
        class_1087 model = class_310.method_1551().method_1554().method_4743().method_3335(state);
        int meta = ModelTextureBakery.getMetaFromLayer(layer);
        for (class_10889 part : model.method_68512((class_5819)new class_6575(42L))) {
            for (class_2350 direction : new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, null}) {
                List quads = part.method_68509(direction);
                Iterator iterator = quads.iterator();
                while (iterator.hasNext()) {
                    class_777 quad;
                    this.vc.quad(quad, meta | ((quad = (class_777)iterator.next()).method_3360() ? 4 : 0));
                }
            }
        }
    }

    private void bakeFluidState(final class_2680 state, class_11515 layer, final int face) {
        int metadata = ModelTextureBakery.getMetaFromLayer(layer);
        this.vc.setDefaultMeta(metadata |= 4);
        class_310.method_1551().method_1541().method_3352(class_2338.field_10980, new class_1920(){

            public float method_24852(class_2350 direction, boolean shaded) {
                return 0.0f;
            }

            public class_3568 method_22336() {
                return null;
            }

            public int method_8314(class_1944 type, class_2338 pos) {
                return 0;
            }

            public int method_23752(class_2338 pos, class_6539 colorResolver) {
                return 0;
            }

            @Nullable
            public class_2586 method_8321(class_2338 pos) {
                return null;
            }

            public class_2680 method_8320(class_2338 pos) {
                if (ModelTextureBakery.shouldReturnAirForFluid(pos, face)) {
                    return class_2246.field_10124.method_9564();
                }
                return state;
            }

            public class_3610 method_8316(class_2338 pos) {
                if (ModelTextureBakery.shouldReturnAirForFluid(pos, face)) {
                    return class_2246.field_10124.method_9564().method_26227();
                }
                return state.method_26227();
            }

            public int method_31605() {
                return 0;
            }

            public int method_31607() {
                return 0;
            }
        }, (class_4588)this.vc, state, state.method_26227());
        this.vc.setDefaultMeta(0);
    }

    private static boolean shouldReturnAirForFluid(class_2338 pos, int face) {
        class_2382 fv = class_2350.method_10143((int)face).method_62675();
        int dot = fv.method_10263() * pos.method_10263() + fv.method_10264() * pos.method_10264() + fv.method_10260() * pos.method_10260();
        return dot >= 1;
    }

    public void free() {
        this.capture.free();
        this.vc.free();
    }

    public int renderToStream(class_2680 state, int streamBuffer, int streamOffset) {
        class_11515 layer;
        this.capture.clear();
        boolean isBlock = true;
        if (state.method_26204() instanceof class_2404) {
            layer = class_4696.method_23680((class_3610)state.method_26227());
            isBlock = false;
        } else {
            layer = state.method_26204() instanceof class_2397 ? class_11515.field_60923 : class_4696.method_23679((class_2680)state);
        }
        if (state.method_31709()) {
            // empty if block
        }
        int[] viewdat = new int[4];
        GL30.glEnable((int)2960);
        GL30.glEnable((int)2929);
        GL30.glEnable((int)2884);
        if (layer == class_11515.field_60926) {
            GL30.glEnable((int)3042);
            GL14C.glBlendFuncSeparate((int)773, (int)772, (int)1, (int)771);
        } else {
            GL30.glDisable((int)3042);
        }
        GL30.glStencilOp((int)7680, (int)7680, (int)7682);
        GL30.glStencilFunc((int)519, (int)1, (int)255);
        GL30.glStencilMask((int)255);
        GL30.glGetIntegerv((int)2978, (int[])viewdat);
        GL30.glBindFramebuffer((int)36160, (int)this.capture.framebuffer.id);
        GpuTexture tex = class_310.method_1551().method_1531().method_4619(class_2960.method_60655((String)"minecraft", (String)"textures/atlas/blocks.png")).method_68004();
        int blockTextureId = ((class_10868)tex).method_68427();
        boolean isAnyShaded = false;
        boolean isAnyDarkend = false;
        if (isBlock) {
            this.vc.reset();
            this.bakeBlockModel(state, layer);
            isAnyShaded |= this.vc.anyShaded;
            isAnyDarkend |= this.vc.anyDarkendTex;
            if (!this.vc.isEmpty()) {
                BudgetBufferRenderer.setup(this.vc.getAddress(), this.vc.quadCount(), blockTextureId);
                Matrix4f mat = new Matrix4f();
                for (int i = 0; i < VIEWS.length; ++i) {
                    if (i == 1 || i == 2 || i == 4) {
                        GL30.glCullFace((int)1028);
                    } else {
                        GL30.glCullFace((int)1029);
                    }
                    GL30.glViewport((int)(i % 3 * this.width), (int)(i / 3 * this.height), (int)this.width, (int)this.height);
                    mat.set(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f).mul((Matrix4fc)VIEWS[i]);
                    BudgetBufferRenderer.render(mat);
                }
            }
            GL30.glBindVertexArray((int)0);
        } else {
            if (!(state.method_26204() instanceof class_2404)) {
                throw new IllegalStateException();
            }
            Matrix4f mat = new Matrix4f();
            for (int i = 0; i < VIEWS.length; ++i) {
                if (i == 1 || i == 2 || i == 4) {
                    GL30.glCullFace((int)1028);
                } else {
                    GL30.glCullFace((int)1029);
                }
                this.vc.reset();
                this.bakeFluidState(state, layer, i);
                if (this.vc.isEmpty()) continue;
                isAnyShaded |= this.vc.anyShaded;
                isAnyDarkend |= this.vc.anyDarkendTex;
                BudgetBufferRenderer.setup(this.vc.getAddress(), this.vc.quadCount(), blockTextureId);
                GL30.glViewport((int)(i % 3 * this.width), (int)(i / 3 * this.height), (int)this.width, (int)this.height);
                mat.set(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f).mul((Matrix4fc)VIEWS[i]);
                BudgetBufferRenderer.render(mat);
            }
            GL30.glBindVertexArray((int)0);
        }
        GL30.glViewport((int)viewdat[0], (int)viewdat[1], (int)viewdat[2], (int)viewdat[3]);
        GL30.glDisable((int)2960);
        GL30.glDisable((int)3042);
        GL45.glTextureBarrier();
        this.capture.emitToStream(streamBuffer, streamOffset);
        GL30.glBindFramebuffer((int)36160, (int)this.capture.framebuffer.id);
        GL30.glClearDepth((double)1.0);
        GL30.glClear((int)256);
        if (layer == class_11515.field_60926) {
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        return (isAnyShaded ? 1 : 0) | (isAnyDarkend ? 2 : 0);
    }

    private static void addView(int i, float pitch, float yaw, float rotation, int flip) {
        class_4587 stack = new class_4587();
        stack.method_46416(0.5f, 0.5f, 0.5f);
        stack.method_22907((Quaternionfc)ModelTextureBakery.makeQuatFromAxisExact(new Vector3f(0.0f, 0.0f, 1.0f), rotation));
        stack.method_22907((Quaternionfc)ModelTextureBakery.makeQuatFromAxisExact(new Vector3f(1.0f, 0.0f, 0.0f), pitch));
        stack.method_22907((Quaternionfc)ModelTextureBakery.makeQuatFromAxisExact(new Vector3f(0.0f, 1.0f, 0.0f), yaw));
        stack.method_34425((Matrix4fc)new Matrix4f().scale((float)(1 - 2 * (flip & 1)), (float)(1 - (flip & 2)), (float)(1 - (flip >> 1 & 2))));
        stack.method_46416(-0.5f, -0.5f, -0.5f);
        ModelTextureBakery.VIEWS[i] = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
    }

    private static Quaternionf makeQuatFromAxisExact(Vector3f vec, float angle) {
        angle = (float)Math.toRadians(angle);
        float hangle = angle / 2.0f;
        float sinAngle = (float)Math.sin(hangle);
        float invVLength = (float)(1.0 / Math.sqrt(vec.lengthSquared()));
        return new Quaternionf((double)(vec.x * invVLength * sinAngle), (double)(vec.y * invVLength * sinAngle), (double)(vec.z * invVLength * sinAngle), Math.cos(hangle));
    }

    static {
        ModelTextureBakery.addView(0, -90.0f, 0.0f, 0.0f, 0);
        ModelTextureBakery.addView(1, 90.0f, 0.0f, 0.0f, 4);
        ModelTextureBakery.addView(2, 0.0f, 180.0f, 0.0f, 1);
        ModelTextureBakery.addView(3, 0.0f, 0.0f, 0.0f, 0);
        ModelTextureBakery.addView(4, 0.0f, 90.0f, 270.0f, 4);
        ModelTextureBakery.addView(5, 0.0f, 270.0f, 270.0f, 0);
    }
}

