/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model.bakery;

import me.cortex.voxy.client.core.gl.GlFramebuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBShaderImageLoadStore;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL45;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GlViewCapture {
    private final int width;
    private final int height;
    private final GlTexture colourTex;
    private final GlTexture depthTex;
    private final GlTexture stencilTex;
    private final GlTexture metaTex;
    final GlFramebuffer framebuffer;
    private final Shader copyOutShader;

    public GlViewCapture(int width, int height) {
        this.width = width;
        this.height = height;
        this.metaTex = new GlTexture().store(33334, 1, width * 3, height * 2).name("ModelBakeryMetadata");
        this.colourTex = new GlTexture().store(32856, 1, width * 3, height * 2).name("ModelBakeryColour");
        this.depthTex = new GlTexture().store(35056, 1, width * 3, height * 2).name("ModelBakeryDepth");
        ARBDirectStateAccess.glTextureParameteri((int)this.depthTex.id, (int)37098, (int)6401);
        this.stencilTex = this.depthTex.createView();
        ARBDirectStateAccess.glTextureParameteri((int)this.depthTex.id, (int)37098, (int)6402);
        this.framebuffer = new GlFramebuffer().bind(36064, this.colourTex).bind(36065, this.metaTex).setDrawBuffers(36064, 36065).bind(33306, this.depthTex).verify().name("ModelFramebuffer");
        ARBDirectStateAccess.glTextureParameteri((int)this.stencilTex.id, (int)37098, (int)6401);
        ARBDirectStateAccess.glTextureParameteri((int)this.stencilTex.id, (int)10240, (int)9728);
        ARBDirectStateAccess.glTextureParameteri((int)this.stencilTex.id, (int)10241, (int)9728);
        ARBDirectStateAccess.glTextureParameteri((int)this.metaTex.id, (int)10240, (int)9728);
        ARBDirectStateAccess.glTextureParameteri((int)this.metaTex.id, (int)10241, (int)9728);
        this.copyOutShader = Shader.makeAuto(new IShaderProcessor[0]).define("WIDTH", width).define("HEIGHT", height).define("COLOUR_IN_BINDING", 0).define("DEPTH_IN_BINDING", 1).define("STENCIL_IN_BINDING", 2).define("META_IN_BINDING", 3).define("BUFFER_OUT_BINDING", 4).add(ShaderType.COMPUTE, "voxy:bakery/bufferreorder.comp").compile().name("ModelBakeryOut").texture("META_IN_BINDING", 0, this.metaTex).texture("COLOUR_IN_BINDING", 0, this.colourTex).texture("DEPTH_IN_BINDING", 0, this.depthTex).texture("STENCIL_IN_BINDING", 0, this.stencilTex);
    }

    public void emitToStream(int buffer, int offset) {
        this.copyOutShader.bind();
        GL43.glBindBufferRange((int)37074, (int)4, (int)buffer, (long)offset, (long)((long)this.width * 3L * ((long)this.height * 2L) * 4L * 2L));
        ARBShaderImageLoadStore.glMemoryBarrier((int)1440);
        GL43.glDispatchCompute((int)3, (int)2, (int)1);
        GL43.glBindBufferRange((int)37074, (int)4, (int)0, (long)0L, (long)4L);
    }

    public void clear() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long ptr = stack.nmalloc(16);
            MemoryUtil.memPutLong((long)ptr, (long)0L);
            MemoryUtil.memPutLong((long)(ptr + 8L), (long)0L);
            ARBDirectStateAccess.nglClearNamedFramebufferfv((int)this.framebuffer.id, (int)6144, (int)0, (long)ptr);
            ARBDirectStateAccess.nglClearNamedFramebufferuiv((int)this.framebuffer.id, (int)6144, (int)1, (long)ptr);
        }
        GL45.glClearNamedFramebufferfi((int)this.framebuffer.id, (int)34041, (int)0, (float)1.0f, (int)0);
    }

    public void free() {
        this.framebuffer.free();
        this.colourTex.free();
        this.stencilTex.free();
        this.depthTex.free();
        this.metaTex.free();
        this.copyOutShader.free();
    }
}

