/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model;

import me.cortex.voxy.client.core.model.ColourDepthTextureData;
import net.caffeinemc.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.class_9848;

public class TextureUtils {
    public static final int WRITE_CHECK_STENCIL = 1;
    public static final int WRITE_CHECK_DEPTH = 2;
    public static final int WRITE_CHECK_ALPHA = 3;
    public static final int DEPTH_MODE_AVG = 1;
    public static final int DEPTH_MODE_MAX = 2;
    public static final int DEPTH_MODE_MIN = 3;

    public static int getWrittenPixelCount(ColourDepthTextureData texture, int checkMode) {
        int count = 0;
        for (int i = 0; i < texture.colour().length; ++i) {
            count += TextureUtils.wasPixelWritten(texture, checkMode, i) ? 1 : 0;
        }
        return count;
    }

    public static boolean isSolid(ColourDepthTextureData texture) {
        for (int pixel : texture.colour()) {
            if ((pixel >> 24 & 0xFF) == 255) continue;
            return false;
        }
        return true;
    }

    private static boolean wasPixelWritten(ColourDepthTextureData data, int mode, int index) {
        if (mode == 1) {
            return (data.depth()[index] & 0xFF) != 0;
        }
        if (mode == 2) {
            return data.depth()[index] >>> 8 != 0xFFFFFF;
        }
        if (mode == 3) {
            return (data.colour()[index] >>> 24 & 0xFF) > 1;
        }
        throw new IllegalArgumentException();
    }

    public static int computeFaceTint(ColourDepthTextureData texture, int checkMode) {
        boolean allTinted = true;
        boolean someTinted = false;
        boolean wasWriten = false;
        int[] colourData = texture.colour();
        int[] depthData = texture.depth();
        for (int i = 0; i < colourData.length; ++i) {
            if (!TextureUtils.wasPixelWritten(texture, checkMode, i) || (colourData[i] & 0xFFFFFF) == 0 || colourData[i] >>> 24 == 0) continue;
            boolean pixelTinited = (depthData[i] & 0x80) != 0;
            wasWriten |= true;
            allTinted &= pixelTinited;
            someTinted |= pixelTinited;
        }
        if (!wasWriten) {
            return 0;
        }
        return someTinted ? (allTinted ? 3 : 2) : 1;
    }

    public static float computeDepth(ColourDepthTextureData texture, int mode, int checkMode) {
        int[] colourData = texture.colour();
        int[] depthData = texture.depth();
        long a = 0L;
        long b = 0L;
        if (mode == 3) {
            a = Long.MAX_VALUE;
        }
        if (mode == 2) {
            a = Long.MIN_VALUE;
        }
        for (int i = 0; i < colourData.length; ++i) {
            if (!TextureUtils.wasPixelWritten(texture, checkMode, i)) continue;
            int depth = depthData[i] >>> 8;
            if (mode == 1) {
                ++a;
                b += (long)depth;
                continue;
            }
            if (mode == 2) {
                a = Math.max(a, (long)depth);
                continue;
            }
            if (mode != 3) continue;
            a = Math.min(a, (long)depth);
        }
        if (mode == 1) {
            if (a == 0L) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)(b / a));
        }
        if (mode == 2) {
            if (a == Long.MIN_VALUE) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)a);
        }
        if (mode == 3) {
            if (a == Long.MAX_VALUE) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)a);
        }
        throw new IllegalArgumentException();
    }

    private static float u2fdepth(int depth) {
        float depthF = (float)((double)depth / 1.6777215E7);
        if ((depthF *= 2.0f) > 1.00001f) {
            depthF = 1.0f;
        }
        return depthF;
    }

    public static int[] computeBounds(ColourDepthTextureData data, int checkMode) {
        int minX = 0;
        block0: do {
            for (int y = 0; y < data.height(); ++y) {
                int idx = minX + y * data.width();
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block0;
            }
        } while (++minX != data.width());
        int maxX = data.width() - 1;
        block2: do {
            for (int y = data.height() - 1; y != -1; --y) {
                int idx = maxX + y * data.width();
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block2;
            }
        } while (--maxX != -1);
        int minY = 0;
        block4: do {
            for (int x = 0; x < data.width(); ++x) {
                int idx = minY * data.height() + x;
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block4;
            }
        } while (++minY != data.height());
        int maxY = data.height() - 1;
        block6: do {
            for (int x = data.width() - 1; x != -1; --x) {
                int idx = maxY * data.height() + x;
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block6;
            }
        } while (--maxY != -1);
        return new int[]{minX, maxX, minY, maxY};
    }

    public static int mipColours(boolean darkend, int C00, int C01, int C10, int C11) {
        darkend = !darkend;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        if (darkend || C00 >>> 24 != 0) {
            r += ColorSRGB.srgbToLinear((int)(C00 >> 0 & 0xFF));
            g += ColorSRGB.srgbToLinear((int)(C00 >> 8 & 0xFF));
            b += ColorSRGB.srgbToLinear((int)(C00 >> 16 & 0xFF));
            a += darkend ? (float)(C00 >>> 24) : ColorSRGB.srgbToLinear((int)(C00 >>> 24));
        }
        if (darkend || C01 >>> 24 != 0) {
            r += ColorSRGB.srgbToLinear((int)(C01 >> 0 & 0xFF));
            g += ColorSRGB.srgbToLinear((int)(C01 >> 8 & 0xFF));
            b += ColorSRGB.srgbToLinear((int)(C01 >> 16 & 0xFF));
            a += darkend ? (float)(C01 >>> 24) : ColorSRGB.srgbToLinear((int)(C01 >>> 24));
        }
        if (darkend || C10 >>> 24 != 0) {
            r += ColorSRGB.srgbToLinear((int)(C10 >> 0 & 0xFF));
            g += ColorSRGB.srgbToLinear((int)(C10 >> 8 & 0xFF));
            b += ColorSRGB.srgbToLinear((int)(C10 >> 16 & 0xFF));
            a += darkend ? (float)(C10 >>> 24) : ColorSRGB.srgbToLinear((int)(C10 >>> 24));
        }
        if (darkend || C11 >>> 24 != 0) {
            r += ColorSRGB.srgbToLinear((int)(C11 >> 0 & 0xFF));
            g += ColorSRGB.srgbToLinear((int)(C11 >> 8 & 0xFF));
            b += ColorSRGB.srgbToLinear((int)(C11 >> 16 & 0xFF));
            a += darkend ? (float)(C11 >>> 24) : ColorSRGB.srgbToLinear((int)(C11 >>> 24));
        }
        return ColorSRGB.linearToSrgb((float)(r / 4.0f), (float)(g / 4.0f), (float)(b / 4.0f), (int)(darkend ? (int)a / 4 : class_9848.method_75599((float)(a / 4.0f))));
    }
}

