/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReentrantLock;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.model.ColourDepthTextureData;
import me.cortex.voxy.client.core.model.IdNotYetComputedException;
import me.cortex.voxy.client.core.model.MipGen;
import me.cortex.voxy.client.core.model.ModelQueries;
import me.cortex.voxy.client.core.model.ModelStore;
import me.cortex.voxy.client.core.model.TextureUtils;
import me.cortex.voxy.client.core.model.bakery.ModelTextureBakery;
import me.cortex.voxy.client.core.rendering.util.RawDownloadStream;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.Pair;
import me.cortex.voxy.common.world.other.Mapper;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_6539;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

public class ModelFactory {
    public static final int MODEL_TEXTURE_SIZE = 16;
    public static final int LAYERS = Integer.numberOfTrailingZeros(16);
    private final class_1959 DEFAULT_BIOME;
    public final ModelTextureBakery bakery;
    private final long[] metadataCache;
    private final int[] fluidStateLUT;
    private final int[] idMappings;
    private final Object2IntOpenHashMap<ModelEntry> modelTexture2id;
    private final IntOpenHashSet blockStatesInFlight;
    private final ReentrantLock blockStatesInFlightLock;
    private final List<class_1959> biomes;
    private final List<Pair<Integer, class_2680>> modelsRequiringBiomeColours;
    private static final ObjectSet<class_2680> LOGGED_SELF_CULLING_WARNING = new ObjectOpenHashSet();
    private final Mapper mapper;
    private final ModelStore storage;
    private final RawDownloadStream downstream;
    private final ConcurrentLinkedDeque<RawBakeResult> rawBakeResults;
    private final ConcurrentLinkedDeque<ResultUploader> uploadResults;
    private Object2IntMap<class_2680> customBlockStateIdMapping;
    private final ConcurrentLinkedDeque<Mapper.BiomeEntry> biomeQueue;

    public ModelFactory(Mapper mapper, ModelStore storage) {
        this.DEFAULT_BIOME = (class_1959)class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9451);
        this.modelTexture2id = new Object2IntOpenHashMap();
        this.blockStatesInFlight = new IntOpenHashSet();
        this.blockStatesInFlightLock = new ReentrantLock();
        this.biomes = new ArrayList<class_1959>();
        this.modelsRequiringBiomeColours = new ArrayList<Pair<Integer, class_2680>>();
        this.downstream = new RawDownloadStream(0x800000);
        this.rawBakeResults = new ConcurrentLinkedDeque();
        this.uploadResults = new ConcurrentLinkedDeque();
        this.biomeQueue = new ConcurrentLinkedDeque();
        this.mapper = mapper;
        this.storage = storage;
        this.bakery = new ModelTextureBakery(16, 16);
        this.metadataCache = new long[65536];
        this.fluidStateLUT = new int[65536];
        this.idMappings = new int[0x100000];
        Arrays.fill(this.idMappings, -1);
        Arrays.fill(this.fluidStateLUT, -1);
        this.modelTexture2id.defaultReturnValue(-1);
        this.addEntry(0);
    }

    public void setCustomBlockStateMapping(Object2IntMap<class_2680> mapping) {
        this.customBlockStateIdMapping = mapping;
    }

    public boolean addEntry(int blockId) {
        class_2680 fluidState;
        int fluidStateId;
        if (this.idMappings[blockId] != -1) {
            return false;
        }
        this.blockStatesInFlightLock.lock();
        if (!this.blockStatesInFlight.add(blockId)) {
            this.blockStatesInFlightLock.unlock();
            return false;
        }
        this.blockStatesInFlightLock.unlock();
        VarHandle.loadLoadFence();
        if (this.idMappings[blockId] != -1) {
            return false;
        }
        class_2680 blockState = this.mapper.getBlockStateFromBlockId(blockId);
        boolean isFluid = blockState.method_26204() instanceof class_2404;
        if (!isFluid && !blockState.method_26227().method_15769() && this.idMappings[fluidStateId = this.mapper.getIdForBlockState(fluidState = blockState.method_26227().method_15759())] == -1) {
            this.addEntry(fluidStateId);
        }
        RawBakeResult result = new RawBakeResult(blockId, blockState);
        int allocation = this.downstream.download(12288, ptr -> this.rawBakeResults.add(result.cpyBuf(ptr)));
        int flags = this.bakery.renderToStream(blockState, this.downstream.getBufferId(), allocation);
        result.hasDarkenedTextures = (flags & 2) != 0;
        result.isShaded = (flags & 1) != 0;
        return true;
    }

    private boolean processModelResult() {
        RawBakeResult result = this.rawBakeResults.poll();
        if (result == null) {
            return false;
        }
        ColourDepthTextureData[] textureData = new ColourDepthTextureData[6];
        long ptr = result.rawData.address;
        int FACE_SIZE = 256;
        for (int face = 0; face < 6; ++face) {
            long faceDataPtr = ptr + (long)(1024 * face * 2);
            int[] colour = new int[256];
            int[] depth = new int[256];
            for (int i = 0; i < 256; ++i) {
                colour[i] = MemoryUtil.memGetInt((long)(faceDataPtr + (long)(i * 4 * 2)));
                depth[i] = MemoryUtil.memGetInt((long)(faceDataPtr + (long)(i * 4 * 2) + 4L));
            }
            textureData[face] = new ColourDepthTextureData(colour, depth, 16, 16);
        }
        result.rawData.free();
        ModelBakeResultUpload bakeResult = this.processTextureBakeResult(result.blockId, result.blockState, textureData, result.isShaded, result.hasDarkenedTextures);
        if (bakeResult != null) {
            this.uploadResults.add(bakeResult);
        }
        return !this.rawBakeResults.isEmpty();
    }

    public void addBiome(Mapper.BiomeEntry biome) {
        this.biomeQueue.add(biome);
    }

    public void processAllThings() {
        Mapper.BiomeEntry biomeEntry = this.biomeQueue.poll();
        while (biomeEntry != null) {
            class_2378 biomeRegistry = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236);
            BiomeUploadResult res = this.addBiome0(biomeEntry.id, (class_1959)biomeRegistry.method_63535(class_2960.method_60654((String)biomeEntry.biome)));
            if (res != null) {
                this.uploadResults.add(res);
            }
            biomeEntry = this.biomeQueue.poll();
        }
        while (this.processModelResult()) {
        }
    }

    public void tickAndProcessUploads() {
        this.downstream.tick();
        ResultUploader upload = this.uploadResults.poll();
        if (upload == null) {
            return;
        }
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        do {
            upload.upload(this.storage);
            upload.free();
        } while ((upload = this.uploadResults.poll()) != null);
        UploadStream.INSTANCE.commit();
    }

    private ModelBakeResultUpload processTextureBakeResult(int blockId, class_2680 blockState, ColourDepthTextureData[] textureData, boolean isShaded, boolean darkenedTinting) {
        float[] depths;
        ModelEntry entry;
        int possibleDuplicate;
        class_2680 fluidState;
        int fluidStateId;
        if (this.idMappings[blockId] != -1) {
            throw new IllegalStateException("Block id already added: " + blockId + " for state: " + String.valueOf(blockState));
        }
        this.blockStatesInFlightLock.lock();
        if (!this.blockStatesInFlight.contains(blockId)) {
            this.blockStatesInFlightLock.unlock();
            throw new IllegalStateException("processing a texture bake result but the block state was not in flight!!");
        }
        this.blockStatesInFlightLock.unlock();
        boolean isFluid = blockState.method_26204() instanceof class_2404;
        int modelId = -1;
        int clientFluidStateId = -1;
        if (!isFluid && !blockState.method_26227().method_15769() && (clientFluidStateId = this.idMappings[fluidStateId = this.mapper.getIdForBlockState(fluidState = blockState.method_26227().method_15759())]) == -1) {
            throw new IllegalStateException("Block has a fluid state but fluid state is not already baked!!!");
        }
        class_322 colourProvider = ModelFactory.getColourProvider(blockState.method_26204());
        boolean isBiomeColourDependent = false;
        if (colourProvider != null) {
            isBiomeColourDependent = ModelFactory.isBiomeDependentColour(colourProvider, blockState);
        }
        if ((possibleDuplicate = this.modelTexture2id.getInt((Object)(entry = new ModelEntry(textureData, clientFluidStateId, isBiomeColourDependent || colourProvider == null ? -1 : ModelFactory.captureColourConstant(colourProvider, blockState, this.DEFAULT_BIOME) | 0xFF000000)))) != -1) {
            this.idMappings[blockId] = possibleDuplicate;
            modelId = possibleDuplicate;
            this.blockStatesInFlightLock.lock();
            if (!this.blockStatesInFlight.remove(blockId)) {
                this.blockStatesInFlightLock.unlock();
                throw new IllegalStateException();
            }
            this.blockStatesInFlightLock.unlock();
            return null;
        }
        modelId = this.modelTexture2id.size();
        this.modelTexture2id.put((Object)entry, modelId);
        if (isFluid) {
            this.fluidStateLUT[modelId] = modelId;
        } else if (clientFluidStateId != -1) {
            this.fluidStateLUT[modelId] = clientFluidStateId;
        }
        class_11515 blockRenderLayer = null;
        blockRenderLayer = blockState.method_26204() instanceof class_2404 ? class_4696.method_23680((class_3610)blockState.method_26227()) : (blockState.method_26204() instanceof class_2397 ? class_11515.field_60923 : class_4696.method_23679((class_2680)blockState));
        int checkMode = blockRenderLayer == class_11515.field_60923 ? 1 : 3;
        ModelBakeResultUpload uploadResult = new ModelBakeResultUpload();
        uploadResult.modelId = modelId;
        long uploadPtr = uploadResult.model.address;
        if (!isFluid && !blockState.method_26227().method_15769() && clientFluidStateId != -1) {
            isBiomeColourDependent |= ModelQueries.isBiomeColoured(this.getModelMetadataFromClientId(clientFluidStateId));
        }
        boolean needsDoubleSidedQuads = (double)(depths = ModelFactory.computeModelDepth(textureData, checkMode))[0] < -0.1 && (double)depths[1] < -0.1 || (double)depths[2] < -0.1 && (double)depths[3] < -0.1 || (double)depths[4] < -0.1 && (double)depths[5] < -0.1;
        boolean cullsSame = false;
        boolean allTrue = true;
        boolean allFalse = true;
        for (class_2350 dir : class_2350.values()) {
            if (blockState.method_26187(blockState, dir)) {
                allFalse = false;
                continue;
            }
            allTrue = false;
        }
        if (allFalse == allTrue) {
            cullsSame = false;
        }
        if (allTrue) {
            cullsSame = true;
        }
        long metadata = 0L;
        metadata |= isBiomeColourDependent ? 1L : 0L;
        metadata |= blockRenderLayer == class_11515.field_60926 ? 2L : 0L;
        metadata |= needsDoubleSidedQuads ? 4L : 0L;
        metadata |= !isFluid && !blockState.method_26227().method_15769() ? 8L : 0L;
        metadata |= isFluid ? 16L : 0L;
        metadata |= cullsSame ? 32L : 0L;
        boolean fullyOpaque = true;
        for (int face = 5; face != -1; --face) {
            long faceUploadPtr = uploadPtr + 4L * (long)face;
            metadata <<= 8;
            float offset = depths[face];
            if ((double)offset < -0.1) {
                metadata |= 0xFFL;
                MemoryUtil.memPutInt((long)faceUploadPtr, (int)-1);
                fullyOpaque = false;
                continue;
            }
            int[] faceSize = TextureUtils.computeBounds(textureData[face], checkMode);
            int writeCount = TextureUtils.getWrittenPixelCount(textureData[face], checkMode);
            boolean faceCoversFullBlock = faceSize[0] == 0 && faceSize[2] == 0 && faceSize[1] == 15 && faceSize[3] == 15;
            metadata |= faceCoversFullBlock ? 2L : 0L;
            boolean occludesFace = true;
            occludesFace &= blockRenderLayer != class_11515.field_60926;
            if (occludesFace &= (double)offset < 0.1) {
                occludesFace &= (double)((float)writeCount / 256.0f) > 0.9;
            }
            metadata |= occludesFace ? 1L : 0L;
            fullyOpaque &= occludesFace;
            boolean canBeOccluded = true;
            metadata |= (canBeOccluded &= (double)offset < 0.3) ? 4L : 0L;
            metadata |= (double)offset > 0.01 || blockRenderLayer == class_11515.field_60926 ? 8L : 0L;
            int faceModelData = 0;
            faceModelData |= faceSize[0] | faceSize[1] << 4 | faceSize[2] << 8 | faceSize[3] << 12;
            int enc = Math.round(offset * 64.0f);
            faceModelData |= Math.min(enc, 62) << 16;
            int area = (faceSize[1] - faceSize[0] + 1) * (faceSize[3] - faceSize[2] + 1);
            boolean needsAlphaDiscard = (double)((float)writeCount / (float)area) < 0.9;
            needsAlphaDiscard |= blockRenderLayer != class_11515.field_60923;
            faceModelData |= (needsAlphaDiscard &= blockRenderLayer != class_11515.field_60926) ? 0x400000 : 0;
            faceModelData |= !faceCoversFullBlock && blockRenderLayer != class_11515.field_60926 ? 0x800000 : 0;
            if (colourProvider != null) {
                int tintState = TextureUtils.computeFaceTint(textureData[face], checkMode);
                if (tintState == 2) {
                    faceModelData |= 0x1000000;
                } else if (tintState == 3) {
                    faceModelData |= 0x2000000;
                }
            }
            MemoryUtil.memPutInt((long)faceUploadPtr, (int)faceModelData);
        }
        long l = fullyOpaque ? 0x40000000000000L : 0L;
        boolean canBeCorrectlyRendered = true;
        this.metadataCache[modelId] = metadata |= l;
        int modelFlags = 0;
        modelFlags |= colourProvider != null ? 1 : 0;
        modelFlags |= isBiomeColourDependent ? 2 : 0;
        modelFlags |= blockRenderLayer == class_11515.field_60926 ? 4 : 0;
        MemoryUtil.memPutInt((long)(uploadPtr += 24L), (int)(modelFlags |= isShaded ? 8 : 0));
        uploadPtr += 4L;
        if (colourProvider == null) {
            MemoryUtil.memPutInt((long)uploadPtr, (int)-1);
        } else if (!isBiomeColourDependent) {
            MemoryUtil.memPutInt((long)uploadPtr, (int)entry.tintingColour);
        } else if (!this.biomes.isEmpty()) {
            int biomeIndex = this.modelsRequiringBiomeColours.size() * this.biomes.size();
            MemoryUtil.memPutInt((long)uploadPtr, (int)biomeIndex);
            this.modelsRequiringBiomeColours.add(new Pair<Integer, class_2680>(modelId, blockState));
            uploadResult.biomeUploadIndex = biomeIndex;
            uploadResult.biomeUpload = new MemoryBuffer(4L * (long)this.biomes.size());
            long clrUploadPtr = uploadResult.biomeUpload.address;
            for (class_1959 biome : this.biomes) {
                MemoryUtil.memPutInt((long)clrUploadPtr, (int)(ModelFactory.captureColourConstant(colourProvider, blockState, biome) | 0xFF000000));
                clrUploadPtr += 4L;
            }
        }
        uploadPtr += 4L;
        if (this.customBlockStateIdMapping != null && this.customBlockStateIdMapping.containsKey((Object)blockState)) {
            MemoryUtil.memPutInt((long)uploadPtr, (int)this.customBlockStateIdMapping.getInt((Object)blockState));
        } else {
            MemoryUtil.memPutInt((long)uploadPtr, (int)0);
        }
        uploadPtr += 4L;
        MipGen.putTextures(darkenedTinting, textureData, uploadResult.texture);
        this.idMappings[blockId] = modelId;
        this.blockStatesInFlightLock.lock();
        if (!this.blockStatesInFlight.remove(blockId)) {
            this.blockStatesInFlightLock.unlock();
            throw new IllegalStateException("processing a texture bake result but the block state was not in flight!!");
        }
        this.blockStatesInFlightLock.unlock();
        return uploadResult;
    }

    private BiomeUploadResult addBiome0(int id, class_1959 biome) {
        for (int i = this.biomes.size(); i <= id; ++i) {
            this.biomes.add(null);
        }
        class_1959 oldBiome = this.biomes.set(id, biome);
        if (oldBiome != null && oldBiome != biome) {
            throw new IllegalStateException("Biome was put in an id that was not null");
        }
        if (oldBiome == biome) {
            Logger.error("Biome added was a duplicate");
        }
        if (this.modelsRequiringBiomeColours.isEmpty()) {
            return null;
        }
        BiomeUploadResult result = new BiomeUploadResult(this.biomes.size(), this.modelsRequiringBiomeColours.size());
        int i = 0;
        long modelUpPtr = result.modelBiomeIndexPairs.address;
        for (Pair<Integer, class_2680> entry : this.modelsRequiringBiomeColours) {
            class_322 colourProvider = ModelFactory.getColourProvider(entry.right().method_26204());
            if (colourProvider == null) {
                throw new IllegalStateException();
            }
            int biomeIndex = i++ * this.biomes.size();
            MemoryUtil.memPutLong((long)modelUpPtr, (long)(Integer.toUnsignedLong(entry.left()) | Integer.toUnsignedLong(biomeIndex) << 32));
            modelUpPtr += 8L;
            long clrUploadPtr = result.biomeColourBuffer.address + (long)biomeIndex * 4L;
            for (class_1959 biomeE : this.biomes) {
                if (biomeE == null) continue;
                MemoryUtil.memPutInt((long)clrUploadPtr, (int)(ModelFactory.captureColourConstant(colourProvider, entry.right(), biomeE) | 0xFF000000));
                clrUploadPtr += 4L;
            }
        }
        return result;
    }

    private static class_322 getColourProvider(class_2248 block) {
        return (class_322)class_310.method_1551().method_1505().field_1995.method_10200(class_7923.field_41175.method_10206((Object)block));
    }

    private static int captureColourConstant(class_322 colorProvider, final class_2680 state, final class_1959 biome) {
        class_1920 getter = new class_1920(){

            public float method_24852(class_2350 direction, boolean shaded) {
                return 0.0f;
            }

            public int method_8314(class_1944 type, class_2338 pos) {
                return 0;
            }

            public class_3568 method_22336() {
                return null;
            }

            public int method_23752(class_2338 pos, class_6539 colorResolver) {
                return colorResolver.getColor(biome, 0.0, 0.0);
            }

            @Nullable
            public class_2586 method_8321(class_2338 pos) {
                return null;
            }

            public class_2680 method_8320(class_2338 pos) {
                return state;
            }

            public class_3610 method_8316(class_2338 pos) {
                return state.method_26227();
            }

            public int method_31605() {
                return 0;
            }

            public int method_31607() {
                return 0;
            }
        };
        int c = colorProvider.getColor(state, getter, class_2338.field_10980, 0);
        if (c != -1) {
            return c;
        }
        return colorProvider.getColor(state, getter, class_2338.field_10980, 1);
    }

    private static boolean isBiomeDependentColour(class_322 colorProvider, final class_2680 state) {
        final boolean[] biomeDependent = new boolean[1];
        class_1920 getter = new class_1920(){

            public float method_24852(class_2350 direction, boolean shaded) {
                return 0.0f;
            }

            public int method_8314(class_1944 type, class_2338 pos) {
                return 0;
            }

            public class_3568 method_22336() {
                return null;
            }

            public int method_23752(class_2338 pos, class_6539 colorResolver) {
                biomeDependent[0] = true;
                return 0;
            }

            @Nullable
            public class_2586 method_8321(class_2338 pos) {
                return null;
            }

            public class_2680 method_8320(class_2338 pos) {
                return state;
            }

            public class_3610 method_8316(class_2338 pos) {
                return state.method_26227();
            }

            public int method_31605() {
                return 0;
            }

            public int method_31607() {
                return 0;
            }
        };
        colorProvider.getColor(state, getter, class_2338.field_10980, 0);
        colorProvider.getColor(state, getter, class_2338.field_10980, 1);
        return biomeDependent[0];
    }

    private static float[] computeModelDepth(ColourDepthTextureData[] textures, int checkMode) {
        float[] res = new float[6];
        for (class_2350 dir : class_2350.values()) {
            ColourDepthTextureData data = textures[dir.method_10146()];
            float fd = TextureUtils.computeDepth(data, 1, checkMode);
            res[dir.ordinal()] = (double)fd < -0.1 ? -1.0f : fd;
        }
        return res;
    }

    public int[] _unsafeRawAccess() {
        return this.idMappings;
    }

    public int getModelId(int blockId) {
        int map = this.idMappings[blockId];
        if (map == -1) {
            throw new IdNotYetComputedException(blockId, true);
        }
        return map;
    }

    public boolean hasModelForBlockId(int blockId) {
        return this.idMappings[blockId] != -1;
    }

    public int getFluidClientStateId(int clientBlockStateId) {
        int map = this.fluidStateLUT[clientBlockStateId];
        if (map == -1) {
            throw new IdNotYetComputedException(clientBlockStateId, false);
        }
        return map;
    }

    public long getModelMetadataFromClientId(int clientId) {
        return this.metadataCache[clientId];
    }

    public void free() {
        this.bakery.free();
        this.downstream.free();
        while (!this.rawBakeResults.isEmpty()) {
            this.rawBakeResults.poll().rawData.free();
        }
        while (!this.uploadResults.isEmpty()) {
            this.uploadResults.poll().free();
        }
    }

    public int getBakedCount() {
        return this.modelTexture2id.size();
    }

    public int getInflightCount() {
        int size = this.blockStatesInFlight.size();
        size += this.uploadResults.size();
        return size += this.biomeQueue.size();
    }

    private static int computeSizeWithMips(int size) {
        int total = 0;
        while (size != 0) {
            total += size * size;
            size >>= 1;
        }
        return total;
    }

    private static final class RawBakeResult {
        private final int blockId;
        private final class_2680 blockState;
        private final MemoryBuffer rawData;
        public boolean isShaded;
        public boolean hasDarkenedTextures;

        public RawBakeResult(int blockId, class_2680 blockState, MemoryBuffer rawData) {
            this.blockId = blockId;
            this.blockState = blockState;
            this.rawData = rawData;
        }

        public RawBakeResult(int blockId, class_2680 blockState) {
            this(blockId, blockState, new MemoryBuffer(12288L));
        }

        public RawBakeResult cpyBuf(long ptr) {
            this.rawData.cpyFrom(ptr);
            return this;
        }
    }

    private static final class ModelBakeResultUpload
    implements ResultUploader {
        private final MemoryBuffer model = new MemoryBuffer(64L).zero();
        private final MemoryBuffer texture = new MemoryBuffer(6L * (long)ModelFactory.computeSizeWithMips(16) * 4L);
        public int modelId = -1;
        public int biomeUploadIndex = -1;
        @Nullable
        public MemoryBuffer biomeUpload;

        private ModelBakeResultUpload() {
        }

        @Override
        public void upload(ModelStore store) {
            this.upload(store.modelBuffer, store.modelColourBuffer, store.textures);
        }

        public void upload(GlBuffer modelBuffer, GlBuffer colourBuffer, GlTexture atlas) {
            this.model.cpyTo(UploadStream.INSTANCE.upload(modelBuffer, (long)this.modelId * 64L, 64L));
            if (this.biomeUploadIndex != -1) {
                this.biomeUpload.cpyTo(UploadStream.INSTANCE.upload(colourBuffer, (long)this.biomeUploadIndex * 4L, this.biomeUpload.size));
                this.biomeUploadIndex = -1;
                this.biomeUpload.free();
                this.biomeUpload = null;
            }
            int X = (this.modelId & 0xFF) * 16 * 3;
            int Y = (this.modelId >> 8 & 0xFF) * 16 * 2;
            long cAddr = this.texture.address;
            for (int lvl = 0; lvl < LAYERS; ++lvl) {
                ARBDirectStateAccess.nglTextureSubImage2D((int)atlas.id, (int)lvl, (int)(X >> lvl), (int)(Y >> lvl), (int)(48 >> lvl), (int)(32 >> lvl), (int)6408, (int)5121, (long)cAddr);
                cAddr += (long)(6144 >> (lvl << 1));
            }
            this.modelId = -1;
        }

        @Override
        public void free() {
            this.model.free();
            this.texture.free();
            if (this.biomeUpload != null) {
                this.biomeUpload.free();
            }
        }
    }

    private static final class BiomeUploadResult
    implements ResultUploader {
        private final MemoryBuffer biomeColourBuffer;
        private final MemoryBuffer modelBiomeIndexPairs;

        private BiomeUploadResult(int biomes, int models) {
            this.biomeColourBuffer = new MemoryBuffer(biomes * models * 4);
            this.modelBiomeIndexPairs = new MemoryBuffer(models * 8);
        }

        @Override
        public void upload(ModelStore store) {
            this.upload(store.modelBuffer, store.modelColourBuffer);
        }

        public void upload(GlBuffer modelBuffer, GlBuffer modelColourBuffer) {
            this.biomeColourBuffer.cpyTo(UploadStream.INSTANCE.upload(modelColourBuffer, 0L, this.biomeColourBuffer.size));
            long ptr = this.modelBiomeIndexPairs.address;
            for (long offset = 0L; offset < this.modelBiomeIndexPairs.size; offset += 8L) {
                long v = MemoryUtil.memGetLong((long)ptr);
                ptr += 8L;
                MemoryUtil.memPutInt((long)UploadStream.INSTANCE.upload(modelBuffer, 64L * (v & 0xFFFFFFFFL) + 24L + 4L, 4L), (int)((int)(v >>> 32)));
            }
            this.biomeColourBuffer.free();
            this.modelBiomeIndexPairs.free();
        }

        @Override
        public void free() {
            if (!this.biomeColourBuffer.isFreed()) {
                this.biomeColourBuffer.free();
                this.modelBiomeIndexPairs.free();
            }
        }
    }

    private static interface ResultUploader {
        public void upload(ModelStore var1);

        public void free();
    }

    private record ModelEntry(ColourDepthTextureData down, ColourDepthTextureData up, ColourDepthTextureData north, ColourDepthTextureData south, ColourDepthTextureData west, ColourDepthTextureData east, int fluidBlockStateId, int tintingColour) {
        public ModelEntry(ColourDepthTextureData[] textures, int fluidBlockStateId, int tintingColour) {
            this(textures[0], textures[1], textures[2], textures[3], textures[4], textures[5], fluidBlockStateId, tintingColour);
        }
    }
}

