/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl.shader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlDebug;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.gl.shader.Shader;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;

public class AutoBindingShader
extends Shader {
    private final Map<String, String> defines;
    private final List<BufferBinding> bindings = new ArrayList<BufferBinding>();
    private final List<TextureBinding> textureBindings = new ArrayList<TextureBinding>();
    private boolean rebuild = true;

    AutoBindingShader(Shader.Builder<AutoBindingShader> builder, int program) {
        super(program);
        this.defines = builder.defines;
    }

    @Override
    public AutoBindingShader name(String name) {
        return GlDebug.name(name, this);
    }

    public AutoBindingShader ssboIf(String define, GlBuffer buffer) {
        if (this.defines.containsKey(define)) {
            return this.ssbo(define, buffer);
        }
        return this;
    }

    public AutoBindingShader ssbo(int index, GlBuffer binding) {
        return this.ssbo(index, binding, 0L);
    }

    public AutoBindingShader ssbo(String define, GlBuffer binding) {
        return this.ssbo(Integer.parseInt(this.defines.get(define)), binding, 0L);
    }

    public AutoBindingShader ssbo(int index, GlBuffer buffer, long offset) {
        this.insertOrReplaceBinding(new BufferBinding(37074, index, buffer, offset, -1L));
        return this;
    }

    public AutoBindingShader ubo(String define, GlBuffer buffer) {
        return this.ubo(Integer.parseInt(this.defines.get(define)), buffer);
    }

    public AutoBindingShader ubo(int index, GlBuffer buffer) {
        return this.ubo(index, buffer, 0L);
    }

    public AutoBindingShader ubo(int index, GlBuffer buffer, long offset) {
        this.insertOrReplaceBinding(new BufferBinding(35345, index, buffer, offset, -1L));
        return this;
    }

    private void insertOrReplaceBinding(BufferBinding binding) {
        this.rebuild = true;
        for (int i = 0; i < this.bindings.size(); ++i) {
            BufferBinding entry = this.bindings.get(i);
            if (entry.target != binding.target || entry.index != binding.index) continue;
            this.bindings.set(i, binding);
            return;
        }
        this.bindings.add(binding);
    }

    public AutoBindingShader texture(String define, GlTexture texture) {
        return this.texture(define, -1, texture);
    }

    public AutoBindingShader texture(String define, int sampler, GlTexture texture) {
        return this.texture(Integer.parseInt(this.defines.get(define)), sampler, texture);
    }

    public AutoBindingShader texture(int unit, int sampler, GlTexture texture) {
        this.rebuild = true;
        for (int i = 0; i < this.textureBindings.size(); ++i) {
            TextureBinding entry = this.textureBindings.get(i);
            if (entry.unit != unit) continue;
            this.textureBindings.set(i, new TextureBinding(unit, sampler, texture));
            return this;
        }
        this.textureBindings.add(new TextureBinding(unit, sampler, texture));
        return this;
    }

    @Override
    public void bind() {
        super.bind();
        if (!this.bindings.isEmpty()) {
            for (BufferBinding bufferBinding : this.bindings) {
                bufferBinding.buffer.assertNotFreed();
                if (bufferBinding.offset == 0L && bufferBinding.size == -1L) {
                    GL30.glBindBufferBase((int)bufferBinding.target, (int)bufferBinding.index, (int)bufferBinding.buffer.id);
                    continue;
                }
                GL30.glBindBufferRange((int)bufferBinding.target, (int)bufferBinding.index, (int)bufferBinding.buffer.id, (long)bufferBinding.offset, (long)bufferBinding.size);
            }
        }
        if (!this.textureBindings.isEmpty()) {
            for (TextureBinding textureBinding : this.textureBindings) {
                if (textureBinding.texture != null) {
                    textureBinding.texture.assertNotFreed();
                    ARBDirectStateAccess.glBindTextureUnit((int)textureBinding.unit, (int)textureBinding.texture.id);
                }
                if (textureBinding.sampler == -1) continue;
                GL33.glBindSampler((int)textureBinding.unit, (int)textureBinding.sampler);
            }
        }
    }

    private record BufferBinding(int target, int index, GlBuffer buffer, long offset, long size) {
    }

    private record TextureBinding(int unit, int sampler, GlTexture texture) {
    }
}

