/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import java.util.Arrays;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45C;

public class GlVertexArray
extends TrackedObject {
    public static final int STATIC_VAO = GL30.glGenVertexArrays();
    public final int id;
    private int[] indices = new int[0];
    private int stride;

    public GlVertexArray() {
        this.id = GL45C.glCreateVertexArrays();
    }

    @Override
    public void free() {
        this.free0();
        GL45C.glDeleteVertexArrays((int)this.id);
    }

    public void bind() {
        GL45C.glBindVertexArray((int)this.id);
    }

    public GlVertexArray bindBuffer(int buffer) {
        for (int index : this.indices) {
            GL45C.glVertexArrayVertexBuffer((int)this.id, (int)index, (int)buffer, (long)0L, (int)this.stride);
        }
        return this;
    }

    public GlVertexArray bindElementBuffer(int buffer) {
        GL45C.glVertexArrayElementBuffer((int)this.id, (int)buffer);
        return this;
    }

    public GlVertexArray setStride(int stride) {
        this.stride = stride;
        return this;
    }

    public GlVertexArray setI(int index, int type, int count, int offset) {
        this.addIndex(index);
        GL45C.glEnableVertexArrayAttrib((int)this.id, (int)index);
        GL45C.glVertexArrayAttribIFormat((int)this.id, (int)index, (int)count, (int)type, (int)offset);
        return this;
    }

    public GlVertexArray setF(int index, int type, int count, int offset) {
        return this.setF(index, type, count, false, offset);
    }

    public GlVertexArray setF(int index, int type, int count, boolean normalize, int offset) {
        this.addIndex(index);
        GL45C.glEnableVertexArrayAttrib((int)this.id, (int)index);
        GL45C.glVertexArrayAttribFormat((int)this.id, (int)index, (int)count, (int)type, (boolean)normalize, (int)offset);
        return this;
    }

    private void addIndex(int index) {
        for (int i : this.indices) {
            if (i != index) continue;
            return;
        }
        this.indices = Arrays.copyOf(this.indices, this.indices.length + 1);
        this.indices[this.indices.length - 1] = index;
    }
}

