/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import java.util.Locale;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.common.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;

public class Capabilities {
    public static final Capabilities INSTANCE = new Capabilities();
    public final boolean repFragTest;
    public final boolean meshShaders;
    public final boolean INT64_t;
    public final long ssboMaxSize;
    public final boolean isMesa;
    public final boolean canQueryGpuMemory;
    public final long totalDedicatedMemory;
    public final long totalDynamicMemory;
    public final boolean compute;
    public final boolean indirectParameters;
    public final boolean isIntel;
    public final boolean subgroup;
    public final boolean sparseBuffer;
    public final boolean isNvidia;
    public final boolean isAmd;
    public final boolean nvBarryCoords;
    public final boolean hasBrokenDepthSampler;

    public Capabilities() {
        GLCapabilities cap = GL.getCapabilities();
        this.sparseBuffer = cap.GL_ARB_sparse_buffer;
        this.compute = cap.glDispatchComputeIndirect != 0L;
        this.indirectParameters = cap.glMultiDrawElementsIndirectCountARB != 0L;
        this.repFragTest = cap.GL_NV_representative_fragment_test;
        this.meshShaders = cap.GL_NV_mesh_shader;
        this.canQueryGpuMemory = cap.GL_NVX_gpu_memory_info;
        this.INT64_t = Capabilities.testShaderCompilesOk(ShaderType.COMPUTE, "#version 430\n#extension GL_ARB_gpu_shader_int64 : require\nlayout(local_size_x=32) in;\nvoid main() {\n    uint64_t a = 1234;\n}\n");
        this.subgroup = cap.GL_KHR_shader_subgroup ? Capabilities.testShaderCompilesOk(ShaderType.COMPUTE, "#version 430\n#extension GL_KHR_shader_subgroup_basic : require\n#extension GL_KHR_shader_subgroup_arithmetic : require\nlayout(local_size_x=32) in;\nvoid main() {\n    uint a = subgroupExclusiveAdd(gl_LocalInvocationIndex);\n}\n") : false;
        this.ssboMaxSize = GL32.glGetInteger64((int)37086);
        this.isMesa = GL45C.glGetString((int)7938).toLowerCase(Locale.ROOT).contains("mesa");
        String vendor = GL45C.glGetString((int)7936).toLowerCase(Locale.ROOT);
        this.isIntel = vendor.contains("intel");
        this.isNvidia = vendor.contains("nvidia");
        boolean bl = this.isAmd = vendor.contains("amd") || vendor.contains("radeon");
        if (this.canQueryGpuMemory) {
            this.totalDedicatedMemory = GL32.glGetInteger64((int)36935) * 1024L;
            this.totalDynamicMemory = GL32.glGetInteger64((int)36936) * 1024L - this.totalDedicatedMemory;
        } else {
            this.totalDedicatedMemory = -1L;
            this.totalDynamicMemory = -1L;
        }
        this.nvBarryCoords = cap.GL_NV_fragment_shader_barycentric;
        if (this.compute && this.isAmd) {
            this.hasBrokenDepthSampler = Capabilities.testDepthSampler();
            if (this.hasBrokenDepthSampler) {
                throw new IllegalStateException("it bork, amd is bork");
            }
        } else {
            this.hasBrokenDepthSampler = false;
        }
    }

    public static void init() {
    }

    private static boolean testDepthSampler() {
        String src = "#version 460 core\nlayout(local_size_x=16,local_size_y=16) in;\n\nlayout(binding = 0) uniform sampler2D depthSampler;\nlayout(binding = 1) buffer OutData {\n    float[] outData;\n};\n\nlayout(location = 2) uniform int dynamicSampleThing;\nlayout(location = 3) uniform float sampleData;\n\nvoid main() {\n    if (abs(texelFetch(depthSampler, ivec2(gl_GlobalInvocationID.xy), dynamicSampleThing).r-sampleData)>0.000001f) {\n        outData[0] = 1.0;\n    }\n}\n";
        int program = GL20C.glCreateProgram();
        int shader = GL20C.glCreateShader((int)ShaderType.COMPUTE.gl);
        GL20C.glShaderSource((int)shader, (CharSequence)src);
        GL20C.glCompileShader((int)shader);
        if (GL20C.glGetShaderi((int)shader, (int)35713) != 1) {
            GL20C.glDeleteShader((int)shader);
            throw new IllegalStateException("Shader compile fail");
        }
        GL20C.glAttachShader((int)program, (int)shader);
        GL20C.glLinkProgram((int)program);
        GL45C.glDeleteShader((int)shader);
        int buffer = GL45C.glCreateBuffers();
        GL45C.glNamedBufferStorage((int)buffer, (long)4096L, (int)257);
        int tex = GL45C.glCreateTextures((int)3553);
        GL45C.glTextureStorage2D((int)tex, (int)2, (int)35056, (int)256, (int)256);
        GL45C.glTextureParameteri((int)tex, (int)10241, (int)9728);
        GL45C.glTextureParameteri((int)tex, (int)10240, (int)9728);
        int fb = GL45C.glCreateFramebuffers();
        boolean isCorrect = true;
        for (int lvl = 0; lvl <= 1; ++lvl) {
            GL45C.glNamedFramebufferTexture((int)fb, (int)33306, (int)tex, (int)lvl);
            for (int i = 0; i <= 10; ++i) {
                boolean localCorrect;
                float value = (float)((double)i / 10.0);
                GL45C.nglClearNamedBufferSubData((int)buffer, (int)33326, (long)0L, (long)4096L, (int)6403, (int)5126, (long)0L);
                GL45.glClearNamedFramebufferfi((int)fb, (int)34041, (int)0, (float)value, (int)1);
                GL45C.glUseProgram((int)program);
                GL45C.glUniform1i((int)2, (int)lvl);
                GL45C.glUniform1f((int)3, (float)value);
                GL45C.glBindTextureUnit((int)0, (int)tex);
                GL30.glBindBufferBase((int)37074, (int)1, (int)buffer);
                GL45C.glDispatchCompute((int)(256 >> lvl + 4), (int)(256 >> lvl + 4), (int)1);
                GL45C.glFinish();
                long ptr = GL45C.nglMapNamedBuffer((int)buffer, (int)35000);
                float gottenValue = MemoryUtil.memGetFloat((long)ptr);
                GL45C.glUnmapNamedBuffer((int)buffer);
                GL45C.glUseProgram((int)0);
                GL45C.glBindTextureUnit((int)0, (int)0);
                GL45C.glBindBuffer((int)37074, (int)0);
                boolean bl = localCorrect = gottenValue == 0.0f;
                if (!localCorrect) {
                    Logger.error("Depth read test failed at value: " + value);
                }
                isCorrect &= localCorrect;
            }
        }
        GL45C.glDeleteFramebuffers((int)fb);
        GL45C.glDeleteTextures((int)tex);
        GL15.glDeleteBuffers((int)buffer);
        GL45C.glDeleteProgram((int)program);
        return !isCorrect;
    }

    private static boolean testShaderCompilesOk(ShaderType type, String src) {
        int shader = GL20C.glCreateShader((int)type.gl);
        GL20C.glShaderSource((int)shader, (CharSequence)src);
        GL20C.glCompileShader((int)shader);
        int result = GL20C.glGetShaderi((int)shader, (int)35713);
        GL20C.glDeleteShader((int)shader);
        return result == 1;
    }

    public long getFreeDedicatedGpuMemory() {
        if (!this.canQueryGpuMemory) {
            throw new IllegalStateException("Cannot query gpu memory, missing extension");
        }
        return GL32.glGetInteger64((int)36937) * 1024L;
    }
}

