/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Arrays;
import java.util.List;
import me.cortex.voxy.client.TimingStatistics;
import me.cortex.voxy.client.VoxyClient;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.AbstractRenderPipeline;
import me.cortex.voxy.client.core.RenderPipelineFactory;
import me.cortex.voxy.client.core.gl.Capabilities;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.model.ModelBakerySubsystem;
import me.cortex.voxy.client.core.rendering.ChunkBoundRenderer;
import me.cortex.voxy.client.core.rendering.RenderDistanceTracker;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.rendering.ViewportSelector;
import me.cortex.voxy.client.core.rendering.building.RenderGenerationService;
import me.cortex.voxy.client.core.rendering.hierachical.AsyncNodeManager;
import me.cortex.voxy.client.core.rendering.hierachical.HierarchicalOcclusionTraverser;
import me.cortex.voxy.client.core.rendering.hierachical.NodeCleaner;
import me.cortex.voxy.client.core.rendering.section.IUsesMeshlets;
import me.cortex.voxy.client.core.rendering.section.backend.AbstractSectionRenderer;
import me.cortex.voxy.client.core.rendering.section.backend.mdic.MDICSectionRenderer;
import me.cortex.voxy.client.core.rendering.section.geometry.BasicSectionGeometryData;
import me.cortex.voxy.client.core.rendering.section.geometry.IGeometryData;
import me.cortex.voxy.client.core.rendering.util.DownloadStream;
import me.cortex.voxy.client.core.rendering.util.PrintfDebugUtil;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.client.core.util.GPUTiming;
import me.cortex.voxy.client.core.util.IrisUtil;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.world.WorldEngine;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.minecraft.class_310;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL33;

public class VoxyRenderSystem {
    private final WorldEngine worldIn;
    private final ModelBakerySubsystem modelService;
    private final RenderGenerationService renderGen;
    private final IGeometryData geometryData;
    private final AsyncNodeManager nodeManager;
    private final NodeCleaner nodeCleaner;
    private final HierarchicalOcclusionTraverser traversal;
    private final RenderDistanceTracker renderDistanceTracker;
    public final ChunkBoundRenderer chunkBoundRenderer;
    private final ViewportSelector<?> viewportSelector;
    private final AbstractRenderPipeline pipeline;

    private static AbstractSectionRenderer.Factory<?, ? extends IGeometryData> getRenderBackendFactory() {
        return MDICSectionRenderer.FACTORY;
    }

    public VoxyRenderSystem(WorldEngine world, ServiceManager sm) {
        int i;
        world.acquireRef();
        System.gc();
        if (class_310.method_1551().field_1690.method_38521() < 3) {
            Logger.warn("Having a vanilla render distance of 2 can cause rare culling near the edge of your screen issues, please use 3 or more");
        }
        int[] oldBufferBindings = new int[10];
        for (int i2 = 0; i2 < oldBufferBindings.length; ++i2) {
            oldBufferBindings[i2] = GL30C.glGetIntegeri((int)37075, (int)i2);
        }
        try {
            GL30C.glFinish();
            GL30C.glFinish();
            this.worldIn = world;
            long geometryCapacity = VoxyRenderSystem.getGeometryBufferSize();
            AbstractSectionRenderer.Factory<?, IGeometryData> backendFactory = VoxyRenderSystem.getRenderBackendFactory();
            this.modelService = new ModelBakerySubsystem(world.getMapper());
            this.renderGen = new RenderGenerationService(world, this.modelService, sm, IUsesMeshlets.class.isAssignableFrom(backendFactory.clz()));
            this.geometryData = new BasicSectionGeometryData(0x100000, geometryCapacity);
            this.nodeManager = new AsyncNodeManager(0x200000, this.geometryData, this.renderGen);
            this.nodeCleaner = new NodeCleaner(this.nodeManager);
            this.traversal = new HierarchicalOcclusionTraverser(this.nodeManager, this.nodeCleaner, this.renderGen);
            world.setDirtyCallback(this.nodeManager::worldEvent);
            Arrays.stream(world.getMapper().getBiomeEntries()).forEach(this.modelService::addBiome);
            world.getMapper().setBiomeCallback(this.modelService::addBiome);
            this.nodeManager.start();
            this.pipeline = RenderPipelineFactory.createPipeline(this.nodeManager, this.nodeCleaner, this.traversal, this::frexStillHasWork);
            this.pipeline.setupExtraModelBakeryData(this.modelService);
            AbstractSectionRenderer<?, IGeometryData> sectionRenderer = backendFactory.create(this.pipeline, this.modelService.getStore(), this.geometryData);
            this.pipeline.setSectionRenderer(sectionRenderer);
            this.viewportSelector = new ViewportSelector<Viewport>(sectionRenderer::createViewport);
            int minSec = class_310.method_1551().field_1687.method_32891() >> 5;
            int maxSec = class_310.method_1551().field_1687.method_31597() - 1 >> 5;
            this.renderDistanceTracker = new RenderDistanceTracker(20, minSec, maxSec, this.nodeManager::addTopLevel, this.nodeManager::removeTopLevel);
            this.setRenderDistance(VoxyConfig.CONFIG.sectionRenderDistance);
            this.chunkBoundRenderer = new ChunkBoundRenderer(this.pipeline);
            Logger.info("Voxy render system created with " + geometryCapacity + " geometry capacity, using pipeline '" + this.pipeline.getClass().getSimpleName() + "' with renderer '" + sectionRenderer.getClass().getSimpleName() + "'");
        }
        catch (RuntimeException e) {
            world.releaseRef();
            throw e;
        }
        for (i = 0; i < oldBufferBindings.length; ++i) {
            GL30C.glBindBufferBase((int)37074, (int)i, (int)oldBufferBindings[i]);
        }
        for (i = 0; i < 12; ++i) {
            GlStateManager._activeTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
            GL33.glBindSampler((int)i, (int)0);
        }
    }

    public Viewport<?> setupViewport(ChunkRenderMatrices matrices, FogParameters fogParameters, double cameraX, double cameraY, double cameraZ) {
        Viewport<?> viewport = this.getViewport();
        if (viewport == null) {
            return null;
        }
        Matrix4f projection = VoxyRenderSystem.computeProjectionMat(matrices.projection());
        int[] dims = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])dims);
        int width = dims[2];
        int height = dims[3];
        float[] factor = this.pipeline.getRenderScalingFactor();
        if (factor != null) {
            width = (int)((float)width * factor[0]);
            height = (int)((float)height * factor[1]);
        }
        ((Viewport)((Viewport)((Viewport)((Viewport)((Viewport)((Viewport)viewport.setVanillaProjection(matrices.projection())).setProjection(projection)).setModelView(new Matrix4f(matrices.modelView()))).setCamera(cameraX, cameraY, cameraZ)).setScreenSize(width, height)).setFogParameters(fogParameters)).update();
        if (VoxyClient.getOcclusionDebugState() == 0) {
            ++viewport.frameId;
        }
        return viewport;
    }

    public void renderOpaque(Viewport<?> viewport) {
        int i;
        int oldFB;
        if (viewport == null) {
            return;
        }
        TimingStatistics.resetSamplers();
        long startTime = System.nanoTime();
        TimingStatistics.all.start();
        GPUTiming.INSTANCE.marker();
        TimingStatistics.main.start();
        int[] oldBufferBindings = new int[10];
        for (int i2 = 0; i2 < oldBufferBindings.length; ++i2) {
            oldBufferBindings[i2] = GL30C.glGetIntegeri((int)37075, (int)i2);
        }
        int boundFB = oldFB = GL11.glGetInteger((int)36006);
        int[] dims = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])dims);
        GL30C.glViewport((int)0, (int)0, (int)viewport.width, (int)viewport.height);
        if (boundFB == 0) {
            throw new IllegalStateException("Cannot use the default framebuffer as cannot source from it");
        }
        this.pipeline.preSetup(viewport);
        TimingStatistics.E.start();
        if (!VoxyClient.disableSodiumChunkRender() && !IrisUtil.irisShadowActive()) {
            this.chunkBoundRenderer.render(viewport);
        } else {
            viewport.depthBoundingBuffer.clear(0.0f);
        }
        TimingStatistics.E.stop();
        GPUTiming.INSTANCE.marker();
        this.pipeline.runPipeline(viewport, boundFB, dims[2], dims[3]);
        GPUTiming.INSTANCE.marker();
        TimingStatistics.main.stop();
        TimingStatistics.postDynamic.start();
        PrintfDebugUtil.tick();
        UploadStream.INSTANCE.tick();
        while (this.renderDistanceTracker.setCenterAndProcess(viewport.cameraX, viewport.cameraZ) && VoxyClient.isFrexActive()) {
        }
        TimingStatistics.H.start();
        do {
            this.modelService.tick(900000L);
        } while (VoxyClient.isFrexActive() && !this.modelService.areQueuesEmpty());
        TimingStatistics.H.stop();
        GPUTiming.INSTANCE.marker();
        TimingStatistics.postDynamic.stop();
        GPUTiming.INSTANCE.tick();
        GL30C.glBindFramebuffer((int)36160, (int)oldFB);
        GL30C.glViewport((int)dims[0], (int)dims[1], (int)dims[2], (int)dims[3]);
        GL30C.glUseProgram((int)0);
        GL30C.glEnable((int)2929);
        GlStateManager._glBindVertexArray((int)0);
        GlStateManager._activeTexture((int)33985);
        for (i = 0; i < 12; ++i) {
            GlStateManager._activeTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
            GL33.glBindSampler((int)i, (int)0);
        }
        IrisUtil.clearIrisSamplers();
        for (i = 0; i < oldBufferBindings.length; ++i) {
            GL30C.glBindBufferBase((int)37074, (int)i, (int)oldBufferBindings[i]);
        }
        TimingStatistics.all.stop();
    }

    private void autoBalanceSubDivSize() {
        boolean canDecreaseSize = this.renderGen.getTaskCount() < 300;
        int MIN_FPS = 55;
        int MAX_FPS = 65;
        float INCREASE_PER_SECOND = 60.0f;
        float DECREASE_PER_SECOND = 30.0f;
        if (class_310.method_1551().method_47599() < MIN_FPS) {
            VoxyConfig.CONFIG.subDivisionSize = Math.min(VoxyConfig.CONFIG.subDivisionSize + INCREASE_PER_SECOND / Math.max(1.0f, (float)class_310.method_1551().method_47599()), 256.0f);
        }
        if (MAX_FPS < class_310.method_1551().method_47599() && canDecreaseSize) {
            VoxyConfig.CONFIG.subDivisionSize = Math.max(VoxyConfig.CONFIG.subDivisionSize - DECREASE_PER_SECOND / Math.max(1.0f, (float)class_310.method_1551().method_47599()), 28.0f);
        }
    }

    private static Matrix4f makeProjectionMatrix(float near, float far) {
        Matrix4f projection = new Matrix4f();
        class_310 client = class_310.method_1551();
        class_757 gameRenderer = client.field_1773;
        float fov = gameRenderer.method_3196(gameRenderer.method_19418(), client.method_61966().method_60637(true), true);
        projection.setPerspective(fov * ((float)Math.PI / 180), (float)client.method_22683().method_4489() / (float)client.method_22683().method_4506(), near, far);
        return projection;
    }

    private static Matrix4f computeProjectionMat(Matrix4fc base) {
        float nearVoxy = class_310.method_1551().field_1773.method_3193() <= 32.0f ? 8.0f : 16.0f;
        nearVoxy = VoxyClient.disableSodiumChunkRender() ? 0.1f : nearVoxy;
        return base.mulLocal((Matrix4fc)VoxyRenderSystem.makeProjectionMatrix(0.05f, class_310.method_1551().field_1773.method_32796()).invert(), new Matrix4f()).mulLocal((Matrix4fc)VoxyRenderSystem.makeProjectionMatrix(nearVoxy, 48000.0f));
    }

    private boolean frexStillHasWork() {
        if (!VoxyClient.isFrexActive()) {
            return false;
        }
        UploadStream.INSTANCE.tick();
        this.modelService.tick(100000000L);
        GL11.glFinish();
        return this.nodeManager.hasWork() || this.renderGen.getTaskCount() != 0 || !this.modelService.areQueuesEmpty();
    }

    public void setRenderDistance(int renderDistance) {
        this.renderDistanceTracker.setRenderDistance(renderDistance);
    }

    public Viewport<?> getViewport() {
        if (IrisUtil.irisShadowActive()) {
            return null;
        }
        return this.viewportSelector.getViewport();
    }

    public void addDebugInfo(List<String> debug) {
        debug.add("Buf/Tex [#/Mb]: [" + GlBuffer.getCount() + "/" + GlBuffer.getTotalSize() / 1000000L + "],[" + GlTexture.getCount() + "/" + GlTexture.getEstimatedTotalSize() / 1000000L + "]");
        this.modelService.addDebugData(debug);
        this.renderGen.addDebugData(debug);
        this.nodeManager.addDebug(debug);
        this.pipeline.addDebug(debug);
        TimingStatistics.update();
        debug.add("Voxy frame runtime (millis): " + TimingStatistics.dynamic.pVal() + ", " + TimingStatistics.main.pVal() + ", " + TimingStatistics.postDynamic.pVal() + ", " + TimingStatistics.all.pVal());
        debug.add("Extra time: " + TimingStatistics.A.pVal() + ", " + TimingStatistics.B.pVal() + ", " + TimingStatistics.C.pVal() + ", " + TimingStatistics.D.pVal());
        debug.add("Extra 2 time: " + TimingStatistics.E.pVal() + ", " + TimingStatistics.F.pVal() + ", " + TimingStatistics.G.pVal() + ", " + TimingStatistics.H.pVal() + ", " + TimingStatistics.I.pVal());
        debug.add(GPUTiming.INSTANCE.getDebug());
        PrintfDebugUtil.addToOut(debug);
    }

    public void shutdown() {
        Logger.info("Flushing download stream");
        DownloadStream.INSTANCE.flushWaitClear();
        Logger.info("Shutting down rendering");
        try {
            this.worldIn.setDirtyCallback(null);
            this.worldIn.getMapper().setBiomeCallback(null);
            this.worldIn.getMapper().setStateCallback(null);
            this.nodeManager.stop();
            this.modelService.shutdown();
            this.renderGen.shutdown();
            this.traversal.free();
            this.nodeCleaner.free();
            this.geometryData.free();
            this.chunkBoundRenderer.free();
            this.viewportSelector.free();
        }
        catch (Exception e) {
            Logger.error("Error shutting down renderer components", e);
        }
        Logger.info("Shutting down render pipeline");
        try {
            this.pipeline.free();
        }
        catch (Exception e) {
            Logger.error("Error releasing render pipeline", e);
        }
        Logger.info("Flushing download stream");
        DownloadStream.INSTANCE.flushWaitClear();
        this.worldIn.releaseRef();
        Logger.info("Render shutdown completed");
    }

    private static long getGeometryBufferSize() {
        String override;
        long geometryCapacity = Math.min(1L << 64 - Long.numberOfLeadingZeros(Capabilities.INSTANCE.ssboMaxSize - 1L) << 1, 0x100000000L) - 1024L;
        if (Capabilities.INSTANCE.isIntel) {
            geometryCapacity = Math.max(geometryCapacity, 0x40000000L);
        }
        if (Capabilities.INSTANCE.canQueryGpuMemory) {
            long limit = Capabilities.INSTANCE.getFreeDedicatedGpuMemory() - 0x60000000L;
            limit = Math.max(0x20000000L, limit);
            geometryCapacity = Math.min(geometryCapacity, limit);
        }
        if (!(override = System.getProperty("voxy.geometryBufferSizeOverrideMB", "")).isEmpty()) {
            geometryCapacity = Long.parseLong(override) * 1024L * 1024L;
        }
        return geometryCapacity;
    }

    public WorldEngine getEngine() {
        return this.worldIn;
    }
}

