/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core;

import java.util.List;
import java.util.function.BooleanSupplier;
import me.cortex.voxy.client.RenderStatistics;
import me.cortex.voxy.client.TimingStatistics;
import me.cortex.voxy.client.VoxyClient;
import me.cortex.voxy.client.core.model.ModelBakerySubsystem;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.rendering.hierachical.AsyncNodeManager;
import me.cortex.voxy.client.core.rendering.hierachical.HierarchicalOcclusionTraverser;
import me.cortex.voxy.client.core.rendering.hierachical.NodeCleaner;
import me.cortex.voxy.client.core.rendering.post.FullscreenBlit;
import me.cortex.voxy.client.core.rendering.section.backend.AbstractSectionRenderer;
import me.cortex.voxy.client.core.rendering.util.DepthFramebuffer;
import me.cortex.voxy.client.core.rendering.util.DownloadStream;
import me.cortex.voxy.common.util.TrackedObject;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryUtil;

public abstract class AbstractRenderPipeline
extends TrackedObject {
    private final BooleanSupplier frexStillHasWork;
    private final AsyncNodeManager nodeManager;
    private final NodeCleaner nodeCleaner;
    private final HierarchicalOcclusionTraverser traversal;
    protected AbstractSectionRenderer<?, ?> sectionRenderer;
    private final FullscreenBlit depthMaskBlit = new FullscreenBlit("voxy:post/fullscreen2.vert", "voxy:post/noop.frag");
    private final FullscreenBlit depthSetBlit = new FullscreenBlit("voxy:post/fullscreen2.vert", "voxy:post/depth0.frag");
    private final FullscreenBlit depthCopy = new FullscreenBlit("voxy:post/fullscreen2.vert", "voxy:post/depth_copy.frag");
    public final DepthFramebuffer fb = new DepthFramebuffer(35056);
    protected final boolean deferTranslucency;
    private static final int DEPTH_SAMPLER = GL42.glGenSamplers();
    private static final long SCRATCH;

    protected AbstractRenderPipeline(AsyncNodeManager nodeManager, NodeCleaner nodeCleaner, HierarchicalOcclusionTraverser traversal, BooleanSupplier frexSupplier, boolean deferTranslucency) {
        this.frexStillHasWork = frexSupplier;
        this.nodeManager = nodeManager;
        this.nodeCleaner = nodeCleaner;
        this.traversal = traversal;
        this.deferTranslucency = deferTranslucency;
    }

    public void setupExtraModelBakeryData(ModelBakerySubsystem modelService) {
    }

    public final void setSectionRenderer(AbstractSectionRenderer<?, ?> sectionRenderer) {
        if (this.sectionRenderer != null) {
            throw new IllegalStateException();
        }
        this.sectionRenderer = sectionRenderer;
    }

    public void preSetup(Viewport<?> viewport) {
    }

    protected abstract int setup(Viewport<?> var1, int var2, int var3, int var4);

    protected abstract void postOpaquePreTranslucent(Viewport<?> var1);

    protected void finish(Viewport<?> viewport, int sourceFrameBuffer, int srcWidth, int srcHeight) {
        GL11C.glDisable((int)2960);
        GL30C.glBindFramebuffer((int)36160, (int)sourceFrameBuffer);
    }

    public void runPipeline(Viewport<?> viewport, int sourceFrameBuffer, int srcWidth, int srcHeight) {
        int depthTexture = this.setup(viewport, sourceFrameBuffer, srcWidth, srcHeight);
        AbstractSectionRenderer<?, ?> rs = this.sectionRenderer;
        rs.renderOpaque(viewport);
        int occlusionDebug = VoxyClient.getOcclusionDebugState();
        if (occlusionDebug == 0) {
            this.innerPrimaryWork(viewport, depthTexture);
        }
        if (occlusionDebug <= 1) {
            rs.buildDrawCalls(viewport);
        }
        rs.renderTemporal(viewport);
        this.postOpaquePreTranslucent(viewport);
        if (!this.deferTranslucency) {
            rs.renderTranslucent(viewport);
        }
        this.finish(viewport, sourceFrameBuffer, srcWidth, srcHeight);
        GL30C.glBindFramebuffer((int)36160, (int)sourceFrameBuffer);
    }

    protected void initDepthStencil(int sourceFrameBuffer, int targetFb, int srcWidth, int srcHeight, int width, int height) {
        GL45.glClearNamedFramebufferfi((int)targetFb, (int)34041, (int)0, (float)1.0f, (int)1);
        GL30C.glBindFramebuffer((int)36160, (int)targetFb);
        this.depthCopy.bind();
        int depthTexture = GL45.glGetNamedFramebufferAttachmentParameteri((int)sourceFrameBuffer, (int)36096, (int)36049);
        GL45C.glBindTextureUnit((int)0, (int)depthTexture);
        GL42.glBindSampler((int)0, (int)DEPTH_SAMPLER);
        GL42.glUniform2f((int)1, (float)((float)width / (float)srcWidth), (float)((float)height / (float)srcHeight));
        GL11C.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.depthCopy.blit();
        GL11C.glEnable((int)2960);
        GL11C.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11C.glStencilFunc((int)519, (int)0, (int)255);
        GL11C.glStencilMask((int)255);
        GL11C.glEnable((int)2929);
        GL42.glDepthFunc((int)517);
        this.depthMaskBlit.blit();
        GL11C.glDisable((int)2929);
        GL11C.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11C.glStencilFunc((int)514, (int)0, (int)255);
        this.depthSetBlit.blit();
        GL42.glDepthFunc((int)515);
        GL11C.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11C.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11C.glStencilFunc((int)514, (int)1, (int)255);
    }

    protected static void transformBlitDepth(FullscreenBlit blitShader, int srcDepthTex, int dstFB, Viewport<?> viewport, Matrix4f targetTransform) {
        GL11C.glDisable((int)2960);
        GL30C.glBindFramebuffer((int)36160, (int)dstFB);
        blitShader.bind();
        GL45C.glBindTextureUnit((int)0, (int)srcDepthTex);
        new Matrix4f((Matrix4fc)viewport.MVP).invert().getToAddress(SCRATCH);
        GL42.nglUniformMatrix4fv((int)1, (int)1, (boolean)false, (long)SCRATCH);
        targetTransform.getToAddress(SCRATCH);
        GL42.nglUniformMatrix4fv((int)2, (int)1, (boolean)false, (long)SCRATCH);
        GL11C.glEnable((int)2929);
        blitShader.blit();
        GL11C.glDisable((int)2960);
        GL11C.glDisable((int)2929);
    }

    protected void innerPrimaryWork(Viewport<?> viewport, int depthBuffer) {
        viewport.hiZBuffer.buildMipChain(depthBuffer, viewport.width, viewport.height);
        do {
            TimingStatistics.main.stop();
            TimingStatistics.dynamic.start();
            TimingStatistics.D.start();
            DownloadStream.INSTANCE.tick();
            TimingStatistics.D.stop();
            this.nodeManager.tick(this.traversal.getNodeBuffer(), this.nodeCleaner);
            this.nodeCleaner.tick(this.traversal.getNodeBuffer());
            TimingStatistics.dynamic.stop();
            TimingStatistics.main.start();
            GL42.glMemoryBarrier((int)1152);
            TimingStatistics.F.start();
            this.traversal.doTraversal(viewport);
            TimingStatistics.F.stop();
        } while (this.frexStillHasWork.getAsBoolean());
    }

    @Override
    protected void free0() {
        this.fb.free();
        this.sectionRenderer.free();
        this.depthMaskBlit.delete();
        this.depthSetBlit.delete();
        this.depthCopy.delete();
        super.free0();
    }

    public void addDebug(List<String> debug) {
        this.sectionRenderer.addDebug(debug);
        RenderStatistics.addDebug(debug);
    }

    public abstract void setupAndBindOpaque(Viewport<?> var1);

    public abstract void setupAndBindTranslucent(Viewport<?> var1);

    public void bindUniforms() {
        this.bindUniforms(-1);
    }

    public void bindUniforms(int index) {
    }

    public String taaFunction(String functionName) {
        return this.taaFunction(-1, functionName);
    }

    public String taaFunction(int uboBindingPoint, String functionName) {
        return null;
    }

    public String patchOpaqueShader(AbstractSectionRenderer<?, ?> renderer, String input) {
        return null;
    }

    public String patchTranslucentShader(AbstractSectionRenderer<?, ?> renderer, String input) {
        return null;
    }

    public float[] getRenderScalingFactor() {
        return null;
    }

    static {
        GL42.glSamplerParameteri((int)DEPTH_SAMPLER, (int)10240, (int)9728);
        GL42.glSamplerParameteri((int)DEPTH_SAMPLER, (int)10241, (int)9728);
        SCRATCH = MemoryUtil.nmemAlloc((long)64L);
    }
}

