/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.config;

import me.cortex.voxy.client.RenderStatistics;
import me.cortex.voxy.client.VoxyClientInstance;
import me.cortex.voxy.client.config.SodiumConfigBuilder;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.common.util.cpu.CpuLayout;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.VoxyInstance;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class VoxyConfigMenu
implements ConfigEntryPoint {
    private static final int SUBDIV_IN_MAX = 100;
    private static final double SUBDIV_MIN = 28.0;
    private static final double SUBDIV_MAX = 256.0;
    private static final double SUBDIV_CONST = Math.log(9.142857142857142) / Math.log(2.0);

    public void registerConfigLate(ConfigBuilder B2) {
        VoxyConfig CFG = VoxyConfig.CONFIG;
        ModOptionsBuilder cc = B2.registerModOptions("voxy", "Voxy", VoxyCommon.MOD_VERSION).setIcon(class_2960.method_60654((String)"voxy:icon.png"));
        SodiumConfigBuilder.buildToSodium(B2, cc, CFG::save, postOp -> postOp.register("voxy:update_threads", () -> {
            VoxyInstance instance = VoxyCommon.getInstance();
            if (instance != null) {
                instance.updateDedicatedThreads();
            }
        }, "voxy:enabled"), (SodiumConfigBuilder.Page)new SodiumConfigBuilder.Page((class_2561)class_2561.method_43471((String)"voxy.config.general"), new SodiumConfigBuilder.Group((SodiumConfigBuilder.Option)((SodiumConfigBuilder.BoolOption)new SodiumConfigBuilder.BoolOption("voxy:enabled", (class_2561)class_2561.method_43471((String)"voxy.config.general.enabled"), () -> CFG.enabled, v -> {
            CFG.enabled = v;
        }).setPostChangeRunner(c -> {
            if (c.booleanValue()) {
                if (VoxyClientInstance.isInGame) {
                    VoxyCommon.createInstance();
                    IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
                    if (vrsh != null && CFG.enableRendering) {
                        vrsh.createRenderer();
                    }
                }
            } else {
                IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
                if (vrsh != null) {
                    vrsh.shutdownRenderer();
                }
                VoxyCommon.shutdownInstance();
            }
        }, new String[0])).setEnabler(null)), new SodiumConfigBuilder.Group(new SodiumConfigBuilder.Option[]{new SodiumConfigBuilder.IntOption("voxy:thread_count", (class_2561)class_2561.method_43471((String)"voxy.config.general.serviceThreads"), () -> CFG.serviceThreads, v -> {
            CFG.serviceThreads = v;
        }, new Range(1, CpuLayout.getCoreCount(), 1)).setPostChangeFlags("voxy:update_threads"), new SodiumConfigBuilder.BoolOption("voxy:use_sodium_threads", (class_2561)class_2561.method_43471((String)"voxy.config.general.useSodiumBuilder"), () -> !CFG.dontUseSodiumBuilderThreads, v -> {
            CFG.dontUseSodiumBuilderThreads = v == false;
        }).setPostChangeFlags("voxy:update_threads")}), new SodiumConfigBuilder.Group(new SodiumConfigBuilder.BoolOption("voxy:ingest_enabled", (class_2561)class_2561.method_43471((String)"voxy.config.general.ingest"), () -> CFG.ingestEnabled, v -> {
            CFG.ingestEnabled = v;
        }))).setEnabler("voxy:enabled"), (SodiumConfigBuilder.Page)new SodiumConfigBuilder.Page((class_2561)class_2561.method_43471((String)"voxy.config.rendering"), new SodiumConfigBuilder.Group((SodiumConfigBuilder.Option)((SodiumConfigBuilder.BoolOption)new SodiumConfigBuilder.BoolOption("voxy:rendering", (class_2561)class_2561.method_43471((String)"voxy.config.general.rendering"), () -> CFG.enableRendering, v -> {
            CFG.enableRendering = v;
        }).setPostChangeRunner(c -> {
            IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
            if (vrsh != null) {
                if (c.booleanValue()) {
                    vrsh.createRenderer();
                } else {
                    vrsh.shutdownRenderer();
                }
            }
        }, "voxy:enabled", "voxy:renderer_reload")).setEnabler("voxy:enabled")), new SodiumConfigBuilder.Group(new SodiumConfigBuilder.Option[]{new SodiumConfigBuilder.IntOption("voxy:subdivsize", (class_2561)class_2561.method_43471((String)"voxy.config.general.subDivisionSize"), () -> VoxyConfigMenu.subDiv2ln(CFG.subDivisionSize), v -> {
            CFG.subDivisionSize = VoxyConfigMenu.ln2subDiv(v);
        }, new Range(0, 100, 1)).setFormatter(v -> class_2561.method_43470((String)Integer.toString(Math.round(VoxyConfigMenu.ln2subDiv(v))))), new SodiumConfigBuilder.IntOption("voxy:render_distance", (class_2561)class_2561.method_43471((String)"voxy.config.general.renderDistance"), () -> CFG.sectionRenderDistance, v -> {
            CFG.sectionRenderDistance = v;
        }, new Range(2, 64, 1)).setFormatter(v -> class_2561.method_43470((String)Integer.toString(v * 32))).setPostChangeRunner(c -> {
            VoxyRenderSystem vrs;
            IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
            if (vrsh != null && (vrs = vrsh.getVoxyRenderSystem()) != null) {
                vrs.setRenderDistance((int)c);
            }
        }, "voxy:rendering", "voxy:renderer_reload")}), new SodiumConfigBuilder.Group(new SodiumConfigBuilder.Option[]{new SodiumConfigBuilder.BoolOption("voxy:eviromental_fog", (class_2561)class_2561.method_43471((String)"voxy.config.general.environmental_fog"), () -> CFG.useEnvironmentalFog, v -> {
            CFG.useEnvironmentalFog = v;
        }).setPostChangeFlags(OptionFlag.REQUIRES_RENDERER_RELOAD.getId().toString())}), new SodiumConfigBuilder.Group(new SodiumConfigBuilder.Option[]{new SodiumConfigBuilder.BoolOption("voxy:render_debug", (class_2561)class_2561.method_43471((String)"voxy.config.general.render_statistics"), () -> RenderStatistics.enabled, v -> {
            RenderStatistics.enabled = v;
        }).setPostChangeFlags(OptionFlag.REQUIRES_RENDERER_RELOAD.getId().toString())})).setEnablerAND("voxy:enabled", "voxy:rendering"));
    }

    private static float ln2subDiv(int in) {
        return (float)(28.0 * Math.pow(2.0, SUBDIV_CONST * ((double)in / 100.0)));
    }

    private static int subDiv2ln(float in) {
        return (int)(Math.log((double)in / 28.0) / Math.log(2.0) / SUBDIV_CONST * 100.0);
    }
}

