/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.cpu.CpuLayout;
import me.cortex.voxy.commonImpl.VoxyCommon;
import net.fabricmc.loader.api.FabricLoader;

public class VoxyConfig {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public static VoxyConfig CONFIG = VoxyConfig.loadOrCreate();
    public boolean enabled = true;
    public boolean enableRendering = true;
    public boolean ingestEnabled = true;
    public int sectionRenderDistance = 16;
    public int serviceThreads = (int)Math.max((double)CpuLayout.getCoreCount() / 1.5, 1.0);
    public float subDivisionSize = 64.0f;
    public boolean useEnvironmentalFog = true;
    public boolean dontUseSodiumBuilderThreads = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static VoxyConfig loadOrCreate() {
        if (!VoxyCommon.isAvailable()) {
            VoxyConfig config = new VoxyConfig();
            config.enabled = false;
            config.enableRendering = false;
            return config;
        }
        Path path = VoxyConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (FileReader reader = new FileReader(path.toFile());){
                VoxyConfig conf = (VoxyConfig)GSON.fromJson((Reader)reader, VoxyConfig.class);
                if (conf != null) {
                    conf.save();
                    VoxyConfig voxyConfig = conf;
                    return voxyConfig;
                }
                Logger.error("Failed to load voxy config, resetting");
            }
            catch (IOException e) {
                Logger.error("Could not parse config", e);
            }
        }
        VoxyConfig config = new VoxyConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.writeString(VoxyConfig.getConfigPath(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error("Failed to write config file", e);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("voxy-config.json");
    }

    public boolean isRenderingEnabled() {
        return VoxyCommon.isAvailable() && this.enabled && this.enableRendering;
    }
}

