/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.ControlValueFormatter;
import net.caffeinemc.mods.sodium.api.config.option.FlagHook;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.api.config.structure.BooleanOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.IntegerOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionGroupBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.StatefulOptionBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class SodiumConfigBuilder {
    private static <F, T> T[] map(F[] from, Function<F, T> mapper, Function<Integer, T[]> factory) {
        T[] arr = factory.apply(from.length);
        for (int i = 0; i < from.length; ++i) {
            arr[i] = mapper.apply(from[i]);
        }
        return arr;
    }

    private static class_2960[] mapIds(String[] strings) {
        return SodiumConfigBuilder.map(strings, class_2960::method_60654, class_2960[]::new);
    }

    public static void buildToSodium(ConfigBuilder builder, ModOptionsBuilder options, StorageEventHandler saveHandler, Consumer<PostApplyOps> registerOps, Page ... pages) {
        BuildCtx ctx = new BuildCtx();
        registerOps.accept(ctx.postRunner);
        ctx.saveHandler = saveHandler;
        for (Page page : pages) {
            options.addPage((PageBuilder)page.create(builder, ctx));
        }
        options.registerFlagHook((FlagHook)ctx.postRunner.build());
    }

    private static final class BuildCtx {
        public PostApplyOps postRunner = new PostApplyOps();
        public StorageEventHandler saveHandler;

        private BuildCtx() {
        }
    }

    public static class PostApplyOps
    implements FlagHook {
        private Map<class_2960, Hook> hooks = new LinkedHashMap<class_2960, Hook>();

        public PostApplyOps register(String name, Runnable postRunner, String ... conflicts) {
            return this.register(class_2960.method_60654((String)name), postRunner, SodiumConfigBuilder.mapIds(conflicts));
        }

        public PostApplyOps register(class_2960 name, Runnable postRunner, class_2960 ... conflicts) {
            this.hooks.put(name, new Hook(name, postRunner, new LinkedHashSet<class_2960>(List.of(conflicts))));
            return this;
        }

        protected PostApplyOps build() {
            boolean changed = false;
            do {
                changed = false;
                for (Hook hook : this.hooks.values()) {
                    for (class_2960 ref : new LinkedHashSet<class_2960>(hook.conflicts)) {
                        Hook other = this.hooks.getOrDefault(ref, null);
                        if (other == null) continue;
                        changed |= hook.conflicts.addAll(other.conflicts);
                    }
                }
            } while (changed);
            return this;
        }

        public Collection<class_2960> getTriggers() {
            return this.hooks.keySet();
        }

        public void accept(Collection<class_2960> identifiers, ConfigState configState) {
            for (class_2960 id : identifiers) {
                Hook hook = this.hooks.get(id);
                if (hook == null || !Collections.disjoint(identifiers, hook.conflicts)) continue;
                hook.runnable.run();
            }
        }

        private record Hook(class_2960 name, Runnable runnable, Set<class_2960> conflicts) {
        }
    }

    public static class Page
    extends Enableable<Page> {
        protected class_2561 name;
        protected Group[] groups;

        public Page(class_2561 name, Group ... groups) {
            this.name = name;
            this.groups = groups;
        }

        protected OptionPageBuilder create(ConfigBuilder builder, BuildCtx ctx) {
            OptionPageBuilder page = builder.createOptionPage();
            page.setName(this.name);
            for (Group group : this.groups) {
                page.addOptionGroup(group.create(builder, ctx));
            }
            return page;
        }

        @Override
        protected Enableable[] getEnablerChildren() {
            return this.groups;
        }
    }

    public static class BoolOption
    extends Option<Boolean, BoolOption, BooleanOptionBuilder> {
        public BoolOption(String id, class_2561 name, class_2561 tooltip, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            super(id, name, tooltip, getter, setter);
        }

        public BoolOption(String id, class_2561 name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            super(id, name, getter, setter);
        }

        @Override
        protected BooleanOptionBuilder createType(ConfigBuilder builder) {
            return builder.createBooleanOption(class_2960.method_60654((String)this.id));
        }
    }

    public static class IntOption
    extends Option<Integer, IntOption, IntegerOptionBuilder> {
        protected Function<ConfigState, Range> rangeProvider;
        protected String[] rangeDependencies;
        protected ControlValueFormatter formatter = v -> class_2561.method_43470((String)Integer.toString(v));

        public IntOption(String id, class_2561 name, class_2561 tooltip, Supplier<Integer> getter, Consumer<Integer> setter, Range range) {
            super(id, name, tooltip, getter, setter);
            this.rangeProvider = s -> range;
        }

        public IntOption(String id, class_2561 name, Supplier<Integer> getter, Consumer<Integer> setter, Range range) {
            super(id, name, getter, setter);
            this.rangeProvider = s -> range;
        }

        public IntOption setFormatter(IntFunction<class_2561> formatter) {
            this.formatter = v -> (class_2561)formatter.apply(v);
            return this;
        }

        @Override
        protected IntegerOptionBuilder createType(ConfigBuilder builder) {
            return builder.createIntegerOption(class_2960.method_60654((String)this.id));
        }

        @Override
        protected IntegerOptionBuilder create(ConfigBuilder builder, BuildCtx ctx) {
            IntegerOptionBuilder option = (IntegerOptionBuilder)super.create(builder, ctx);
            if (this.rangeDependencies == null || this.rangeDependencies.length == 0) {
                option.setRange(this.rangeProvider.apply(null));
            } else {
                option.setRangeProvider(this.rangeProvider, SodiumConfigBuilder.mapIds(this.rangeDependencies));
            }
            option.setValueFormatter(this.formatter);
            return option;
        }
    }

    public static abstract class Option<TYPE, OPTION extends Option<TYPE, OPTION, STYPE>, STYPE extends StatefulOptionBuilder<TYPE>>
    extends Enableable<Option<TYPE, OPTION, STYPE>> {
        protected String id;
        protected class_2561 name;
        protected class_2561 tooltip;
        protected Supplier<TYPE> getter;
        protected Consumer<TYPE> setter;
        protected Consumer<TYPE> postRunner;
        protected class_2960[] postRunnerConflicts;
        protected class_2960[] postChangeFlags;

        public Option(String id, class_2561 name, class_2561 tooltip, Supplier<TYPE> getter, Consumer<TYPE> setter) {
            this.id = id;
            this.name = name;
            this.tooltip = tooltip;
            this.getter = getter;
            this.setter = setter;
        }

        public Option(String id, class_2561 name, Supplier<TYPE> getter, Consumer<TYPE> setter) {
            this.id = id;
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            class_7417 class_74172 = name.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 tc = (class_2588)class_74172;
                this.tooltip = class_2561.method_43471((String)(tc.method_11022() + ".tooltip"));
            } else {
                this.tooltip = name;
            }
        }

        public OPTION setPostChangeRunner(Consumer<TYPE> postRunner, String ... dontRunIfChangedVars) {
            if (this.postChangeFlags != null) {
                throw new IllegalStateException();
            }
            this.postRunner = postRunner;
            this.postRunnerConflicts = SodiumConfigBuilder.mapIds(dontRunIfChangedVars);
            return (OPTION)this;
        }

        public OPTION setPostChangeFlags(String ... flags) {
            if (this.postRunner != null) {
                throw new IllegalStateException();
            }
            this.postChangeFlags = SodiumConfigBuilder.mapIds(flags);
            return (OPTION)this;
        }

        protected abstract STYPE createType(ConfigBuilder var1);

        protected STYPE create(ConfigBuilder builder, BuildCtx ctx) {
            STYPE option = this.createType(builder);
            option.setName(this.name);
            option.setTooltip(this.tooltip);
            if (this.postRunner != null) {
                class_2960 id = class_2960.method_60654((String)this.id);
                Consumer runner = this.postRunner;
                Supplier getter = this.getter;
                ctx.postRunner.register(id, () -> runner.accept(getter.get()), this.postRunnerConflicts);
                option.setFlags(new class_2960[]{id});
            } else if (this.postChangeFlags != null) {
                option.setFlags(this.postChangeFlags);
            }
            option.setBinding(this.setter, this.getter);
            if (this.enabler != null) {
                Predicate<ConfigState> pred = this.enabler.tester;
                option.setEnabledProvider(s -> pred.test((ConfigState)s), this.enabler.dependencies);
            }
            option.setStorageHandler(ctx.saveHandler);
            option.setDefaultValue(this.getter.get());
            return option;
        }
    }

    public static class Group
    extends Enableable<Group> {
        protected Option[] options;

        public Group(Option ... options) {
            this.options = options;
        }

        protected OptionGroupBuilder create(ConfigBuilder builder, BuildCtx ctx) {
            OptionGroupBuilder group = builder.createOptionGroup();
            for (Option option : this.options) {
                group.addOption(option.create(builder, ctx));
            }
            return group;
        }

        @Override
        protected Enableable[] getEnablerChildren() {
            return this.options;
        }
    }

    public static abstract class Enableable<TYPE extends Enableable<TYPE>> {
        @Nullable
        private Enabler prevEnabler;
        @Nullable
        protected Enabler enabler;

        private TYPE setEnabler0(Enabler enabler) {
            this.prevEnabler = this.enabler;
            this.enabler = enabler;
            Enableable[] children = this.getEnablerChildren();
            if (children != null) {
                for (Enableable child : children) {
                    if (child.enabler != null && child.enabler != this.prevEnabler) continue;
                    child.setEnabler0(this.enabler);
                }
            }
            return (TYPE)this;
        }

        public TYPE setEnabler(Predicate<ConfigState> enabler, String ... dependencies) {
            return this.setEnabler0(new Enabler(enabler, dependencies));
        }

        public TYPE setEnabler(String enabler) {
            if (enabler == null) {
                return this.setEnabler(s -> true, new String[0]);
            }
            class_2960 id = class_2960.method_60654((String)enabler);
            return this.setEnabler(s -> s.readBooleanOption(id), enabler);
        }

        public TYPE setEnablerAND(String ... enablers) {
            class_2960[] enablersId = SodiumConfigBuilder.mapIds(enablers);
            return this.setEnabler0(new Enabler(s -> {
                for (class_2960 id : enablersId) {
                    if (s.readBooleanOption(id)) continue;
                    return false;
                }
                return true;
            }, enablersId));
        }

        protected Enableable[] getEnablerChildren() {
            return null;
        }
    }

    private record Enabler(Predicate<ConfigState> tester, class_2960[] dependencies) {
        public Enabler(Predicate<ConfigState> tester, String[] dependencies) {
            this(tester, SodiumConfigBuilder.mapIds(dependencies));
        }
    }
}

