/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client;

import java.util.HashSet;
import java.util.function.Consumer;
import me.cortex.voxy.client.VoxyClientInstance;
import me.cortex.voxy.client.VoxyCommands;
import me.cortex.voxy.client.VoxyDebugScreenEntry;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.client.core.gl.Capabilities;
import me.cortex.voxy.client.core.model.bakery.BudgetBufferRenderer;
import me.cortex.voxy.client.core.rendering.util.SharedIndexBuffer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.VoxyInstance;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11630;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_761;
import org.jspecify.annotations.Nullable;

public class VoxyClient
implements ClientModInitializer {
    private static final HashSet<String> FREX = new HashSet();

    public static void initVoxyClient() {
        boolean systemSupported;
        Capabilities.init();
        if (Capabilities.INSTANCE.hasBrokenDepthSampler) {
            Logger.error("AMD broken depth sampler detected, voxy does not work correctly and has been disabled, this will hopefully be fixed in the future");
        }
        boolean bl = systemSupported = Capabilities.INSTANCE.compute && Capabilities.INSTANCE.indirectParameters && !Capabilities.INSTANCE.hasBrokenDepthSampler;
        if (systemSupported) {
            SharedIndexBuffer.INSTANCE.id();
            BudgetBufferRenderer.init();
            VoxyCommon.setInstanceFactory(VoxyClientInstance::new);
            if (!Capabilities.INSTANCE.subgroup) {
                Logger.warn("GPU does not support subgroup operations, expect some performance degradation");
            }
        } else {
            Logger.error("Voxy is unsupported on your system.");
        }
    }

    public void onInitializeClient() {
        class_11631.method_72763((class_2960)class_2960.method_60655((String)"voxy", (String)"version"), (class_11632)new class_11632(this){

            public void method_72751(class_11630 lines, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk2) {
                if (!VoxyCommon.isAvailable()) {
                    lines.method_72747(String.valueOf(class_124.field_1061) + "voxy-" + VoxyCommon.MOD_VERSION);
                    return;
                }
                VoxyInstance instance = VoxyCommon.getInstance();
                if (instance == null) {
                    lines.method_72747(String.valueOf(class_124.field_1054) + "voxy-" + VoxyCommon.MOD_VERSION);
                    return;
                }
                VoxyRenderSystem vrs = null;
                class_761 wr = class_310.method_1551().field_1769;
                if (wr != null) {
                    vrs = ((IGetVoxyRenderSystem)wr).getVoxyRenderSystem();
                }
                lines.method_72747(String.valueOf(vrs == null ? class_124.field_1077 : class_124.field_1060) + "voxy-" + VoxyCommon.MOD_VERSION);
            }
        });
        class_11631.method_72763((class_2960)class_2960.method_60655((String)"voxy", (String)"debug"), (class_11632)new VoxyDebugScreenEntry());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            if (VoxyCommon.isAvailable()) {
                dispatcher.register(VoxyCommands.register());
            }
        });
        FabricLoader.getInstance().getEntrypoints("frex_flawless_frames", Consumer.class).forEach(api -> api.accept(name -> active -> {
            if (active.booleanValue()) {
                FREX.add((String)name);
            } else {
                FREX.remove(name);
            }
        }));
    }

    public static boolean isFrexActive() {
        return !FREX.isEmpty();
    }

    public static int getOcclusionDebugState() {
        return 0;
    }

    public static boolean disableSodiumChunkRender() {
        return false;
    }
}

