/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.fabric.client;

import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesModService;

public class FabricVoiceRecordThread
extends Thread
implements VoiceMessagesModService.VoiceRecordThread {
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private final Predicate<short[]> frameConsumer;
    private final MicThread micThread;
    private final boolean usesOwnMicThread;
    private volatile boolean running;

    public FabricVoiceRecordThread(Predicate<short[]> frameConsumer, Consumer<IOException> onMicError) {
        MicThread micThread;
        this.frameConsumer = frameConsumer;
        this.setDaemon(true);
        this.setName("VoiceRecordThread#" + THREAD_COUNT.getAndIncrement());
        ClientVoicechat client = ClientManager.getClient();
        MicThread micThread2 = micThread = client != null ? client.getMicThread() : null;
        if (micThread == null) {
            micThread = new MicThread(client, null, onMicError::accept);
            this.usesOwnMicThread = true;
        } else {
            this.usesOwnMicThread = false;
        }
        micThread.setMicrophoneLocked(true);
        this.micThread = micThread;
        this.running = true;
    }

    @Override
    public void run() {
        while (this.running) {
            short[] buff = this.micThread.pollMic();
            if (buff == null) continue;
            this.running = this.frameConsumer.test(buff);
        }
        this.micThread.setMicrophoneLocked(false);
        if (this.usesOwnMicThread) {
            this.micThread.close();
        }
    }

    @Override
    public void startVoiceRecord() {
        this.start();
    }

    @Override
    public void stopVoiceRecord() {
        try {
            this.running = false;
            this.join(1000L);
        }
        catch (Exception e) {
            VoiceMessages.getLogger().error("Failed to join voice record thread", e);
        }
    }
}

