/*
 * Decompiled with CFR 0.152.
 */
package rynnavinx.sspb.common.client.options;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import rynnavinx.sspb.common.client.SSPBClientMod;
import rynnavinx.sspb.common.services.IPlatformHelper;

public class SSPBOptions {
    private static final String DEFAULT_FILE_NAME = "sodium-shadowy-path-blocks-options.json";
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 8}).create();
    private Path configPath;
    public static final int DEFAULT_SHADOWYNESS_PERCENT = 85;
    public static final boolean DEFAULT_ONLY_AFFECT_PATH_BLOCKS = false;
    public static final boolean DEFAULT_VANILLA_PATH_BLOCK_LIGHTING = false;
    public int shadowynessPercent = 85;
    private float shadowyness = 0.85f;
    private float shadowynessCompliment = 0.15f;
    public boolean onlyAffectPathBlocks = false;
    public boolean vanillaPathBlockLighting = false;

    public void updateShadowyness(int shadowynessPercent) {
        this.shadowynessPercent = shadowynessPercent;
        this.shadowyness = (float)shadowynessPercent / 100.0f;
        this.shadowynessCompliment = 1.0f - (float)shadowynessPercent / 100.0f;
    }

    public float getShadowyness() {
        return this.shadowyness;
    }

    public float getShadowynessCompliment() {
        return this.shadowynessCompliment;
    }

    public void save() {
        try {
            this.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't save SSPB options changes", e);
        }
        SSPBClientMod.LOGGER.info("[SSPB] Saved changes to SSPB options");
    }

    public static SSPBOptions load() {
        SSPBOptions config;
        Path path;
        block10: {
            path = IPlatformHelper.INSTANCE.getConfigDirectory().resolve(DEFAULT_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SSPBOptions)GSON.fromJson((Reader)reader, SSPBOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse SSPB options", e);
                }
            }
            config = new SSPBOptions();
        }
        config.configPath = path;
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update SSPB options", e);
        }
        config.updateShadowyness(config.shadowynessPercent);
        return config;
    }

    private void writeChanges() throws IOException {
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        Files.writeString(this.configPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
    }
}

