/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.config.builder.ConfigBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.Config;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.minecraft.class_128;
import net.minecraft.class_310;

public class ConfigManager {
    public static final String CONFIG_ENTRY_POINT_KEY = "sodium:config_api_user";
    private static final Collection<ConfigUser> configUsers = new ArrayList<ConfigUser>();
    public static Config CONFIG;
    private static Function<String, ModMetadata> modInfoFunction;

    public static void setModInfoFunction(Function<String, ModMetadata> modInfoFunction) {
        ConfigManager.modInfoFunction = modInfoFunction;
    }

    public static void registerConfigEntryPoint(String className, String modId) {
        Class<?> entryPointClass;
        try {
            entryPointClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            SodiumClientMod.logger().warn("Mod '{}' provided a custom config integration but the class is missing: {}", (Object)modId, (Object)className);
            return;
        }
        if (!ConfigEntryPoint.class.isAssignableFrom(entryPointClass)) {
            SodiumClientMod.logger().warn("Mod '{}' provided a custom config integration but the class is of the wrong type: {}", (Object)modId, entryPointClass);
            return;
        }
        ConfigManager.registerConfigEntryPoint(() -> {
            try {
                Constructor constructor = entryPointClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ConfigEntryPoint)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                SodiumClientMod.logger().warn("Mod '{}' provided a custom config integration but the class could not be constructed: {}", (Object)modId, (Object)entryPointClass);
                return null;
            }
        }, modId);
    }

    public static void registerConfigEntryPoint(Supplier<ConfigEntryPoint> entryPoint, String modId) {
        configUsers.add(new ConfigUser(entryPoint, modId));
    }

    public static void registerConfigsEarly() {
        ConfigManager.registerConfigs(ConfigEntryPoint::registerConfigEarly);
    }

    public static void registerConfigsLate() {
        ConfigManager.registerConfigs(ConfigEntryPoint::registerConfigLate);
    }

    private static void registerConfigs(BiConsumer<ConfigEntryPoint, ConfigBuilder> registerMethod) {
        ObjectOpenHashSet configIds = new ObjectOpenHashSet();
        ModOptions sodiumModOptions = null;
        ObjectArrayList modConfigs = new ObjectArrayList();
        for (ConfigUser configUser : configUsers) {
            ConfigEntryPoint entryPoint = configUser.configEntrypoint.get();
            if (entryPoint == null) continue;
            ConfigBuilderImpl builder = new ConfigBuilderImpl(modInfoFunction, configUser.modId);
            try {
                registerMethod.accept(entryPoint, builder);
                Collection<ModOptions> builtConfigs = builder.build();
                for (ModOptions modConfig : builtConfigs) {
                    String configId = modConfig.configId();
                    if (configIds.contains((Object)configId)) {
                        throw new IllegalArgumentException("Mod '" + configUser.modId + "' provided a duplicate mod id: " + configId);
                    }
                    configIds.add((Object)configId);
                    if (configId.equals("sodium")) {
                        sodiumModOptions = modConfig;
                        continue;
                    }
                    modConfigs.add((Object)modConfig);
                }
            }
            catch (Exception e) {
                ConfigManager.crashWithMessage("Mod '" + configUser.modId + "' failed while registering config options.", e);
                return;
            }
        }
        modConfigs.sort(Comparator.comparing(ModOptions::name));
        if (sodiumModOptions == null) {
            throw new RuntimeException("Sodium mod config not found");
        }
        modConfigs.add(0, sodiumModOptions);
        try {
            CONFIG = new Config((List<ModOptions>)modConfigs);
        }
        catch (Exception e) {
            ConfigManager.crashWithMessage("Failed to build config options", e);
        }
    }

    private static void crashWithMessage(String message, Exception e) {
        class_310.method_1565(null, (File)class_310.method_1551().field_1697, (class_128)new class_128(message, (Throwable)e));
    }

    private record ConfigUser(Supplier<ConfigEntryPoint> configEntrypoint, String modId) {
    }

    public record ModMetadata(String modName, String modVersion) {
    }
}

