/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox.components;

import btw.lowercase.skyboxify.utils.CommonUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record Fade(int startIn, int endIn, int startOut, int endOut, boolean alwaysOn) {
    public static final Fade DEFAULT = new Fade(0, 0, 0, 0, true);
    public static final Codec<Fade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("startFadeIn", (Object)0).forGetter(Fade::startIn), (App)Codec.INT.optionalFieldOf("endFadeIn", (Object)0).forGetter(Fade::endIn), (App)Codec.INT.optionalFieldOf("startFadeOut", (Object)0).forGetter(Fade::startOut), (App)Codec.INT.optionalFieldOf("endFadeOut", (Object)0).forGetter(Fade::endOut), (App)Codec.BOOL.optionalFieldOf("alwaysOn", (Object)false).forGetter(Fade::alwaysOn)).apply((Applicative)instance, Fade::new));

    public Fade(int startIn, int endIn, int startOut, int endOut, boolean alwaysOn) {
        this.startIn = Fade.normalizeIfNot(startIn, alwaysOn);
        this.endIn = Fade.normalizeIfNot(endIn, alwaysOn);
        this.startOut = Fade.normalizeIfNot(startOut, alwaysOn);
        this.endOut = Fade.normalizeIfNot(endOut, alwaysOn);
        this.alwaysOn = alwaysOn;
    }

    private static int normalizeIfNot(int time, boolean ignore) {
        return ignore ? time : CommonUtils.normalizeTickTime(time);
    }

    public float getAlpha(int timeOfDay) {
        if (!this.alwaysOn) {
            return CommonUtils.calculateFadeAlphaValue(1.0f, 0.0f, timeOfDay, this.startIn, this.endIn, this.startOut, this.endOut);
        }
        return 1.0f;
    }
}

