/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.screen.widget;

import btw.lowercase.skyboxify.screen.widget.Gidget;
import btw.lowercase.skyboxify.screen.widget.components.Box;
import btw.lowercase.skyboxify.screen.widget.components.Scrollbar;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_9848;

public class ScrollableList
extends Gidget {
    private final List<Gidget> gidgets;
    private final Scrollbar scrollbar;

    public ScrollableList(List<Gidget> gidgets, int x, int y, int width, int height) {
        super(new Box(x, y, width, height));
        this.gidgets = gidgets;
        this.scrollbar = new Scrollbar(width - 10 - 8, y + 1, height - 1);
        this.updateGidgetsPosition();
    }

    private void updateGidgetsPosition() {
        int rowHeight = 28;
        int contentHeight = this.gidgets.size() * 28;
        int scrollableHeight = Math.max(0, contentHeight - this.box().height());
        for (Gidget gidget : this.gidgets) {
            Box box = this.box();
            gidget.move(box.left() + (box.width() - gidget.box().width()) / 2, box.top() + 9 + this.gidgets.indexOf(gidget) * 28 - (int)(this.scrollbar.getScrollY() * (double)scrollableHeight));
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        super.render(guiGraphics, mouseX, mouseY);
        this.scrollbar.render(guiGraphics, mouseX, mouseY);
        guiGraphics.method_44379(this.box().left(), this.box().top(), this.box().right(), this.box().bottom());
        for (Gidget gidget : this.gidgets) {
            gidget.render(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.method_44380();
    }

    @Override
    public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_25294(this.box().left(), this.box().top(), this.box().right(), this.box().bottom(), class_9848.method_61330((int)76, (int)0));
        int lineColor = class_9848.method_61330((int)170, (int)0xA0A0A0);
        guiGraphics.method_51738(this.box().left(), this.box().right(), this.box().top(), lineColor);
        guiGraphics.method_51738(this.box().left(), this.box().right(), this.box().top() + this.box().height(), lineColor);
    }

    @Override
    public boolean onMouseMove(double mouseX, double mouseY) {
        for (Gidget gidget : this.gidgets) {
            if (!this.box().contains((int)mouseX, (int)mouseY) || !gidget.onMouseMove(mouseX, mouseY)) continue;
            return true;
        }
        if (this.scrollbar.box().contains((int)mouseX, (int)mouseY)) {
            this.scrollbar.onMouseMove(mouseX, mouseY);
        }
        return super.onMouseMove(mouseX, mouseY);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY) {
        super.onMouseClicked(mouseX, mouseY);
        for (Gidget gidget : this.gidgets) {
            if (!this.box().contains((int)mouseX, (int)mouseY) || !gidget.box().contains((int)mouseX, (int)mouseY) || !gidget.onMouseClicked(mouseX, mouseY)) continue;
            return true;
        }
        if (this.scrollbar.box().contains((int)mouseX, (int)mouseY)) {
            this.scrollbar.onMouseClicked(mouseX, mouseY);
        }
        return true;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (Gidget gidget : this.gidgets) {
            if (!gidget.box().contains((int)mouseX, (int)mouseY) || !gidget.onMouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        int rowHeight = 28;
        int scrollableHeight = Math.max(0, this.gidgets.size() * 28 - this.box().height());
        double scrollAmount = 28.0 / (double)scrollableHeight;
        if (scrollY > 0.0) {
            this.scrollbar.setScrollY(this.scrollbar.getScrollY() - scrollAmount);
        } else {
            this.scrollbar.setScrollY(this.scrollbar.getScrollY() + scrollAmount);
        }
        this.updateGidgetsPosition();
        return super.onMouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean onKeyDown(int scancode, int key, int modifiers) {
        for (Gidget gidget : this.gidgets) {
            if (!gidget.onKeyDown(scancode, key, modifiers)) continue;
            return true;
        }
        return super.onKeyDown(scancode, key, modifiers);
    }

    @Override
    public boolean onKeyUp(int scancode, int key, int modifiers) {
        for (Gidget gidget : this.gidgets) {
            if (!gidget.onKeyUp(scancode, key, modifiers)) continue;
            return true;
        }
        return super.onKeyUp(scancode, key, modifiers);
    }
}

