/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.google.common.collect.Maps;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTab;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTabType;
import de.dafuqs.paginatedadvancements.client.PinnedAdvancementTabType;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_454;
import net.minecraft.class_456;
import net.minecraft.class_457;
import net.minecraft.class_632;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import org.jetbrains.annotations.Nullable;

public class PaginatedAdvancementScreen
extends class_457
implements class_632.class_633 {
    public static final class_2960 PAGINATION_TEXTURE = PaginatedAdvancementsClient.locate("textures/gui/buttons.png");
    public static final class_2960 WINDOW_TEXTURE = class_2960.method_60656((String)"textures/gui/advancements/window.png");
    private static final class_2561 SAD_LABEL_TEXT = class_2561.method_43471((String)"advancements.sad_label");
    private static final class_2561 EMPTY_TEXT = class_2561.method_43471((String)"advancements.empty");
    private static final class_2561 ADVANCEMENTS_TEXT = class_2561.method_43471((String)"gui.advancements");
    private final class_632 advancementHandler;
    private final Map<class_8779, PaginatedAdvancementTab> tabs = Maps.newLinkedHashMap();
    private final Map<class_8779, PaginatedAdvancementTab> pinnedTabs = Maps.newLinkedHashMap();
    @Nullable
    private PaginatedAdvancementTab selectedTab;
    private boolean movingTab;
    private int currentPage = 0;
    public static final int ADDITIONAL_PADDING_TOP = 20;
    public static final int BORDER_PADDING = 32;
    public static final int ELEMENT_WIDTH = 15;
    public static final int TOP_ELEMENT_HEIGHT = 22;
    public static final int BOTTOM_ELEMENT_HEIGHT = 15;
    public static final int FAVOURITES_BUTTON_WIDTH = 18;
    public static final int FAVOURITES_BUTTON_HEIGHT = 18;
    public static final int FAVOURITES_BUTTON_OFFSET_X = 32;
    public static final int FAVOURITES_BUTTON_OFFSET_Y = 8;

    public PaginatedAdvancementScreen(class_632 advancementHandler) {
        super(advancementHandler);
        this.advancementHandler = advancementHandler;
    }

    protected void method_25426() {
        super.method_25426();
        this.tabs.clear();
        this.selectedTab = null;
        this.advancementHandler.method_2862((class_632.class_633)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            boolean tabSelected = false;
            if (PaginatedAdvancementsClient.CONFIG.SaveLastSelectedTab && !PaginatedAdvancementsClient.CONFIG.LastSelectedTab.isEmpty()) {
                class_2960 savedTabIdentifier = class_2960.method_12829((String)PaginatedAdvancementsClient.CONFIG.LastSelectedTab);
                for (class_454 class_4542 : this.tabs.values()) {
                    if (!class_4542.method_53813().method_53649().comp_1919().equals((Object)savedTabIdentifier)) continue;
                    this.advancementHandler.method_2864(class_4542.method_53813().method_53649(), true);
                    tabSelected = true;
                    break;
                }
            }
            if (!tabSelected) {
                this.advancementHandler.method_2864(this.tabs.values().iterator().next().method_53813().method_53649(), true);
            }
        } else {
            this.advancementHandler.method_2864(this.selectedTab == null ? null : this.selectedTab.method_53813().method_53649(), true);
        }
        if (!this.tabs.isEmpty() && PaginatedAdvancementsClient.hasPins()) {
            block1: for (String pinnedTabString : PaginatedAdvancementsClient.getPinnedTabs()) {
                class_2960 pinnedTabIdentifier = class_2960.method_12829((String)pinnedTabString);
                for (PaginatedAdvancementTab advancementTab : this.tabs.values()) {
                    if (!advancementTab.method_53813().method_53649().comp_1919().equals((Object)pinnedTabIdentifier)) continue;
                    this.pinnedTabs.put(advancementTab.method_53813().method_53649(), advancementTab);
                    continue block1;
                }
            }
        }
    }

    public void method_25432() {
        super.method_25432();
    }

    public void drawWindow(class_332 context, int mouseX, int mouseY, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.drawFrame(context, minWidth, minHeight, maxWidth, maxHeight);
        context.method_51439(this.field_22787.field_1772, ADVANCEMENTS_TEXT, minWidth + 8, minHeight + 6, 0x404040, false);
    }

    public void drawPinButtonAndHeader(class_332 context, int mouseX, int mouseY, int startX, int startY, int endX, int endY, boolean hasPins) {
        if (this.selectedTab != null && PaginatedAdvancementsClient.CONFIG.PinningEnabled) {
            if (this.isClickOnFavouritesButton(mouseX, mouseY, startY, endX)) {
                if (PaginatedAdvancementsClient.isPinned(this.selectedTab.method_53813().method_53649().comp_1919())) {
                    context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - 32, startY + 8, 18.0f, 64.0f, 18, 18, 256, 256);
                } else {
                    context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - 32, startY + 8, 0.0f, 64.0f, 18, 18, 256, 256);
                }
            } else if (PaginatedAdvancementsClient.isPinned(this.selectedTab.method_53813().method_53649().comp_1919())) {
                context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - 32, startY + 8, 18.0f, 46.0f, 18, 18, 256, 256);
            } else {
                context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - 32, startY + 8, 0.0f, 46.0f, 18, 18, 256, 256);
            }
            if (hasPins) {
                context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX + PinnedAdvancementTabType.getTabX() + 1, startY + 6, 46.0f, 0.0f, 32, 15, 256, 256);
            }
        }
    }

    public boolean isClickOnFavouritesButton(double mouseX, double mouseY, int minHeight, int maxWidth) {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && mouseX > (double)(maxWidth - 32) && mouseX < (double)(maxWidth - 32 + 18) && mouseY > (double)(minHeight + 8) && mouseY < (double)(minHeight + 8 + 18);
    }

    public int getMaxPaginatedTabsToRender(int startX, int endXTitle, int endXWindow, boolean paginated) {
        if (paginated) {
            int usableWidth = endXTitle - startX;
            return (usableWidth - 58) / PaginatedAdvancementTabType.getWidthWithSpacing();
        }
        int usableWidth = endXWindow - startX;
        return (usableWidth - 28) / PaginatedAdvancementTabType.getWidthWithSpacing();
    }

    public int getMaxPinnedTabsToRender(int startY, int endY) {
        int usableHeight = endY - startY;
        return (usableHeight - 56 + PaginatedAdvancementTabType.getWidthWithSpacing()) / PinnedAdvancementTabType.getHeightWithSpacing();
    }

    private boolean isPaginated(int startX, int endXWindow) {
        if (this.tabs.size() < 3) {
            return false;
        }
        return endXWindow - startX < this.tabs.size() * PaginatedAdvancementTabType.getWidthWithSpacing();
    }

    private void renderPaginatedTabs(class_332 context, int startX, int startY, int endXTitle, int endXWindow, boolean paginated) {
        int displayedPosition;
        Iterator<PaginatedAdvancementTab> tabIterator = this.tabs.values().iterator();
        int maxAdvancementTabsToRender = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, paginated);
        int index = 0;
        while (tabIterator.hasNext()) {
            PaginatedAdvancementTab advancementTab = tabIterator.next();
            if (paginated) {
                if (advancementTab.getPaginatedDisplayedPage(maxAdvancementTabsToRender) != this.currentPage) continue;
                displayedPosition = advancementTab.getPaginatedDisplayedPosition(maxAdvancementTabsToRender, this.currentPage);
                advancementTab.drawBackground(context, startX, startY, advancementTab == this.selectedTab, displayedPosition);
                continue;
            }
            advancementTab.drawBackground(context, startX, startY, advancementTab == this.selectedTab, index);
            ++index;
        }
        index = 0;
        for (PaginatedAdvancementTab advancementTab : this.tabs.values()) {
            if (paginated) {
                if (advancementTab.getPaginatedDisplayedPage(maxAdvancementTabsToRender) != this.currentPage) continue;
                displayedPosition = advancementTab.getPaginatedDisplayedPosition(maxAdvancementTabsToRender, this.currentPage);
                advancementTab.drawIcon(context, startX, startY, displayedPosition);
                continue;
            }
            advancementTab.drawIcon(context, startX, startY, index);
            ++index;
        }
    }

    private void renderPinnedTabs(class_332 context, int startX, int startY, int endX, int endY) {
        int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
        for (PaginatedAdvancementTab advancementTab : this.pinnedTabs.values()) {
            advancementTab.drawPinnedBackground(context, endX, startY, advancementTab == this.selectedTab, maxPinnedTabs);
        }
        for (PaginatedAdvancementTab advancementTab : this.pinnedTabs.values()) {
            advancementTab.drawPinnedIcon(context, endX, startY, maxPinnedTabs);
        }
    }

    public void drawPaginationButtons(class_332 context, int mouseX, int mouseY, int startX, int endX) {
        if (PaginatedAdvancementScreen.isClickOnBackTab(mouseX, mouseY, startX, endX)) {
            context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, startX + 4, 27, 0.0f, 23.0f, 23, 23, 256, 256);
        } else {
            context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, startX + 4, 27, 0.0f, 0.0f, 23, 23, 256, 256);
        }
        if (PaginatedAdvancementScreen.isClickOnForwardTab(mouseX, mouseY, startX, endX)) {
            context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - startX + 4, 27, 23.0f, 23.0f, 23, 23, 256, 256);
        } else {
            context.method_25290(class_10799.field_56883, PAGINATION_TEXTURE, endX - startX + 4, 27, 23.0f, 0.0f, 23, 23, 256, 256);
        }
    }

    public static boolean isClickOnBackTab(double mouseX, double mouseY, int startX, int enX) {
        int buttonStartX = startX + 4;
        int buttonStartY = 27;
        return mouseX > (double)buttonStartX && mouseX < (double)(buttonStartX + 23) && mouseY > (double)buttonStartY && mouseY < (double)(buttonStartY + 23);
    }

    public static boolean isClickOnForwardTab(double mouseX, double mouseY, int startX, int endX) {
        int buttonStartX = endX - startX + 4;
        int buttonStartY = 27;
        return mouseX > (double)buttonStartX && mouseX < (double)(buttonStartX + 23) && mouseY > (double)buttonStartY && mouseY < (double)(buttonStartY + 23);
    }

    private void drawFrame(class_332 context, int startX, int startY, int endX, int endY) {
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, startX, startY, 0.0f, 0.0f, 15, 22, 256, 256);
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, endX - 15, startY, 237.0f, 0.0f, 15, 22, 256, 256);
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, startX, endY - 15, 0.0f, 125.0f, 15, 15, 256, 256);
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, endX - 15, endY - 15, 237.0f, 125.0f, 15, 15, 256, 256);
        int maxTopHeightInOneDrawCall = 100;
        int middleHeight = endY - startY - 22 - 15;
        int currentY = startY + 22;
        while (middleHeight > 0) {
            int currentDrawHeight = Math.min(middleHeight, maxTopHeightInOneDrawCall);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, startX, currentY, 0.0f, 22.0f, 15, currentDrawHeight, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, endX - 15, currentY, 237.0f, 22.0f, 15, currentDrawHeight, 256, 256);
            middleHeight -= currentDrawHeight;
            currentY += currentDrawHeight;
        }
        int maxTopWidthInOneDrawCall = 220;
        int middleWidth = endX - startX - 15 - 15;
        int currentX = startX + 15;
        while (middleWidth > 0) {
            int currentDrawWidth = Math.min(middleWidth, maxTopWidthInOneDrawCall);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, currentX, startY, 15.0f, 0.0f, currentDrawWidth, 22, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, currentX, endY - 15, 15.0f, 125.0f, currentDrawWidth, 15, 256, 256);
            middleWidth -= currentDrawWidth;
            currentX += currentDrawWidth;
        }
    }

    public void method_723(class_8781 root) {
        int pinnedIndex = PaginatedAdvancementsClient.getPinIndex(root.method_53649().comp_1919());
        PaginatedAdvancementTab advancementTab = PaginatedAdvancementTab.create(this.field_22787, this, this.tabs.size(), pinnedIndex, root);
        if (advancementTab != null) {
            this.tabs.put(root.method_53649(), advancementTab);
            if (PaginatedAdvancementsClient.isPinned(root.method_53649().comp_1919())) {
                this.pinnedTabs.put(root.method_53649(), advancementTab);
            }
        }
    }

    public void method_720(class_8781 root) {
    }

    public void method_721(class_8781 dependent) {
        PaginatedAdvancementTab advancementTab = this.getTab(dependent);
        if (advancementTab != null) {
            advancementTab.method_2318(dependent);
        }
    }

    public void method_719(class_8781 dependent) {
    }

    @Nullable
    private PaginatedAdvancementTab getTab(class_8781 advancement) {
        class_8781 placedAdvancement = advancement.method_53652();
        return this.tabs.get(placedAdvancement.method_53649());
    }

    public void method_722() {
        this.tabs.clear();
        this.pinnedTabs.clear();
        this.selectedTab = null;
    }

    public void method_2866(@Nullable class_8779 advancement) {
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            PaginatedAdvancementsClient.saveSelectedTab(this.selectedTab.method_53813().method_53649().comp_1919());
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0) {
            int startX = 32;
            int endXWindow = !this.pinnedTabs.isEmpty() ? this.field_22789 - 32 - 32 : this.field_22789 - 32;
            int endXTitle = this.field_22789 - 32;
            int startY = 52;
            int endY = this.field_22790 - 32;
            boolean isPaginated = this.isPaginated(startX, endXWindow);
            if (this.selectedTab != null && this.isClickOnFavouritesButton(click.comp_4798(), click.comp_4799(), startY, endXWindow)) {
                class_2960 pageIdentifier = this.selectedTab.method_53813().method_53649().comp_1919();
                if (PaginatedAdvancementsClient.isPinned(pageIdentifier)) {
                    this.unpinTab(pageIdentifier);
                } else {
                    this.pinTab(pageIdentifier);
                }
            }
            if (isPaginated) {
                if (PaginatedAdvancementScreen.isClickOnBackTab(click.comp_4798(), click.comp_4799(), startX, endXTitle)) {
                    this.pageBackward(startX, endXTitle, endXWindow);
                } else if (PaginatedAdvancementScreen.isClickOnForwardTab(click.comp_4798(), click.comp_4799(), startX, endXTitle)) {
                    this.pageForward(startX, endXTitle, endXWindow);
                }
            }
            int maxDisplayedTabs = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, isPaginated);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.tabs.values()) {
                if (!paginatedAdvancementTab.isClickOnTab(32, 52, click.comp_4798(), click.comp_4799(), isPaginated, maxDisplayedTabs, this.currentPage)) continue;
                this.advancementHandler.method_2864(paginatedAdvancementTab.method_53813().method_53649(), true);
                break;
            }
            if (!this.pinnedTabs.isEmpty()) {
                int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
                for (PaginatedAdvancementTab paginatedAdvancementTab : this.pinnedTabs.values()) {
                    if (!paginatedAdvancementTab.isClickOnPinnedTab(endXWindow, startY, click.comp_4798(), click.comp_4799(), maxPinnedTabs)) continue;
                    this.advancementHandler.method_2864(paginatedAdvancementTab.method_53813().method_53649(), true);
                }
            }
        }
        return super.method_25402(click, doubled);
    }

    private void pinTab(class_2960 pageIdentifier) {
        this.selectedTab.setPinIndex(this.pinnedTabs.size());
        this.pinnedTabs.put(this.selectedTab.method_53813().method_53649(), this.selectedTab);
        PaginatedAdvancementsClient.pinTab(pageIdentifier);
    }

    private void unpinTab(class_2960 pageIdentifier) {
        int oldPinIndex = this.selectedTab.getPinIndex();
        this.selectedTab.setPinIndex(-1);
        this.pinnedTabs.remove(this.selectedTab.method_53813().method_53649());
        PaginatedAdvancementsClient.unpinTab(pageIdentifier);
        for (PaginatedAdvancementTab tab : this.pinnedTabs.values()) {
            int currentPinIndex = tab.getPinIndex();
            if (currentPinIndex <= oldPinIndex) continue;
            tab.setPinIndex(currentPinIndex - 1);
        }
    }

    public int getMaxPageIndex(int startX, int endXTitle, int endXWindow) {
        int maxDisplayedTabsPerPage = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, true);
        return (this.tabs.size() - 1) / maxDisplayedTabsPerPage;
    }

    public void clampCurrentPage(int startX, int endXTitle, int endXWindow) {
        this.currentPage = Math.min(this.currentPage, this.getMaxPageIndex(startX, endXTitle, endXWindow));
    }

    public void pageForward(int startX, int endXTitle, int endXWindow) {
        ++this.currentPage;
        this.currentPage %= this.getMaxPageIndex(startX, endXTitle, endXWindow) + 1;
    }

    public void pageBackward(int startX, int endXTitle, int endXWindow) {
        int maxPageIndex = this.getMaxPageIndex(startX, endXTitle, endXWindow);
        this.currentPage = this.currentPage == 0 ? maxPageIndex : --this.currentPage;
    }

    public boolean method_25404(class_11908 input) {
        if (this.field_22787.field_1690.field_1844.method_1417(input)) {
            this.field_22787.method_1507(null);
            this.field_22787.field_1729.method_1612();
            return true;
        }
        if (this.selectedTab != null && input.method_74242()) {
            this.selectedTab.copyHoveredAdvancementID();
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.selectedTab != null) {
            return this.selectedTab.scrollDebug(-((int)verticalAmount));
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (click.method_74245() != 0) {
            this.movingTab = false;
            return false;
        }
        if (!this.movingTab) {
            this.movingTab = true;
        } else if (this.selectedTab != null) {
            int endX = !this.pinnedTabs.isEmpty() ? this.field_22789 - 32 - 32 - 4 : this.field_22789 - 32;
            int endY = this.field_22790 - 32;
            this.selectedTab.move(offsetX, offsetY, endX - 60 + 5, endY - 84);
        }
        return true;
    }

    private void drawWidgetTooltip(class_332 context, int mouseX, int mouseY, int startX, int startY, int endXTitle, int endXWindow, int endY) {
        if (this.selectedTab != null) {
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)(startX + 9), (float)(startY + 18));
            this.selectedTab.drawWidgetTooltip(context, mouseX - startX - 9, mouseY - startY - 18, startX, startY, endXWindow, endY);
            context.method_51448().translate(0.0f, 0.0f);
            if (PaginatedAdvancementsClient.CONFIG.shouldShowAdvancementDebug(this.field_22787)) {
                this.selectedTab.drawDebugInfo(context, startX, startY, endXWindow, endY);
            }
            context.method_51448().popMatrix();
        }
        if (this.tabs.size() > 1) {
            boolean isPaginated = this.isPaginated(startX, endXWindow);
            int maxDisplayedTabs = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, isPaginated);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.tabs.values()) {
                if (!paginatedAdvancementTab.isClickOnTab(startX, startY, mouseX, mouseY, isPaginated, maxDisplayedTabs, this.currentPage)) continue;
                context.method_51438(this.field_22793, paginatedAdvancementTab.method_2309(), mouseX, mouseY);
            }
        }
        if (!this.pinnedTabs.isEmpty()) {
            int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.pinnedTabs.values()) {
                if (!paginatedAdvancementTab.isClickOnPinnedTab(endXWindow, startY, mouseX, mouseY, maxPinnedTabs)) continue;
                context.method_51438(this.field_22793, paginatedAdvancementTab.method_2309(), mouseX, mouseY);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean hasPins = !this.pinnedTabs.isEmpty();
        int startX = 32;
        int startY = 52;
        int endXWindow = hasPins ? this.field_22789 - 32 - 32 : this.field_22789 - 32;
        int endXTitle = this.field_22789 - 32;
        int endY = this.field_22790 - 32;
        this.clampCurrentPage(startX, endXTitle, endXWindow);
        this.drawAdvancementTree(context, startX, startY, endXWindow, endY);
        this.drawWindow(context, mouseX, mouseY, startX, startY, endXWindow, endY);
        if (this.tabs.size() > 1) {
            if (this.isPaginated(startX, endXWindow)) {
                this.drawPaginationButtons(context, mouseX, mouseY, startX, endXTitle);
                this.renderPaginatedTabs(context, startX, startY, endXTitle, endXWindow, true);
            } else {
                this.renderPaginatedTabs(context, startX, startY, endXTitle, endXWindow, false);
            }
        }
        if (hasPins) {
            this.renderPinnedTabs(context, startX, startY, endXWindow, endY);
        }
        this.drawPinButtonAndHeader(context, mouseX, mouseY, startX, startY, endXWindow, endY, hasPins);
        this.drawWidgetTooltip(context, mouseX, mouseY, startX, startY, endXTitle, endXWindow, endY);
    }

    private void drawAdvancementTree(class_332 context, int startX, int startY, int endX, int endY) {
        PaginatedAdvancementTab advancementTab = this.selectedTab;
        if (advancementTab == null) {
            context.method_25294(startX + 9, startY + 18, endX, endY, -16777216);
            int textCenterX = startX + (endX - startX) / 2;
            int textY = startY + (endY - startY) / 2;
            context.method_27534(this.field_22793, EMPTY_TEXT, textCenterX, textY, -1);
            context.method_27534(this.field_22793, SAD_LABEL_TEXT, textCenterX, textY + 16, -1);
        } else {
            advancementTab.render(context, startX, startY, endX, endY);
        }
    }

    @Nullable
    public class_456 method_2335(class_8781 advancement) {
        PaginatedAdvancementTab advancementTab = this.getTab(advancement);
        return advancementTab == null ? null : advancementTab.method_2308(advancement.method_53649());
    }
}

